------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2010-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

--  This software was originally contributed by William A. Duff

with Ada.Command_Line;         use Ada.Command_Line;
with Ada.Text_IO;              use Ada.Text_IO;

with GNATCOLL.Paragraph_Filling;       use GNATCOLL.Paragraph_Filling;
with GNATCOLL.Paragraph_Filling.Words; use GNATCOLL.Paragraph_Filling.Words;

procedure GNATCOLL.Paragraph_Filling.Test_Words is
   --  Test program for Paragraph_Filling.Words. Prints each word in a file and
   --  then the length of that word.

   Input  : File_Type;
begin
   Open (Input, In_File, Argument (1));
   while not End_Of_File (Input) loop
      declare
         Current_Paragraph : constant Paragraph_Filling.Words.Words :=
            Index_Paragraph (Get_Paragraph (Input));
      begin
         for Word in 1 .. Current_Paragraph.Num_Words - 1 loop
            Put (Word'Img);
            Put ("""" & Nth_Word (Current_Paragraph, Word) & """");
            Put_Line (Word_Length (Current_Paragraph, Word)'Img);
         end loop;
      end;
   end loop;
   Close (Input);
end GNATCOLL.Paragraph_Filling.Test_Words;
