/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc.example;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;

import net.noderunner.xmlrpc.ParamIterator;
import net.noderunner.xmlrpc.XmlRpcReader;
import net.noderunner.xmlrpc.XmlRpcReaderImpl;
import net.noderunner.xmlrpc.XmlRpcWriter;
import net.noderunner.xmlrpc.XmlRpcWriterImpl;

/**
 * This class uses tests the XmlRpcAdapter classes for proper behavior.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class XmlRpcAdapterTest
	extends junit.framework.TestCase
{

	public XmlRpcAdapterTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(XmlRpcAdapterTest.class);
	}

	public static IteratorAdapter makeIA() {
		Vector v = new Vector();
		v.add(new SubscriberImpl("name", "password"));
		v.add(new SubscriberImpl("name2", "password2"));
		v.add(new SubscriberSearchImpl("smith"));
		v.add(new ProvResult("failed to add", 
			new SubscriberImpl("bob", "1234")));
		return new IteratorAdapter(v.iterator());
	}

	public void testInputOutput() 
		throws Exception
	{
		StringWriter sw = new StringWriter();
		XmlRpcWriter xrw = new XmlRpcWriterImpl(sw);
		xrw.writeResponse(new XmlRpcOutputAdapter(makeIA()));
	
		// compare out to input 
		StringReader sr = new StringReader(sw.getBuffer().toString());
		XmlRpcReader xrr = new XmlRpcReaderImpl(sr);
		ParamIterator pi = xrr.readMethodResponse();
		XmlRpcInputAdapter in = new XmlRpcInputAdapter(pi);

		ProvIterator ia = makeIA();
		while (in.hasNext()) {
			ProvEntity entity1 = in.next();
			ProvEntity entity2 = ia.next();
			assertEquals(entity1.getClass(), entity2.getClass());
		}
	}
}
