/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc.example;

import java.util.Iterator;

/**
 * An "Adapter" or "Wrapper", constructed over an underlying Iterator
 * object.  This allows for the java.util package Iterator to be used.
 * @author Elias Ross
 * @version 1.0
 */
public class IteratorAdapter
	implements ProvIterator 
{
	Iterator i;

	/** 
	 * Create a IteratorAdapter around an Iterator.
	 * @param i Iterator to wrap.
	 */
	public IteratorAdapter(Iterator i) {
		this.i = i;
	}

	/** 
	 * Calls next() on underlying Iterator.
	 */
	public ProvEntity next() {
		return (ProvEntity)i.next();
	}
	
	/** 
	 * Calls hasNext() on underlying Iterator.
	 * @return true if hasNext returned true
	 */
	public boolean hasNext() {
		return i.hasNext();
	}

	/** 
	 * Removes the reference to the underlying Iterator, by setting it
	 * to null.  Then, no more methods can be called on this object.
	 */
	public void close() {
		i = null;
	}
}
