/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

import java.io.Writer;

/**
 * This interfaces describes the basic interface for writing
 * data to an Xml-Rpc server or client.
 * Methods that take a ParamIterator instance should be able to accept a
 * variety of objects returned by the <code>next()</code> method.  A
 * class that implements this interface should be able to output the
 * Xml-Rpc representation of these supported Java objects:
 * <ul>
 * <li> <code>java.lang.Integer</code>, as int
 * <li> <code>java.lang.Boolean</code>, as boolean
 * <li> <code>java.lang.Double</code>, as double
 * <li> <code>java.lang.Float</code>, as double
 * <li> <code>java.util.Date</code>, as iso8601
 * <li> <code>byte[]</code>, as base64
 * <li> <code>null</code>, as nil
 * <li> <code>java.util.Collection</code>, as array
 * <li> <code>java.util.Map</code>, as struct
 * <li> <code>java.util.Enumeration</code>, as array
 * <li> <code>java.util.Iterator</code>, as array
 * <li> <code>net.noderunner.xmlrpc.ParamIterator</code>, as array or struct
 * </ul>
 * Additional object types can be supported.
 *
 * @see XmlRpcReader
 */
public interface XmlRpcWriter 
{
	/**
	 * Write an Xml-Rpc request from a method name and a parameter
	 * iterator.
	 * @throws XmlRpcException if ParamIterator throws an exception or
	 * serializing the object fails
	 */
	void writeRequest(String method, ParamIterator iterator) 
		throws XmlRpcException;

	/**
	 * Write an Xml-Rpc response using a parameter
	 * iterator.
	 * @throws XmlRpcException if ParamIterator throws an exception or
	 * serializing the object fails
	 */
	void writeResponse(ParamIterator i) 
		throws XmlRpcException;

	/**
	 * Writes an Xml-Rpc error response to the Xml writer.
	 * @throws XmlRpcException if serializing the error failed
	 */
	void writeError(XmlRpcException xre) 
		throws XmlRpcException;

	/**
	 * Sets the output stream (writer) to be used.  Allows an instance to be
	 * re-used.
	 * @param writer writer to wrap
	 */
	void setWriter(Writer writer);

}
