/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;


/**
 * Contains an HTTP client request.
 */
public class ClientRequest
	extends Request
{

	DataPoster dataPoster;

	/**
	 * Constructs a <code>ClientRequestImpl</code> by parts.
	 */
	public ClientRequest(RequestLine requestLine, MessageHeaders headers)
	{
		super(requestLine, headers);
	}

	/**
	 * Constructs a <code>ClientRequestImpl</code> by parts.
	 * @param dataPoster may be null
	 */
	public ClientRequest(RequestLine requestLine, MessageHeaders headers, 
			DataPoster dataPoster)
	{
		super(requestLine, headers);
		this.dataPoster = dataPoster;
	}

	/**
	 * Returns an optional call-back interface for sending
	 * HTTP data to the server.  May return null, in which case, data may
	 * be instead sent by via the output stream obtained by calling {@link
	 * HttpClient#getOutputStream}.
	 */
	public DataPoster getDataPoster() {
		return dataPoster;
	}

	/**
	 * Returns a debug string.
	 */
	public String toString() {
		return super.toString() + " dataPoster=" + dataPoster;
	}

}
