/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

/**
 * This is used to test the DefaultResolver class.
 */
public class DefaultResolverTest
	extends junit.framework.TestCase
{
	public DefaultResolverTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(DefaultResolverTest.class);
		if (args.length == 0) {
			System.err.println("Usage:  DefaultResolver [path path2] item");
			return;
		}
		// 
		DefaultResolver r = new DefaultResolver();
		for (int i = 0; i < args.length - 1; i++) {
			r.addSearchPath(args[i]);
		}
		try {
			Reader in = r.resolve(args[args.length - 1]);
			BufferedReader br = new BufferedReader(in);
			String line;
			while ((line = br.readLine()) != null)
				System.out.println(line);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void testWhatever()
		throws Exception
	{
		DefaultResolver r = new DefaultResolver();
		try {
			r.resolve(null);
			fail("no null");
		} catch (IllegalArgumentException e) { }
		try {
			r.addSearchPath(null);
			fail("no null");
		} catch (IllegalArgumentException e) { }
		r.addSearchPath("http://example.com/");
		r.addSearchPath("http://example.org/");
		r.addSearchPath("http://example.net/");
		try {
			r.resolve("barney.xml");
			fail("should not be able to find barney");
		} catch (IOException e) {
		}
	}
}
