/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 12088 $ of $ 
 *
 * $Id:$
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "dessertAppParamsTable.h"


/** @defgroup data_get data_get: Routines to get data
 *
 * TODO:230:M: Implement dessertAppParamsTable get routines.
 * TODO:240:M: Implement dessertAppParamsTable mapping routines (if any).
 *
 * These routine are used to get the value for individual objects. The
 * row context is passed, along with a pointer to the memory where the
 * value should be copied.
 *
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table dessertAppParamsTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * DESSERT-MIB::dessertAppParamsTable is subid 9 of dessertObjects.
 * Its status is Current.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9, length: 13
 */

/*
 * ---------------------------------------------------------------------
 * * TODO:200:r: Implement dessertAppParamsTable data context functions.
 */


/**
 * set mib index(es)
 *
 * @param tbl_idx mib index structure
 * @param appParamsIndex_val
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This convenience function is useful for setting all the MIB index
 *  components with a single function call. It is assume that the C values
 *  have already been mapped from their native/rawformat to the MIB format.
 */
int
dessertAppParamsTable_indexes_set_tbl_idx(dessertAppParamsTable_mib_index *
                                          tbl_idx, long appParamsIndex_val)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_indexes_set_tbl_idx", "called\n"));

    /*
     * appParamsIndex(1)/DessertAppParamsIndex/ASN_INTEGER/long(long)//l/a/w/e/R/d/H 
     */
    tbl_idx->appParamsIndex = appParamsIndex_val;


    return MFD_SUCCESS;
}                               /* dessertAppParamsTable_indexes_set_tbl_idx */

/**
 * @internal
 * set row context indexes
 *
 * @param reqreq_ctx the row context that needs updated indexes
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This function sets the mib indexs, then updates the oid indexs
 *  from the mib index.
 */
int
dessertAppParamsTable_indexes_set(dessertAppParamsTable_rowreq_ctx *
                                  rowreq_ctx, long appParamsIndex_val)
{
    DEBUGMSGTL(("verbose:dessertAppParamsTable:dessertAppParamsTable_indexes_set", "called\n"));

    if (MFD_SUCCESS !=
        dessertAppParamsTable_indexes_set_tbl_idx(&rowreq_ctx->tbl_idx,
                                                  appParamsIndex_val))
        return MFD_ERROR;

    /*
     * convert mib index to oid index
     */
    rowreq_ctx->oid_idx.len = sizeof(rowreq_ctx->oid_tmp) / sizeof(oid);
    if (0 != dessertAppParamsTable_index_to_oid(&rowreq_ctx->oid_idx,
                                                &rowreq_ctx->tbl_idx)) {
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
}                               /* dessertAppParamsTable_indexes_set */


/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsName
 * appParamsName is subid 2 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.2
 * Description:
The name of the parameter.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   0
 *   hint: 255a
 *
 * Ranges:  0 - 255;
 *
 * Its syntax is DisplayString (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 255)
 */
/**
 * Extract the current value of the appParamsName data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsName_val_ptr_ptr
 *        Pointer to storage for a char variable
 * @param appParamsName_val_ptr_len_ptr
 *        Pointer to a size_t. On entry, it will contain the size (in bytes)
 *        pointed to by appParamsName.
 *        On exit, this value should contain the data size (in bytes).
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
*
 * @note If you need more than (*appParamsName_val_ptr_len_ptr) bytes of memory,
 *       allocate it using malloc() and update appParamsName_val_ptr_ptr.
 *       <b>DO NOT</b> free the previous pointer.
 *       The MFD helper will release the memory you allocate.
 *
 * @remark If you call this function yourself, you are responsible
 *         for checking if the pointer changed, and freeing any
 *         previously allocated memory. (Not necessary if you pass
 *         in a pointer to static memory, obviously.)
 */
int
appParamsName_get(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                  char **appParamsName_val_ptr_ptr,
                  size_t *appParamsName_val_ptr_len_ptr)
{
   /** we should have a non-NULL pointer and enough storage */
    netsnmp_assert((NULL != appParamsName_val_ptr_ptr)
                   && (NULL != *appParamsName_val_ptr_ptr));
    netsnmp_assert(NULL != appParamsName_val_ptr_len_ptr);


    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsName_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the appParamsName data.
     * copy (* appParamsName_val_ptr_ptr ) data and (* appParamsName_val_ptr_len_ptr ) from rowreq_ctx->data
     */
    /*
     * make sure there is enough space for appParamsName data
     */
    if ((NULL == (*appParamsName_val_ptr_ptr)) ||
        ((*appParamsName_val_ptr_len_ptr) <
         (rowreq_ctx->data.appParamsName_len *
          sizeof(rowreq_ctx->data.appParamsName[0])))) {
        /*
         * allocate space for appParamsName data
         */
        (*appParamsName_val_ptr_ptr) =
            malloc(rowreq_ctx->data.appParamsName_len *
                   sizeof(rowreq_ctx->data.appParamsName[0]));
        if (NULL == (*appParamsName_val_ptr_ptr)) {
            snmp_log(LOG_ERR, "could not allocate memory\n");
            return MFD_ERROR;
        }
    }
    (*appParamsName_val_ptr_len_ptr) =
        rowreq_ctx->data.appParamsName_len *
        sizeof(rowreq_ctx->data.appParamsName[0]);
    memcpy((*appParamsName_val_ptr_ptr), rowreq_ctx->data.appParamsName,
           rowreq_ctx->data.appParamsName_len *
           sizeof(rowreq_ctx->data.appParamsName[0]));

    return MFD_SUCCESS;
}                               /* appParamsName_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsDesc
 * appParamsDesc is subid 3 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.3
 * Description:
A short description of the parameter
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   0
 *   hint: 255a
 *
 * Ranges:  0 - 255;
 *
 * Its syntax is DisplayString (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 255)
 */
/**
 * Extract the current value of the appParamsDesc data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsDesc_val_ptr_ptr
 *        Pointer to storage for a char variable
 * @param appParamsDesc_val_ptr_len_ptr
 *        Pointer to a size_t. On entry, it will contain the size (in bytes)
 *        pointed to by appParamsDesc.
 *        On exit, this value should contain the data size (in bytes).
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
*
 * @note If you need more than (*appParamsDesc_val_ptr_len_ptr) bytes of memory,
 *       allocate it using malloc() and update appParamsDesc_val_ptr_ptr.
 *       <b>DO NOT</b> free the previous pointer.
 *       The MFD helper will release the memory you allocate.
 *
 * @remark If you call this function yourself, you are responsible
 *         for checking if the pointer changed, and freeing any
 *         previously allocated memory. (Not necessary if you pass
 *         in a pointer to static memory, obviously.)
 */
int
appParamsDesc_get(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                  char **appParamsDesc_val_ptr_ptr,
                  size_t *appParamsDesc_val_ptr_len_ptr)
{
   /** we should have a non-NULL pointer and enough storage */
    netsnmp_assert((NULL != appParamsDesc_val_ptr_ptr)
                   && (NULL != *appParamsDesc_val_ptr_ptr));
    netsnmp_assert(NULL != appParamsDesc_val_ptr_len_ptr);


    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsDesc_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the appParamsDesc data.
     * copy (* appParamsDesc_val_ptr_ptr ) data and (* appParamsDesc_val_ptr_len_ptr ) from rowreq_ctx->data
     */
    /*
     * make sure there is enough space for appParamsDesc data
     */
    if ((NULL == (*appParamsDesc_val_ptr_ptr)) ||
        ((*appParamsDesc_val_ptr_len_ptr) <
         (rowreq_ctx->data.appParamsDesc_len *
          sizeof(rowreq_ctx->data.appParamsDesc[0])))) {
        /*
         * allocate space for appParamsDesc data
         */
        (*appParamsDesc_val_ptr_ptr) =
            malloc(rowreq_ctx->data.appParamsDesc_len *
                   sizeof(rowreq_ctx->data.appParamsDesc[0]));
        if (NULL == (*appParamsDesc_val_ptr_ptr)) {
            snmp_log(LOG_ERR, "could not allocate memory\n");
            return MFD_ERROR;
        }
    }
    (*appParamsDesc_val_ptr_len_ptr) =
        rowreq_ctx->data.appParamsDesc_len *
        sizeof(rowreq_ctx->data.appParamsDesc[0]);
    memcpy((*appParamsDesc_val_ptr_ptr), rowreq_ctx->data.appParamsDesc,
           rowreq_ctx->data.appParamsDesc_len *
           sizeof(rowreq_ctx->data.appParamsDesc[0]));

    return MFD_SUCCESS;
}                               /* appParamsDesc_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsValueType
 * appParamsValueType is subid 4 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.4
 * Description:
Indicates which of the columns (appParamsTruthValue, 
        appParamsInterger32, appParamsUInteger32, appParamsOctetString) in the 
        dessertAppParamsTable is actually valid.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 * Enum range: 3/8. Values:  bool(0), int32(1), uint32(2), counter64(3), octetstring(4)
 *
 * Its syntax is DessertAppValueType (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * map a value from its original native format to the MIB format.
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_ERROR           : Any other error
 *
 * @note parameters follow the memset convention (dest, src).
 *
 * @note generation and use of this function can be turned off by re-running
 * mib2c after adding the following line to the file
 * defaults/node-appParamsValueType.m2d :
 *   @eval $m2c_node_skip_mapping = 1@
 *
 * @remark
 *  If the values for your data type don't exactly match the
 *  possible values defined by the mib, you should map them here.
 *  Otherwise, just do a direct copy.
 */
int
appParamsValueType_map(u_long * mib_appParamsValueType_val_ptr,
                       u_long raw_appParamsValueType_val)
{
    netsnmp_assert(NULL != mib_appParamsValueType_val_ptr);

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsValueType_map",
                "called\n"));

    /*
     * TODO:241:o: |-> Implement appParamsValueType enum mapping.
     * uses INTERNAL_* macros defined in the header files
     */
    switch (raw_appParamsValueType_val) {
    case INTERNAL_DESSERTAPPPARAMSTABLE_APPPARAMSVALUETYPE_BOOL:
        *mib_appParamsValueType_val_ptr = DESSERTAPPVALUETYPE_BOOL;
        break;

    case INTERNAL_DESSERTAPPPARAMSTABLE_APPPARAMSVALUETYPE_INT32:
        *mib_appParamsValueType_val_ptr = DESSERTAPPVALUETYPE_INT32;
        break;

    case INTERNAL_DESSERTAPPPARAMSTABLE_APPPARAMSVALUETYPE_UINT32:
        *mib_appParamsValueType_val_ptr = DESSERTAPPVALUETYPE_UINT32;
        break;

    case INTERNAL_DESSERTAPPPARAMSTABLE_APPPARAMSVALUETYPE_OCTETSTRING:
        *mib_appParamsValueType_val_ptr = DESSERTAPPVALUETYPE_OCTETSTRING;
        break;

    default:
        snmp_log(LOG_ERR,
                 "couldn't map value %ld for appParamsValueType\n",
                 raw_appParamsValueType_val);
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
}                               /* appParamsValueType_map */

/**
 * Extract the current value of the appParamsValueType data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsValueType_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
appParamsValueType_get(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                       u_long * appParamsValueType_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != appParamsValueType_val_ptr);


    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsValueType_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the appParamsValueType data.
     * copy (* appParamsValueType_val_ptr ) from rowreq_ctx->data
     */
    (*appParamsValueType_val_ptr) = rowreq_ctx->data.appParamsValueType;

    return MFD_SUCCESS;
}                               /* appParamsValueType_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsTruthValue
 * appParamsTruthValue is subid 5 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.5
 * Description:
A parameter with TruthValue semantics.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 2/8. Values:  true(1), false(2)
 *
 * Its syntax is TruthValue (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * map a value from its original native format to the MIB format.
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_ERROR           : Any other error
 *
 * @note parameters follow the memset convention (dest, src).
 *
 * @note generation and use of this function can be turned off by re-running
 * mib2c after adding the following line to the file
 * defaults/node-appParamsTruthValue.m2d :
 *   @eval $m2c_node_skip_mapping = 1@
 *
 * @remark
 *  If the values for your data type don't exactly match the
 *  possible values defined by the mib, you should map them here.
 *  Otherwise, just do a direct copy.
 */
int
appParamsTruthValue_map(u_long * mib_appParamsTruthValue_val_ptr,
                        u_long raw_appParamsTruthValue_val)
{
    netsnmp_assert(NULL != mib_appParamsTruthValue_val_ptr);

    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsTruthValue_map",
                "called\n"));

    /*
     * TODO:241:o: |-> Implement appParamsTruthValue enum mapping.
     * uses INTERNAL_* macros defined in the header files
     */
    switch (raw_appParamsTruthValue_val) {
    case INTERNAL_DESSERTAPPPARAMSTABLE_APPPARAMSTRUTHVALUE_TRUE:
        *mib_appParamsTruthValue_val_ptr = TRUTHVALUE_TRUE;
        break;

    case INTERNAL_DESSERTAPPPARAMSTABLE_APPPARAMSTRUTHVALUE_FALSE:
        *mib_appParamsTruthValue_val_ptr = TRUTHVALUE_FALSE;
        break;

    default:
        snmp_log(LOG_ERR,
                 "couldn't map value %ld for appParamsTruthValue\n",
                 raw_appParamsTruthValue_val);
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
}                               /* appParamsTruthValue_map */

/**
 * Extract the current value of the appParamsTruthValue data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsTruthValue_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
appParamsTruthValue_get(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                        u_long * appParamsTruthValue_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != appParamsTruthValue_val_ptr);


    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsTruthValue_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the appParamsTruthValue data.
     * copy (* appParamsTruthValue_val_ptr ) from rowreq_ctx->data
     */
    (*appParamsTruthValue_val_ptr) = rowreq_ctx->data.appParamsTruthValue;

    return MFD_SUCCESS;
}                               /* appParamsTruthValue_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsInteger32
 * appParamsInteger32 is subid 6 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.6
 * Description:
A parameter with Integer32 semantics.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Extract the current value of the appParamsInteger32 data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsInteger32_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
appParamsInteger32_get(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                       long *appParamsInteger32_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != appParamsInteger32_val_ptr);


    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsInteger32_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the appParamsInteger32 data.
     * copy (* appParamsInteger32_val_ptr ) from rowreq_ctx->data
     */
    (*appParamsInteger32_val_ptr) = rowreq_ctx->data.appParamsInteger32;

    return MFD_SUCCESS;
}                               /* appParamsInteger32_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsUnsigned32
 * appParamsUnsigned32 is subid 7 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.7
 * Description:
A parameter with Unsigned32 semantics.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 *
 * Its syntax is UNSIGNED32 (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the appParamsUnsigned32 data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsUnsigned32_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
appParamsUnsigned32_get(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                        u_long * appParamsUnsigned32_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != appParamsUnsigned32_val_ptr);


    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsUnsigned32_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the appParamsUnsigned32 data.
     * copy (* appParamsUnsigned32_val_ptr ) from rowreq_ctx->data
     */
    (*appParamsUnsigned32_val_ptr) = rowreq_ctx->data.appParamsUnsigned32;

    return MFD_SUCCESS;
}                               /* appParamsUnsigned32_get */

/*---------------------------------------------------------------------
 * DESSERT-MIB::dessertAppParamsEntry.appParamsOctetString
 * appParamsOctetString is subid 9 of dessertAppParamsEntry.
 * Its status is Current, and its access level is ReadWrite.
 * OID: .1.3.6.1.4.1.18898.0.19.10.1.1.9.1.9
 * Description:
A parameter containing of up to 1024 octets.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   1
 *   hint: 1024a
 *
 * Ranges:  0 - 1024;
 *
 * Its syntax is DessertApplicationOctetString (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 1024)
 */
/**
 * Extract the current value of the appParamsOctetString data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param appParamsOctetString_val_ptr_ptr
 *        Pointer to storage for a char variable
 * @param appParamsOctetString_val_ptr_len_ptr
 *        Pointer to a size_t. On entry, it will contain the size (in bytes)
 *        pointed to by appParamsOctetString.
 *        On exit, this value should contain the data size (in bytes).
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
*
 * @note If you need more than (*appParamsOctetString_val_ptr_len_ptr) bytes of memory,
 *       allocate it using malloc() and update appParamsOctetString_val_ptr_ptr.
 *       <b>DO NOT</b> free the previous pointer.
 *       The MFD helper will release the memory you allocate.
 *
 * @remark If you call this function yourself, you are responsible
 *         for checking if the pointer changed, and freeing any
 *         previously allocated memory. (Not necessary if you pass
 *         in a pointer to static memory, obviously.)
 */
int
appParamsOctetString_get(dessertAppParamsTable_rowreq_ctx * rowreq_ctx,
                         char **appParamsOctetString_val_ptr_ptr,
                         size_t *appParamsOctetString_val_ptr_len_ptr)
{
   /** we should have a non-NULL pointer and enough storage */
    netsnmp_assert((NULL != appParamsOctetString_val_ptr_ptr)
                   && (NULL != *appParamsOctetString_val_ptr_ptr));
    netsnmp_assert(NULL != appParamsOctetString_val_ptr_len_ptr);


    DEBUGMSGTL(("verbose:dessertAppParamsTable:appParamsOctetString_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the appParamsOctetString data.
     * copy (* appParamsOctetString_val_ptr_ptr ) data and (* appParamsOctetString_val_ptr_len_ptr ) from rowreq_ctx->data
     */
    /*
     * make sure there is enough space for appParamsOctetString data
     */
    if ((NULL == (*appParamsOctetString_val_ptr_ptr)) ||
        ((*appParamsOctetString_val_ptr_len_ptr) <
         (rowreq_ctx->data.appParamsOctetString_len *
          sizeof(rowreq_ctx->data.appParamsOctetString[0])))) {
        /*
         * allocate space for appParamsOctetString data
         */
        (*appParamsOctetString_val_ptr_ptr) =
            malloc(rowreq_ctx->data.appParamsOctetString_len *
                   sizeof(rowreq_ctx->data.appParamsOctetString[0]));
        if (NULL == (*appParamsOctetString_val_ptr_ptr)) {
            snmp_log(LOG_ERR, "could not allocate memory\n");
            return MFD_ERROR;
        }
    }
    (*appParamsOctetString_val_ptr_len_ptr) =
        rowreq_ctx->data.appParamsOctetString_len *
        sizeof(rowreq_ctx->data.appParamsOctetString[0]);
    memcpy((*appParamsOctetString_val_ptr_ptr),
           rowreq_ctx->data.appParamsOctetString,
           rowreq_ctx->data.appParamsOctetString_len *
           sizeof(rowreq_ctx->data.appParamsOctetString[0]));

    return MFD_SUCCESS;
}                               /* appParamsOctetString_get */



/** @} */
