/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class PropertySet
extends DataType {
    private boolean dynamic = true;
    private Vector cachedNames;
    private Vector ptyRefs = new Vector();
    private Vector setRefs = new Vector();
    private Mapper _mapper;
    private boolean noAttributeSet = true;

    public void appendName(String name) {
        PropertyRef ref = new PropertyRef();
        ref.setName(name);
        this.addPropertyref(ref);
    }

    public void appendRegex(String regex) {
        PropertyRef ref = new PropertyRef();
        ref.setRegex(regex);
        this.addPropertyref(ref);
    }

    public void appendPrefix(String prefix) {
        PropertyRef ref = new PropertyRef();
        ref.setPrefix(prefix);
        this.addPropertyref(ref);
    }

    public void appendBuiltin(BuiltinPropertySetName b) {
        PropertyRef ref = new PropertyRef();
        ref.setBuiltin(b);
        this.addPropertyref(ref);
    }

    public void setMapper(String type, String from, String to) {
        Mapper mapper = this.createMapper();
        Mapper.MapperType mapperType = new Mapper.MapperType();
        mapperType.setValue(type);
        mapper.setFrom(from);
        mapper.setTo(to);
    }

    public void addPropertyref(PropertyRef ref) {
        this.assertNotReference();
        this.ptyRefs.addElement(ref);
    }

    public void addPropertyset(PropertySet ref) {
        this.assertNotReference();
        this.setRefs.addElement(ref);
    }

    public Mapper createMapper() {
        this.assertNotReference();
        if (this._mapper != null) {
            throw new BuildException("Too many <mapper>s!");
        }
        this._mapper = new Mapper(this.getProject());
        return this._mapper;
    }

    public void setDynamic(boolean dynamic) {
        this.assertNotReference();
        this.dynamic = dynamic;
    }

    public boolean getDynamic() {
        return this.isReference() ? this.getRef().dynamic : this.dynamic;
    }

    public Mapper getMapper() {
        return this.isReference() ? this.getRef()._mapper : this._mapper;
    }

    public Properties getProperties() {
        Vector names = null;
        Project prj = this.getProject();
        if (this.getDynamic() || this.cachedNames == null) {
            names = new Vector();
            if (this.isReference()) {
                this.getRef().addPropertyNames(names, prj.getProperties());
            } else {
                this.addPropertyNames(names, prj.getProperties());
            }
            if (!this.getDynamic()) {
                this.cachedNames = names;
            }
        } else {
            names = this.cachedNames;
        }
        FileNameMapper mapper = null;
        Mapper myMapper = this.getMapper();
        if (myMapper != null) {
            mapper = myMapper.getImplementation();
        }
        Properties properties = new Properties();
        Enumeration e = names.elements();
        while (e.hasMoreElements()) {
            String[] newname;
            String name = (String)e.nextElement();
            String value = prj.getProperty(name);
            if (mapper != null && (newname = mapper.mapFileName(name)) != null) {
                name = newname[0];
            }
            properties.setProperty(name, value);
        }
        return properties;
    }

    /*
     * Unable to fully structure code
     */
    private void addPropertyNames(Vector names, Hashtable properties) {
        prj = this.getProject();
        e = this.ptyRefs.elements();
        while (e.hasMoreElements()) {
            block8: {
                block11: {
                    block10: {
                        block9: {
                            ref = (PropertyRef)e.nextElement();
                            if (PropertyRef.access$000(ref) != null) {
                                if (prj.getProperty(PropertyRef.access$000(ref)) == null) continue;
                                names.addElement(PropertyRef.access$000(ref));
                                continue;
                            }
                            if (PropertyRef.access$100(ref) != null) {
                                p = properties.keys();
                                while (p.hasMoreElements()) {
                                    name = (String)p.nextElement();
                                    if (!name.startsWith(PropertyRef.access$100(ref))) continue;
                                    names.addElement(name);
                                }
                                continue;
                            }
                            if (PropertyRef.access$200(ref) != null) {
                                matchMaker = new RegexpMatcherFactory();
                                matcher = matchMaker.newRegexpMatcher();
                                matcher.setPattern(PropertyRef.access$200(ref));
                                p = properties.keys();
                                while (p.hasMoreElements()) {
                                    name = (String)p.nextElement();
                                    if (!matcher.matches(name)) continue;
                                    names.addElement(name);
                                }
                                continue;
                            }
                            if (PropertyRef.access$300(ref) == null) break block8;
                            e2 = null;
                            if (!PropertyRef.access$300(ref).equals("all")) break block9;
                            e2 = properties.keys();
                            ** GOTO lbl45
                        }
                        if (!PropertyRef.access$300(ref).equals("system")) break block10;
                        e2 = System.getProperties().keys();
                        ** GOTO lbl45
                    }
                    if (!PropertyRef.access$300(ref).equals("commandline")) break block11;
                    e2 = this.getProject().getUserProperties().keys();
                    if (true) ** GOTO lbl45
                }
                throw new BuildException("Impossible: Invalid builtin attribute!");
                do {
                    names.addElement(e2.nextElement());
lbl45:
                    // 4 sources

                } while (e2.hasMoreElements());
                continue;
            }
            throw new BuildException("Impossible: Invalid PropertyRef!");
        }
        e = this.setRefs.elements();
        while (e.hasMoreElements()) {
            set = (PropertySet)e.nextElement();
            set.addPropertyNames(names, properties);
        }
    }

    protected PropertySet getRef() {
        Object o;
        if (!this.isChecked()) {
            Stack<PropertySet> stk = new Stack<PropertySet>();
            stk.push(this);
            this.dieOnCircularReference(stk, this.getProject());
        }
        if (!((o = this.getRefid().getReferencedObject(this.getProject())) instanceof PropertySet)) {
            String msg = this.getRefid().getRefId() + " doesn't denote a propertyset";
            throw new BuildException(msg);
        }
        return (PropertySet)o;
    }

    public final void setRefid(Reference r) {
        if (!this.noAttributeSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    protected final void assertNotReference() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.noAttributeSet = false;
    }

    public static class BuiltinPropertySetName
    extends EnumeratedAttribute {
        static final String ALL = "all";
        static final String SYSTEM = "system";
        static final String COMMANDLINE = "commandline";

        public String[] getValues() {
            return new String[]{ALL, SYSTEM, COMMANDLINE};
        }
    }

    public static class PropertyRef {
        private int count;
        private String name;
        private String regex;
        private String prefix;
        private String builtin;

        public void setName(String name) {
            this.assertValid("name", name);
            this.name = name;
        }

        public void setRegex(String regex) {
            this.assertValid("regex", regex);
            this.regex = regex;
        }

        public void setPrefix(String prefix) {
            this.assertValid("prefix", prefix);
            this.prefix = prefix;
        }

        public void setBuiltin(BuiltinPropertySetName b) {
            String builtin = b.getValue();
            this.assertValid("builtin", builtin);
            this.builtin = builtin;
        }

        private void assertValid(String attr, String value) {
            if (value == null || value.length() < 1) {
                throw new BuildException("Invalid attribute: " + attr);
            }
            if (++this.count != 1) {
                throw new BuildException("Attributes name, regex, and prefix are mutually exclusive");
            }
        }

        public String toString() {
            return "name=" + this.name + ", regex=" + this.regex + ", prefix=" + this.prefix + ", builtin=" + this.builtin;
        }

        static /* synthetic */ String access$000(PropertyRef x0) {
            return x0.name;
        }

        static /* synthetic */ String access$100(PropertyRef x0) {
            return x0.prefix;
        }

        static /* synthetic */ String access$200(PropertyRef x0) {
            return x0.regex;
        }

        static /* synthetic */ String access$300(PropertyRef x0) {
            return x0.builtin;
        }
    }
}

