package Cdk::Marquee;

@ISA = qw (Cdk);

#
# This creates a new Marquee object.
#
sub new {
    my $type   = shift;
    my %params = @_;
    my $self   = {};
    my $name   = "${type}::new";

    # Retain the type of the object.
    $self->{'Type'} = $type;

    # Set up the parameters passed in.
    my $width = Cdk::checkReq( $name, "Width", $params{'Width'} );
    my $xpos   = Cdk::checkDef( $name, "Xpos",   $params{'Xpos'},   "CENTER" );
    my $ypos   = Cdk::checkDef( $name, "Ypos",   $params{'Ypos'},   "CENTER" );
    my $box    = Cdk::checkDef( $name, "Box",    $params{'Box'},    "TRUE" );
    my $shadow = Cdk::checkDef( $name, "Shadow", $params{'Shadow'}, "FALSE" );

    # Create the thing.
    $self->{'Me'} = Cdk::Marquee::New( $width, $xpos, $ypos, $box, $shadow );
    bless $self;
}

#
# This activates the object
#
sub activate {
    my $self   = shift;
    my %params = @_;
    my $name   = "$self->{'Type'}::activate";

    # Set the values.
    my $message = Cdk::checkReq( $name, "Message", $params{'Message'} );
    my $delay   = Cdk::checkReq( $name, "Delay",   $params{'Delay'} );
    my $repeat  = Cdk::checkReq( $name, "Repeat",  $params{'Repeat'} );
    my $box = Cdk::checkDef( $name, "Box", $params{'Box'}, "TRUE" );

    # Store the information in both the object and Perl's stack.
    $self->{'Info'} =
      Cdk::Marquee::Activate( $self->{'Me'}, $params{'Message'}, $delay,
        $repeat, $box );
    return ( $self->{'Info'} );
}

#
# This turns off the marquee.
#
sub deactivate {
    my $self = shift;
    Cdk::Marquee::Deactivate( $self->{'Me'} );
}

#
# This sets several parameters of the widget.
#
sub set {
    my $self   = shift;
    my %params = @_;
    my $name   = "$self->{'Type'}::set";

    #
    # Check the parameters sent in.
    #
    if ( defined $params{'ULChar'} ) {
        Cdk::Marquee::SetULChar( $self->{'Me'}, $params{'ULChar'} );
    }
    if ( defined $params{'URChar'} ) {
        Cdk::Marquee::SetURChar( $self->{'Me'}, $params{'URChar'} );
    }
    if ( defined $params{'LLChar'} ) {
        Cdk::Marquee::SetLLChar( $self->{'Me'}, $params{'LLChar'} );
    }
    if ( defined $params{'LRChar'} ) {
        Cdk::Marquee::SetLRChar( $self->{'Me'}, $params{'LRChar'} );
    }
    if ( defined $params{'VChar'} ) {
        Cdk::Marquee::SetVerticalChar( $self->{'Me'}, $params{'VChar'} );
    }
    if ( defined $params{'HChar'} ) {
        Cdk::Marquee::SetHorizontalChar( $self->{'Me'}, $params{'HChar'} );
    }
    if ( defined $params{'BoxAttribute'} ) {
        Cdk::Marquee::SetBoxAttribute( $self->{'Me'}, $params{'BoxAttribute'} );
    }
    if ( defined $params{'BGColor'} ) {
        Cdk::Marquee::SetBackgroundColor( $self->{'Me'}, $params{'BGColor'} );
    }
    if ( defined $params{'Box'} ) {
        Cdk::Marquee::SetBox( $self->{'Me'}, $params{'Box'} );
    }
}

#
# This draws the object.
#
sub draw {
    my $self   = shift;
    my %params = @_;
    my $name   = "$self->{'Type'}::draw";

    # Set up the parameters passed in.
    my $box = Cdk::checkDef( $name, "Box", $params{'Box'}, "TRUE" );

    # Draw the object.
    Cdk::Marquee::Draw( $self->{'Me'}, $box );
}

#
# This erases the object.
#
sub erase {
    my $self = shift;
    Cdk::Marquee::Erase( $self->{'Me'} );
}

#
# This function raises the object.
#
sub raise {
    my $self = shift;
    Cdk::Marquee::Raise( $self->{'Me'} );
}

#
# This function lowers the object.
#
sub lower {
    my $self = shift;
    Cdk::Marquee::Lower( $self->{'Me'} );
}

#
# This function registers the object.
#
sub register {
    my $self = shift;
    Cdk::Marquee::Register( $self->{'Me'} );
}

#
# This function unregisters the object.
#
sub unregister {
    my $self = shift;
    Cdk::Marquee::Unregister( $self->{'Me'} );
}

#
# This function returns the pointer to the window.
#
sub getwin {
    my $self = shift;
    Cdk::Marquee::GetWindow( $self->{'Me'} );
}

1;
