------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                        Copyright (C) 2011, AdaCore                       --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;

with AWS.Client;
with AWS.MIME;
with AWS.Response;
with AWS.Server;
with AWS.Status;
with AWS.Utils;
with AWS.Messages;

with Get_Free_Port;

procedure File_Not_Found is

   use Ada;
   use AWS;

   WS   : Server.HTTP;
   Port : Positive := 8567;

   function CB (Request : Status.Data) return Response.Data is
      URI : constant String := Status.URI (Request);
   begin
      if URI = "/data" then
         return Response.File
           (MIME.Text_HTML, "data2.txt",
            Encoding => Messages.Identity);
      elsif URI = "/zdata" then
         return Response.File
           (MIME.Text_HTML, "data.txt.gz",
            Encoding => Messages.Gzip);
      else
         return Response.Build (MIME.Text_HTML, "URI not supported");
      end if;
   end CB;

   procedure Call_It (URL : String) is
      use type Response.Content_Length_Type;
      R : Response.Data;
   begin
      R := Client.Get ("http://localhost:" & Utils.Image (Port) & URL);

      Text_IO.Put_Line
        ("RC " & URL & " : "
           & Messages.Status_Code'Image (Response.Status_Code (R)));

      if Response.Content_Length (R) = -1 then
         Text_IO.Put_Line ("OK length is -1");
      else
         Text_IO.Put_Line
           ("NOK length is " & Utils.Image (Response.Content_Length (R)));
         Text_IO.Put_Line
           ("=> " & Response.Message_Body (R));
      end if;
   end Call_It;

begin
   Get_Free_Port (Port);

   Server.Start
     (WS, "file_not_found",
      CB'Unrestricted_Access,
      Port           => Port,
      Max_Connection => 5);
   Text_IO.Put_Line ("started"); Ada.Text_IO.Flush;

   delay 1.0;

   Call_It ("/data");
   Call_It ("/zdata");

   Server.Shutdown (WS);
   Text_IO.Put_Line ("shutdown");
end File_Not_Found;
