/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.file;

import alt.jiapi.file.Attribute;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ExceptionsAttribute
extends Attribute {
    private short[] exceptionIndexTable;

    ExceptionsAttribute(short nameIndex, DataInputStream dis) throws IOException {
        super(nameIndex);
        int exceptionCount = dis.readShort();
        this.exceptionIndexTable = new short[exceptionCount];
        for (int i = 0; i < exceptionCount; ++i) {
            this.exceptionIndexTable[i] = dis.readShort();
        }
    }

    short[] getExceptionIndexTable() {
        return this.exceptionIndexTable;
    }

    public String[] getExceptionNames() {
        String[] eNames = new String[this.exceptionIndexTable.length];
        for (int i = 0; i < eNames.length; ++i) {
            eNames[i] = this.cp.getClassName(this.exceptionIndexTable[i]).replace('/', '.');
        }
        return eNames;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.exceptionIndexTable.length);
            for (int i = 0; i < this.exceptionIndexTable.length; ++i) {
                dos.writeShort(this.exceptionIndexTable[i]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }
}

