/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2009 Apogee Instruments, Inc. 
* \class PlatformData 
* \brief  
* 
*/ 


#ifndef PLATFORMDATA_INCLUDE_H__ 
#define PLATFORMDATA_INCLUDE_H__ 

#include <stdint.h>

class PlatformData 
{ 
    public: 
        virtual ~PlatformData();
        const uint16_t		m_NumCols2BinMax;
	    const uint16_t		m_NumRows2BinMax;

	    const double				m_TimerResolution;
	    const double				m_PeriodTimerResolution;

	    const long				    m_TimerOffsetCount;

	    const double				m_SequenceDelayResolution;
	    const double				m_SequenceDelayMaximum;
	    const double				m_SequenceDelayMinimum;

	    const double				m_ExposureTimeMin;
	    const double				m_ExposureTimeMax;

	    const double				m_TdiRateResolution;
	    const double				m_TdiRateMin;
	    const double				m_TdiRateMax;
	    const double				m_TdiRateDefault;

	    const double				m_VoltageResolution;

	    const double				m_ShutterCloseDiff;

	    const double				m_StrobeTimerResolution;
	    const double				m_StrobePositionMin;
	    const double				m_StrobePositionMax;
	    const double				m_StrobePositionDefault;

	    const double				m_StrobePeriodMin;
	    const double				m_StrobePeriodMax;
	    const double				m_StrobePeriodDefault;

	    const long				    m_TempCounts;
	    const double				m_TempKelvinScaleOffset;

	    const double				m_TempSetpointMin;
	    const double				m_TempSetpointMax;

        const double				m_TempBackoffpointMin;
	    const double				m_TempBackoffpointMax;

	    const double				m_TempHeatsinkMin;
	    const double				m_TempHeatsinkMax;

	    const long				    m_TempSetpointZeroPoint;
	    const long				    m_TempHeatsinkZeroPoint;

	    const double				m_TempDegreesPerBit;

	    const uint16_t		m_FanSpeedOff;
	    const uint16_t		m_FanSpeedLow;
	    const uint16_t		m_FanSpeedMedium;
	    const uint16_t		m_FanSpeedHigh;

	    const double				m_PreflashDuration;
        const uint16_t   m_CoolerDriveMax;
        const double                m_CoolerDriveOffset;
        const double                m_CoolerDriveDivisor;

    protected:
        PlatformData(const uint16_t HBinningMax,
                     const uint16_t VBinningMax,
                     const double TimerResolution,
                     const double PeriodTimerResolution,
                     const long TimerOffsetCount,
                     const double SequenceDelayResolution,
                     const double SequenceDelayMaximum,
                     const double SequenceDelayMinimum,
                     const double ExposureTimeMin,
                     const double ExposureTimeMax,
                     const double TdiRateResolution,
                     const double TdiRateMin,
                     const double TdiRateMax,
                     const double TdiRateDefault,
                     const double VoltageResolution,
                     const double ShutterCloseDiff,
                     const double StrobeTimerResolution,
                     const double StrobePositionMin,
                     const double StrobePositionMax,
                     const double StrobePositionDefault,
                     const double StrobePeriodMin,
                     const double StrobePeriodMax,
                     const double StrobePeriodDefault,
                     const long TempCounts,
                     const double TempKelvinScaleOffset,                     
                     const double TempSetpointMin,
                     const double TempSetpointMax,   
                     const double TempBackoffpointMin,
                     const double TempBackoffpointMax,
                     const double TempHeatsinkMin,
                     const double TempHeatsinkMax,
                     const long TempSetpointZeroPoint,
                     const long TempHeatsinkZeroPoint,
                     const double TempDegreesPerBit,
                     const uint16_t FanSpeedOff,
                     const uint16_t FanSpeedLow,
                     const uint16_t FanSpeedMedium,
                     const uint16_t FanSpeedHigh,
                     const double PreflashDuration,
                     const uint16_t CoolerDriveMax,
                     const double CoolerDriveOffset,
                     const double CoolerDriveDivisor
                     );

             

    private:
        //disabling the copy ctor and assignment operator
        //generated by the compiler - don't want them
        //Effective C++ Item 6
        PlatformData(const PlatformData&);
        PlatformData& operator=(PlatformData&);


};

#endif
