# - Find LIBMEMCACHED
# Find the LIBMEMCACHED includes and libraries.
# This module defines:
#  LIBMEMCACHED_FOUND
#  LIBMEMCACHED_INCLUDE_DIRS
#  LIBMEMCACHED_LIBRARIES

find_package(PkgConfig QUIET)
pkg_check_modules(LIBMEMCACHED QUIET libmemcached)

find_path(LIBMEMCACHED_INCLUDE_DIR
  NAMES memcached.h
  PATHS ${LIBMEMCACHED_INCLUDE_DIRS}
  PATH_SUFFIXES libmemcached
)

if((NOT LIBMEMCACHED_INCLUDE_DIRS) AND (LIBMEMCACHED_INCLUDE_DIR))
  set(LIBMEMCACHED_INCLUDE_DIRS ${LIBMEMCACHED_INCLUDE_DIR})
elseif(LIBMEMCACHED_INCLUDE_DIRS AND LIBMEMCACHED_INCLUDE_DIR)
  list(APPEND LIBMEMCACHED_INCLUDE_DIRS ${LIBMEMCACHED_INCLUDE_DIR})
endif()

find_library(LIBMEMCACHED_LIBRARY
  NAMES ${LIBMEMCACHED_LIBRARIES} memcached
)

if((NOT LIBMEMCACHED_LIBRARIES) AND (LIBMEMCACHED_LIBRARY))
  set(LIBMEMCACHED_LIBRARIES ${LIBMEMCACHED_LIBRARY})
elseif(LIBMEMCACHED_LIBRARIES AND LIBMEMCACHED_LIBRARY)
  list(APPEND LIBMEMCACHED_LIBRARIES ${LIBMEMCACHED_LIBRARY})
endif()

message(VERBOSE "LIBMEMCACHED_INCLUDE_DIRS=${LIBMEMCACHED_INCLUDE_DIRS}")
message(VERBOSE "LIBMEMCACHED_INCLUDE_DIR=${LIBMEMCACHED_INCLUDE_DIR}")
message(VERBOSE "LIBMEMCACHED_LIBRARIES=${LIBMEMCACHED_LIBRARIES}")
message(VERBOSE "LIBMEMCACHED_LIBRARY=${LIBMEMCACHED_LIBRARY}")

if((NOT LIBMEMCACHED_FOUND) AND (LIBMEMCACHED_INCLUDE_DIRS) AND (LIBMEMCACHED_LIBRARIES))
  set(LIBMEMCACHED_FOUND True)
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(LIBMEMCACHED
  FOUND_VAR LIBMEMCACHED_FOUND
  REQUIRED_VARS LIBMEMCACHED_FOUND LIBMEMCACHED_INCLUDE_DIRS LIBMEMCACHED_LIBRARIES
  VERSION_VAR LIBMEMCACHED_VERSION
)

mark_as_advanced(LIBMEMCACHED_INCLUDE_DIR LIBMEMCACHED_LIBRARY)
