
#include <iostream>

#include <cstdlib>
#include "logger.h"

using namespace std;
    
Logger::Logger(const Logger& l){
    type_ = l.type_;
}

Logger& Logger::operator << (const char * c){
  if (type_!=DEV_NULL)
	  cerr << c;
}
Logger& Logger::operator << (const string& s){
  if (type_!=DEV_NULL)
	  cerr << s.c_str();
}
Logger& Logger::operator << (int i){
  if (type_!=DEV_NULL)
	  cerr << i;
}
Logger& Logger::operator << (double d){
  if (type_!=DEV_NULL)
	  cerr << d;
}


Logger LOG(LogType t){
  Logger l(t);
  switch (t){
	  case FATAL: 
      l << "FATAL: ";
		  break;
	  case INFO:
      l << "INFO: ";
		  break;
	  case DEV_NULL:
      break;
    }
  return l;
}

Logger::Logger(LogType t):type_(t){
}

Logger::~Logger(){
  switch (type_){
	  case INFO:
      cerr << endl;
		  break;
	case FATAL:
    cerr << endl;
		exit(1);
  }
}
