#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE


import gtk
import glib

_statusbar_instance = None

class Statusbar(gtk.Statusbar):

    __gtype_name__ = 'LernidStatusbar'

    def __init__(self):
        gtk.Statusbar.__init__(self)

    @classmethod
    def get_instance(cls):
        global _statusbar_instance
        if not _statusbar_instance:
            _statusbar_instance = cls()
        return _statusbar_instance

    @classmethod
    def push_message(cls, msg, ctx='lernid', duration=None):
        obj = cls.get_instance()
        ctxid = obj.get_context_id(ctx)
        msgid = obj.push(ctxid, msg)
        if duration:
            glib.timeout_add_seconds(duration, obj.remove_message, ctxid, msgid)

    @classmethod
    def pop_message(cls, ctx='lernid'):
        obj = cls.get_instance()
        id = obj.get_context_id(ctx)
        obj.pop(id)
