/* LekhoneeOperations.c generated by valac, the Vala compiler
 * generated from LekhoneeOperations.vala, do not modify */

/* LekhoneeDialogs.vala
 *
 * Copyright (C) 2010  Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



void xml_save_file (const char* filename, const char* title, const char* desc, const char* tags);
void xml_open_file (const char* path, char** title, char** desc, char** tags);
static int _vala_strcmp0 (const char * str1, const char * str2);



void xml_save_file (const char* filename, const char* title, const char* desc, const char* tags) {
	xmlDoc* doc = NULL;
	xmlNode* root = NULL;
	FILE* stream;
	g_return_if_fail (filename != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (desc != NULL);
	g_return_if_fail (tags != NULL);
	doc = xmlNewDoc ("1.0");
	root = xmlNewNode (NULL, "post");
	xmlDocSetRootElement (doc, root);
	xmlNewTextChild (root, NULL, "title", title);
	xmlNewTextChild (root, NULL, "description", desc);
	xmlNewTextChild (root, NULL, "tags", tags);
	stream = fopen (filename, "w");
	xmlDocDump (stream, doc);
	_fclose0 (stream);
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void xml_open_file (const char* path, char** title, char** desc, char** tags) {
	xmlDoc* doc;
	xmlNode* root;
	g_return_if_fail (path != NULL);
	if (title != NULL) {
		*title = NULL;
	}
	if (desc != NULL) {
		*desc = NULL;
	}
	if (tags != NULL) {
		*tags = NULL;
	}
	doc = xmlParseFile (path);
	if (doc == NULL) {
		fprintf (stderr, "File %s not found or permissions missing", path);
		return;
	}
	root = xmlDocGetRootElement (doc);
	if (root == NULL) {
		char* _tmp0_;
		xmlFreeDoc (doc);
		g_debug ("LekhoneeOperations.vala:55: %s", _tmp0_ = g_strconcat ("The xml file '", string_to_string (path), "' is empty", NULL));
		_g_free0 (_tmp0_);
		return;
	}
	{
		xmlNode* iter;
		iter = root->children;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				char* node_name;
				char* node_content;
				if (!_tmp1_) {
					iter = iter->next;
				}
				_tmp1_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				node_name = g_strdup (iter->name);
				node_content = xmlNodeGetContent (iter);
				if (_vala_strcmp0 (node_name, "title") == 0) {
					char* _tmp2_;
					*title = (_tmp2_ = g_strdup (node_content), _g_free0 (*title), _tmp2_);
				}
				if (_vala_strcmp0 (node_name, "description") == 0) {
					char* _tmp3_;
					*desc = (_tmp3_ = g_strdup (node_content), _g_free0 (*desc), _tmp3_);
				}
				if (_vala_strcmp0 (node_name, "tags") == 0) {
					char* _tmp4_;
					*tags = (_tmp4_ = g_strdup (node_content), _g_free0 (*tags), _tmp4_);
				}
				_g_free0 (node_name);
				_g_free0 (node_content);
			}
		}
	}
	xmlFreeDoc (doc);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




