

from PyQt4 import QtGui, QtCore

from qt4gui import qt4factory

class GlyphSize(QtGui.QWidget):
    
    def __init__(self, *params):
        QtGui.QWidget.__init__(self, *params)
        self.layout = QtGui.QVBoxLayout()
        self.setLayout(self.layout)
        self.pb = QtGui.QPushButton("Test")
        self.pbChooseFont = QtGui.QPushButton("Font...")
        self.fontName = QtGui.QLabel()
        self.text = QtGui.QLineEdit()
        self.label = QtGui.QLabel()
        self.layout.addWidget(self.pb)
        self.layout.addWidget(self.pbChooseFont)
        self.layout.addWidget(self.text)
        self.layout.addWidget(self.label)
        
        self.fontSize = 20
        self.font = QtGui.QFont("Times New Roman", self.fontSize)
        
        self.text.setText("A")
        
        self.connect(self.pb, QtCore.SIGNAL("clicked()"), self.showText)
        self.connect(self.pbChooseFont, QtCore.SIGNAL("clicked()"), self.chooseFont)
        #self.connect(self.chooseFont, QtCore.SIGNAL("clicked()"), self.chooseFont)
        
    def showText(self):
        x,y,width,height = self.showGlyph(self.text.text())
        
    def chooseFont(self):
        font, ok = QtGui.QFontDialog.getFont(self)
        if ok:
            self.font = font
    
    def showGlyph(self, text):
        X = self.fontSize * 4.0
        Y = self.fontSize * 2.0
        image = QtGui.QImage(X,Y, QtGui.QImage.Format_RGB32)
        #print "orig dpm",image.dotsPerMeterX(), image.dotsPerMeterY()
        #dpm = 5000
#        image.setDotsPerMeterX(dpm)
#        image.setDotsPerMeterY(dpm)

        whiteRGB = QtGui.qRgb(255,255,255)
        #print "white",whiteRGB
        image.fill(whiteRGB)
        painter = QtGui.QPainter(image)
        painter.setFont(self.font)
        brush = QtGui.QBrush(QtCore.Qt.red)
        painter.setBrush(brush)
        painter.drawText(X/4.0,Y*3/4.0,text)
        painter.end()
        minY = Y
        maxY = 0
        minX = X
        maxX = 0
        for x in range(X):
            pixelFound = False
            for y in range(Y):
                #print "x,y,c",x,y,image.pixel(x,y)
                if not image.pixel(x,y) == whiteRGB:
                    pixelFound = True
                    if y < minY:
                        #print x,y,"miny", y
                        minY = y
                    break
            for y in reversed(range(Y)):
                if not image.pixel(x,y) == whiteRGB:
                    pixelFound = True
                    if y > maxY:
                        #################print x,y,"maxy", y
                        maxY = y
                    break
            if pixelFound:
                if minX == X:
                    minX = x
                if x > maxX:
                    maxX = x
                    
        x = minX - X/4.0
        y = minY - Y*3/4.0
        width = maxX - minX
        height = maxY - minY
        print x,y,width,height
        
        fm = QtGui.QFontMetrics(self.font)
        rect = QtGui.QFontMetrics.boundingRect(fm,0,0,1000,1000,QtCore.Qt.AlignLeft + QtCore.Qt.AlignTop, text)
        print "qtBoundingRect",qt4factory.Rect(rect.x(),rect.y(),rect.width(),rect.height())
        print "boundingRect",qt4factory.Rect(rect.x(),-(rect.height()+rect.y()),rect.width(),rect.height())
        
        
#        pen  = QtGui.QPen()
#        pen.setWidth(1)
#        painter.setPen(pen)
#        brush = QtGui.QBrush(QtCore.Qt.white)
#        painter.setBrush(brush)
#        painter.drawRect(X/2 + x, Y/2 + y,width,height)
#        brush = QtGui.QBrush(QtCore.Qt.white)
#        painter.setBrush(brush)
#        painter.drawText(X/2,Y/2,text)
#        brush = QtGui.QBrush(QtCore.Qt.red)
#        painter.setBrush(brush)
#        painter.drawRect(X/2, Y/2,1,1)
#        painter.end()
        self.label.setPixmap(QtGui.QPixmap.fromImage(image))
        return x,y,width,height
    
    
if __name__ == "__main__":
    app = QtGui.QApplication([])
    test = GlyphSize(None)
    test.show()
    app.exec_()
    #unittest.main()
