// Code generated by gqlclientgen - DO NOT EDIT.

package todosrht

import (
	"context"
	"encoding/json"
	"fmt"
	gqlclient "git.sr.ht/~emersion/gqlclient"
)

type ACL struct {
	// Permission to view tickets
	Browse bool `json:"browse"`
	// Permission to submit tickets
	Submit bool `json:"submit"`
	// Permission to comment on tickets
	Comment bool `json:"comment"`
	// Permission to edit tickets
	Edit bool `json:"edit"`
	// Permission to resolve, re-open, transfer, or label tickets
	Triage bool `json:"triage"`

	// Underlying value of the GraphQL interface
	Value ACLValue `json:"-"`
}

func (base *ACL) UnmarshalJSON(b []byte) error {
	type Raw ACL
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "TrackerACL":
		base.Value = new(TrackerACL)
	case "DefaultACL":
		base.Value = new(DefaultACL)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface ACL: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// ACLValue is one of: TrackerACL | DefaultACL
type ACLValue interface {
	isACL()
}

// A cursor for enumerating access control list entries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type ACLCursor struct {
	Results []TrackerACL `json:"results"`
	Cursor  *Cursor      `json:"cursor,omitempty"`
}

type ACLInput struct {
	// Permission to view tickets
	Browse bool `json:"browse"`
	// Permission to submit tickets
	Submit bool `json:"submit"`
	// Permission to comment on tickets
	Comment bool `json:"comment"`
	// Permission to edit tickets
	Edit bool `json:"edit"`
	// Permission to resolve, re-open, transfer, or label tickets
	Triage bool `json:"triage"`
}

type AccessKind string

const (
	AccessKindRo AccessKind = "RO"
	AccessKindRw AccessKind = "RW"
)

type AccessScope string

const (
	AccessScopeProfile       AccessScope = "PROFILE"
	AccessScopeTrackers      AccessScope = "TRACKERS"
	AccessScopeTickets       AccessScope = "TICKETS"
	AccessScopeAcls          AccessScope = "ACLS"
	AccessScopeEvents        AccessScope = "EVENTS"
	AccessScopeSubscriptions AccessScope = "SUBSCRIPTIONS"
)

type ActivitySubscription struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`

	// Underlying value of the GraphQL interface
	Value ActivitySubscriptionValue `json:"-"`
}

func (base *ActivitySubscription) UnmarshalJSON(b []byte) error {
	type Raw ActivitySubscription
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "TrackerSubscription":
		base.Value = new(TrackerSubscription)
	case "TicketSubscription":
		base.Value = new(TicketSubscription)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface ActivitySubscription: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// ActivitySubscriptionValue is one of: TrackerSubscription | TicketSubscription
type ActivitySubscriptionValue interface {
	isActivitySubscription()
}

// A cursor for enumerating subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type ActivitySubscriptionCursor struct {
	Results []ActivitySubscription `json:"results"`
	Cursor  *Cursor                `json:"cursor,omitempty"`
}

type Assignment struct {
	EventType EventType `json:"eventType"`
	Ticket    *Ticket   `json:"ticket"`
	Assigner  *Entity   `json:"assigner"`
	Assignee  *Entity   `json:"assignee"`
}

func (*Assignment) isEventDetail() {}

type Authenticity string

const (
	// The server vouches for this information as entered verbatim by the
	// attributed entity.
	AuthenticityAuthentic Authenticity = "AUTHENTIC"
	// The server does not vouch for this information as entered by the attributed
	// entity, no authentication was provided.
	AuthenticityUnauthenticated Authenticity = "UNAUTHENTICATED"
	// The server has evidence that the information has likely been manipulated by
	// a third-party.
	AuthenticityTampered Authenticity = "TAMPERED"
)

type Comment struct {
	EventType    EventType    `json:"eventType"`
	Ticket       *Ticket      `json:"ticket"`
	Author       *Entity      `json:"author"`
	Text         string       `json:"text"`
	Authenticity Authenticity `json:"authenticity"`
	// If this comment has been edited, this field points to the new revision.
	SupersededBy *Comment `json:"supersededBy,omitempty"`
}

func (*Comment) isEventDetail() {}

type Created struct {
	EventType EventType `json:"eventType"`
	Ticket    *Ticket   `json:"ticket"`
	Author    *Entity   `json:"author"`
}

func (*Created) isEventDetail() {}

type Cursor string

// These ACL policies are applied non-specifically, e.g. the default ACL for all
// authenticated users.
type DefaultACL struct {
	Browse  bool `json:"browse"`
	Submit  bool `json:"submit"`
	Comment bool `json:"comment"`
	Edit    bool `json:"edit"`
	Triage  bool `json:"triage"`
}

func (*DefaultACL) isACL() {}

type EmailAddress struct {
	CanonicalName string `json:"canonicalName"`
	// "jdoe@example.org" of "Jane Doe <jdoe@example.org>"
	Mailbox string `json:"mailbox"`
	// "Jane Doe" of "Jane Doe <jdoe@example.org>"
	Name *string `json:"name,omitempty"`
}

func (*EmailAddress) isEntity() {}

type EmailCmd string

const (
	EmailCmdResolve EmailCmd = "RESOLVE"
	EmailCmdReopen  EmailCmd = "REOPEN"
	EmailCmdLabel   EmailCmd = "LABEL"
	EmailCmdUnlabel EmailCmd = "UNLABEL"
)

type Entity struct {
	CanonicalName string `json:"canonicalName"`

	// Underlying value of the GraphQL interface
	Value EntityValue `json:"-"`
}

func (base *Entity) UnmarshalJSON(b []byte) error {
	type Raw Entity
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "User":
		base.Value = new(User)
	case "EmailAddress":
		base.Value = new(EmailAddress)
	case "ExternalUser":
		base.Value = new(ExternalUser)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Entity: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// EntityValue is one of: User | EmailAddress | ExternalUser
type EntityValue interface {
	isEntity()
}

// Represents an event which affects a ticket. Multiple changes can occur in a
// single event, and are enumerated in the "changes" field.
type Event struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Changes []EventDetail  `json:"changes"`
	Ticket  *Ticket        `json:"ticket"`
}

type EventCreated struct {
	Uuid     string         `json:"uuid"`
	Event    WebhookEvent   `json:"event"`
	Date     gqlclient.Time `json:"date"`
	NewEvent *Event         `json:"newEvent"`
}

func (*EventCreated) isWebhookPayload() {}

// A cursor for enumerating events
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type EventCursor struct {
	Results []Event `json:"results"`
	Cursor  *Cursor `json:"cursor,omitempty"`
}

type EventDetail struct {
	EventType EventType `json:"eventType"`
	Ticket    *Ticket   `json:"ticket"`

	// Underlying value of the GraphQL interface
	Value EventDetailValue `json:"-"`
}

func (base *EventDetail) UnmarshalJSON(b []byte) error {
	type Raw EventDetail
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "Created":
		base.Value = new(Created)
	case "Assignment":
		base.Value = new(Assignment)
	case "Comment":
		base.Value = new(Comment)
	case "LabelUpdate":
		base.Value = new(LabelUpdate)
	case "StatusChange":
		base.Value = new(StatusChange)
	case "UserMention":
		base.Value = new(UserMention)
	case "TicketMention":
		base.Value = new(TicketMention)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface EventDetail: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// EventDetailValue is one of: Created | Assignment | Comment | LabelUpdate | StatusChange | UserMention | TicketMention
type EventDetailValue interface {
	isEventDetail()
}

type EventType string

const (
	EventTypeCreated         EventType = "CREATED"
	EventTypeComment         EventType = "COMMENT"
	EventTypeStatusChange    EventType = "STATUS_CHANGE"
	EventTypeLabelAdded      EventType = "LABEL_ADDED"
	EventTypeLabelRemoved    EventType = "LABEL_REMOVED"
	EventTypeAssignedUser    EventType = "ASSIGNED_USER"
	EventTypeUnassignedUser  EventType = "UNASSIGNED_USER"
	EventTypeUserMentioned   EventType = "USER_MENTIONED"
	EventTypeTicketMentioned EventType = "TICKET_MENTIONED"
)

type ExternalUser struct {
	CanonicalName string `json:"canonicalName"`
	// <service>:<service specific details...>
	// e.g. github:ddevault
	ExternalId string `json:"externalId"`
	// The canonical external URL for this user, e.g. https://github.com/ddevault
	ExternalUrl *string `json:"externalUrl,omitempty"`
}

func (*ExternalUser) isEntity() {}

// This is used for importing tickets from third-party services, and may only be
// used by the tracker owner. It causes a ticket submission, update, or comment
// to be attributed to an external user and appear as if it were submitted at a
// specific time.
type ImportInput struct {
	Created gqlclient.Time `json:"created"`
	// External user ID. By convention this should be "service:username", e.g.
	// "codeberg:ddevault".
	ExternalId string `json:"externalId"`
	// A URL at which the user's external profile may be found, e.g.
	// "https://codeberg.org/ddevault".
	ExternalUrl string `json:"externalUrl"`
}

type Label struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Name    string         `json:"name"`
	Tracker *Tracker       `json:"tracker"`
	// In CSS hexadecimal format
	BackgroundColor string        `json:"backgroundColor"`
	ForegroundColor string        `json:"foregroundColor"`
	Tickets         *TicketCursor `json:"tickets"`
}

// A cursor for enumerating labels
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type LabelCursor struct {
	Results []Label `json:"results"`
	Cursor  *Cursor `json:"cursor,omitempty"`
}

type LabelEvent struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`
	Label *Label         `json:"label"`
}

func (*LabelEvent) isWebhookPayload() {}

type LabelUpdate struct {
	EventType EventType `json:"eventType"`
	Ticket    *Ticket   `json:"ticket"`
	Labeler   *Entity   `json:"labeler"`
	Label     *Label    `json:"label"`
}

func (*LabelUpdate) isEventDetail() {}

type OAuthClient struct {
	Uuid string `json:"uuid"`
}

type StatusChange struct {
	EventType     EventType        `json:"eventType"`
	Ticket        *Ticket          `json:"ticket"`
	Editor        *Entity          `json:"editor"`
	OldStatus     TicketStatus     `json:"oldStatus"`
	NewStatus     TicketStatus     `json:"newStatus"`
	OldResolution TicketResolution `json:"oldResolution"`
	NewResolution TicketResolution `json:"newResolution"`
}

func (*StatusChange) isEventDetail() {}

type SubmitCommentEmailInput struct {
	Text       string            `json:"text"`
	SenderId   int32             `json:"senderId"`
	Cmd        *EmailCmd         `json:"cmd,omitempty"`
	Resolution *TicketResolution `json:"resolution,omitempty"`
	LabelIds   []int32           `json:"labelIds,omitempty"`
	MessageId  string            `json:"messageId"`
}

// You may omit the status or resolution fields to leave them unchanged (or if
// you do not have permission to change them). "resolution" is required if
// status is RESOLVED.
type SubmitCommentInput struct {
	Text       string            `json:"text"`
	Status     *TicketStatus     `json:"status,omitempty"`
	Resolution *TicketResolution `json:"resolution,omitempty"`
	// For use by the tracker owner only
	Import *ImportInput `json:"import,omitempty"`
}

type SubmitTicketEmailInput struct {
	Subject   string  `json:"subject"`
	Body      *string `json:"body,omitempty"`
	SenderId  int32   `json:"senderId"`
	MessageId string  `json:"messageId"`
}

type SubmitTicketInput struct {
	Subject     string         `json:"subject"`
	Body        *string        `json:"body,omitempty"`
	Created     gqlclient.Time `json:"created,omitempty"`
	ExternalId  *string        `json:"externalId,omitempty"`
	ExternalUrl *string        `json:"externalUrl,omitempty"`
}

type Ticket struct {
	// The ticket ID is unique within each tracker, but is not globally unique.
	// The first ticket opened on a given tracker will have ID 1, then 2, and so
	// on.
	Id        int32          `json:"id"`
	Created   gqlclient.Time `json:"created"`
	Updated   gqlclient.Time `json:"updated"`
	Submitter *Entity        `json:"submitter"`
	Tracker   *Tracker       `json:"tracker"`
	// Canonical ticket reference string; may be used in comments to identify the
	// ticket from anywhere.
	Ref          string           `json:"ref"`
	Subject      string           `json:"subject"`
	Body         *string          `json:"body,omitempty"`
	Status       TicketStatus     `json:"status"`
	Resolution   TicketResolution `json:"resolution"`
	Authenticity Authenticity     `json:"authenticity"`
	Labels       []Label          `json:"labels"`
	Assignees    []Entity         `json:"assignees"`
	Events       *EventCursor     `json:"events"`
	// If the authenticated user is subscribed to this ticket, this is that
	// subscription.
	Subscription *TicketSubscription `json:"subscription,omitempty"`
	// Returns a list of ticket webhook subscriptions. For clients
	// authenticated with a personal access token, this returns all webhooks
	// configured by all GraphQL clients for your account. For clients
	// authenticated with an OAuth 2.0 access token, this returns only webhooks
	// registered for your client.
	Webhooks *WebhookSubscriptionCursor `json:"webhooks"`
	// Returns details of a ticket webhook subscription by its ID.
	Webhook *WebhookSubscription `json:"webhook,omitempty"`
}

// A cursor for enumerating tickets
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type TicketCursor struct {
	Results []Ticket `json:"results"`
	Cursor  *Cursor  `json:"cursor,omitempty"`
}

type TicketDeletedEvent struct {
	Uuid      string         `json:"uuid"`
	Event     WebhookEvent   `json:"event"`
	Date      gqlclient.Time `json:"date"`
	TrackerId int32          `json:"trackerId"`
	TicketId  int32          `json:"ticketId"`
}

func (*TicketDeletedEvent) isWebhookPayload() {}

type TicketEvent struct {
	Uuid   string         `json:"uuid"`
	Event  WebhookEvent   `json:"event"`
	Date   gqlclient.Time `json:"date"`
	Ticket *Ticket        `json:"ticket"`
}

func (*TicketEvent) isWebhookPayload() {}

type TicketMention struct {
	EventType EventType `json:"eventType"`
	Ticket    *Ticket   `json:"ticket"`
	Author    *Entity   `json:"author"`
	Mentioned *Ticket   `json:"mentioned"`
}

func (*TicketMention) isEventDetail() {}

type TicketResolution string

const (
	TicketResolutionUnresolved  TicketResolution = "UNRESOLVED"
	TicketResolutionClosed      TicketResolution = "CLOSED"
	TicketResolutionFixed       TicketResolution = "FIXED"
	TicketResolutionImplemented TicketResolution = "IMPLEMENTED"
	TicketResolutionWontFix     TicketResolution = "WONT_FIX"
	TicketResolutionByDesign    TicketResolution = "BY_DESIGN"
	TicketResolutionInvalid     TicketResolution = "INVALID"
	TicketResolutionDuplicate   TicketResolution = "DUPLICATE"
	TicketResolutionNotOurBug   TicketResolution = "NOT_OUR_BUG"
)

type TicketStatus string

const (
	TicketStatusReported   TicketStatus = "REPORTED"
	TicketStatusConfirmed  TicketStatus = "CONFIRMED"
	TicketStatusInProgress TicketStatus = "IN_PROGRESS"
	TicketStatusPending    TicketStatus = "PENDING"
	TicketStatusResolved   TicketStatus = "RESOLVED"
)

// A ticket subscription will notify a participant when activity occurs on a
// ticket.
type TicketSubscription struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Ticket  *Ticket        `json:"ticket"`
}

func (*TicketSubscription) isActivitySubscription() {}

type TicketWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type TicketWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
	Ticket     *Ticket                `json:"ticket"`
}

func (*TicketWebhookSubscription) isWebhookSubscription() {}

type Tracker struct {
	Id          int32          `json:"id"`
	Created     gqlclient.Time `json:"created"`
	Updated     gqlclient.Time `json:"updated"`
	Owner       *Entity        `json:"owner"`
	Name        string         `json:"name"`
	Description *string        `json:"description,omitempty"`
	Visibility  Visibility     `json:"visibility"`
	Ticket      *Ticket        `json:"ticket"`
	Tickets     *TicketCursor  `json:"tickets"`
	Label       *Label         `json:"label,omitempty"`
	Labels      *LabelCursor   `json:"labels"`
	// If the authenticated user is subscribed to this tracker, this is that
	// subscription.
	Subscription *TrackerSubscription `json:"subscription,omitempty"`
	// The access control list entry (or the default ACL) which describes the
	// authenticated user's permissions with respect to this tracker.
	Acl        *ACL        `json:"acl,omitempty"`
	DefaultACL *DefaultACL `json:"defaultACL"`
	Acls       *ACLCursor  `json:"acls"`
	// Returns a URL from which the tracker owner may download a gzipped JSON
	// archive of the tracker.
	Export URL `json:"export"`
	// Returns a list of tracker webhook subscriptions. For clients
	// authenticated with a personal access token, this returns all webhooks
	// configured by all GraphQL clients for your account. For clients
	// authenticated with an OAuth 2.0 access token, this returns only webhooks
	// registered for your client.
	Webhooks *WebhookSubscriptionCursor `json:"webhooks"`
	// Returns details of a tracker webhook subscription by its ID.
	Webhook *WebhookSubscription `json:"webhook,omitempty"`
}

// These ACLs are configured for specific entities, and may be used to expand or
// constrain the rights of a participant.
type TrackerACL struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Tracker *Tracker       `json:"tracker"`
	Entity  *Entity        `json:"entity"`
	Browse  bool           `json:"browse"`
	Submit  bool           `json:"submit"`
	Comment bool           `json:"comment"`
	Edit    bool           `json:"edit"`
	Triage  bool           `json:"triage"`
}

func (*TrackerACL) isACL() {}

// A cursor for enumerating trackers
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type TrackerCursor struct {
	Results []Tracker `json:"results"`
	Cursor  *Cursor   `json:"cursor,omitempty"`
}

type TrackerEvent struct {
	Uuid    string         `json:"uuid"`
	Event   WebhookEvent   `json:"event"`
	Date    gqlclient.Time `json:"date"`
	Tracker *Tracker       `json:"tracker"`
}

func (*TrackerEvent) isWebhookPayload() {}

// You may omit any fields to leave them unchanged.
type TrackerInput struct {
	Name        *string     `json:"name,omitempty"`
	Description *string     `json:"description,omitempty"`
	Visibility  *Visibility `json:"visibility,omitempty"`
}

// A tracker subscription will notify a participant of all activity for a
// tracker, including all new tickets and their events.
type TrackerSubscription struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Tracker *Tracker       `json:"tracker"`
}

func (*TrackerSubscription) isActivitySubscription() {}

type TrackerWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type TrackerWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
	Tracker    *Tracker               `json:"tracker"`
}

func (*TrackerWebhookSubscription) isWebhookSubscription() {}

type URL string

// You may omit any fields to leave them unchanged.
type UpdateLabelInput struct {
	Name            *string `json:"name,omitempty"`
	ForegroundColor *string `json:"foregroundColor,omitempty"`
	BackgroundColor *string `json:"backgroundColor,omitempty"`
}

// "resolution" is required if status is RESOLVED.
type UpdateStatusInput struct {
	Status     TicketStatus      `json:"status"`
	Resolution *TicketResolution `json:"resolution,omitempty"`
	// For use by the tracker owner only
	Import *ImportInput `json:"import,omitempty"`
}

// You may omit any fields to leave them unchanged. To remove the ticket body,
// set it to null.
type UpdateTicketInput struct {
	Subject *string `json:"subject,omitempty"`
	Body    *string `json:"body,omitempty"`
	// For use by the tracker owner only
	Import *ImportInput `json:"import,omitempty"`
}

type User struct {
	Id            int32          `json:"id"`
	Created       gqlclient.Time `json:"created"`
	Updated       gqlclient.Time `json:"updated"`
	CanonicalName string         `json:"canonicalName"`
	Username      string         `json:"username"`
	Email         string         `json:"email"`
	Url           *string        `json:"url,omitempty"`
	Location      *string        `json:"location,omitempty"`
	Bio           *string        `json:"bio,omitempty"`
	// Returns a specific tracker.
	Tracker  *Tracker       `json:"tracker,omitempty"`
	Trackers *TrackerCursor `json:"trackers"`
}

func (*User) isEntity() {}

type UserMention struct {
	EventType EventType `json:"eventType"`
	Ticket    *Ticket   `json:"ticket"`
	Author    *Entity   `json:"author"`
	Mentioned *Entity   `json:"mentioned"`
}

func (*UserMention) isEventDetail() {}

type UserWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type UserWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
}

func (*UserWebhookSubscription) isWebhookSubscription() {}

type Version struct {
	Major int32 `json:"major"`
	Minor int32 `json:"minor"`
	Patch int32 `json:"patch"`
	// If this API version is scheduled for deprecation, this is the date on which
	// it will stop working; or null if this API version is not scheduled for
	// deprecation.
	DeprecationDate gqlclient.Time `json:"deprecationDate,omitempty"`
}

type Visibility string

const (
	VisibilityPublic   Visibility = "PUBLIC"
	VisibilityUnlisted Visibility = "UNLISTED"
	VisibilityPrivate  Visibility = "PRIVATE"
)

type WebhookDelivery struct {
	Uuid         string               `json:"uuid"`
	Date         gqlclient.Time       `json:"date"`
	Event        WebhookEvent         `json:"event"`
	Subscription *WebhookSubscription `json:"subscription"`
	RequestBody  string               `json:"requestBody"`
	// These details are provided only after a response is received from the
	// remote server. If a response is sent whose Content-Type is not text/*, or
	// cannot be decoded as UTF-8, the response body will be null. It will be
	// truncated after 64 KiB.
	ResponseBody    *string `json:"responseBody,omitempty"`
	ResponseHeaders *string `json:"responseHeaders,omitempty"`
	ResponseStatus  *int32  `json:"responseStatus,omitempty"`
}

// A cursor for enumerating a list of webhook deliveries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookDeliveryCursor struct {
	Results []WebhookDelivery `json:"results"`
	Cursor  *Cursor           `json:"cursor,omitempty"`
}

type WebhookEvent string

const (
	WebhookEventTrackerCreated WebhookEvent = "TRACKER_CREATED"
	WebhookEventTrackerUpdate  WebhookEvent = "TRACKER_UPDATE"
	WebhookEventTrackerDeleted WebhookEvent = "TRACKER_DELETED"
	WebhookEventTicketCreated  WebhookEvent = "TICKET_CREATED"
	WebhookEventTicketUpdate   WebhookEvent = "TICKET_UPDATE"
	WebhookEventTicketDeleted  WebhookEvent = "TICKET_DELETED"
	WebhookEventLabelCreated   WebhookEvent = "LABEL_CREATED"
	WebhookEventLabelUpdate    WebhookEvent = "LABEL_UPDATE"
	WebhookEventLabelDeleted   WebhookEvent = "LABEL_DELETED"
	WebhookEventEventCreated   WebhookEvent = "EVENT_CREATED"
)

type WebhookPayload struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`

	// Underlying value of the GraphQL interface
	Value WebhookPayloadValue `json:"-"`
}

func (base *WebhookPayload) UnmarshalJSON(b []byte) error {
	type Raw WebhookPayload
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "TrackerEvent":
		base.Value = new(TrackerEvent)
	case "TicketEvent":
		base.Value = new(TicketEvent)
	case "TicketDeletedEvent":
		base.Value = new(TicketDeletedEvent)
	case "EventCreated":
		base.Value = new(EventCreated)
	case "LabelEvent":
		base.Value = new(LabelEvent)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookPayload: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookPayloadValue is one of: TrackerEvent | TicketEvent | TicketDeletedEvent | EventCreated | LabelEvent
type WebhookPayloadValue interface {
	isWebhookPayload()
}

type WebhookSubscription struct {
	Id     int32          `json:"id"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
	Url    string         `json:"url"`
	// If this webhook was registered by an authorized OAuth 2.0 client, this
	// field is non-null.
	Client *OAuthClient `json:"client,omitempty"`
	// All deliveries which have been sent to this webhook.
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	// Returns a sample payload for this subscription, for testing purposes
	Sample string `json:"sample"`

	// Underlying value of the GraphQL interface
	Value WebhookSubscriptionValue `json:"-"`
}

func (base *WebhookSubscription) UnmarshalJSON(b []byte) error {
	type Raw WebhookSubscription
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "UserWebhookSubscription":
		base.Value = new(UserWebhookSubscription)
	case "TrackerWebhookSubscription":
		base.Value = new(TrackerWebhookSubscription)
	case "TicketWebhookSubscription":
		base.Value = new(TicketWebhookSubscription)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookSubscription: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookSubscriptionValue is one of: UserWebhookSubscription | TrackerWebhookSubscription | TicketWebhookSubscription
type WebhookSubscriptionValue interface {
	isWebhookSubscription()
}

// A cursor for enumerating a list of webhook subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookSubscriptionCursor struct {
	Results []WebhookSubscription `json:"results"`
	Cursor  *Cursor               `json:"cursor,omitempty"`
}

func Trackers(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (trackers *TrackerCursor, err error) {
	op := gqlclient.NewOperation("query trackers ($cursor: Cursor) {\n\ttrackers(cursor: $cursor) {\n\t\t... trackers\n\t}\n}\nfragment trackers on TrackerCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t}\n\tcursor\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Trackers *TrackerCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Trackers, err
}

func TrackersByUser(client *gqlclient.Client, ctx context.Context, username string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query trackersByUser ($username: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\ttrackers(cursor: $cursor) {\n\t\t\t... trackers\n\t\t}\n\t}\n}\nfragment trackers on TrackerCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t}\n\tcursor\n}\n")
	op.Var("username", username)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func ExportTracker(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query exportTracker ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\t... trackerExport\n\t\t}\n\t}\n}\nfragment trackerExport on Tracker {\n\tname\n\tdescription\n\tvisibility\n\texport\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func ExportTrackers(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (trackers *TrackerCursor, err error) {
	op := gqlclient.NewOperation("query exportTrackers ($cursor: Cursor) {\n\ttrackers(cursor: $cursor) {\n\t\tresults {\n\t\t\t... trackerExport\n\t\t}\n\t\tcursor\n\t}\n}\nfragment trackerExport on Tracker {\n\tname\n\tdescription\n\tvisibility\n\texport\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Trackers *TrackerCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Trackers, err
}

func TrackerIDByName(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query trackerIDByName ($name: String!) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func TrackerIDByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query trackerIDByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func Tickets(client *gqlclient.Client, ctx context.Context, name string, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query tickets ($name: String!, $cursor: Cursor) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\ttickets(cursor: $cursor) {\n\t\t\t\t... tickets\n\t\t\t}\n\t\t}\n\t}\n}\nfragment tickets on TicketCursor {\n\tresults {\n\t\tid\n\t\tsubject\n\t\tstatus\n\t\tresolution\n\t\tcreated\n\t\tsubmitter {\n\t\t\tcanonicalName\n\t\t}\n\t\tlabels {\n\t\t\tname\n\t\t\tbackgroundColor\n\t\t\tforegroundColor\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func TicketsByUser(client *gqlclient.Client, ctx context.Context, username string, name string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query ticketsByUser ($username: String!, $name: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\ttickets(cursor: $cursor) {\n\t\t\t\t... tickets\n\t\t\t}\n\t\t}\n\t}\n}\nfragment tickets on TicketCursor {\n\tresults {\n\t\tid\n\t\tsubject\n\t\tstatus\n\t\tresolution\n\t\tcreated\n\t\tsubmitter {\n\t\t\tcanonicalName\n\t\t}\n\t\tlabels {\n\t\t\tname\n\t\t\tbackgroundColor\n\t\t\tforegroundColor\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func Labels(client *gqlclient.Client, ctx context.Context, name string, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query labels ($name: String!, $cursor: Cursor) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tlabels(cursor: $cursor) {\n\t\t\t\t... labels\n\t\t\t}\n\t\t}\n\t}\n}\nfragment labels on LabelCursor {\n\tresults {\n\t\tname\n\t\tbackgroundColor\n\t\tforegroundColor\n\t}\n\tcursor\n}\n")
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func LabelsByUser(client *gqlclient.Client, ctx context.Context, username string, name string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query labelsByUser ($username: String!, $name: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\tlabels(cursor: $cursor) {\n\t\t\t\t... labels\n\t\t\t}\n\t\t}\n\t}\n}\nfragment labels on LabelCursor {\n\tresults {\n\t\tname\n\t\tbackgroundColor\n\t\tforegroundColor\n\t}\n\tcursor\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func AclByTrackerName(client *gqlclient.Client, ctx context.Context, name string, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query aclByTrackerName ($name: String!, $cursor: Cursor) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\t... acl\n\t\t}\n\t}\n}\nfragment acl on Tracker {\n\tdefaultACL {\n\t\tbrowse\n\t\tsubmit\n\t\tcomment\n\t\tedit\n\t\ttriage\n\t}\n\tacls(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\tcreated\n\t\t\tentity {\n\t\t\t\tcanonicalName\n\t\t\t}\n\t\t\tbrowse\n\t\t\tsubmit\n\t\t\tcomment\n\t\t\tedit\n\t\t\ttriage\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func AclByUser(client *gqlclient.Client, ctx context.Context, username string, name string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query aclByUser ($username: String!, $name: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\t... acl\n\t\t}\n\t}\n}\nfragment acl on Tracker {\n\tdefaultACL {\n\t\tbrowse\n\t\tsubmit\n\t\tcomment\n\t\tedit\n\t\ttriage\n\t}\n\tacls(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\tcreated\n\t\t\tentity {\n\t\t\t\tcanonicalName\n\t\t\t}\n\t\t\tbrowse\n\t\t\tsubmit\n\t\t\tcomment\n\t\t\tedit\n\t\t\ttriage\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func UserIDByName(client *gqlclient.Client, ctx context.Context, username string) (user *User, err error) {
	op := gqlclient.NewOperation("query userIDByName ($username: String!) {\n\tuser(username: $username) {\n\t\tid\n\t}\n}\n")
	op.Var("username", username)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func Assignees(client *gqlclient.Client, ctx context.Context, name string, id int32) (me *User, err error) {
	op := gqlclient.NewOperation("query assignees ($name: String!, $id: Int!) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tticket(id: $id) {\n\t\t\t\tassignees {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func AssigneesByUser(client *gqlclient.Client, ctx context.Context, username string, name string, id int32) (user *User, err error) {
	op := gqlclient.NewOperation("query assigneesByUser ($username: String!, $name: String!, $id: Int!) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\tticket(id: $id) {\n\t\t\t\tassignees {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func CompleteTicketId(client *gqlclient.Client, ctx context.Context, name string, subscription bool) (me *User, err error) {
	op := gqlclient.NewOperation("query completeTicketId ($name: String!, $subscription: Boolean!) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\t... completeTicket\n\t\t}\n\t}\n}\nfragment completeTicket on Tracker {\n\ttickets {\n\t\tresults {\n\t\t\tid\n\t\t\tsubject\n\t\t\t... on Ticket @include(if: $subscription) {\n\t\t\t\tsubscription {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("subscription", subscription)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func CompleteTicketIdByUser(client *gqlclient.Client, ctx context.Context, username string, name string, subscription bool) (user *User, err error) {
	op := gqlclient.NewOperation("query completeTicketIdByUser ($username: String!, $name: String!, $subscription: Boolean!) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\t... completeTicket\n\t\t}\n\t}\n}\nfragment completeTicket on Tracker {\n\ttickets {\n\t\tresults {\n\t\t\tid\n\t\t\tsubject\n\t\t\t... on Ticket @include(if: $subscription) {\n\t\t\t\tsubscription {\n\t\t\t\t\tid\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("subscription", subscription)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func CompleteTicketAssign(client *gqlclient.Client, ctx context.Context, name string, id int32) (me *User, err error) {
	op := gqlclient.NewOperation("query completeTicketAssign ($name: String!, $id: Int!) {\n\tme {\n\t\tcanonicalName\n\t\ttracker(name: $name) {\n\t\t\tticket(id: $id) {\n\t\t\t\tassignees {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t}\n\t\t\ttickets {\n\t\t\t\tresults {\n\t\t\t\t\tassignees {\n\t\t\t\t\t\tcanonicalName\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func CompleteTicketAssignByUser(client *gqlclient.Client, ctx context.Context, username string, name string, id int32) (me *User, user *User, err error) {
	op := gqlclient.NewOperation("query completeTicketAssignByUser ($username: String!, $name: String!, $id: Int!) {\n\tme {\n\t\tcanonicalName\n\t}\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\tticket(id: $id) {\n\t\t\t\tassignees {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t}\n\t\t\ttickets {\n\t\t\t\tresults {\n\t\t\t\t\tassignees {\n\t\t\t\t\t\tcanonicalName\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		Me   *User
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, respData.User, err
}

func TrackerNames(client *gqlclient.Client, ctx context.Context) (trackers *TrackerCursor, err error) {
	op := gqlclient.NewOperation("query trackerNames {\n\ttrackers {\n\t\tresults {\n\t\t\tname\n\t\t}\n\t}\n}\n")
	var respData struct {
		Trackers *TrackerCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Trackers, err
}

func TicketWebhooks(client *gqlclient.Client, ctx context.Context, name string, id int32, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query ticketWebhooks ($name: String!, $id: Int!, $cursor: Cursor) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tticket(id: $id) {\n\t\t\t\t... ticketWebhooks\n\t\t\t}\n\t\t}\n\t}\n}\nfragment ticketWebhooks on Ticket {\n\twebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("name", name)
	op.Var("id", id)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func TicketWebhooksByUser(client *gqlclient.Client, ctx context.Context, username string, name string, id int32, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query ticketWebhooksByUser ($username: String!, $name: String!, $id: Int!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\tticket(id: $id) {\n\t\t\t\t... ticketWebhooks\n\t\t\t}\n\t\t}\n\t}\n}\nfragment ticketWebhooks on Ticket {\n\twebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("id", id)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func UserWebhooks(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (userWebhooks *WebhookSubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query userWebhooks ($cursor: Cursor) {\n\tuserWebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		UserWebhooks *WebhookSubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserWebhooks, err
}

func TrackerWebhooks(client *gqlclient.Client, ctx context.Context, name string, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query trackerWebhooks ($name: String!, $cursor: Cursor) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\t... trackerWebhooks\n\t\t}\n\t}\n}\nfragment trackerWebhooks on Tracker {\n\twebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func TrackerWebhooksByUser(client *gqlclient.Client, ctx context.Context, username string, name string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query trackerWebhooksByUser ($username: String!, $name: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\t... trackerWebhooks\n\t\t}\n\t}\n}\nfragment trackerWebhooks on Tracker {\n\twebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func TicketByName(client *gqlclient.Client, ctx context.Context, name string, id int32) (me *User, err error) {
	op := gqlclient.NewOperation("query ticketByName ($name: String!, $id: Int!) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tticket(id: $id) {\n\t\t\t\t... ticket\n\t\t\t}\n\t\t}\n\t}\n}\nfragment ticket on Ticket {\n\tcreated\n\tupdated\n\tsubmitter {\n\t\tcanonicalName\n\t}\n\tsubject\n\tbody\n\tstatus\n\tresolution\n\tlabels {\n\t\tname\n\t\tbackgroundColor\n\t\tforegroundColor\n\t}\n\tassignees {\n\t\tcanonicalName\n\t}\n\tevents {\n\t\tresults {\n\t\t\tcreated\n\t\t\tchanges {\n\t\t\t\t__typename\n\t\t\t\t... on Comment {\n\t\t\t\t\tauthor {\n\t\t\t\t\t\tcanonicalName\n\t\t\t\t\t}\n\t\t\t\t\ttext\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func TicketByUser(client *gqlclient.Client, ctx context.Context, username string, tracker string, id int32) (user *User, err error) {
	op := gqlclient.NewOperation("query ticketByUser ($username: String!, $tracker: String!, $id: Int!) {\n\tuser(username: $username) {\n\t\ttracker(name: $tracker) {\n\t\t\tticket(id: $id) {\n\t\t\t\t... ticket\n\t\t\t}\n\t\t}\n\t}\n}\nfragment ticket on Ticket {\n\tcreated\n\tupdated\n\tsubmitter {\n\t\tcanonicalName\n\t}\n\tsubject\n\tbody\n\tstatus\n\tresolution\n\tlabels {\n\t\tname\n\t\tbackgroundColor\n\t\tforegroundColor\n\t}\n\tassignees {\n\t\tcanonicalName\n\t}\n\tevents {\n\t\tresults {\n\t\t\tcreated\n\t\t\tchanges {\n\t\t\t\t__typename\n\t\t\t\t... on Comment {\n\t\t\t\t\tauthor {\n\t\t\t\t\t\tcanonicalName\n\t\t\t\t\t}\n\t\t\t\t\ttext\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("tracker", tracker)
	op.Var("id", id)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func TicketBodyByName(client *gqlclient.Client, ctx context.Context, name string, id int32) (me *User, err error) {
	op := gqlclient.NewOperation("query ticketBodyByName ($name: String!, $id: Int!) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tid\n\t\t\tticket(id: $id) {\n\t\t\t\t... ticketBody\n\t\t\t}\n\t\t}\n\t}\n}\nfragment ticketBody on Ticket {\n\tid\n\tsubject\n\tbody\n}\n")
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func TicketBodyByUser(client *gqlclient.Client, ctx context.Context, username string, tracker string, id int32) (user *User, err error) {
	op := gqlclient.NewOperation("query ticketBodyByUser ($username: String!, $tracker: String!, $id: Int!) {\n\tuser(username: $username) {\n\t\ttracker(name: $tracker) {\n\t\t\tid\n\t\t\tticket(id: $id) {\n\t\t\t\t... ticketBody\n\t\t\t}\n\t\t}\n\t}\n}\nfragment ticketBody on Ticket {\n\tid\n\tsubject\n\tbody\n}\n")
	op.Var("username", username)
	op.Var("tracker", tracker)
	op.Var("id", id)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func LabelIDByName(client *gqlclient.Client, ctx context.Context, trackerName string, labelName string) (me *User, err error) {
	op := gqlclient.NewOperation("query labelIDByName ($trackerName: String!, $labelName: String!) {\n\tme {\n\t\ttracker(name: $trackerName) {\n\t\t\tlabel(name: $labelName) {\n\t\t\t\tid\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("trackerName", trackerName)
	op.Var("labelName", labelName)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func LabelIDByUser(client *gqlclient.Client, ctx context.Context, username string, trackerName string, labelName string) (user *User, err error) {
	op := gqlclient.NewOperation("query labelIDByUser ($username: String!, $trackerName: String!, $labelName: String!) {\n\tuser(username: $username) {\n\t\ttracker(name: $trackerName) {\n\t\t\tlabel(name: $labelName) {\n\t\t\t\tid\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("trackerName", trackerName)
	op.Var("labelName", labelName)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func CompleteLabel(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query completeLabel ($name: String!) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tlabels {\n\t\t\t\tresults {\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func CompleteLabelByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query completeLabelByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\tlabels {\n\t\t\t\tresults {\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func CompleteTicketLabel(client *gqlclient.Client, ctx context.Context, name string, id int32) (me *User, err error) {
	op := gqlclient.NewOperation("query completeTicketLabel ($name: String!, $id: Int!) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tlabels {\n\t\t\t\tresults {\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t}\n\t\t\tticket(id: $id) {\n\t\t\t\tlabels {\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func CompleteTicketLabelByUser(client *gqlclient.Client, ctx context.Context, username string, name string, id int32) (user *User, err error) {
	op := gqlclient.NewOperation("query completeTicketLabelByUser ($username: String!, $name: String!, $id: Int!) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\tlabels {\n\t\t\t\tresults {\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t}\n\t\t\tticket(id: $id) {\n\t\t\t\tlabels {\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func CompleteTicketUnlabel(client *gqlclient.Client, ctx context.Context, name string, id int32) (me *User, err error) {
	op := gqlclient.NewOperation("query completeTicketUnlabel ($name: String!, $id: Int!) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tticket(id: $id) {\n\t\t\t\tlabels {\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func CompleteTicketUnlabelByUser(client *gqlclient.Client, ctx context.Context, username string, name string, id int32) (user *User, err error) {
	op := gqlclient.NewOperation("query completeTicketUnlabelByUser ($username: String!, $name: String!, $id: Int!) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\tticket(id: $id) {\n\t\t\t\tlabels {\n\t\t\t\t\tname\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("id", id)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func TrackerDescription(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query trackerDescription ($name: String!) {\n\tme {\n\t\ttracker(name: $name) {\n\t\t\tdescription\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func TrackerDescriptionByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query trackerDescriptionByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\ttracker(name: $name) {\n\t\t\tdescription\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func DeleteTracker(client *gqlclient.Client, ctx context.Context, id int32) (deleteTracker *Tracker, err error) {
	op := gqlclient.NewOperation("mutation deleteTracker ($id: Int!) {\n\tdeleteTracker(id: $id) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteTracker *Tracker
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteTracker, err
}

func SubmitComment(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32, input SubmitCommentInput) (submitComment *Event, err error) {
	op := gqlclient.NewOperation("mutation submitComment ($trackerId: Int!, $ticketId: Int!, $input: SubmitCommentInput!) {\n\tsubmitComment(trackerId: $trackerId, ticketId: $ticketId, input: $input) {\n\t\tticket {\n\t\t\tsubject\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	op.Var("input", input)
	var respData struct {
		SubmitComment *Event
	}
	err = client.Execute(ctx, op, &respData)
	return respData.SubmitComment, err
}

func UpdateTicketStatus(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32, input UpdateStatusInput) (updateTicketStatus *Event, err error) {
	op := gqlclient.NewOperation("mutation updateTicketStatus ($trackerId: Int!, $ticketId: Int!, $input: UpdateStatusInput!) {\n\tupdateTicketStatus(trackerId: $trackerId, ticketId: $ticketId, input: $input) {\n\t\tticket {\n\t\t\tsubject\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	op.Var("input", input)
	var respData struct {
		UpdateTicketStatus *Event
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateTicketStatus, err
}

func DeleteLabel(client *gqlclient.Client, ctx context.Context, id int32) (deleteLabel *Label, err error) {
	op := gqlclient.NewOperation("mutation deleteLabel ($id: Int!) {\n\tdeleteLabel(id: $id) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteLabel *Label
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteLabel, err
}

func CreateLabel(client *gqlclient.Client, ctx context.Context, trackerId int32, name string, foregroundColor string, backgroundColor string) (createLabel *Label, err error) {
	op := gqlclient.NewOperation("mutation createLabel ($trackerId: Int!, $name: String!, $foregroundColor: String!, $backgroundColor: String!) {\n\tcreateLabel(trackerId: $trackerId, name: $name, foregroundColor: $foregroundColor, backgroundColor: $backgroundColor) {\n\t\tname\n\t\tbackgroundColor\n\t\tforegroundColor\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("name", name)
	op.Var("foregroundColor", foregroundColor)
	op.Var("backgroundColor", backgroundColor)
	var respData struct {
		CreateLabel *Label
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateLabel, err
}

func UpdateLabel(client *gqlclient.Client, ctx context.Context, id int32, input UpdateLabelInput) (updateLabel *Label, err error) {
	op := gqlclient.NewOperation("mutation updateLabel ($id: Int!, $input: UpdateLabelInput!) {\n\tupdateLabel(id: $id, input: $input) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	op.Var("input", input)
	var respData struct {
		UpdateLabel *Label
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateLabel, err
}

func DeleteACL(client *gqlclient.Client, ctx context.Context, id int32) (deleteACL *TrackerACL, err error) {
	op := gqlclient.NewOperation("mutation deleteACL ($id: Int!) {\n\tdeleteACL(id: $id) {\n\t\ttracker {\n\t\t\tname\n\t\t}\n\t\tentity {\n\t\t\tcanonicalName\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteACL *TrackerACL
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteACL, err
}

func TrackerSubscribe(client *gqlclient.Client, ctx context.Context, trackerId int32) (trackerSubscribe *TrackerSubscription, err error) {
	op := gqlclient.NewOperation("mutation trackerSubscribe ($trackerId: Int!) {\n\ttrackerSubscribe(trackerId: $trackerId) {\n\t\ttracker {\n\t\t\tname\n\t\t\towner {\n\t\t\t\tcanonicalName\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	var respData struct {
		TrackerSubscribe *TrackerSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.TrackerSubscribe, err
}

func TrackerUnsubscribe(client *gqlclient.Client, ctx context.Context, trackerId int32) (trackerUnsubscribe *TrackerSubscription, err error) {
	op := gqlclient.NewOperation("mutation trackerUnsubscribe ($trackerId: Int!) {\n\ttrackerUnsubscribe(trackerId: $trackerId, tickets: false) {\n\t\ttracker {\n\t\t\tname\n\t\t\towner {\n\t\t\t\tcanonicalName\n\t\t\t}\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	var respData struct {
		TrackerUnsubscribe *TrackerSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.TrackerUnsubscribe, err
}

func TicketSubscribe(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32) (ticketSubscribe *TicketSubscription, err error) {
	op := gqlclient.NewOperation("mutation ticketSubscribe ($trackerId: Int!, $ticketId: Int!) {\n\tticketSubscribe(trackerId: $trackerId, ticketId: $ticketId) {\n\t\tticket {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	var respData struct {
		TicketSubscribe *TicketSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.TicketSubscribe, err
}

func TicketUnsubscribe(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32) (ticketUnsubscribe *TicketSubscription, err error) {
	op := gqlclient.NewOperation("mutation ticketUnsubscribe ($trackerId: Int!, $ticketId: Int!) {\n\tticketUnsubscribe(trackerId: $trackerId, ticketId: $ticketId) {\n\t\tticket {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	var respData struct {
		TicketUnsubscribe *TicketSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.TicketUnsubscribe, err
}

func AssignUser(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32, userId int32) (assignUser *Event, err error) {
	op := gqlclient.NewOperation("mutation assignUser ($trackerId: Int!, $ticketId: Int!, $userId: Int!) {\n\tassignUser(trackerId: $trackerId, ticketId: $ticketId, userId: $userId) {\n\t\tticket {\n\t\t\tsubject\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	op.Var("userId", userId)
	var respData struct {
		AssignUser *Event
	}
	err = client.Execute(ctx, op, &respData)
	return respData.AssignUser, err
}

func UnassignUser(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32, userId int32) (unassignUser *Event, err error) {
	op := gqlclient.NewOperation("mutation unassignUser ($trackerId: Int!, $ticketId: Int!, $userId: Int!) {\n\tunassignUser(trackerId: $trackerId, ticketId: $ticketId, userId: $userId) {\n\t\tticket {\n\t\t\tsubject\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	op.Var("userId", userId)
	var respData struct {
		UnassignUser *Event
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UnassignUser, err
}

func CreateTracker(client *gqlclient.Client, ctx context.Context, name string, description *string, visibility Visibility) (createTracker *Tracker, err error) {
	op := gqlclient.NewOperation("mutation createTracker ($name: String!, $description: String, $visibility: Visibility!) {\n\tcreateTracker(name: $name, description: $description, visibility: $visibility) {\n\t\tname\n\t}\n}\n")
	op.Var("name", name)
	op.Var("description", description)
	op.Var("visibility", visibility)
	var respData struct {
		CreateTracker *Tracker
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateTracker, err
}

func ImportTracker(client *gqlclient.Client, ctx context.Context, name string, description *string, visibility Visibility, dump gqlclient.Upload) (createTracker *Tracker, err error) {
	op := gqlclient.NewOperation("mutation importTracker ($name: String!, $description: String, $visibility: Visibility!, $dump: Upload!) {\n\tcreateTracker(name: $name, description: $description, visibility: $visibility, importUpload: $dump) {\n\t\tid\n\t}\n}\n")
	op.Var("name", name)
	op.Var("description", description)
	op.Var("visibility", visibility)
	op.Var("dump", dump)
	var respData struct {
		CreateTracker *Tracker
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateTracker, err
}

func DeleteTicket(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32) (deleteTicket *Ticket, err error) {
	op := gqlclient.NewOperation("mutation deleteTicket ($trackerId: Int!, $ticketId: Int!) {\n\tdeleteTicket(trackerId: $trackerId, ticketId: $ticketId) {\n\t\tsubject\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	var respData struct {
		DeleteTicket *Ticket
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteTicket, err
}

func CreateTicketWebhook(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32, config TicketWebhookInput) (createTicketWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createTicketWebhook ($trackerId: Int!, $ticketId: Int!, $config: TicketWebhookInput!) {\n\tcreateTicketWebhook(trackerId: $trackerId, ticketId: $ticketId, config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	op.Var("config", config)
	var respData struct {
		CreateTicketWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateTicketWebhook, err
}

func DeleteTicketWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteTicketWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteTicketWebhook ($id: Int!) {\n\tdeleteTicketWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteTicketWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteTicketWebhook, err
}

func CreateUserWebhook(client *gqlclient.Client, ctx context.Context, config UserWebhookInput) (createUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createUserWebhook ($config: UserWebhookInput!) {\n\tcreateUserWebhook(config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("config", config)
	var respData struct {
		CreateUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateUserWebhook, err
}

func DeleteUserWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteUserWebhook ($id: Int!) {\n\tdeleteUserWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteUserWebhook, err
}

func CreateTrackerWebhook(client *gqlclient.Client, ctx context.Context, trackerId int32, config TrackerWebhookInput) (createTrackerWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createTrackerWebhook ($trackerId: Int!, $config: TrackerWebhookInput!) {\n\tcreateTrackerWebhook(trackerId: $trackerId, config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("config", config)
	var respData struct {
		CreateTrackerWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateTrackerWebhook, err
}

func DeleteTrackerWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteTrackerWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteTrackerWebhook ($id: Int!) {\n\tdeleteTrackerWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteTrackerWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteTrackerWebhook, err
}

func SubmitTicket(client *gqlclient.Client, ctx context.Context, trackerId int32, input SubmitTicketInput) (submitTicket *Ticket, err error) {
	op := gqlclient.NewOperation("mutation submitTicket ($trackerId: Int!, $input: SubmitTicketInput!) {\n\tsubmitTicket(trackerId: $trackerId, input: $input) {\n\t\tid\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("input", input)
	var respData struct {
		SubmitTicket *Ticket
	}
	err = client.Execute(ctx, op, &respData)
	return respData.SubmitTicket, err
}

func LabelTicket(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32, labelId int32) (labelTicket *Event, err error) {
	op := gqlclient.NewOperation("mutation labelTicket ($trackerId: Int!, $ticketId: Int!, $labelId: Int!) {\n\tlabelTicket(trackerId: $trackerId, ticketId: $ticketId, labelId: $labelId) {\n\t\tticket {\n\t\t\tsubject\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	op.Var("labelId", labelId)
	var respData struct {
		LabelTicket *Event
	}
	err = client.Execute(ctx, op, &respData)
	return respData.LabelTicket, err
}

func UnlabelTicket(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32, labelId int32) (unlabelTicket *Event, err error) {
	op := gqlclient.NewOperation("mutation unlabelTicket ($trackerId: Int!, $ticketId: Int!, $labelId: Int!) {\n\tunlabelTicket(trackerId: $trackerId, ticketId: $ticketId, labelId: $labelId) {\n\t\tticket {\n\t\t\tsubject\n\t\t}\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	op.Var("labelId", labelId)
	var respData struct {
		UnlabelTicket *Event
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UnlabelTicket, err
}

func UpdateTicket(client *gqlclient.Client, ctx context.Context, trackerId int32, ticketId int32, input UpdateTicketInput) (updateTicket *Ticket, err error) {
	op := gqlclient.NewOperation("mutation updateTicket ($trackerId: Int!, $ticketId: Int!, $input: UpdateTicketInput!) {\n\tupdateTicket(trackerId: $trackerId, ticketId: $ticketId, input: $input) {\n\t\tid\n\t}\n}\n")
	op.Var("trackerId", trackerId)
	op.Var("ticketId", ticketId)
	op.Var("input", input)
	var respData struct {
		UpdateTicket *Ticket
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateTicket, err
}

func UpdateTracker(client *gqlclient.Client, ctx context.Context, id int32, input TrackerInput) (updateTracker *Tracker, err error) {
	op := gqlclient.NewOperation("mutation updateTracker ($id: Int!, $input: TrackerInput!) {\n\tupdateTracker(id: $id, input: $input) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	op.Var("input", input)
	var respData struct {
		UpdateTracker *Tracker
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateTracker, err
}

func ClearDescription(client *gqlclient.Client, ctx context.Context, id int32) (updateTracker *Tracker, err error) {
	op := gqlclient.NewOperation("mutation clearDescription ($id: Int!) {\n\tupdateTracker(id: $id, input: {description:null}) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		UpdateTracker *Tracker
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateTracker, err
}
