///////
   //    _Server.cc
   //    _Server Class definitions
   //
   //    Class to interface with Server table of mysql Database
   //    This inherits from the Server class.
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: _Server.cc,v 1.10 2008-11-16 18:28:52 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 02.07.1999
///////

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "_Server.h"

#ifdef HAVE_STD
#include <iostream>
#include <string>
#ifdef HAVE_NAMESPACES
using namespace std;
#endif
#else
#include <iostream.h>
#include <string.h>
#endif /* HAVE_STD */

///////
   //    Static variables
///////

   unsigned int _Server::TotServers = 0;
   

///////
   //    Construction
///////

_Server::_Server (const std::string &host, int port )
   : Server (host.c_str(), port),
    IDServer(0),
    IPAddress(),
    HttpServer(),
    HttpVersion(),
    Requests(0)
{
}


_Server::_Server (const _Server& rhs)
   : Server (rhs),
    IDServer(rhs.IDServer),
    IPAddress(rhs.IPAddress),
    HttpServer(rhs.HttpServer),
    HttpVersion(rhs.HttpVersion),
    Requests(rhs.Requests)
{
}


///////
   //    Destruction
///////

_Server::~_Server ()
{
   
}
