# -*- coding: utf-8 -*-
#/usr/bin/python

from __future__ import with_statement # This isn't required in Python 2.6
import sys
import re

SynElements = {}
outfile=None


def printHeader(outfile):
  outfile.write('-- Language definition generated by lang2to3\n\n')

def printDescription(outfile):
  outfile.write("Description=\"%s\"\n\n" % SynElements['$DESCRIPTION'])

def printKeywords(outfile):
  outfile.write("Keywords={\n");
  idx=0
  for group in ("$KEYWORDS(KWA)", "$KEYWORDS(KWB)","$KEYWORDS(KWC)","$KEYWORDS(KWD)"):
    idx+=1
    if (group in SynElements):
        outfile.write("  { Id=%d,\n" % idx);
        if not SynElements[group].startswith("regex"):
	  outfile.write("    List={\"")
	  outfile.write('\", \"'.join(SynElements[group].strip().split(' ')))
	  outfile.write("\"},\n");
	else:
	  p = re.compile('regex\\(([^,]+)(\\,\\s*(\\d+))?\\)')
	  m = p.match(SynElements[group])
	  if m:
	    outfile.write("    Regex=[[%s]],\n" % m.group(1))
	    if m.group(3):
	      outfile.write("    Group=%s,\n" % m.group(3))
        outfile.write("  },\n");
  outfile.write("}\n\n");

def printStrings(outfile):
  if not "$STRINGDELIMITERS" in SynElements: return
  outfile.write("Strings={\n");
  outfile.write("  Delimiter=[[%s]],\n" % "|".join(SynElements['$STRINGDELIMITERS'].strip().split(' ')))
  if "$RAWSTRINGPREFIX" in SynElements:
    outfile.write("  RawPrefix=\"%s\",\n" % SynElements["$RAWSTRINGPREFIX"])
  #if "$ESCCHAR" in SynElements:
  #  outfile.write("  Escape=[[ %s ]],\n" % SynElements["$ESCCHAR"][6:-1])
  outfile.write("}\n\n");

def printEscape(outfile):
  if "$ESCCHAR" in SynElements:
    if SynElements["$ESCCHAR"]!="regex(\\\\u\\p{XDigit}{4}|\\\\\\d{3}|\\\\x\\p{XDigit}{2}|\\\\[ntvbrfa\\\\\\?'\"])":
      outfile.write("--FIXME no default escchar param: %s" % SynElements["$ESCCHAR"])

def printIgnoreCase(outfile):
  if not "$IGNORECASE" in SynElements: return
  outfile.write("IgnoreCase=%s\n\n" % SynElements["$IGNORECASE"].lower())

def printComments(outfile):
  if not "$SL_COMMENT" in SynElements and not not "$ML_COMMENT" in SynElements: return
  outfile.write("Comments={\n");
  if  "$SL_COMMENT" in SynElements:
    outfile.write("  { ")
    outfile.write("Block=false,\n")
    outfile.write("    Delimiter= { [[%s]] },\n" % "\\".join(SynElements['$SL_COMMENT'].strip().split()))
    outfile.write("  },\n")
  if "$ML_COMMENT" in SynElements:
     outfile.write("  { ")
     outfile.write("Block=true,\n")
     if "$ALLOWNESTEDCOMMENTS" in SynElements and SynElements["$ALLOWNESTEDCOMMENTS"].lower()=="true":
       outfile.write("    Nested=true,\n")
     else:
       outfile.write("    Nested=false,\n")

     outfile.write("    Delimiter= { ")
     for openDel in SynElements["$ML_COMMENT"].split(' '):
        outfile.write("[[")
	for c in openDel:
	  outfile.write("\\%s" % c)
	outfile.write("]],")
     outfile.write("}\n")
     if len(openDel)!=2:
       outfile.write("--FIXME number of delimiters nok\n")
     outfile.write("  }\n")
  outfile.write("}\n\n");

def printPreproc(outfile):
   if not "$DIRECTIVE" in SynElements: return
   outfile.write("PreProcessor={\n");
   outfile.write("  Prefix=[[%s]],\n" % SynElements['$DIRECTIVE'].strip())
   if "$CONTINUATIONSYMBOL" in SynElements:
     outfile.write("  Continuation=\"%s\",\n" % SynElements["$CONTINUATIONSYMBOL"])
   outfile.write("}\n\n");

def printSymbols(outfile):
   if not "$SYMBOLS" in SynElements: return
   outfile.write("Operators=[[\\%s]]\n\n" % "|\\".join(SynElements['$SYMBOLS'].strip().split(' ')));

def printReformatting(outfile):
  if not "$REFORMATTING" in SynElements: return
  outfile.write("EnableIndentation=%s\n\n" % SynElements["$REFORMATTING"].lower())

def printDefaultRegex(outfile):
  if "$IDENTIFIER" in SynElements:
    outfile.write("Identifiers=[[ %s ]]\n\n" % SynElements["$IDENTIFIER"][6:-1])
  if "$DIGIT" in SynElements:
    outfile.write("Digits=[[ %s ]]\n\n" % SynElements["$DIGIT"][6:-1])


def convert(oldFile):
  SynElements.clear()
  newFile=oldFile[0:oldFile.rfind('.')] + ".lang.new"
  with open(newFile,'w') as outfile:
    with open(oldFile) as f:
      currElem=''
      for line in f:
	  if line.startswith('--'): # already converted....
	    return
	  line=line.strip()
	  if line.startswith('$'):
	    values =line.split('=',1)
	    currElem=values[0].upper()
	    if currElem in SynElements:
	      print "%s: WARNING cannot handle more of %s" % (oldFile, currElem)
	      outfile.write( "-- FIXME omitted definition of %s\n" % (currElem))
	    elif currElem in ("$STRING_UNEQUAL", "$ML_COMMENT_EQUAL", "$INCLUDE"):
	      print "%s: WARNING ignored %s" % (oldFile, currElem)
	      outfile.write( "-- FIXME omitted definition of %s\n" % (currElem))
	    else:
	      SynElements[currElem]=values[1]
	  elif not line.startswith('#') and currElem.startswith('$KEYWORDS'):
	     SynElements[currElem]+=' '
	     SynElements[currElem]+=line
    printHeader(outfile)
    printDescription(outfile)
    printDefaultRegex(outfile)
    printKeywords(outfile)
    printStrings(outfile)
    printIgnoreCase(outfile)
    printComments(outfile)
    printPreproc(outfile)
    printSymbols(outfile)
    printReformatting(outfile)
    printEscape(outfile)

if __name__ == "__main__":
  if len(sys.argv) < 2:
    print "USAGE: %s old_file.lang" % sys.argv[0]
  else:
    for f in sys.argv[1:]:
      convert(f)