/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.script;

import java.io.Serializable;


public class ScriptEvent<T> implements Serializable {

	public enum Type { INPUT_FILE_CHANGED, OUTPUT_FILE_CHANGED }

	private static final long serialVersionUID = 1L;

	private final Type type;
	private final T value;
	private final Script script;
	
	public ScriptEvent(Script script, T value, Type type) {

		this.script = script;
		this.value = value;
		this.type = type;
	}

	public Type getType() {
		return type;
	}

	public T getValue() {
		return value;
	}

	public Script getScript() {
		return script;
	}
	
}
