/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.widget;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public abstract class AbstractTextField extends JTextField {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private int maxLength = 64;
    private JComponent next = null;
    private JLabel label;

    public AbstractTextField(int cols) {

        super(cols);
        this.maxLength = cols;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return maxLength;
    }

    public void setNext(JComponent next) {
        this.next = next;
    }

    public JComponent getNext() {
        return next;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }
    
    public JLabel getLabel() {
        return label;
    }
 
}
/*
 * $Log$
 */
