/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.html.parser;

public class ParserException extends Exception {

	private static final long serialVersionUID = 1L;

	public ParserException(String msg) {
		super(msg);
	}

	public ParserException(Throwable oops) {
		super(oops);
	}

	@Override
	public String getMessage() {

		String str;
		String msg;

		Throwable cause = getCause();

		if (cause != null) {

			msg = "[" + cause.getClass().getName() + "] ";
			str = cause.getMessage();

			if ((str != null) && (str.length() > 0)) {
				msg += str;
			}

		} else {

			msg = super.getMessage();
		}

		return msg;
	}
}
