//
// C++ Implementation: rename
//
// Description: 
//
//
// Author: Spiros Georgaras <sng@hellug.gr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "timestamp.h"
// #include "settings.h"

#include <klocale.h>
#include <QtGui/QDialog>



extern QString tFormatBefore;
extern QString tFormatDate;
extern QString tFormatAfter;
// extern GwenRename *gwen;
extern QString history[HISTORY_ITEMS * HISTORY_CONTROLS];
extern int historyIndex;

// gWen::gWen(QDialog *)
timeStamp::timeStamp(QWidget* )
	:QDialog()
{
	setupUi(this);
// 	QString msg="<html><body><p><font size=\"+3\"><b>";
// 	msg+=i18n("Time stamping format");
// 	msg+="</font></b></p><p>";
// 	msg+=i18n("The time stamping field supports a variety of expressions, both for date and time. The following section describes these expressions.");
// 	msg+="</p><p><font size=\"+2\"><b>";
// 	msg+=i18n("Date Format");
// 	msg+="</font></b></p><p>";
// 	msg+=i18n("These expressions may be used for the date:");
// 	msg+="</p><table width=\"100%\"><tr><td width=\"1%\" bgcolor=\"#A2C511\"><b>";
// 	msg+=i18n("Expression");
// 	msg+="</b></td><td width=\"99%\" bgcolor=\"#A2C511\"><b>";
// 	msg+=i18n("Output");
// 	msg+="</b></td></tr><tr><td bgcolor=\"#F0F0F0\"><b>d</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("the day as number without a leading zero (1-31)");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>dd</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("the day as number with a leading zero (01-31)");
// 	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>ddd</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("the abbreviated localized day name (e.g. 'Mon'..'Sun')");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>dddd</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("the long localized day name (e.g. 'Monday'..'Sunday')");
// 	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>M</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("the month as number without a leading zero (1-12)");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>MM</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("the month as number with a leading zero (01-12)");
// 	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>MMM</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("the abbreviated localized month name (e.g. 'Jan'..'Dec')");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>MMMM</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("the long localized month name (e.g. 'January'..'December')");
// 	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>yy</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("the year as two digit number (00-99)");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>yyyy</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("the year as four digit number (1752-8000)");
// 	msg+="</td></tr></table><p><font size=\"+2\"><b>";
// 	msg+=i18n("Time Format");
// 	msg+="</font></b></p><p>";
// 	msg+=i18n("These expressions may be used for the time:");
// 	msg+="</p><table width=\"100%\"><tr><td width=\"1%\" bgcolor=\"#A2C511\"><b>";
// 	msg+=i18n("Expression");
// 	msg+="</b></td><td width=\"99%\" bgcolor=\"#A2C511\"><b>";
// 	msg+=i18n("Output");
// 	msg+="</b></td></tr><tr><td bgcolor=\"#F0F0F0\"><b>h</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("the hour without a leading zero (0..23 or 1..12 if AM/PM display)");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>hh</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("the hour with a leading zero (00..23 or 01..12 if AM/PM display)");
// 	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>m</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("the minute without a leading zero (0..59)");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>mm</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("the minute with a leading zero (00..59)");
// 	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>s</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("the second without a leading zero (0..59)");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>ss</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("the second whith a leading zero (00..59)");
// 	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>z</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("the milliseconds without leading zeroes (0..999)");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>zzz</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("the milliseconds with leading zeroes (000..999)");
// 	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>AP</b></td><td bgcolor=\"#F0F0F0\">";
// 	msg+=i18n("use AM/PM display. AP will be replaced by either \"AM\" or \"PM\"");
// 	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>ap</b></td><td bgcolor=\"#D0D0D0\">";
// 	msg+=i18n("use am/pm display. ap will be replaced by either \"am\" or \"pm\"");
// 	msg+="</td></tr></table><p>";
// 	msg+=i18n("Source:");
// 	msg+="<b> Trolltech's QT 4.4.3 Manual</b></p></body></html>";
// 	txt->setHtml(msg);
	
	kFormat->clear();
	QStringList t;
	t << "dd-MM-yy";
	t << "dd-MM-yyyy";
	t << "dd_MM_yy";
	t << "dd_MM_yyyy";
	t << "MM-dd-yy";
	t << "MM-dd-yyyy";
	t << "MM_dd_yy";
	t << "MM_dd_yyyy";
	t << "yy-dd-MM";
	t << "yy_dd_MM";
	t << "yyyy-dd-MM"; 
	t	<< "yyyy_dd_MM";
	t << "yy-MM-dd";
	t << "yy_MM_dd";
	t << "yyyy-MM-dd";
	t << "yyyy_MM_dd";
	t << i18n("Other...");
	kFormat->insertItems(0,t);
// 	kFormat->setMaxVisibleItems(kFormat->count());
// 	buttonOk->setIcon(KIcon(ic->Icon(6)));
// 	buttonCancel->setIcon(KIcon(ic->Icon(7)));
// 	buttonHelp->setIcon(KIcon(ic->Icon(16)));
// // 	clearTxtFormat->setIcon(KIcon(ic->Icon(11))); FIX ME!!!
	
	if(!checkFormat(tFormatDate)) GFormat->setEnabled(FALSE);
	else getExampleDate();
	readConfig( historyIndex );
// 	rCreationChanged();
	updateFormat();
}

timeStamp::timeStamp(QWidget* , iconload* ic ){
	setupUi(this);
	QString msg="<html><body><p><font size=\"+3\"><b>";
	msg+=i18n("Time stamping format");
	msg+="</font></b></p><p>";
	msg+=i18n("The time stamping field supports a variety of expressions, both for date and time. The following section describes these expressions.");
	msg+="</p><p><font size=\"+2\"><b>";
	msg+=i18n("Date Format");
	msg+="</font></b></p><p>";
	msg+=i18n("These expressions may be used for the date:");
	msg+="</p><table width=\"100%\"><tr><td width=\"1%\" bgcolor=\"#A2C511\"><b>";
	msg+=i18n("Expression");
	msg+="</b></td><td width=\"99%\" bgcolor=\"#A2C511\"><b>";
	msg+=i18n("Output");
	msg+="</b></td></tr><tr><td bgcolor=\"#F0F0F0\"><b>d</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("the day as number without a leading zero (1-31)");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>dd</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("the day as number with a leading zero (01-31)");
	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>ddd</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("the abbreviated localized day name (e.g. 'Mon'..'Sun')");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>dddd</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("the long localized day name (e.g. 'Monday'..'Sunday')");
	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>M</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("the month as number without a leading zero (1-12)");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>MM</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("the month as number with a leading zero (01-12)");
	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>MMM</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("the abbreviated localized month name (e.g. 'Jan'..'Dec')");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>MMMM</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("the long localized month name (e.g. 'January'..'December')");
	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>yy</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("the year as two digit number (00-99)");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>yyyy</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("the year as four digit number (1752-8000)");
	msg+="</td></tr></table><p><font size=\"+2\"><b>";
	msg+=i18n("Time Format");
	msg+="</font></b></p><p>";
	msg+=i18n("These expressions may be used for the time:");
	msg+="</p><table width=\"100%\"><tr><td width=\"1%\" bgcolor=\"#A2C511\"><b>";
	msg+=i18n("Expression");
	msg+="</b></td><td width=\"99%\" bgcolor=\"#A2C511\"><b>";
	msg+=i18n("Output");
	msg+="</b></td></tr><tr><td bgcolor=\"#F0F0F0\"><b>h</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("the hour without a leading zero (0..23 or 1..12 if AM/PM display)");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>hh</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("the hour with a leading zero (00..23 or 01..12 if AM/PM display)");
	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>m</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("the minute without a leading zero (0..59)");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>mm</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("the minute with a leading zero (00..59)");
	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>s</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("the second without a leading zero (0..59)");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>ss</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("the second whith a leading zero (00..59)");
	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>z</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("the milliseconds without leading zeroes (0..999)");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>zzz</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("the milliseconds with leading zeroes (000..999)");
	msg+="</td></tr><tr><td bgcolor=\"#F0F0F0\"><b>AP</b></td><td bgcolor=\"#F0F0F0\">";
	msg+=i18n("use AM/PM display. AP will be replaced by either \"AM\" or \"PM\"");
	msg+="</td></tr><tr><td bgcolor=\"#D0D0D0\"><b>ap</b></td><td bgcolor=\"#D0D0D0\">";
	msg+=i18n("use am/pm display. ap will be replaced by either \"am\" or \"pm\"");
	msg+="</td></tr></table><p>";
	msg+=i18n("Source:");
	msg+="<b> Trolltech's QT 4.4.3 Manual</b></p></body></html>";
	txt->setHtml(msg);
	
	kFormat->clear();
	QStringList t;
	t << "dd-MM-yy";
	t << "dd-MM-yyyy";
	t << "dd_MM_yy";
	t << "dd_MM_yyyy";
	t << "MM-dd-yy";
	t << "MM-dd-yyyy";
	t << "MM_dd_yy";
	t << "MM_dd_yyyy";
	t << "yy-dd-MM";
	t << "yy_dd_MM";
	t << "yyyy-dd-MM"; 
	t	<< "yyyy_dd_MM";
	t << "yy-MM-dd";
	t << "yy_MM_dd";
	t << "yyyy-MM-dd";
	t << "yyyy_MM_dd";
	t << i18n("Other...");
	kFormat->insertItems(0,t);
	kFormat->setMaxVisibleItems(kFormat->count());
	buttonOk->setIcon(KIcon(ic->Icon(6)));
	buttonCancel->setIcon(KIcon(ic->Icon(7)));
	buttonHelp->setIcon(KIcon(ic->Icon(16)));
// 	clearTxtFormat->setIcon(KIcon(ic->Icon(11))); FIX ME!!!
	
	if(!checkFormat(tFormatDate)) GFormat->setEnabled(FALSE);
	else getExampleDate();
	readConfig( historyIndex );
// 	rCreationChanged(); old impl
	updateFormat();
}

timeStamp::~timeStamp()
{

}

//================================
bool timeStamp::checkFormat( QString t ){
QString tmp=t;
if(tmp.isEmpty())
	return FALSE;
else{
	int i,ii;
// 	if((i=tmp.find(":",0))!=-1){ old impl
	if((i=tmp.indexOf(":"))!=-1){
			if(i==0)
				tFormatBefore="";
			else
				tFormatBefore=tmp.mid(0,i);
// 			if((ii=tmp.find(":",i+1))!=-1){ old impl
			if((ii=tmp.indexOf(":",i+1))!=-1){
				tFormatAfter=tmp.mid(ii+1,tFormatDate.length());
				tFormatDate=tmp.mid(i+1,ii-i-1);
			}else
				return FALSE;
	}else
		return FALSE;
}
tmp=tFormatDate;
chkExif->setChecked(false);
if(!tmp.isEmpty()){
	if(tmp.left(1)=="C"){
	    rCreation->setChecked(TRUE);
	    rCreation->setFocus();
	    chkExif->setEnabled(TRUE);
	}else if(tmp.left(1)=="E"){
	    rCreation->setChecked(TRUE);
	    rCreation->setFocus();
	    chkExif->setChecked(TRUE);
	    chkExif->setEnabled(TRUE);
	}else if(tmp.left(1)=="M"){
	    rModified->setChecked(TRUE);
	    rModified->setFocus();
	    chkExif->setEnabled(TRUE);
	}else if(tmp.left(1)=="L"){
	    rModified->setChecked(TRUE);
	    rModified->setFocus();
	    chkExif->setChecked(TRUE);
	    chkExif->setEnabled(TRUE);
	}else if(tmp.left(1)=="R"){
	    rRead->setChecked(TRUE);
	    rRead->setFocus();
	    chkExif->setEnabled(false);
	}else{
	    return FALSE;
	}
	int i;
	tmp=tmp.right(tmp.length()-1);
	if((i=isFormat(tmp))==-1){
	    GFormat->setEnabled(TRUE);
	    lblPredefined->setEnabled(TRUE);
	    kFormat->setEnabled(TRUE);
// 	    kFormat->setCurrentItem(kFormat->count()-1); old impl
	    kFormat->setCurrentIndex(kFormat->count()-1);
	    txtFormat->setEnabled(TRUE);
	    lblUser->setEnabled(TRUE);
// 	    txtFormat->setCurrentText(tmp); old impl
			txtFormat->setEditText(tmp);
	    txtFormat->setFocus();
	    getExampleDate();
	}else
// 		kFormat->setCurrentItem(i); old impl
		kFormat->setCurrentIndex(i);
}else
	return FALSE;
return TRUE;
}


//================================
void timeStamp::getExampleDate(){
	if(txtFormat->isEnabled()){
		if(!txtFormat->currentText().isEmpty())
			buttonOk->setEnabled(TRUE);
		else
			buttonOk->setEnabled(FALSE);
	}else
		buttonOk->setEnabled(true);
	if(GFormat->isEnabled()){
		QString dateFormat;
		if(txtFormat->isEnabled()) dateFormat=txtFormat->currentText();
		else dateFormat=kFormat->currentText();
/*	QDate d=QDate::currentDate();
	d.setYMD(d.year(),7,4);
	QTime t=QTime::currentTime();
	t.setHMS(3,8,5,1);
	QDateTime tmp(d,t);*/
		QDateTime tmp = QDateTime::currentDateTime();
		lblExample->setText(tmp.toString(dateFormat));
	}else lblExample->setText("");
}

//================================
void timeStamp::readConfig( int index ){
	static bool read=FALSE;
	if(!read){
		KConfig config("gwenrenamerc");
// 		config.setGroup("UserExpression1"); old impl
		KConfigGroup grp=config.group("UserExpression1");
		for(int i=0;i<HISTORY_ITEMS;i++){
			QString n;
			n=QString("Exp%1").arg(i);
// 			history[FIRST_TIMESTAMP_HISTORY_INDEX+i]=config.readEntry(n,QString::null); old impl
			history[FIRST_TIMESTAMP_HISTORY_INDEX+i]=grp.readEntry(n,"");
// 			qWarning("history[%d] = %s",FIRST_TIMESTAMP_HISTORY_INDEX+i,history[FIRST_TIMESTAMP_HISTORY_INDEX+i].toLocal8Bit().constData());
		}
// 		config.setGroup("UserExpression2"); old impl
		grp=config.group("UserExpression2");
		for(int i=0;i<HISTORY_ITEMS;i++){
	    QString n;
	    n=QString("Exp%1").arg(i);
// 	    history[SECOND_TIMESTAMP_HISTORY_INDEX+i]=config.readEntry(n,QString::null); old impl
	    history[SECOND_TIMESTAMP_HISTORY_INDEX+i]=grp.readEntry(n,"");
// 			qWarning("history[%d] = %s",SECOND_TIMESTAMP_HISTORY_INDEX+i,history[SECOND_TIMESTAMP_HISTORY_INDEX+i].toLocal8Bit().constData());
	    read=TRUE;
 		}
  }
	loadUserFormats(index);
}



//================================
void timeStamp::loadUserFormats( int index ){
	QString prev=txtFormat->currentText();
	txtFormat->clear();
	QStringList t;
	for(int i=0;i<HISTORY_ITEMS;i++)
		if(!history[index+i].isEmpty()){
			t<<history[index+i];
// 			qWarning("history[index+i] = %s",history[index+i].toLocal8Bit().constData());
		}
	txtFormat->insertItems(0,t);
// 	txtFormat->setCurrentText(prev); old impl 
	txtFormat->setEditText(prev); // FIX ME!!!
	
	
// 	for(int i=0;i<HISTORY_ITEMS;i++)
// 		if(!history[index+i].isEmpty())
// 			txtFormat->insertItem( history[index+i] );
// 	txtFormat->setCurrentText(prev);
}



void timeStamp::showHelp(){
    KRun::runCommand(QString("khelpcenter \"help:/gwenrename/time-stamping-window.html\""),this);
}



//================================
void timeStamp::updateFormat(){
    if(rCreation->isChecked() || rModified->isChecked() || rRead->isChecked()){
	GFormat->setEnabled(TRUE);
// 	if(kFormat->currentItem()==kFormat->count()-1){ old impl
	if(kFormat->currentIndex()==kFormat->count()-1){
		lblUser->setEnabled(TRUE);
		txtFormat->setEnabled(TRUE);
	}else{
		lblUser->setEnabled(FALSE);
		buttonOk->setEnabled(FALSE);
	}
    }else GFormat->setEnabled(FALSE);
    getExampleDate();
}


//================================
void timeStamp::txtFormatTextChanged( const QString &txt )
{
	QString dummy=txt;
	if(!txtFormat->currentText().isEmpty())
	    buttonOk->setEnabled(TRUE);
	else
	    buttonOk->setEnabled(FALSE);
    getExampleDate();
}


//================================
void timeStamp::kFormatActivated( int item ){
	if(item==kFormat->count()-1){
//		clearTxtFormat->setEnabled(TRUE);
		lblUser->setEnabled(TRUE);
		txtFormat->setEnabled(TRUE);
		txtFormat->setFocus();
	}else{
// 		clearTxtFormat->setEnabled(FALSE);
		txtFormat->setEnabled(FALSE);
		lblUser->setEnabled(FALSE);
	}
	getExampleDate();
}

void timeStamp::keyPressEvent( QKeyEvent *e ){
// 	if(e->key()==Qt::Key_F1 && e->state()==Qt::NoButton){ old impl
	if(e->key()==Qt::Key_F1 && e->modifiers()==Qt::NoModifier){
		e->accept();
		showHelp();
// 	}else if(e->key()==Qt::Key_Escape && e->state()==Qt::NoButton){ old impl
	}else if(e->key()==Qt::Key_Escape && e->modifiers()==Qt::NoModifier){
		e->accept();
		reject();
	}
}

//================================
int timeStamp::isFormat( QString s ){
for(int i=0;i<kFormat->count();i++){
// 	if(s==kFormat->text(i)) return i; old impl
	if(s==kFormat->itemText(i)) return i;
}
return -1;
}


//================================
void timeStamp::OkClicked(){
	if(chkExif->isChecked()){
		if(rCreation->isChecked()) tFormatDate="E";
		else if(rModified->isChecked()) tFormatDate="L";
		else if(rRead->isChecked()) tFormatDate="R";
		else tFormatDate="";
	}else{
		if(rCreation->isChecked()) tFormatDate="C";
		else if(rModified->isChecked()) tFormatDate="M";
		else if(rRead->isChecked()) tFormatDate="R";
		else tFormatDate="";
	}
	if(!tFormatDate.isEmpty()){
		writeConfig(historyIndex);
// 		if(kFormat->currentItem()<kFormat->count()-1) tFormatDate+=kFormat->currentText(); old impl
		if(kFormat->currentIndex()<kFormat->count()-1) tFormatDate+=kFormat->currentText();
		else tFormatDate+=txtFormat->currentText();
		tFormatDate=":"+tFormatDate+":";
// 		qWarning("tFormatDate = %s",tFormatDate.toLocal8Bit().constData());
	}
	QDialog::accept();
}
//================================
void timeStamp::CancelClicked(){
	if(!rCreation->isChecked() && !rModified->isChecked() && !rRead->isChecked()) tFormatDate="";
	QDialog::reject();
}


//================================
void timeStamp::writeConfig( int index ){
	int found=-1;
	QString cur=txtFormat->currentText();
	for(int i=0;i<HISTORY_ITEMS;i++){
		if(cur==history[index+i]){
			found=i;
			break;
		}
	}
	if(found!=0){
		if(found==-1) for(int i=HISTORY_ITEMS-2;i>=0;i--) history[index+i+1]=history[index+i];
		else for(int i=found-1;i>=0;i--) history[index+i+1]=history[index+i];
	}
	history[index]=cur;
	KConfig config("gwenrenamerc");
	KConfigGroup grp;
// 	if(index==FIRST_TIMESTAMP_HISTORY_INDEX) config.setGroup("UserExpression1"); old impl
// 	else config.setGroup("UserExpression2"); old impl
	if(index==FIRST_TIMESTAMP_HISTORY_INDEX) grp=config.group("UserExpression1");
	else grp=config.group("UserExpression2");
	for(int i=0;i<HISTORY_ITEMS;i++){
		QString n;
		n=QString("Exp%1").arg(i);
// 		if(!history[index+i].isEmpty()) config.writeEntry(n,history[index+i]); old impl
		if(!history[index+i].isEmpty()) grp.writeEntry(n,history[index+i]);
		else break;
	}
}

//================================
void timeStamp::rCreationChanged(){
	chkExif->setEnabled(TRUE);
	updateFormat();
}

//================================
void timeStamp::rModifiedChanged(){
	chkExif->setEnabled(TRUE);
	updateFormat();
}


//================================
void timeStamp::rReadChanged(){
	chkExif->setEnabled(false);
	updateFormat();
}

#include "timestamp.moc"