//
// C++ Interface: rename
//
// Description: 
//
//
// Author: Spiros Georgaras <sng@hellug.gr>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef RENAME_H
#define RENAME_H

#include "initaskmode.h"

#include "main.h"
#include "iconload.h"
#include "timestamp.h"
#include "multiselecttool.h"
#include "ui_rename.h"
#include <QtGui/QWidget>
#include <QtGui/QDialog>
#include <khelpmenu.h>
#include <kaboutdata.h>
#include <kmessagebox.h>
#include <kmenu.h>

// extern KAboutData * ab;



/**
 * This is the main view class for gwenrename.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Spiros Georgaras <sng@hellug.gr>
 * @version 1.1
 */

// class GwenRename : public QDialog, public Ui::GwenRename
class GwenRename : public QWidget, public Ui::GwenRename
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
//      GwenRename(QDialog * parent = 0);
     GwenRename(QWidget * parent = 0);
//      GwenRename(QDialog * parent = 0, KAboutData* about = 0 );
     GwenRename(QWidget * parent = 0, KAboutData* about = 0 );
		 
    /**
     * Destructor
     */
    virtual ~GwenRename();
		
private:
    Ui::GwenRename gw;
 		KAboutData * ab;
		KHelpMenu *mHelpMenu;
		iconload ic;
		timeStamp* ts;
		multiSelect* mS;
		multiSelect *tMult;
		initaskMode* inMode;
		bool updateViewEnabled;
		int activeExtension;
		int compoundExtensions;
		
// 		QListViewItem * firstSelectedItem; FIX ME!!! Does it exist?
		int filesSelectedType;

		int hiddenWidgetSets;
		bool smallScreen;

		int theErrorMessage;
		
		KMenu* popM;
		
		QTreeWidgetItem *firstSelectedItem;
		
		int itemsOfSelectedType;
		
		void readConfig();
		void writeConfig();
		void readHistory();
		void writeHistory();
		bool historyItemExist( KComboBox *com, QString s );
		
		virtual void mousePressEvent( QMouseEvent * e );
		virtual void resizeEvent( QResizeEvent * );
		void loadIcons();
		void exitError(int errorMsg);
		void getFormatParts( int mode );
		void useTimeStamp( int mode );
		QDateTime getTimeStampData( QString fName, QString type );
		bool isValidExifDate( QString s );
		QDateTime exifToDate( QString x );
		QString fixFormat( QString mFormat );
		QString firstCapitalize( QString s );
		QString allCapitalize( QString s );
		void renameError( int index, int mode );
		void applyProfile( int index );
		int getProfileByIndex( int index );
		int getProfileByCurrentText();
		int getProfileByText(QString txt);
		int getDefProfileIndex();
		QString getNewProfileNumber();
		int readProfiles( KConfig *conf );
		void clearDeletedProfiles( KConfig *conf );
		int getDeletedProfile();
		int getFreeProfileNum();
		bool dublicateElement( QString tmp );
		int getActiveProfileIndex();
		bool notRevised( int id );
		void fill_cmbProfile();
		
		
		void updateAfterSelection( int itemsSkipped, int itemsToManipulate, QString * msg );
		
		
		void handleLed1();
		void handleLed2();
		void handleLed3();
// signals:
//     /**
//      * Use this signal to change the content of the statusbar
//      */
//     void signalChangeStatusbar(const QString& text);
// 
//     /**
//      * Use this signal to change the content of the caption
//      */
//     void signalChangeCaption(const QString& text);
// 
 private slots:
		void keyPressEvent( QKeyEvent *e );
		
		
		//================================
		//
		//    Bottom buttons
		//
		//================================
		void buttonOkClicked();
		void CancelIt();
		void showAbout();
		void RenameIt();
		
		
		
		//================================
		//
		//    Extensions slots
		//
		//================================
		void btDelExtClicked();
		void btNewExtClicked();
		void cmbExtChanged();
		void btSaveExtClicked();
		void AdjustExtension();
		
		
		//================================
		//
		//    Common slots
		//
		//================================
		void updateNameView();
		void rSElExtClicked( int state );
		void updateExtView();
		
		
		void AdjustPartName();
		void AdjustPartNameFromSufix();
		void AdjustPartNameFromPrefix();
		void chkProfileCahnged( int state );
		void cmbProfileChanged( int ind );
		
		
		void updateCounterView();
		void updateView();
		
		
		void prDefaultClicked();
		void prDeleteClicked();
		void prEditClicked();
		void prLoadClicked();
		void prNewClicked();
		void prSaveClicked();
		bool reAllocateConfigData( int items );
		void fillProfile( int item );
		void cmbProfileEnter( const QString &txt );
		void cmbProfileEnterPressed();
		
		
		
		void pTimeClicked();
		void sTimeClicked();
		
// 		void rLExtClicked( int state ); old impl
		void rLExtClicked( bool state );
// 		void rUExtClicked( int state ); old impl
		void rUExtClicked( bool state );
		
		void rShowClicked( int val ); //FIX ME!!! - listview
		
		int noDoubleNewName();
		void fixViewGeometry( int mode ); //FIX ME!!! - listview
		
		
		void sortToggled( bool state );
		int getRandom();
		bool randExist( int num );
		int calcDigits( void );
		QString getNumber( int num );
		QString getNumberByID( int num );
		bool canDoRelaxed( void );
		bool isRelaxed( int item );
		bool checkIt( const QString mName );
		QString increaseQString( QString tmp );
		void fixbuttonOk();
		int getSameNewName();
		//================================
		//
		//    Space manipulation slots
		//
		//================================
		void underToSpaceClicked();
		void dashToSpaceClicked();
		void spaceToUnderClicked();
		void spaceToDashClicked();
		
		
// 		void nFCapClicked( int state ); old impl
		void nFCapClicked( bool state );
// 		void nLCaseClicked( int state ); old impl
		void nLCaseClicked( bool state );
// 		void nUCaseClicked( int state ); old impl
		void nUCaseClicked( bool state );
// 		void nSCapClicked( int state ); old impl
		void nSCapClicked( bool state );
		void nOriginalClicked(int state);
		void nSpecifyClicked(int state);
		void nSufChanged();
		
		
		void viewDoubleClicked( QTreeWidgetItem * item , int column );
		void AddToList();
		void RemoveFromList();
		void reFixList(bool mode, bool calculateType);
		int checkItemToList(QString readName, int found, bool noNeedToManipulate, bool mode, int itemsSkipped, QString * msg);
		void setNewFileData( int id, bool state );
		
		void contextMenuRequested(QPoint point);
		
		void showHelp();
		void ListFromSelection();
		void SelectionFromList();
		void InvertList();
		void setList( bool state );
		void mnuSelectAll( void );
		void mnuSelectByType( void );
		void mnuInvertSelection( void );
		void mnuShowSelectionDialog( void );
		void makeSelectionFromString( QString str, bool useCase, bool invertSelection, bool addToCurrentSelection, bool useRegExp );
};

#endif // RENAME_H
