
// output12au7_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  3.000000
 // --table_div  15.263200
 // --table_op  1.000000

struct tableoutput12au7 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tableoutput12au7_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tableoutput12au7&() const { return *(tableoutput12au7*)this; }
};

 static tableoutput12au7_imp<2048> output12au7_table __rt_data = {
	0,-0.833333,682.333,2048, {
	0.000000000000,-0.000592578143,-0.001184919845,-0.001777025193,-0.002368894299,
	-0.002960527276,-0.003551924234,-0.004143085288,-0.004734010547,-0.005324700124,
	-0.005915154131,-0.006505372680,-0.007095355882,-0.007685103849,-0.008274616693,
	-0.008863894525,-0.009452937456,-0.010041745599,-0.010630319064,-0.011218657963,
	-0.011806762407,-0.012394632507,-0.012982268374,-0.013569670121,-0.014156837856,
	-0.014743771693,-0.015330471741,-0.015916938111,-0.016503170915,-0.017089170263,
	-0.017674936265,-0.018260469033,-0.018845768677,-0.019430835308,-0.020015669037,
	-0.020600269972,-0.021184638226,-0.021768773909,-0.022352677130,-0.022936348000,
	-0.023519786629,-0.024102993128,-0.024685967606,-0.025268710173,-0.025851220940,
	-0.026433500016,-0.027015547512,-0.027597363536,-0.028178948199,-0.028760301611,
	-0.029341423881,-0.029922315119,-0.030502975434,-0.031083404936,-0.031663603734,
	-0.032243571937,-0.032823309656,-0.033402816999,-0.033982094075,-0.034561140994,
	-0.035139957865,-0.035718544796,-0.036296901898,-0.036875029278,-0.037452927045,
	-0.038030595310,-0.038608034179,-0.039185243763,-0.039762224169,-0.040338975507,
	-0.040915497885,-0.041491791411,-0.042067856194,-0.042643692343,-0.043219299965,
	-0.043794679170,-0.044369830065,-0.044944752758,-0.045519447358,-0.046093913972,
	-0.046668152710,-0.047242163678,-0.047815946985,-0.048389502739,-0.048962831047,
	-0.049535932017,-0.050108805758,-0.050681452376,-0.051253871979,-0.051826064675,
	-0.052398030571,-0.052969769775,-0.053541282395,-0.054112568536,-0.054683628308,
	-0.055254461817,-0.055825069170,-0.056395450474,-0.056965605837,-0.057535535365,
	-0.058105239166,-0.058674717346,-0.059243970012,-0.059812997272,-0.060381799231,
	-0.060950375997,-0.061518727676,-0.062086854375,-0.062654756200,-0.063222433258,
	-0.063789885655,-0.064357113499,-0.064924116894,-0.065490895947,-0.066057450765,
	-0.066623781453,-0.067189888119,-0.067755770867,-0.068321429804,-0.068886865036,
	-0.069452076669,-0.070017064808,-0.070581829560,-0.071146371030,-0.071710689324,
	-0.072274784548,-0.072838656807,-0.073402306206,-0.073965732851,-0.074528936848,
	-0.075091918302,-0.075654677318,-0.076217214002,-0.076779528459,-0.077341620793,
	-0.077903491111,-0.078465139516,-0.079026566115,-0.079587771011,-0.080148754311,
	-0.080709516119,-0.081270056539,-0.081830375702,-0.082390473661,-0.082950350547,
	-0.083510006465,-0.084069441518,-0.084628655811,-0.085187649449,-0.085746422536,
	-0.086304975177,-0.086863307475,-0.087421419534,-0.087979311460,-0.088536983356,
	-0.089094435326,-0.089651667474,-0.090208679904,-0.090765472721,-0.091322046026,
	-0.091878399926,-0.092434534523,-0.092990449921,-0.093546146223,-0.094101623534,
	-0.094656881957,-0.095211921594,-0.095766742551,-0.096321344929,-0.096875728832,
	-0.097429894364,-0.097983841628,-0.098537570727,-0.099091081764,-0.099644374842,
	-0.100197450063,-0.100750307532,-0.101302947351,-0.101855369622,-0.102407574449,
	-0.102959561934,-0.103511332180,-0.104062885289,-0.104614221364,-0.105165340509,
	-0.105716242824,-0.106266928412,-0.106817397376,-0.107367649819,-0.107917685842,
	-0.108467505547,-0.109017109037,-0.109566496414,-0.110115667780,-0.110664623237,
	-0.111213362886,-0.111761886830,-0.112310195171,-0.112858288009,-0.113406165448,
	-0.113953827589,-0.114501274532,-0.115048506381,-0.115595523236,-0.116142325199,
	-0.116688912371,-0.117235284853,-0.117781442748,-0.118327386155,-0.118873115177,
	-0.119418629915,-0.119963930468,-0.120509016940,-0.121053889430,-0.121598548040,
	-0.122142992870,-0.122687224021,-0.123231241594,-0.123775045690,-0.124318636410,
	-0.124862013853,-0.125405178121,-0.125948129314,-0.126490867533,-0.127033392877,
	-0.127575705448,-0.128117805345,-0.128659692670,-0.129201367521,-0.129742829999,
	-0.130284080205,-0.130825118238,-0.131365944198,-0.131906558186,-0.132446960301,
	-0.132987150642,-0.133527129310,-0.134066896405,-0.134606452026,-0.135145796272,
	-0.135684929244,-0.136223851040,-0.136762561761,-0.137301061505,-0.137839350372,
	-0.138377428462,-0.138915295873,-0.139452952705,-0.139990399056,-0.140527635027,
	-0.141064660715,-0.141601476221,-0.142138081642,-0.142674477078,-0.143210662628,
	-0.143746638390,-0.144282404463,-0.144817960946,-0.145353307938,-0.145888445536,
	-0.146423373839,-0.146958092947,-0.147492602957,-0.148026903967,-0.148560996076,
	-0.149094879383,-0.149628553985,-0.150162019980,-0.150695277467,-0.151228326544,
	-0.151761167308,-0.152293799857,-0.152826224291,-0.153358440705,-0.153890449198,
	-0.154422249868,-0.154953842813,-0.155485228129,-0.156016405915,-0.156547376268,
	-0.157078139286,-0.157608695065,-0.158139043704,-0.158669185299,-0.159199119949,
	-0.159728847749,-0.160258368797,-0.160787683190,-0.161316791026,-0.161845692401,
	-0.162374387412,-0.162902876156,-0.163431158730,-0.163959235231,-0.164487105755,
	-0.165014770399,-0.165542229259,-0.166069482433,-0.166596530016,-0.167123372106,
	-0.167650008798,-0.168176440189,-0.168702666375,-0.169228687452,-0.169754503517,
	-0.170280114666,-0.170805520994,-0.171330722599,-0.171855719575,-0.172380512019,
	-0.172905100026,-0.173429483693,-0.173953663116,-0.174477638389,-0.175001409608,
	-0.175524976870,-0.176048340270,-0.176571499903,-0.177094455864,-0.177617208250,
	-0.178139757155,-0.178662102674,-0.179184244904,-0.179706183939,-0.180227919874,
	-0.180749452804,-0.181270782825,-0.181791910031,-0.182312834518,-0.182833556379,
	-0.183354075711,-0.183874392607,-0.184394507163,-0.184914419473,-0.185434129631,
	-0.185953637733,-0.186472943872,-0.186992048144,-0.187510950642,-0.188029651461,
	-0.188548150695,-0.189066448439,-0.189584544787,-0.190102439832,-0.190620133669,
	-0.191137626391,-0.191654918094,-0.192172008870,-0.192688898814,-0.193205588019,
	-0.193722076580,-0.194238364589,-0.194754452141,-0.195270339329,-0.195786026247,
	-0.196301512987,-0.196816799645,-0.197331886312,-0.197846773082,-0.198361460050,
	-0.198875947307,-0.199390234947,-0.199904323063,-0.200418211748,-0.200931901095,
	-0.201445391198,-0.201958682149,-0.202471774040,-0.202984666965,-0.203497361017,
	-0.204009856288,-0.204522152871,-0.205034250858,-0.205546150342,-0.206057851416,
	-0.206569354171,-0.207080658700,-0.207591765097,-0.208102673451,-0.208613383857,
	-0.209123896407,-0.209634211191,-0.210144328303,-0.210654247834,-0.211163969877,
	-0.211673494523,-0.212182821864,-0.212691951991,-0.213200884998,-0.213709620974,
	-0.214218160013,-0.214726502205,-0.215234647642,-0.215742596416,-0.216250348618,
	-0.216757904338,-0.217265263670,-0.217772426703,-0.218279393530,-0.218786164240,
	-0.219292738926,-0.219799117679,-0.220305300588,-0.220811287746,-0.221317079243,
	-0.221822675171,-0.222328075619,-0.222833280678,-0.223338290440,-0.223843104994,
	-0.224347724432,-0.224852148844,-0.225356378320,-0.225860412951,-0.226364252827,
	-0.226867898039,-0.227371348676,-0.227874604829,-0.228377666587,-0.228880534042,
	-0.229383207283,-0.229885686400,-0.230387971483,-0.230890062622,-0.231391959907,
	-0.231893663427,-0.232395173272,-0.232896489532,-0.233397612296,-0.233898541655,
	-0.234399277696,-0.234899820511,-0.235400170188,-0.235900326816,-0.236400290486,
	-0.236900061285,-0.237399639304,-0.237899024631,-0.238398217355,-0.238897217566,
	-0.239396025353,-0.239894640803,-0.240393064007,-0.240891295053,-0.241389334030,
	-0.241887181025,-0.242384836129,-0.242882299430,-0.243379571015,-0.243876650975,
	-0.244373539396,-0.244870236367,-0.245366741978,-0.245863056315,-0.246359179467,
	-0.246855111523,-0.247350852569,-0.247846402696,-0.248341761989,-0.248836930538,
	-0.249331908431,-0.249826695754,-0.250321292596,-0.250815699044,-0.251309915187,
	-0.251803941112,-0.252297776905,-0.252791422656,-0.253284878451,-0.253778144377,
	-0.254271220522,-0.254764106974,-0.255256803819,-0.255749311145,-0.256241629039,
	-0.256733757587,-0.257225696877,-0.257717446996,-0.258209008031,-0.258700380068,
	-0.259191563195,-0.259682557497,-0.260173363062,-0.260663979977,-0.261154408328,
	-0.261644648201,-0.262134699683,-0.262624562860,-0.263114237819,-0.263603724646,
	-0.264093023427,-0.264582134248,-0.265071057197,-0.265559792357,-0.266048339817,
	-0.266536699661,-0.267024871975,-0.267512856846,-0.268000654359,-0.268488264600,
	-0.268975687655,-0.269462923609,-0.269949972548,-0.270436834557,-0.270923509723,
	-0.271409998129,-0.271896299862,-0.272382415008,-0.272868343650,-0.273354085875,
	-0.273839641768,-0.274325011413,-0.274810194896,-0.275295192301,-0.275780003715,
	-0.276264629221,-0.276749068904,-0.277233322849,-0.277717391141,-0.278201273865,
	-0.278684971104,-0.279168482945,-0.279651809470,-0.280134950765,-0.280617906913,
	-0.281100678000,-0.281583264110,-0.282065665326,-0.282547881733,-0.283029913414,
	-0.283511760455,-0.283993422939,-0.284474900949,-0.284956194571,-0.285437303887,
	-0.285918228981,-0.286398969938,-0.286879526840,-0.287359899771,-0.287840088816,
	-0.288320094056,-0.288799915577,-0.289279553460,-0.289759007790,-0.290238278650,
	-0.290717366123,-0.291196270292,-0.291674991240,-0.292153529050,-0.292631883806,
	-0.293110055590,-0.293588044484,-0.294065850573,-0.294543473938,-0.295020914663,
	-0.295498172829,-0.295975248520,-0.296452141818,-0.296928852806,-0.297405381566,
	-0.297881728180,-0.298357892730,-0.298833875300,-0.299309675971,-0.299785294825,
	-0.300260731944,-0.300735987411,-0.301211061307,-0.301685953715,-0.302160664716,
	-0.302635194391,-0.303109542824,-0.303583710094,-0.304057696285,-0.304531501477,
	-0.305005125753,-0.305478569193,-0.305951831879,-0.306424913893,-0.306897815315,
	-0.307370536227,-0.307843076710,-0.308315436845,-0.308787616714,-0.309259616397,
	-0.309731435975,-0.310203075529,-0.310674535140,-0.311145814889,-0.311616914857,
	-0.312087835124,-0.312558575770,-0.313029136877,-0.313499518524,-0.313969720793,
	-0.314439743764,-0.314909587517,-0.315379252131,-0.315848737689,-0.316318044269,
	-0.316787171951,-0.317256120817,-0.317724890945,-0.318193482416,-0.318661895309,
	-0.319130129705,-0.319598185683,-0.320066063323,-0.320533762704,-0.321001283906,
	-0.321468627009,-0.321935792092,-0.322402779234,-0.322869588515,-0.323336220014,
	-0.323802673810,-0.324268949983,-0.324735048612,-0.325200969775,-0.325666713552,
	-0.326132280021,-0.326597669262,-0.327062881354,-0.327527916374,-0.327992774402,
	-0.328457455517,-0.328921959797,-0.329386287320,-0.329850438166,-0.330314412412,
	-0.330778210136,-0.331241831418,-0.331705276336,-0.332168544967,-0.332631637390,
	-0.333094553683,-0.333557293923,-0.334019858189,-0.334482246559,-0.334944459111,
	-0.335406495922,-0.335868357070,-0.336330042632,-0.336791552687,-0.337252887312,
	-0.337714046584,-0.338175030580,-0.338635839379,-0.339096473057,-0.339556931692,
	-0.340017215361,-0.340477324141,-0.340937258109,-0.341397017341,-0.341856601916,
	-0.342316011910,-0.342775247400,-0.343234308462,-0.343693195173,-0.344151907611,
	-0.344610445850,-0.345068809969,-0.345527000043,-0.345985016150,-0.346442858364,
	-0.346900526763,-0.347358021423,-0.347815342420,-0.348272489831,-0.348729463730,
	-0.349186264194,-0.349642891300,-0.350099345123,-0.350555625738,-0.351011733222,
	-0.351467667651,-0.351923429099,-0.352379017643,-0.352834433358,-0.353289676320,
	-0.353744746603,-0.354199644283,-0.354654369437,-0.355108922137,-0.355563302461,
	-0.356017510483,-0.356471546278,-0.356925409921,-0.357379101486,-0.357832621050,
	-0.358285968686,-0.358739144469,-0.359192148475,-0.359644980777,-0.360097641450,
	-0.360550130569,-0.361002448208,-0.361454594441,-0.361906569343,-0.362358372988,
	-0.362810005450,-0.363261466804,-0.363712757123,-0.364163876481,-0.364614824953,
	-0.365065602612,-0.365516209531,-0.365966645786,-0.366416911449,-0.366867006594,
	-0.367316931295,-0.367766685625,-0.368216269657,-0.368665683466,-0.369114927124,
	-0.369564000704,-0.370012904281,-0.370461637926,-0.370910201713,-0.371358595715,
	-0.371806820005,-0.372254874656,-0.372702759741,-0.373150475332,-0.373598021503,
	-0.374045398325,-0.374492605871,-0.374939644215,-0.375386513428,-0.375833213582,
	-0.376279744751,-0.376726107006,-0.377172300419,-0.377618325063,-0.378064181010,
	-0.378509868332,-0.378955387100,-0.379400737387,-0.379845919265,-0.380290932804,
	-0.380735778078,-0.381180455157,-0.381624964113,-0.382069305017,-0.382513477942,
	-0.382957482958,-0.383401320137,-0.383844989550,-0.384288491269,-0.384731825363,
	-0.385174991905,-0.385617990965,-0.386060822615,-0.386503486925,-0.386945983966,
	-0.387388313808,-0.387830476524,-0.388272472182,-0.388714300853,-0.389155962609,
	-0.389597457520,-0.390038785655,-0.390479947085,-0.390920941881,-0.391361770113,
	-0.391802431850,-0.392242927163,-0.392683256121,-0.393123418795,-0.393563415255,
	-0.394003245570,-0.394442909810,-0.394882408044,-0.395321740343,-0.395760906775,
	-0.396199907410,-0.396638742318,-0.397077411568,-0.397515915229,-0.397954253370,
	-0.398392426060,-0.398830433369,-0.399268275366,-0.399705952119,-0.400143463697,
	-0.400580810170,-0.401017991605,-0.401455008071,-0.401891859638,-0.402328546374,
	-0.402765068346,-0.403201425624,-0.403637618276,-0.404073646370,-0.404509509974,
	-0.404945209156,-0.405380743985,-0.405816114529,-0.406251320855,-0.406686363031,
	-0.407121241126,-0.407555955206,-0.407990505340,-0.408424891595,-0.408859114039,
	-0.409293172739,-0.409727067762,-0.410160799177,-0.410594367049,-0.411027771447,
	-0.411461012437,-0.411894090087,-0.412327004464,-0.412759755633,-0.413192343664,
	-0.413624768621,-0.414057030572,-0.414489129584,-0.414921065723,-0.415352839056,
	-0.415784449648,-0.416215897568,-0.416647182880,-0.417078305651,-0.417509265947,
	-0.417940063835,-0.418370699380,-0.418801172648,-0.419231483706,-0.419661632619,
	-0.420091619453,-0.420521444273,-0.420951107146,-0.421380608136,-0.421809947310,
	-0.422239124733,-0.422668140469,-0.423096994585,-0.423525687146,-0.423954218216,
	-0.424382587861,-0.424810796146,-0.425238843136,-0.425666728895,-0.426094453489,
	-0.426522016982,-0.426949419439,-0.427376660924,-0.427803741502,-0.428230661238,
	-0.428657420195,-0.429084018438,-0.429510456032,-0.429936733040,-0.430362849527,
	-0.430788805556,-0.431214601192,-0.431640236499,-0.432065711540,-0.432491026378,
	-0.432916181079,-0.433341175704,-0.433766010319,-0.434190684986,-0.434615199768,
	-0.435039554730,-0.435463749933,-0.435887785442,-0.436311661320,-0.436735377629,
	-0.437158934433,-0.437582331793,-0.438005569775,-0.438428648439,-0.438851567848,
	-0.439274328066,-0.439696929155,-0.440119371176,-0.440541654194,-0.440963778269,
	-0.441385743464,-0.441807549841,-0.442229197463,-0.442650686391,-0.443072016687,
	-0.443493188414,-0.443914201633,-0.444335056405,-0.444755752792,-0.445176290857,
	-0.445596670659,-0.446016892262,-0.446436955726,-0.446856861112,-0.447276608482,
	-0.447696197897,-0.448115629417,-0.448534903105,-0.448954019020,-0.449372977224,
	-0.449791777777,-0.450210420740,-0.450628906174,-0.451047234139,-0.451465404695,
	-0.451883417904,-0.452301273825,-0.452718972518,-0.453136514045,-0.453553898464,
	-0.453971125836,-0.454388196220,-0.454805109678,-0.455221866267,-0.455638466049,
	-0.456054909083,-0.456471195428,-0.456887325144,-0.457303298289,-0.457719114925,
	-0.458134775109,-0.458550278901,-0.458965626360,-0.459380817546,-0.459795852516,
	-0.460210731330,-0.460625454047,-0.461040020725,-0.461454431423,-0.461868686200,
	-0.462282785113,-0.462696728223,-0.463110515586,-0.463524147261,-0.463937623306,
	-0.464350943780,-0.464764108740,-0.465177118244,-0.465589972350,-0.466002671116,
	-0.466415214600,-0.466827602859,-0.467239835951,-0.467651913932,-0.468063836862,
	-0.468475604797,-0.468887217793,-0.469298675909,-0.469709979202,-0.470121127727,
	-0.470532121543,-0.470942960707,-0.471353645274,-0.471764175301,-0.472174550846,
	-0.472584771964,-0.472994838713,-0.473404751148,-0.473814509325,-0.474224113302,
	-0.474633563134,-0.475042858876,-0.475452000586,-0.475860988319,-0.476269822130,
	-0.476678502075,-0.477087028211,-0.477495400592,-0.477903619274,-0.478311684313,
	-0.478719595763,-0.479127353681,-0.479534958120,-0.479942409136,-0.480349706785,
	-0.480756851121,-0.481163842198,-0.481570680072,-0.481977364797,-0.482383896428,
	-0.482790275019,-0.483196500624,-0.483602573299,-0.484008493097,-0.484414260072,
	-0.484819874278,-0.485225335770,-0.485630644601,-0.486035800825,-0.486440804496,
	-0.486845655667,-0.487250354392,-0.487654900725,-0.488059294719,-0.488463536426,
	-0.488867625902,-0.489271563197,-0.489675348367,-0.490078981463,-0.490482462538,
	-0.490885791646,-0.491288968838,-0.491691994168,-0.492094867689,-0.492497589452,
	-0.492900159509,-0.493302577915,-0.493704844719,-0.494106959975,-0.494508923735,
	-0.494910736050,-0.495312396973,-0.495713906555,-0.496115264848,-0.496516471903,
	-0.496917527772,-0.497318432507,-0.497719186158,-0.498119788777,-0.498520240415,
	-0.498920541124,-0.499320690953,-0.499720689955,-0.500120538179,-0.500520235677,
	-0.500919782500,-0.501319178697,-0.501718424319,-0.502117519417,-0.502516464040,
	-0.502915258240,-0.503313902066,-0.503712395568,-0.504110738796,-0.504508931800,
	-0.504906974629,-0.505304867334,-0.505702609964,-0.506100202568,-0.506497645195,
	-0.506894937896,-0.507292080718,-0.507689073712,-0.508085916927,-0.508482610410,
	-0.508879154212,-0.509275548380,-0.509671792964,-0.510067888012,-0.510463833572,
	-0.510859629693,-0.511255276424,-0.511650773811,-0.512046121904,-0.512441320751,
	-0.512836370399,-0.513231270896,-0.513626022290,-0.514020624628,-0.514415077959,
	-0.514809382329,-0.515203537786,-0.515597544377,-0.515991402150,-0.516385111151,
	-0.516778671427,-0.517172083026,-0.517565345994,-0.517958460377,-0.518351426223,
	-0.518744243578,-0.519136912488,-0.519529433000,-0.519921805160,-0.520314029013,
	-0.520706104607,-0.521098031987,-0.521489811198,-0.521881442287,-0.522272925299,
	-0.522664260280,-0.523055447275,-0.523446486330,-0.523837377490,-0.524228120800,
	-0.524618716304,-0.525009164049,-0.525399464079,-0.525789616438,-0.526179621172,
	-0.526569478325,-0.526959187942,-0.527348750066,-0.527738164742,-0.528127432015,
	-0.528516551928,-0.528905524526,-0.529294349852,-0.529683027950,-0.530071558863,
	-0.530459942637,-0.530848179313,-0.531236268935,-0.531624211547,-0.532012007192,
	-0.532399655913,-0.532787157752,-0.533174512754,-0.533561720960,-0.533948782413,
	-0.534335697156,-0.534722465231,-0.535109086682,-0.535495561549,-0.535881889875,
	-0.536268071703,-0.536654107074,-0.537039996030,-0.537425738613,-0.537811334865,
	-0.538196784827,-0.538582088541,-0.538967246047,-0.539352257388,-0.539737122604,
	-0.540121841737,-0.540506414828,-0.540890841916,-0.541275123044,-0.541659258251,
	-0.542043247578,-0.542427091067,-0.542810788756,-0.543194340686,-0.543577746897,
	-0.543961007430,-0.544344122324,-0.544727091619,-0.545109915355,-0.545492593571,
	-0.545875126307,-0.546257513601,-0.546639755494,-0.547021852025,-0.547403803232,
	-0.547785609155,-0.548167269832,-0.548548785303,-0.548930155604,-0.549311380777,
	-0.549692460857,-0.550073395885,-0.550454185898,-0.550834830933,-0.551215331030,
	-0.551595686226,-0.551975896559,-0.552355962066,-0.552735882785,-0.553115658754,
	-0.553495290008,-0.553874776587,-0.554254118527,-0.554633315864,-0.555012368637,
	-0.555391276880,-0.555770040632,-0.556148659929,-0.556527134807,-0.556905465302,
	-0.557283651450,-0.557661693289,-0.558039590853,-0.558417344178,-0.558794953301,
	-0.559172418257,-0.559549739081,-0.559926915808,-0.560303948475,-0.560680837116,
	-0.561057581767,-0.561434182462,-0.561810639235,-0.562186952123,-0.562563121159,
	-0.562939146378,-0.563315027814,-0.563690765502,-0.564066359475,-0.564441809768,
	-0.564817116415,-0.565192279449,-0.565567298904,-0.565942174813,-0.566316907211,
	-0.566691496130,-0.567065941604,-0.567440243665,-0.567814402347,-0.568188417682,
	-0.568562289704,-0.568936018444,-0.569309603936,-0.569683046211,-0.570056345302,
	-0.570429501242,-0.570802514061,-0.571175383792,-0.571548110468,-0.571920694118,
	-0.572293134776,-0.572665432472,-0.573037587237,-0.573409599103,-0.573781468101,
	-0.574153194262,-0.574524777617,-0.574896218196,-0.575267516029,-0.575638671148,
	-0.576009683582,-0.576380553363,-0.576751280519,-0.577121865080,-0.577492307078,
	-0.577862606540,-0.578232763498,-0.578602777980,-0.578972650015,-0.579342379634,
	-0.579711966864,-0.580081411735,-0.580450714275,-0.580819874514,-0.581188892480,
	-0.581557768201,-0.581926501706,-0.582295093023,-0.582663542180,-0.583031849204,
	-0.583400014124,-0.583768036968,-0.584135917762,-0.584503656535,-0.584871253313,
	-0.585238708124,-0.585606020994,-0.585973191951,-0.586340221022,-0.586707108233,
	-0.587073853610,-0.587440457181,-0.587806918970,-0.588173239005,-0.588539417312,
	-0.588905453915,-0.589271348841,-0.589637102116,-0.590002713765,-0.590368183813,
	-0.590733512286,-0.591098699208,-0.591463744605,-0.591828648501,-0.592193410921,
	-0.592558031889,-0.592922511430,-0.593286849569,-0.593651046328,-0.594015101733,
	-0.594379015807,-0.594742788574,-0.595106420057,-0.595469910280,-0.595833259266,
	-0.596196467039,-0.596559533621,-0.596922459035,-0.597285243304,-0.597647886451,
	-0.598010388498,-0.598372749467,-0.598734969381,-0.599097048262,-0.599458986132,
	-0.599820783012,-0.600182438924,-0.600543953890,-0.600905327931,-0.601266561068,
	-0.601627653323,-0.601988604715,-0.602349415267,-0.602710084999,-0.603070613931,
	-0.603431002083,-0.603791249477,-0.604151356132,-0.604511322067,-0.604871147303,
	-0.605230831860,-0.605590375757,-0.605949779013,-0.606309041648,-0.606668163680,
	-0.607027145129,-0.607385986013,-0.607744686352,-0.608103246163,-0.608461665465,
	-0.608819944276,-0.609178082614,-0.609536080498,-0.609893937944,-0.610251654971,
	-0.610609231597,-0.610966667837,-0.611323963710,-0.611681119233,-0.612038134422,
	-0.612395009294,-0.612751743866,-0.613108338154,-0.613464792175,-0.613821105945,
	-0.614177279479,-0.614533312793,-0.614889205904,-0.615244958826,-0.615600571576,
	-0.615956044167,-0.616311376616,-0.616666568938,-0.617021621146,-0.617376533256,
	-0.617731305282,-0.618085937238,-0.618440429139,-0.618794780999,-0.619148992831,
	-0.619503064649,-0.619856996466,-0.620210788297,-0.620564440153,-0.620917952049,
	-0.621271323997,-0.621624556010,-0.621977648101,-0.622330600269,-0.622683412552,
	-0.623036084948,-0.623388617471,-0.623741010132,-0.624093262943,-0.624445375914,
	-0.624797349058,-0.625149182386,-0.625500875908,-0.625852429636,-0.626203843579,
	-0.626555117749,-0.626906252156,-0.627257246810,-0.627608101721,-0.627958816899,
	-0.628309392354,-0.628659828095,-0.629010124131,-0.629360280472,-0.629710297127,
	-0.630060174104,-0.630409911413,-0.630759509061,-0.631108967057,-0.631458285410,
	-0.631807464128,-0.632156503217,-0.632505402687,-0.632854162544,-0.633202782796,
	-0.633551263450,-0.633899604513,-0.634247805992,-0.634595867894,-0.634943790224,
	-0.635291572991,-0.635639216198,-0.635986719854,-0.636334083963,-0.636681308531,
	-0.637028393563,-0.637375339066,-0.637722145043,-0.638068811501,-0.638415338443,
	-0.638761725875,-0.639107973801,-0.639454082224,-0.639800051150,-0.640145880582,
	-0.640491570524,-0.640837120980,-0.641182531952,-0.641527803444,-0.641872935459,
	-0.642217928000,-0.642562781070,-0.642907494670,-0.643252068804,-0.643596503474,
	-0.643940798681,-0.644284954427,-0.644628970714,-0.644972847544,-0.645316584917,
	-0.645660182834,-0.646003641297,-0.646346960306,-0.646690139862,-0.647033179965,
	-0.647376080614,-0.647718841811,-0.648061463555,-0.648403945845,-0.648746288680,
	-0.649088492061,-0.649430555986,-0.649772480454,-0.650114265463,-0.650455911012,
	-0.650797417100,-0.651138783724,-0.651480010882,-0.651821098572,-0.652162046792,
	-0.652502855539,-0.652843524810,-0.653184054601,-0.653524444911,-0.653864695735,
	-0.654204807069,-0.654544778911,-0.654884611255,-0.655224304099,-0.655563857436,
	-0.655903271264,-0.656242545576,-0.656581680368,-0.656920675635,-0.657259531372,
	-0.657598247573,-0.657936824232,-0.658275261343,-0.658613558901,-0.658951716898,
	-0.659289735328,-0.659627614185,-0.659965353462,-0.660302953151,-0.660640413245,
	-0.660977733737,-0.661314914619,-0.661651955883,-0.661988857520,-0.662325619523,
	-0.662662241884,-0.662998724592,-0.663335067639,-0.663671271017,-0.664007334716,
	-0.664343258726,-0.664679043037,-0.665014687640,-0.665350192524,-0.665685557680,
	-0.666020783095,-0.666355868761,-0.666690814665,-0.667025620797,-0.667360287144,
	-0.667694813696,-0.668029200441,-0.668363447367,-0.668697554460,-0.669031521710,
	-0.669365349103,-0.669699036626,-0.670032584267,-0.670365992012,-0.670699259847,
	-0.671032387759,-0.671365375733,-0.671698223757,-0.672030931815,-0.672363499892,
	-0.672695927975,-0.673028216047,-0.673360364095,-0.673692372101,-0.674024240052,
	-0.674355967930,-0.674687555719,-0.675019003404,-0.675350310968,-0.675681478394,
	-0.676012505666,-0.676343392765,-0.676674139674,-0.677004746377,-0.677335212855,
	-0.677665539089,-0.677995725062,-0.678325770756,-0.678655676151,-0.678985441228,
	-0.679315065969,-0.679644550353,-0.679973894362,-0.680303097975,-0.680632161173,
	-0.680961083934,-0.681289866239,-0.681618508066,-0.681947009395,-0.682275370204,
	-0.682603590473,-0.682931670178,-0.683259609299,-0.683587407813,-0.683915065698,
	-0.684242582931,-0.684569959489,-0.684897195349,-0.685224290489,-0.685551244884,
	-0.685878058510,-0.686204731344,-0.686531263362,-0.686857654538,-0.687183904848,
	-0.687510014268,-0.687835982771,-0.688161810333,-0.688487496928,-0.688813042530,
	-0.689138447113,-0.689463710650,-0.689788833115,-0.690113814481,-0.690438654721,
	-0.690763353807,-0.691087911712,-0.691412328408,-0.691736603867,-0.692060738061,
	-0.692384730961,-0.692708582538,-0.693032292763,-0.693355861607,-0.693679289040,
	-0.694002575033,-0.694325719556,-0.694648722577,-0.694971584068,-0.695294303996,
	-0.695616882331,-0.695939319041,-0.696261614096,-0.696583767462,-0.696905779109,
	-0.697227649004,-0.697549377113,-0.697870963406,-0.698192407848,-0.698513710406,
	-0.698834871046,-0.699155889735,-0.699476766439,-0.699797501124,-0.700118093753,
	-0.700438544294,-0.700758852711,-0.701079018968,-0.701399043030,-0.701718924861,
	-0.702038664424,-0.702358261684,-0.702677716604,-0.702997029146,-0.703316199274,
	-0.703635226950,-0.703954112136,-0.704272854795,-0.704591454888,-0.704909912377,
	-0.705228227222,-0.705546399385,-0.705864428827,-0.706182315508,-0.706500059388,
	-0.706817660427,-0.707135118584,-0.707452433820,-0.707769606092,-0.708086635360,
	-0.708403521583,-0.708720264718,-0.709036864723,-0.709353321557,-0.709669635177,
	-0.709985805540,-0.710301832602,-0.710617716321,-0.710933456653,-0.711249053553,
	-0.711564506978,-0.711879816883,-0.712194983224,-0.712510005954,-0.712824885030,
	-0.713139620405,-0.713454212033,-0.713768659869,-0.714082963866,-0.714397123976,
	-0.714711140154,-0.715025012351,-0.715338740521,-0.715652324615,-0.715965764585,
	-0.716279060383,-0.716592211960,-0.716905219266,-0.717218082254,-0.717530800872,
	-0.717843375072,-0.718155804802,-0.718468090013,-0.718780230654,-0.719092226674,
	-0.719404078021,-0.719715784643,-0.720027346490,-0.720338763508,-0.720650035645,
	-0.720961162849,-0.721272145066,-0.721582982242,-0.721893674325,-0.722204221260,
	-0.722514622992,-0.722824879468,-0.723134990632,-0.723444956429,-0.723754776804,
	-0.724064451701,-0.724373981063,-0.724683364835,-0.724992602960,-0.725301695380,
	-0.725610642038,-0.725919442878,-0.726228097840,-0.726536606866,-0.726844969899,
	-0.727153186879,-0.727461257747,-0.727769182444,-0.728076960909,-0.728384593084,
	-0.728692078906,-0.728999418317,-0.729306611254,-0.729613657656,-0.729920557462,
	-0.730227310610,-0.730533917038,-0.730840376682,-0.731146689480,-0.731452855370,
	-0.731758874286,-0.732064746166,-0.732370470946,-0.732676048560,-0.732981478944,
	-0.733286762033,-0.733591897762,-0.733896886064,-0.734201726874,-0.734506420125,
	-0.734810965750,-0.735115363683,-0.735419613856,-0.735723716201,-0.736027670650,
	-0.736331477136,-0.736635135588,-0.736938645939,-0.737242008119,-0.737545222058,
	-0.737848287686,-0.738151204933,-0.738453973728,-0.738756594001,-0.739059065679,
	-0.739361388691,-0.739663562966,-0.739965588431,-0.740267465012,-0.740569192638,
	-0.740870771235,-0.741172200729,-0.741473481047,-0.741774612113,-0.742075593853,
	-0.742376426192,-0.742677109055,-0.742977642366,-0.743278026049,-0.743578260028,
	-0.743878344225,-0.744178278564,-0.744478062968,-0.744777697358,-0.745077181656,
	-0.745376515784,-0.745675699664,-0.745974733215,-0.746273616359,-0.746572349015,
	-0.746870931104,-0.747169362545,-0.747467643256,-0.747765773157,-0.748063752166,
	-0.748361580201,-0.748659257180,-0.748956783020,-0.749254157638,-0.749551380950,
	-0.749848452874,-0.750145373324,-0.750442142216,-0.750738759466,-0.751035224988,
	-0.751331538696,-0.751627700506,-0.751923710330,-0.752219568082,-0.752515273675,
	-0.752810827021,-0.753106228033,-0.753401476623,-0.753696572703,-0.753991516182,
	-0.754286306973,-0.754580944986,-0.754875430131,-0.755169762317,-0.755463941447,
	-0.755757967444,-0.756051840209,-0.756345559651,-0.756639125678,-0.756932538196,
	-0.757225797113,-0.757518902337,-0.757811853772,-0.758104651326,-0.758397294903,
	-0.758689784410,-0.758982119750,-0.759274300828,-0.759566327549,-0.759858199816,
	-0.760149917532,-0.760441480601,-0.760732888924,-0.761024142405,-0.761315240944,
	-0.761606184444,-0.761896972805,-0.762187605928,-0.762478083713,-0.762768406060,
	-0.763058572869,-0.763348584038,-0.763638439466,-0.763928139052,-0.764217682694,
	-0.764507070289,-0.764796301733,-0.765085376925,-0.765374295760,-0.765663058134,
	-0.765951663943,-0.766240113082,-0.766528405445,-0.766816540928,-0.767104519423,
	-0.767392340825,-0.767680005027,-0.767967511921,-0.768254861400,-0.768542053356,
	-0.768829087680,-0.769115964263,-0.769402682997,-0.769689243772,-0.769975646477,
	-0.770261891003,-0.770547977237,-0.770833905070,-0.771119674388,-0.771405285081,
	-0.771690737036,-0.771976030140,-0.772261164279,-0.772546139339,-0.772830955208,
	-0.773115611769,-0.773400108909,-0.773684446511,-0.773968624460,-0.774252642639,
	-0.774536500933,-0.774820199224,-0.775103737394,-0.775387115325,-0.775670332901,
	-0.775953390000,-0.776236286505,-0.776519022296,-0.776801597253,-0.777084011256,
	-0.777366264183,-0.777648355913,-0.777930286325,-0.778212055297,-0.778493662705,
	-0.778775108428,-0.779056392341,-0.779337514322,-0.779618474245,-0.779899271986,
	-0.780179907419,-0.780460380420,-0.780740690863,-0.781020838620,-0.781300823565,
	-0.781580645571,-0.781860304510,-0.782139800254,-0.782419132675,-0.782698301643,
	-0.782977307029,-0.783256148702,-0.783534826534,-0.783813340392,-0.784091690146,
	-0.784369875664,-0.784647896814,-0.784925753464,-0.785203445480,-0.785480972729,
	-0.785758335077,-0.786035532390,-0.786312564533,-0.786589431371,-0.786866132769,
	-0.787142668589,-0.787419038696,-0.787695242953,-0.787971281222,-0.788247153365,
	-0.788522859244,-0.788798398720,-0.789073771654,-0.789348977907,-0.789624017337,
	-0.789898889805,-0.790173595169,-0.790448133287,-0.790722504019,-0.790996707221,
	-0.791270742751,-0.791544610464,-0.791818310219,-0.792091841869,-0.792365205270,
	-0.792638400278,-0.792911426746,-0.793184284528,-0.793456973479,-0.793729493450,
	-0.794001844294,-0.794274025863,-0.794546038010,-0.794817880584,-0.795089553437,
	-0.795361056418,-0.795632389378,-0.795903552165,-0.796174544629,-0.796445366617,
	-0.796716017978,-0.796986498559,-0.797256808206,-0.797526946766,-0.797796914085,
	-0.798066710009,-0.798336334382,-0.798605787049,-0.798875067853,-0.799144176639,
	-0.799413113250,-0.799681877528,-0.799950469314,-0.800218888452,-0.800487134782,
	-0.800755208144,-0.801023108379,-0.801290835326,-0.801558388826,-0.801825768715,
	-0.802092974834,-0.802360007019,-0.802626865107,-0.802893548937,-0.803160058343,
	-0.803426393162,-0.803692553229,-0.803958538379,-0.804224348446,-0.804489983264,
	-0.804755442667,-0.805020726488,-0.805285834558,-0.805550766710,-0.805815522776,
	-0.806080102585,-0.806344505969,-0.806608732758,-0.806872782780,-0.807136655866,
	-0.807400351843,-0.807663870539,-0.807927211782,-0.808190375399,-0.808453361216,
	-0.808716169060,-0.808978798755,-0.809241250127,-0.809503523000,-0.809765617199,
	-0.810027532546,-0.810289268864,-0.810550825977,-0.810812203706,-0.811073401872,
	-0.811334420297,-0.811595258801,-0.811855917203,-0.812116395325,-0.812376692983,
	-0.812636809998,-0.812896746186,-0.813156501365,-0.813416075352,-0.813675467964,
	-0.813934679016,-0.814193708324,-0.814452555702,-0.814711220966,-0.814969703928,
	-0.815228004403,-0.815486122203,-0.815744057140,-0.816001809027,-0.816259377674,
	-0.816516762893,-0.816773964493,-0.817030982284,-0.817287816076,-0.817544465678,
	-0.817800930897,-0.818057211542,-0.818313307419,-0.818569218335,-0.818824944096,
	-0.819080484509,-0.819335839377,-0.819591008506,-0.819845991700,-0.820100788762,
	-0.820355399496,-0.820609823703,-0.820864061186,-0.821118111747,-0.821371975186,
	-0.821625651303,-0.821879139899,-0.822132440774,-0.822385553725,-0.822638478551,
	-0.822891215051,-0.823143763020,-0.823396122257,-0.823648292558,-0.823900273717,
	-0.824152065531,-0.824403667793,-0.824655080299,-0.824906302841,-0.825157335213,
	-0.825408177208,-0.825658828617,-0.825909289232,-0.826159558844,-0.826409637243,
	-0.826659524219,-0.826909219562,-0.827158723060,-0.827408034503,-0.827657153677,
	-0.827906080370,-0.828154814368,-0.828403355459,-0.828651703427,-0.828899858057,
	-0.829147819135,-0.829395586445,-0.829643159769,-0.829890538891,-0.830137723594,
	-0.830384713659,-0.830631508868,-0.830878109002,-0.831124513841,-0.831370723165,
	-0.831616736753,-0.831862554384,-0.832108175836,-0.832353600887,-0.832598829314,
	-0.832843860894,-0.833088695402,-0.833333332615
	}
};

double always_inline output12au7clip(double x) {
    double f = fabs(x);
    f = f * output12au7_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = output12au7_table.data[0];
    } else if (i >= output12au7_table.size-1) {
        f = output12au7_table.data[output12au7_table.size-1];
    } else {
    f -= i;
    f = output12au7_table.data[i]*(1-f) + output12au7_table.data[i+1]*f;
    }
    return copysign(f, x);
}

