(* Bindings for visitor function.
 * Copyright (C) 2016 Red Hat Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *)

type visitor_function = string -> string option -> Guestfs.statns -> Guestfs.xattr array -> unit

exception Failure

external c_visit : int64 -> string -> visitor_function -> unit =
  "guestfs_int_mllib_visit"

let visit g dir f =
  c_visit (Guestfs.c_pointer g) dir f

let () =
  Callback.register_exception "Visit.Failure" Failure
