//*****************************************************************************
//                                 TextCtrl.hpp                               *
//                                --------------                              *
//  Description : This class extends wxTextCtrl, it adds some useful          *
//                functionality (eg. increment by more than one).             *
//  Started     : 21/06/2004                                                  *
//  Last Update : 02/09/2011                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef TEXTCTRL_HPP
#define TEXTCTRL_HPP

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/textctrl.h>
#include <wx/textfile.h>

// System Includes

#include <climits>
#include <iostream>

// Application Includes

#include "TypeDefs.hpp"

// Local Constant Declarations

#define  TCTL_INITMSG    wxT("Empty") // Default initialization message
#define  TCTL_INITLINES  4       // Totals initial lines including init. msg.
#define  TCTL_DISPMIN    10      // Minimum allowable lines in display area
#define  TCTL_DISPDEF    15      // Default number of lines in display area
#define  TCTL_DISPMAX    50      // Maximum allowable lines in display area
#define  TCTL_LINESMIN   100     // Minimum allowable lines in text control
#define  TCTL_LINESDEF   10E3    // Default number of lines in text control
#define  TCTL_LINESMAX   1E6     // Maximum allowable lines in text control
#define  TCTL_VIEWCOLS   122     // The number of columns in display area
#define  TCTL_NBKTABHT   40      // Extra height in pixels needed by wxNotebook
#define  TCTL_FONTHT     12.7    // Height in pixels of the font

//*****************************************************************************

class TextCtrl : public wxTextCtrl
{
  private :

            wxString  m_osInitMsg;
    static  int       m_iLinesMax; // Max no. lines the text controls will hold
    static  int       m_iLinesDsp; // No. of lines in text control display area
            int       m_iLinesCnt; // No. of lines currently in text control

  public :

    TextCtrl( void );
   ~TextCtrl( );

    bool  bCreate   ( wxWindow * poWin, wxWindowID oWinID=-1 );
    bool  bIsCreated( void )                { return( GetParent( ) != NULL ); }

    bool  bClear     ( void );
    bool  bInitialize( void );
    bool  bIsEmpty   ( void );

            bool  bSetInitMsg ( const wxString & rosMsg );
    static  bool  bSetLinesMax( int iLines );
    static  bool  bSetLinesDsp( int iLines );

    const   wxString & rosGetInitMsg ( void ) { return( m_osInitMsg ); }
            int          iGetLinesMax( void ) { return( m_iLinesMax ); }
            int          iGetLinesDsp( void ) { return( m_iLinesDsp ); }
            int          iGetLinesCnt( void ) { return( m_iLinesCnt ); }
    static  int          iGetPixelHt ( void )
                 { return( (int) ((float) m_iLinesDsp * TCTL_FONTHT + 0.5 )); }

    bool  bAppendLine( const wxString & rosLine );
    bool  bAppendFile( const wxString & roFName );
    bool  bLoadFile  ( const wxString & roFName );
};

//*****************************************************************************

#endif // TEXTCTRL_HPP
