//*****************************************************************************
//                                 NbkGnuCap.hpp                              *
//                                ---------------                             *
// Description : Provides a container class for the analysis configuration    *
//               panels for the different analyses provided by GNU-Cap        *
//               electronic circuit simulator.                                *
// Started     : 05/09/2003                                                   *
// Last Update : 23/05/2011                                                   *
// Copyright   : (C) 2003 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef NBKGNUCAP_HPP
#define NBKGNUCAP_HPP

// System Includes


// wxWidgets Includes

#include <wx/wx.h>

// Application Includes

#include "TypeDefs.hpp"
#include "base/NbkSimrBase.hpp"
#include "gnucap/dialogs/DlgGcpCfgOPT.hpp"
#include "gnucap/panels/PnlGnuCapOP.hpp"
#include "gnucap/panels/PnlGnuCapDC.hpp"
#include "gnucap/panels/PnlGnuCapAC.hpp"
#include "gnucap/panels/PnlGnuCapTR.hpp"
#include "gnucap/panels/PnlGnuCapFO.hpp"

// Local Constant Declarations


//*****************************************************************************

class NbkGnuCap : public NbkSimrBase
{
  private:

    // Analysis pages
    PnlGnuCapOP * m_poPnlGnuCapOP;
    PnlGnuCapDC * m_poPnlGnuCapDC;
    PnlGnuCapAC * m_poPnlGnuCapAC;
    PnlGnuCapTR * m_poPnlGnuCapTR;
    PnlGnuCapFO * m_poPnlGnuCapFO;

    // OPTIONS line setup dialog
    DlgGcpCfgOPT  m_oDlgCfgOPT;

  public:

    NbkGnuCap( wxWindow * poParent, wxWindowID oWinID );
   ~NbkGnuCap( );

    virtual  bool  bClear( void );

    virtual  bool  bLoad( const SimnBase & roSimn );
    virtual  bool  bSave(       SimnBase & roSimn );

    virtual  bool  bSetPage( const wxChar * psAnalysis );
    virtual  bool  bSetPage(       eCmdType  eAnalysis );

    virtual  const  wxString & rosGetPage( void );
    virtual         eCmdType     eGetPage( void );

    // Event handlers
    void  OnPageChangd( wxNotebookEvent & roEvtNbk );
    void  OnBtnOptions( wxCommandEvent  & roEvtCmd );

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // NBKGNUCAP_HPP
