//*****************************************************************************
//                                PrcBase.hpp                                 *
//                               -------------                                *
// Description : Provides a wrapper for the wxProcess class adding a bit of   *
//               extra desirable functionality.                               *
// Started     : 29/01/2004                                                   *
// Last Update : 14/04/2011                                                   *
// Copyright   : (C) 2004 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCBASE_HPP
#define PRCBASE_HPP

// System Includes

using  namespace  std;

#include <iostream>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/process.h>
#include <wx/utils.h>

// Application Includes

#include "TypeDefs.hpp"
#include "utility/TextCtrl.hpp"
#include "utility/StrUtils.hpp"

// Local Constant Declarations

#define  DEF_LOG_FILE  wxT("./prcbase.log")  // Default log file path and name

//*****************************************************************************

class PrcBase : protected wxProcess
{
  protected :

    wxFileName  m_ofnBinary;  // The file name of the binary to be executed
    wxString    m_osArgLst;   // The argument list appended to the binary name
    int         m_iPid;       // The process ID number
    int         m_iExitCode;  // The process exit code
    wxFileName  m_ofnLog;     // The file name of the simulation log
    wxString    m_osErrMsg;   // Error message

    bool  bFindBinary( wxFileName & rofnBinary );
    bool  bLogOutput ( void );

  public :

    PrcBase( int iFlags=wxPROCESS_REDIRECT );
   ~PrcBase( );

    bool  bBinExists( void );

    bool  bIsExec( void ) { return( m_iPid>0 ? TRUE : FALSE ); }
    bool  bIsOk  ( void ) { return( m_iExitCode==0 && m_osErrMsg.IsEmpty( ) ); }

    bool  bSetBinary ( const wxString & rosFName );
    bool  bSetArgLst ( const wxString & rosArgLst   );
    bool  bSetLogFile( const wxString & rosFName );
    void   SetErrMsg ( const wxString & rosErrMsg   )
                                     { if( bIsOk( ) ) m_osErrMsg = rosErrMsg; }

    const wxFileName &  roGetBinary ( void ) { return( m_ofnBinary ); }
    const wxString   & rosGetArgLst ( void ) { return( m_osArgLst  ); }
    const wxFileName &  roGetLogFile( void ) { return( m_ofnLog    ); }
    const wxString   & rosGetErrMsg ( void ) { return( m_osErrMsg  ); }

    virtual  bool  bExecAsync( void );
    virtual  bool  bExecSync ( void );
    virtual  bool  bKill     ( void );

    bool  bDelLogFile( void );

    void  Print   ( TextCtrl & roTxtCtl );
    void  PrintCmd( TextCtrl & roTxtCtl );
    void  PrintRsp( TextCtrl & roTxtCtl );

    // Event handlers
    void  OnTerminate( int iPid, int iStatus );
};

//*****************************************************************************

#endif // PRCBASE_HPP
