#include "common.h"
#ifdef WIN32
#pragma warning(disable:4305)	/* disable warning about initialization of a double by a double */
#endif

Sixs_aer sixs_aer;	/* will be initialized in AerosolModel */
Sixs_trunc sixs_trunc; /* initialized in discom global routine */

Sixs_disc sixs_disc = 
{
    {{0}}, {{0}}, {{0}}, {{0}}, {{0}}, {{0}}, 
    { .4f, .488f, .515f, .55f, .633f, .694f, .86f, 1.536f, 2.25f, 3.75f },/* wldis */
    {0},
    {0}
};

Sixs_sos sixs_sos = 
{
    {{0}},
    {
	-1.f, -.9996f, -.9976f, -.9942f, -.9893f, -.9828f,
	-.9749f, -.9655f, -.9546f, -.9422f, -.9285f, -.9133f, -.8967f,
	-.8787f, -.8594f, -.8388f, -.817f, -.7938f, -.7695f, -.744f,
	-.7174f, -.6896f, -.6609f, -.6311f, -.6003f, -.5687f, -.5361f,
	-.5028f, -.4687f, -.4339f, -.3984f, -.3623f, -.3257f, -.2885f,
	-.251f, -.213f, -.1747f, -.1362f, -.0974f, -.0585f, -.0195f, 0.f,
	.0195f, .0585f, .0974f, .1362f, .1747f, .213f, .251f, .2885f,
	.3257f, .3623f, .3984f, .4339f, .4687f, .5028f, .5361f, .5687f,
	.6003f, .6311f, .6609f, .6896f, .7174f, .744f, .7695f, .7938f,
	.817f, .8388f, .8594f, .8787f, .8967f, .9133f, .9285f, .9422f,
	.9546f, .9655f, .9749f, .9828f, .9893f, .9942f, .9976f, .9996f, 1.f, 
    },
    {    0.f, .0114f, .0266f, .0418f, .0569f, .0719f, .0868f, .1016f,
	 .1162f, .1307f, .1449f, .159f, .1727f, .1863f, .1995f, .2124f,
	 .2251f, .2373f, .2492f, .2606f, .2719f, .2826f, .2929f, .3027f,
	 .3121f, .321f, .3294f, .3373f, .3447f, .3516f, .3579f, .3637f,
	 .369f, .3737f, .3778f, .3813f, .3842f, .3866f, .3884f, .3896f,
	 .3902f, 0.f, .3902f, .3896f, .3884f, .3866f, .3842f, .3813f,
	 .3778f, .3737f, .369f, .3637f, .3579f, .3516f, .3447f, .3373f,
	 .3294f, .321f, .3121f, .3027f, .2929f, .2826f, .2719f, .2606f,
	 .2492f, .2373f, .2251f, .2124f, .1995f, .1863f, .1727f, .159f,
	 .1449f, .1307f, .1162f, .1016f, .0868f, .0719f, .0569f, .0418f,
	 .0266f, .0114f, 0.f
    } 
};


/* only used in aerosol model */
Sixs_aerbas sixs_aerbas =
{
    /* background desert model... */
    {{
	    0.8352,0.8057,0.7377,0.6569,0.5760,0.5032,0.4427,0.3969,

	    0.3646,0.3385,0.3125,0.2863,0.2611,0.2380,0.2175,0.1998,
	    0.1848,0.1722,0.1619,0.1536,0.1469,0.1416,0.1376,0.1347,
	    0.1329,0.1319,0.1319,0.1327,0.1343,0.1366,0.1397,0.1437,
	    0.1485,0.1541,0.1607,0.1682,0.1768,0.1865,0.1974,0.2097,
	    0.2235,0.2309,0.2388,0.2559,0.2749,0.2960,0.3196,0.3459,
	    0.3750,0.4073,0.4432,0.4831,0.5276,0.5774,0.6331,0.6954,
	    0.7652,0.8433,0.9308,1.0291,1.1399,1.2648,1.4060,1.5661,
	    1.7479,1.9552,2.1925,2.4657,2.7822,3.1529,3.5921,4.1201,
	    4.7671,5.5787,6.6249,8.0218,9.9742,12.864,17.461,25.540,
	    42.106,87.294,183.39
	},
     {
	 0.8002,0.7733,0.7063,0.6273,0.5489,0.4793,0.4227,0.3810,
	 0.3524,0.3297,0.3071,0.2839,0.2611,0.2399,0.2207,0.2039,
	 0.1895,0.1773,0.1672,0.1590,0.1523,0.1471,0.1431,0.1401,
	 0.1382,0.1373,0.1372,0.1380,0.1396,0.1419,0.1451,0.1490,
	 0.1539,0.1596,0.1663,0.1739,0.1826,0.1925,0.2036,0.2161,
	 0.2301,0.2377,0.2458,0.2632,0.2826,0.3042,0.3284,0.3553,
	 0.3852,0.4184,0.4553,0.4964,0.5424,0.5938,0.6514,0.7159,
	 0.7882,0.8693,0.9603,1.0626,1.1779,1.3081,1.4554,1.6225,
	 1.8124,2.0287,2.2763,2.5611,2.8904,3.2747,3.7281,4.2698,
	 4.9281,5.7448,6.7836,8.1481,10.017,12.714,16.878,23.920,
	 37.639,72.434,130.26
     },
     {
	 0.7899,0.7637,0.6974,0.6190,0.5414,0.4728,0.4173,0.3766,
	 0.3489,0.3271,0.3054,0.2830,0.2609,0.2402,0.2214,0.2048,
	 0.1906,0.1786,0.1685,0.1603,0.1537,0.1485,0.1445,0.1415,
	 0.1396,0.1387,0.1386,0.1394,0.1409,0.1433,0.1464,0.1504,
	 0.1553,0.1610,0.1677,0.1754,0.1841,0.1940,0.2052,0.2178,

	 0.2319,0.2395,0.2476,0.2651,0.2846,0.3064,0.3307,0.3578,
	 0.3879,0.4214,0.4585,0.5000,0.5464,0.5982,0.6563,0.7215,
	 0.7944,0.8763,0.9682,1.0715,1.1881,1.3197,1.4685,1.6375,
	 1.8294,2.0481,2.2983,2.5859,2.9183,3.3060,3.7626,4.3073,
	 4.9677,5.7846,6.8200,8.1736,10.017,12.661,16.709,23.484,
	 36.489,68.980,119.09
     },
     {
	 0.7770,0.7516,0.6862,0.6087,0.5323,0.4648,0.4106,0.3713,
	 0.3447,0.3239,0.3032,0.2817,0.2604,0.2403,0.2220,0.2058,
	 0.1918,0.1800,0.1700,0.1619,0.1553,0.1501,0.1461,0.1432,
	 0.1413,0.1403,0.1402,0.1410,0.1426,0.1449,0.1481,0.1521,
	 0.1570,0.1628,0.1695,0.1772,0.1860,0.1959,0.2072,0.2199,
	 0.2340,0.2417,0.2498,0.2675,0.2871,0.3091,0.3336,0.3608,
	 0.3912,0.4250,0.4625,0.5044,0.5512,0.6036,0.6623,0.7282,
	 0.8019,0.8848,0.9777,1.0823,1.2003,1.3336,1.4844,1.6555,
	 1.8498,2.0712,2.3245,2.6155,2.9515,3.3429,3.8033,4.3511,
	 5.0134,5.8298,6.8600,8.1995,10.012,12.589,16.495,22.954,
	 35.131,65.032,107.60
     },
     {
	 0.7483,0.7247,0.6618,0.5867,0.5127,0.4480,0.3967,0.3601,
	 0.3357,0.3169,0.2982,0.2787,0.2590,0.2403,0.2230,0.2076,
	 0.1942,0.1827,0.1730,0.1651,0.1586,0.1535,0.1495,0.1466,
	 0.1447,0.1437,0.1437,0.1445,0.1460,0.1484,0.1516,0.1557,
	 0.1606,0.1664,0.1732,0.1810,0.1899,0.2000,0.2114,0.2242,
	 0.2386,0.2464,0.2546,0.2725,0.2925,0.3147,0.3396,0.3674,
	 0.3983,0.4327,0.4710,0.5138,0.5616,0.6151,0.6752,0.7425,
	 0.8180,0.9029,0.9982,1.1054,1.2264,1.3631,1.5178,1.6933,
	 1.8926,2.1196,2.3789,2.6765,3.0196,3.4181,3.8851,4.4383,

	 5.1031,5.9162,6.9324,8.2384,9.9800,12.414,16.024,21.8313,
	 32.417,57.406,86.131
     },
     {
	 0.7290,0.7065,0.6456,0.5721,0.5001,0.4373,0.3879,0.3528,
	 0.3298,0.3122,0.2948,0.2764,0.2579,0.2400,0.2234,0.2085,
	 0.1955,0.1843,0.1748,0.1670,0.1606,0.1555,0.1516,0.1488,
	 0.1469,0.1459,0.1459,0.1467,0.1483,0.1507,0.1539,0.1579,
	 0.1629,0.1688,0.1756,0.1835,0.1924,0.2026,0.2141,0.2270,
	 0.2415,0.2494,0.2577,0.2758,0.2959,0.3185,0.3436,0.3717,
	 0.4030,0.4378,0.4766,0.5199,0.5684,0.6227,0.6836,0.7519,
	 0.8285,0.9146,1.0114,1.1203,1.2432,1.3821,1.5392,1.7174,
	 1.9197,2.1501,2.4131,2.7146,3.0617,3.4642,3.9347,4.4902,
	 5.1552,5.9644,6.9694,8.2514,9.9446,12.284,15.706,21.119,
	 30.763,52.922,75.133
     },
     {
	 0.6834,0.6633,0.6079,0.5390,0.4716,0.4134,0.3682,0.3368,
	 0.3165,0.3014,0.2865,0.2708,0.2546,0.2387,0.2237,0.2101,
	 0.1980,0.1875,0.1786,0.1711,0.1650,0.1601,0.1564,0.1536,
	 0.1518,0.1509,0.1509,0.1517,0.1534,0.1558,0.1591,0.1632,
	 0.1683,0.1742,0.1812,0.1892,0.1983,0.2087,0.2204,0.2337,
	 0.2485,0.2565,0.2650,0.2835,0.3042,0.3273,0.3531,0.3819,
	 0.4140,0.4499,0.4898,0.5345,0.5844,0.6405,0.7033,0.7739,
	 0.8531,0.9420,1.0421,1.1547,1.2818,1.4253,1.5877,1.7716,
	 1.9804,2.2176,2.4880,2.7971,3.1520,3.5615,4.0374,4.5953,
	 5.2568,6.0522,7.0261,8.2465,9.8238,11.947,14.951,19.512,
	 27.207,43.691,55.647
     },
     {
	 0.5664,0.5524,0.5105,0.4593,0.4056,0.3604,0.3252,0.3017,
	 0.2868,0.2764,0.2666,0.2562,0.2452,0.2340,0.2231,0.2127,
	 0.2033,0.1949,0.1876,0.1814,0.1763,0.1721,0.1689,0.1665,
	 0.1651,0.1644,0.1647,0.1657,0.1675,0.1702,0.1737,0.1781,
	 0.1835,0.1898,0.1972,0.2056,0.2153,0.2264,0.2388,0.2529,
	 0.2687,0.2773,0.2864,0.3062,0.3284,0.3531,0.3808,0.4118,
	 0.4464,0.4850,0.5281,0.5763,0.6303,0.6908,0.7586,0.8347,
	 0.9201,1.0159,1.1236,1.2446,1.3810,1.5344,1.7076,1.9029,
	 2.1236,2.3730,2.6551,2.9753,3.3383,3.7523,4.2252,4.7683,
	 5.3971,6.1289,6.9937,8.0270,9.2901,10.873,12.948,15.760,
	 20.227,26.155,28.327
     },
     {
	 0.5017,0.4916,0.4574,0.4166,0.3755,0.3366,0.3067,0.2874,
	 0.2748,0.2660,0.2585,0.2504,0.2418,0.2329,0.2241,0.2156,
	 0.2078,0.2007,0.1945,0.1891,0.1846,0.1810,0.1781,0.1761,
	 0.1750,0.1746,0.1750,0.1762,0.1782,0.1810,0.1848,0.1894,
	 0.1950,0.2016,0.2093,0.2181,0.2283,0.2398,0.2528,0.2676,
	 0.2841,0.2931,0.3026,0.3234,0.3466,0.3726,0.4016,0.4341,
	 0.4704,0.5108,0.5560,0.6065,0.6630,0.7261,0.7970,0.8761,
	 0.9649,1.0644,1.1759,1.3009,1.4415,1.5992,1.7762,1.9755,
	 2.1997,2.4512,2.7345,3.0541,3.4136,3.8188,4.2785,4.7998,
	 5.3909,6.0685,6.8504,7.7572,8.8313,10.118,11.724,13.933,
	 16.806,19.370,20.119
     },
     {
	 0.4481,0.4411,0.4148,0.3788,0.3444,0.3172,0.2972,0.2822,
	 0.2711,0.2632,0.2572,0.2514,0.2450,0.2379,0.2310,0.2245,
	 0.2183,0.2126,0.2074,0.2030,0.1993,0.1963,0.1939,0.1923,
	 0.1915,0.1914,0.1920,0.1934,0.1957,0.1988,0.2027,0.2076,
	 0.2135,0.2206,0.2287,0.2381,0.2488,0.2611,0.2750,0.2906,
	 0.3082,0.3178,0.3279,0.3501,0.3748,0.4024,0.4332,0.4677,
	 0.5062,0.5491,0.5968,0.6500,0.7094,0.7758,0.8499,0.9325,
	 1.0245,1.1273,1.2424,1.3710,1.5144,1.6743,1.8527,2.0524,
	 2.2759,2.5253,2.8026,3.1112,3.4553,3.8394,4.2681,4.7465,
	 5.2801,5.8742,6.5358,7.2843,8.1602,9.2141,10.458,11.804,
	 13.032,13.853,14.061
     }},

    /* biomass burning model... */
    {{
	    0.2150,0.2122,0.2027,0.1928,0.1884,0.1905,0.1952,0.1983,
	    0.1980,0.1954,0.1918,0.1874,0.1819,0.1752,0.1680,0.1612,
	    0.1553,0.1501,0.1457,0.1417,0.1382,0.1351,0.1326,0.1308,
	    0.1296,0.1292,0.1293,0.1299,0.1310,0.1328,0.1353,0.1387,
	    0.1429,0.1480,0.1539,0.1606,0.1682,0.1770,0.1870,0.1984,
	    0.2115,0.2186,0.2263,0.2432,0.2622,0.2838,0.3082,0.3358,
	    0.3671,0.4024,0.4423,0.4875,0.5386,0.5968,0.6630,0.7387,
	    0.8253,0.9247,1.0387,1.1695,1.3192,1.4909,1.6883,1.9162,
	    2.1797,2.4841,2.8350,3.2382,3.7008,4.2315,4.8393,5.5328,
	    6.3184,7.2028,8.1966,9.3190,10.591,12.016,13.541,15.036,
	    16.295,17.092,17.290
	},
     {
	 0.2180,0.2160,0.2091,0.2007,0.1951,0.1943,0.1972,0.2005,
	 0.2013,0.1986,0.1934,0.1874,0.1819,0.1771,0.1724,0.1673,
	 0.1619,0.1565,0.1518,0.1480,0.1449,0.1426,0.1408,0.1395,
	 0.1387,0.1383,0.1385,0.1392,0.1406,0.1427,0.1456,0.1492,
	 0.1535,0.1585,0.1644,0.1713,0.1793,0.1887,0.1995,0.2119,
	 0.2261,0.2339,0.2421,0.2601,0.2803,0.3029,0.3284,0.3571,
	 0.3896,0.4266,0.4687,0.5166,0.5710,0.6328,0.7029,0.7826,
	 0.8733,0.9769,1.0955,1.2314,1.3869,1.5649,1.7685,2.0010,
	 2.2665,2.5691,2.9134,3.3049,3.7496,4.2547,4.8268,5.4728,
	 6.1989,7.0122,7.9194,8.9236,10.016,11.166,12.309,13.350,
	 14.175,14.677,14.799
     },
     {
	 0.2171,0.2154,0.2091,0.2012,0.1955,0.1939,0.1960,0.1992,
	 0.2006,0.1987,0.1940,0.1879,0.1820,0.1770,0.1727,0.1684,
	 0.1638,0.1590,0.1544,0.1504,0.1473,0.1450,0.1433,0.1422,
	 0.1416,0.1414,0.1418,0.1426,0.1439,0.1459,0.1486,0.1522,
	 0.1566,0.1619,0.1681,0.1752,0.1835,0.1930,0.2039,0.2163,
	 0.2305,0.2383,0.2466,0.2650,0.2857,0.3090,0.3352,0.3647,
	 0.3981,0.4358,0.4785,0.5269,0.5816,0.6437,0.7143,0.7949,
	 0.8870,0.9923,1.1126,1.2501,1.4072,1.5866,1.7913,2.0244,
	 2.2894,2.5902,2.9315,3.3191,3.7594,4.2591,4.8242,5.4598,
	 6.1705,6.9612,7.8359,8.7939,9.8227,10.889,11.934,12.873,
	 13.609,14.053,14.161
     },
     {
	 0.2183,0.2168,0.2113,0.2040,0.1981,0.1956,0.1966,0.1992,
	 0.2011,0.2003,0.1965,0.1907,0.1843,0.1786,0.1740,0.1701,
	 0.1664,0.1624,0.1583,0.1543,0.1510,0.1484,0.1466,0.1454,
	 0.1448,0.1447,0.1451,0.1461,0.1476,0.1497,0.1525,0.1560,
	 0.1605,0.1660,0.1725,0.1800,0.1886,0.1984,0.2095,0.2221,
	 0.2364,0.2442,0.2526,0.2710,0.2920,0.3158,0.3429,0.3735,
	 0.4081,0.4469,0.4906,0.5399,0.5957,0.6591,0.7311,0.8132,
	 0.9068,1.0134,1.1350,1.2737,1.4317,1.6116,1.8158,2.0475,
	 2.3101,2.6080,2.9466,3.3317,3.7694,4.2645,4.8209,5.4417,
	 6.1298,6.8888,7.7208,8.6227,9.5794,10.558,11.502,12.339,
	 12.989,13.377,13.471  
     },
     {
	 0.2249,0.2239,0.2197,0.2137,0.2078,0.2036,0.2019,0.2022,
	 0.2034,0.2038,0.2022,0.1985,0.1929,0.1865,0.1803,0.1751,
	 0.1711,0.1679,0.1651,0.1624,0.1597,0.1571,0.1549,0.1533,
	 0.1525,0.1525,0.1532,0.1545,0.1564,0.1589,0.1622,0.1662,
	 0.1710,0.1767,0.1832,0.1907,0.1995,0.2097,0.2215,0.2351,
	 0.2505,0.2589,0.2679,0.2874,0.3094,0.3341,0.3621,0.3936,
	 0.4294,0.4698,0.5157,0.5676,0.6266,0.6934,0.7691,0.8549,
	 0.9521,1.0619,1.1858,1.3254,1.4828,1.6604,1.8614,2.0895,
	 2.3492,2.6448,2.9802,3.3587,3.7823,4.2529,4.7729,5.3459,
	 5.9763,6.6683,7.4225,8.2312,9.0749,9.9191,10.715,11.405,
	 11.931,12.241,12.316
     },
     {
	 0.2268,0.2259,0.2225,0.2173,0.2117,0.2070,0.2041,0.2029,

	 0.2031,0.2034,0.2029,0.2008,0.1970,0.1919,0.1861,0.1806,
	 0.1758,0.1721,0.1693,0.1673,0.1655,0.1638,0.1622,0.1607,
	 0.1597,0.1593,0.1597,0.1609,0.1628,0.1654,0.1687,0.1728,
	 0.1778,0.1838,0.1908,0.1990,0.2083,0.2189,0.2309,0.2446,
	 0.2602,0.2687,0.2779,0.2981,0.3210,0.3470,0.3763,0.4093,
	 0.4464,0.4883,0.5354,0.5887,0.6488,0.7166,0.7931,0.8793,
	 0.9763,1.0854,1.2083,1.3469,1.5037,1.6817,1.8840,2.1140,
	 2.3747,2.6685,2.9974,3.3632,3.7679,4.2147,4.7080,5.2537,
	 5.8571,6.5215,7.2440,8.0132,8.8062,9.5882,10.315,10.936,
	 11.403,11.678,11.743
     },
     {
	 0.2427,0.2421,0.2399,0.2362,0.2317,0.2269,0.2224,0.2187,
	 0.2159,0.2139,0.2124,0.2110,0.2094,0.2072,0.2041,0.2004,
	 0.1962,0.1917,0.1875,0.1839,0.1810,0.1790,0.1779,0.1775,
	 0.1776,0.1782,0.1792,0.1805,0.1822,0.1846,0.1877,0.1917,
	 0.1968,0.2031,0.2106,0.2194,0.2295,0.2412,0.2545,0.2697,
	 0.2869,0.2963,0.3063,0.3284,0.3532,0.3812,0.4125,0.4476,
	 0.4868,0.5305,0.5793,0.6339,0.6951,0.7639,0.8414,0.9288,
	 1.0277,1.1395,1.2655,1.4074,1.5662,1.7433,1.9398,2.1574,
	 2.3979,2.6641,2.9597,3.2895,3.6589,4.0736,4.5385,5.0562,
	 5.6261,6.2424,6.8937,7.5622,8.2243,8.8516,9.4132,9.8788,
	 10.221,10.418,10.465
     },
     {
	 0.3408,0.3406,0.3396,0.3380,0.3356,0.3327,0.3292,0.3253,
	 0.3210,0.3165,0.3119,0.3072,0.3026,0.2981,0.2939,0.2898,
	 0.2861,0.2827,0.2797,0.2770,0.2747,0.2728,0.2712,0.2701,
	 0.2693,0.2690,0.2693,0.2700,0.2715,0.2737,0.2768,0.2808,
	 0.2861,0.2926,0.3005,0.3101,0.3214,0.3346,0.3499,0.3675,

	 0.3875,0.3984,0.4100,0.4354,0.4636,0.4951,0.5300,0.5686,
	 0.6114,0.6588,0.7114,0.7697,0.8346,0.9068,0.9874,1.0773,
	 1.1778,1.2898,1.4147,1.5535,1.7072,1.8766,2.0625,2.2649,
	 2.4840,2.7191,2.9691,3.2325,3.5070,3.7899,4.0777,4.3667,
	 4.6524,4.9302,5.1951,5.4422,5.6667,5.8638,6.0293,6.1597,
	 6.2518,6.3038,6.3160
     },
     {
	 0.4735,0.4733,0.4725,0.4711,0.4690,0.4664,0.4632,0.4596,
	 0.4554,0.4507,0.4457,0.4404,0.4347,0.4289,0.4229,0.4168,
	 0.4106,0.4046,0.3987,0.3930,0.3876,0.3825,0.3779,0.3738,
	 0.3704,0.3676,0.3656,0.3646,0.3645,0.3655,0.3677,0.3712,
	 0.3762,0.3827,0.3910,0.4011,0.4134,0.4278,0.4447,0.4643,
	 0.4868,0.4992,0.5124,0.5414,0.5742,0.6109,0.6519,0.6974,
	 0.7479,0.8036,0.8648,0.9317,1.0047,1.0838,1.1694,1.2615,
	 1.3601,1.4653,1.5768,1.6946,1.8182,1.9474,2.0814,2.2197,
	 2.3614,2.5057,2.6516,2.7980,2.9435,3.0870,3.2271,3.3623,
	 3.4914,3.6129,3.7254,3.8277,3.9184,3.9966,4.0611,4.1113,
	 4.1465,4.1662,4.1709
     },
     {
	 0.7907,0.7905,0.7895,0.7878,0.7852,0.7820,0.7780,0.7733,
	 0.7679,0.7619,0.7553,0.7481,0.7405,0.7324,0.7239,0.7151,
	 0.7061,0.6968,0.6875,0.6782,0.6690,0.6599,0.6512,0.6428,
	 0.6349,0.6276,0.6211,0.6154,0.6107,0.6071,0.6047,0.6037,
	 0.6042,0.6063,0.6102,0.6160,0.6239,0.6339,0.6462,0.6609,
	 0.6782,0.6878,0.6981,0.7207,0.7461,0.7743,0.8055,0.8396,
	 0.8768,0.9168,0.9599,1.0058,1.0545,1.1060,1.1601,1.2166,
	 1.2753,1.3362,1.3988,1.4630,1.5284,1.5948,1.6618,1.7290,
	 1.7962,1.8627,1.9284,1.9927,2.0553,2.1156,2.1734,2.2281,

	 2.2795,2.3271,2.3705,2.4095,2.4438,2.4729,2.4969,2.5154,
	 2.5283,2.5355,2.5372
     }},

    /* stratospherique aerosol model...
       model: Stratospheric aerosol as follow king's model 
       Journal of Climate and Applied Meteorology, Vol23, No7, pp=1121-1137, 1984 */
    {{
	    .4482,  .4378,  .3984,  .3460,  .3030,  .2864,  .3011,  .3393,
	    .3852,  .4224,  .4395,  .4332,  .4068,  .3674,  .3232,  .2806,
	    .2436,  .2137,  .1909,  .1740,  .1615,  .1523,  .1453,  .1398,
	    .1356,  .1324,  .1300,  .1284,  .1277,  .1278,  .1286,  .1303,
	    .1328,  .1362,  .1404,  .1455,  .1515,  .1585,  .1666,  .1759,
	    .1864,  .1922,  .1984,  .2119,  .2272,  .2444,  .2638,  .2856,
	    .3103,  .3381,  .3696,  .4052,  .4454,  .4911,  .5429,  .6018,
	    .6687,  .7447,  .8309,  .9284, 1.0383, 1.1614, 1.2985, 1.4500,
	    1.6169, 1.8014, 2.0088, 2.2506, 2.5487, 2.9404, 3.4830, 4.2562,
	    5.3583, 6.8944, 8.9537,11.5772,14.7221,18.2338,21.8390,25.1693,
	    27.8195,29.4297,29.8220
	},
     {
	 .3066,  .3025,  .2862,  .2621,  .2369,  .2173,  .2078,  .2095,
	 .2201,  .2355,  .2504,  .2607,  .2637,  .2589,  .2472,  .2305,
	 .2114,  .1919,  .1736,  .1577,  .1445,  .1340,  .1261,  .1203,
	 .1162,  .1134,  .1117,  .1109,  .1108,  .1113,  .1124,  .1141,
	 .1165,  .1194,  .1230,  .1273,  .1324,  .1384,  .1452,  .1531,
	 .1620,  .1669,  .1722,  .1838,  .1969,  .2117,  .2285,  .2475,
	 .2691,  .2936,  .3213,  .3528,  .3886,  .4293,  .4754,  .5278,
	 .5872,  .6543,  .7304,  .8164,  .9142, 1.0260, 1.1554, 1.3080,
	 1.4922, 1.7208, 2.0120, 2.3907, 2.8891, 3.5464, 4.4062, 5.5124,
	 6.9014, 8.5929,10.5796,12.8175,15.2199,17.6577,19.9678,21.9699,
	 23.4901,24.3864,24.6019
     },
     {
	 .2797,  .2765,  .2636,  .2440,  .2227,  .2045,  .1934,  .1907,
	 .1956,  .2056,  .2171,  .2266,  .2316,  .2310,  .2247,  .2138,
	 .1998,  .1843,  .1689,  .1546,  .1422,  .1319,  .1237,  .1176,
	 .1131,  .1101,  .1082,  .1073,  .1072,  .1077,  .1089,  .1107,
	 .1130,  .1160,  .1196,  .1239,  .1289,  .1347,  .1413,  .1490,
	 .1577,  .1625,  .1676,  .1789,  .1916,  .2061,  .2225,  .2410,
	 .2621,  .2859,  .3130,  .3437,  .3785,  .4179,  .4626,  .5133,
	 .5706,  .6356,  .7094,  .7936,  .8904, 1.0031, 1.1367, 1.2984,
	 1.4985, 1.7518, 2.0779, 2.5018, 3.0542, 3.7695, 4.6834, 5.8280,
	 7.2258, 8.8822,10.7776,12.8620,15.0519,17.2327,19.2671,21.0083,
	 22.3181,23.0858,23.2698
     },
     {
	 .2523,  .2499,  .2401,  .2249,  .2075,  .1914,  .1795,  .1736,
	 .1735,  .1782,  .1854,  .1928,  .1984,  .2005,  .1988,  .1932,
	 .1846,  .1739,  .1623,  .1506,  .1398,  .1303,  .1223,  .1159,
	 .1110,  .1076,  .1054,  .1042,  .1039,  .1044,  .1055,  .1073,
	 .1097,  .1127,  .1163,  .1205,  .1255,  .1312,  .1378,  .1453,
	 .1539,  .1586,  .1636,  .1746,  .1871,  .2013,  .2173,  .2354,
	 .2559,  .2792,  .3055,  .3352,  .3689,  .4070,  .4502,  .4990,
	 .5545,  .6178,  .6905,  .7747,  .8738,  .9921, 1.1363, 1.3153,
	 1.5410, 1.8295, 2.2003, 2.6770, 3.2861, 4.0549, 5.0090, 6.1680,
	 7.5404, 9.1188,10.8752,12.7575,14.6902,16.5769,18.3076,19.7692,
	 20.8579,21.4919,21.6435
     },
     {
	 .2099,  .2085,  .2029,  .1937,  .1824,  .1705,  .1597,  .1512,
	 .1457,  .1433,  .1435,  .1455,  .1484,  .1511,  .1529,  .1533,
	 .1519,  .1489,  .1445,  .1391,  .1331,  .1270,  .1212,  .1158,
	 .1112,  .1075,  .1048,  .1029,  .1020,  .1019,  .1027,  .1041,
	 .1063,  .1092,  .1128,  .1170,  .1220,  .1278,  .1344,  .1419,
	 .1505,  .1551,  .1601,  .1710,  .1833,  .1971,  .2127,  .2303,
	 .2501,  .2724,  .2976,  .3260,  .3583,  .3950,  .4371,  .4857,
	 .5424,  .6092,  .6892,  .7862,  .9053, 1.0531, 1.2379, 1.4701,
	 1.7619, 2.1272, 2.5813, 3.1398, 3.8174, 4.6261, 5.5735, 6.6598,
	 7.8763, 9.2034,10.6092,12.0501,13.4719,14.8129,16.0082,16.9948,
	 17.7172,18.1334,18.2325
     },
     {
	 .1911,  .1901,  .1861,  .1793,  .1706,  .1610,  .1516,  .1432,
	 .1365,  .1318,  .1292,  .1284,  .1289,  .1301,  .1316,  .1328,
	 .1333,  .1330,  .1317,  .1295,  .1266,  .1232,  .1196,  .1160,
	 .1126,  .1096,  .1072,  .1054,  .1043,  .1040,  .1044,  .1056,
	 .1075,  .1102,  .1136,  .1177,  .1227,  .1285,  .1351,  .1427,
	 .1513,  .1560,  .1610,  .1719,  .1842,  .1981,  .2136,  .2311,
	 .2509,  .2732,  .2986,  .3275,  .3607,  .3992,  .4441,  .4973,
	 .5608,  .6374,  .7309,  .8458,  .9877, 1.1636, 1.3815, 1.6506,
	 1.9812, 2.3839, 2.8694, 3.4473, 4.1253, 4.9077, 5.7944, 6.7794,
	 7.8497, 8.9848,10.1567,11.3301,12.4643,13.5152,14.4381,15.1909,
	 15.7373,16.0504,16.1247
     },
     {
	 .1657,  .1652,  .1631,  .1595,  .1546,  .1488,  .1424,  .1358,
	 .1294,  .1235,  .1183,  .1141,  .1107,  .1084,  .1070,  .1063,
	 .1062,  .1066,  .1072,  .1080,  .1088,  .1096,  .1103,  .1108,
	 .1113,  .1117,  .1121,  .1126,  .1133,  .1142,  .1155,  .1172,
	 .1193,  .1221,  .1255,  .1296,  .1345,  .1402,  .1469,  .1547,
	 .1636,  .1686,  .1739,  .1856,  .1991,  .2147,  .2326,  .2534,
	 .2775,  .3058,  .3392,  .3787,  .4256,  .4818,  .5491,  .6299,
	 .7270,  .8435,  .9830, 1.1494, 1.3469, 1.5800, 1.8530, 2.1701,
	 2.5350, 2.9507, 3.4187, 3.9394, 4.5111, 5.1299, 5.7894, 6.4806,
	 7.1921, 7.9098, 8.6176, 9.2978, 9.9320,10.5016,10.9891,11.3786,
	 11.6571,11.8152,11.8525
     },
     {
	 .1867,  .1866,  .1860,  .1850,  .1836,  .1819,  .1797,  .1773,
	 .1746,  .1717,  .1687,  .1655,  .1624,  .1593,  .1563,  .1535,
	 .1509,  .1487,  .1469,  .1455,  .1447,  .1444,  .1449,  .1460,
	 .1480,  .1509,  .1547,  .1596,  .1656,  .1729,  .1814,  .1915,
	 .2031,  .2164,  .2315,  .2488,  .2683,  .2902,  .3149,  .3426,
	 .3736,  .3904,  .4081,  .4466,  .4894,  .5369,  .5895,  .6476,
	 .7117,  .7821,  .8593,  .9436, 1.0355, 1.1354, 1.2434, 1.3598,
	 1.4848, 1.6183, 1.7604, 1.9108, 2.0693, 2.2352, 2.4081, 2.5870,
	 2.7711, 2.9591, 3.1498, 3.3417, 3.5332, 3.7226, 3.9080, 4.0876,
	 4.2594, 4.4215, 4.5720, 4.7090, 4.8308, 4.9359, 5.0228, 5.0905,
	 5.1379, 5.1645, 5.1708
     },
     {
	 .4829,  .4828,  .4824,  .4816,  .4804,  .4790,  .4772,  .4751,
	 .4728,  .4701,  .4673,  .4643,  .4611,  .4578,  .4544,  .4511,
	 .4477,  .4444,  .4413,  .4384,  .4358,  .4335,  .4317,  .4304,
	 .4298,  .4299,  .4308,  .4327,  .4356,  .4397,  .4452,  .4520,
	 .4605,  .4708,  .4829,  .4971,  .5135,  .5323,  .5536,  .5776,
	 .6045,  .6190,  .6344,  .6674,  .7038,  .7435,  .7869,  .8338,
	 .8845,  .9390,  .9973, 1.0594, 1.1253, 1.1949, 1.2682, 1.3449,
	 1.4249, 1.5080, 1.5939, 1.6823, 1.7728, 1.8650, 1.9584, 2.0527,
	 2.1472, 2.2414, 2.3347, 2.4266, 2.5162, 2.6031, 2.6866, 2.7660,
	 2.8408, 2.9103, 2.9739, 3.0312, 3.0815, 3.1246, 3.1599, 3.1873,
	 3.2064, 3.2170, 3.2195
     },
     {
	 1.0488, 1.0485, 1.0470, 1.0443, 1.0405, 1.0355, 1.0295, 1.0223,
	 1.0141, 1.0049,  .9948,  .9838,  .9719,  .9594,  .9461,  .9323,
	 .9180,  .9032,  .8882,  .8730,  .8577,  .8425,  .8273,  .8125,
	 .7981,  .7841,  .7709,  .7584,  .7469,  .7364,  .7271,  .7191,
	 .7126,  .7077,  .7045,  .7031,  .7036,  .7062,  .7109,  .7179,
	 .7271,  .7326,  .7387,  .7527,  .7692,  .7881,  .8096,  .8335,
	 .8599,  .8886,  .9198,  .9532,  .9888, 1.0265, 1.0661, 1.1075,
	 1.1505, 1.1949, 1.2406, 1.2872, 1.3346, 1.3825, 1.4307, 1.4789,
	 1.5267, 1.5741, 1.6205, 1.6659, 1.7098, 1.7521, 1.7924, 1.8305,
	 1.8661, 1.8989, 1.9289, 1.9557, 1.9792, 1.9992, 2.0156, 2.0282,
	 2.0370, 2.0419, 2.0431
     }},

    /* dust model */
    {{
	    0.2021E+00,0.2079E+00,0.2462E+00,0.2310E+00,0.2069E+00,0.1883E+00,
	    0.1750E+00,0.1624E+00,0.1458E+00,0.1241E+00,0.1013E+00,0.8379E-01,
	    0.7097E-01,0.6207E-01,0.5595E-01,0.5174E-01,0.4879E-01,0.4675E-01,
	    0.4531E-01,0.4435E-01,0.4373E-01,0.4337E-01,0.4324E-01,0.4330E-01,
	    0.4353E-01,0.4392E-01,0.4449E-01,0.4522E-01,0.4612E-01,0.4721E-01,
	    0.4850E-01,0.5001E-01,0.5177E-01,0.5381E-01,0.5616E-01,0.5885E-01,
	    0.6191E-01,0.6540E-01,0.6936E-01,0.7383E-01,0.7889E-01,0.8168E-01,
	    0.8459E-01,0.9096E-01,0.9808E-01,0.1060E+00,0.1148E+00,0.1246E+00,
	    0.1355E+00,0.1474E+00,0.1605E+00,0.1750E+00,0.1910E+00,0.2088E+00,
	    0.2284E+00,0.2501E+00,0.2739E+00,0.3000E+00,0.3284E+00,0.3594E+00,
	    0.3935E+00,0.4308E+00,0.4718E+00,0.5172E+00,0.5670E+00,0.6222E+00,
	    0.6840E+00,0.7528E+00,0.8308E+00,0.9217E+00,0.1029E+01,0.1159E+01,
	    0.1327E+01,0.1553E+01,0.1878E+01,0.2386E+01,0.3253E+01,0.4937E+01,
	    0.8737E+01,0.1952E+02,0.6427E+02,0.4929E+03,0.5169E+05
	},
     {
	 0.2467E+00,0.2483E+00,0.2871E+00,0.2722E+00,0.2454E+00,0.2231E+00,
	 0.2060E+00,0.1900E+00,0.1704E+00,0.1452E+00,0.1186E+00,0.9754E-01,
	 0.8182E-01,0.7067E-01,0.6284E-01,0.5734E-01,0.5345E-01,0.5070E-01,
	 0.4875E-01,0.4741E-01,0.4651E-01,0.4596E-01,0.4570E-01,0.4569E-01,
	 0.4589E-01,0.4631E-01,0.4693E-01,0.4776E-01,0.4879E-01,0.5005E-01,
	 0.5153E-01,0.5328E-01,0.5532E-01,0.5768E-01,0.6040E-01,0.6350E-01,
	 0.6704E-01,0.7104E-01,0.7559E-01,0.8071E-01,0.8648E-01,0.8967E-01,
	 0.9298E-01,0.1002E+00,0.1083E+00,0.1173E+00,0.1273E+00,0.1384E+00,
	 0.1507E+00,0.1641E+00,0.1790E+00,0.1954E+00,0.2134E+00,0.2335E+00,
	 0.2557E+00,0.2801E+00,0.3070E+00,0.3366E+00,0.3687E+00,0.4039E+00,
	 0.4427E+00,0.4850E+00,0.5316E+00,0.5834E+00,0.6402E+00,0.7032E+00,
	 0.7738E+00,0.8527E+00,0.9422E+00,0.1047E+01,0.1171E+01,0.1321E+01,
	 0.1516E+01,0.1780E+01,0.2160E+01,0.2753E+01,0.3768E+01,0.5728E+01,
	 0.1011E+02,0.2231E+02,0.7109E+02,0.5001E+03,0.3548E+05
     },
     {
	 0.2599E+00,0.2602E+00,0.2986E+00,0.2838E+00,0.2563E+00,0.2330E+00,
	 0.2148E+00,0.1978E+00,0.1774E+00,0.1513E+00,0.1237E+00,0.1017E+00,
	 0.8513E-01,0.7333E-01,0.6499E-01,0.5912E-01,0.5494E-01,0.5198E-01,
	 0.4986E-01,0.4840E-01,0.4742E-01,0.4681E-01,0.4651E-01,0.4647E-01,
	 0.4667E-01,0.4708E-01,0.4772E-01,0.4858E-01,0.4965E-01,0.5094E-01,
	 0.5249E-01,0.5430E-01,0.5642E-01,0.5887E-01,0.6169E-01,0.6491E-01,
	 0.6858E-01,0.7273E-01,0.7744E-01,0.8274E-01,0.8872E-01,0.9201E-01,
	 0.9544E-01,0.1029E+00,0.1113E+00,0.1206E+00,0.1309E+00,0.1424E+00,
	 0.1550E+00,0.1689E+00,0.1842E+00,0.2011E+00,0.2198E+00,0.2404E+00,
	 0.2633E+00,0.2886E+00,0.3163E+00,0.3468E+00,0.3800E+00,0.4164E+00,
	 0.4565E+00,0.5002E+00,0.5485E+00,0.6020E+00,0.6608E+00,0.7261E+00,
	 0.7993E+00,0.8810E+00,0.9739E+00,0.1083E+01,0.1211E+01,0.1368E+01,
	 0.1571E+01,0.1846E+01,0.2242E+01,0.2860E+01,0.3918E+01,0.5956E+01,
	 0.1050E+02,0.2307E+02,0.7281E+02,0.4999E+03,0.3196E+05
     },
     {
	 0.2765E+00,0.2752E+00,0.3129E+00,0.2981E+00,0.2697E+00,0.2452E+00,
	 0.2256E+00,0.2075E+00,0.1862E+00,0.1589E+00,0.1301E+00,0.1069E+00,
	 0.8939E-01,0.7677E-01,0.6780E-01,0.6145E-01,0.5690E-01,0.5366E-01,
	 0.5134E-01,0.4973E-01,0.4862E-01,0.4794E-01,0.4758E-01,0.4751E-01,
	 0.4769E-01,0.4811E-01,0.4877E-01,0.4965E-01,0.5076E-01,0.5212E-01,
	 0.5373E-01,0.5563E-01,0.5784E-01,0.6041E-01,0.6336E-01,0.6672E-01,
	 0.7055E-01,0.7488E-01,0.7979E-01,0.8532E-01,0.9155E-01,0.9497E-01,
	 0.9854E-01,0.1063E+00,0.1150E+00,0.1247E+00,0.1354E+00,0.1473E+00,
	 0.1604E+00,0.1748E+00,0.1907E+00,0.2083E+00,0.2276E+00,0.2491E+00,
	 0.2729E+00,0.2990E+00,0.3279E+00,0.3596E+00,0.3941E+00,0.4319E+00,
	 0.4735E+00,0.5191E+00,0.5693E+00,0.6251E+00,0.6864E+00,0.7545E+00,
	 0.8309E+00,0.9163E+00,0.1013E+01,0.1127E+01,0.1262E+01,0.1426E+01,
	 0.1640E+01,0.1928E+01,0.2345E+01,0.2995E+01,0.4106E+01,0.6242E+01,
	 0.1098E+02,0.2400E+02,0.7481E+02,0.4984E+03,0.2810E+05
     },
     {
	 0.3140E+00,0.3090E+00,0.3440E+00,0.3291E+00,0.2988E+00,0.2716E+00,
	 0.2491E+00,0.2285E+00,0.2053E+00,0.1759E+00,0.1447E+00,0.1190E+00,
	 0.9926E-01,0.8484E-01,0.7446E-01,0.6700E-01,0.6162E-01,0.5774E-01,
	 0.5493E-01,0.5295E-01,0.5158E-01,0.5070E-01,0.5021E-01,0.5005E-01,
	 0.5019E-01,0.5060E-01,0.5129E-01,0.5224E-01,0.5344E-01,0.5492E-01,
	 0.5668E-01,0.5876E-01,0.6118E-01,0.6400E-01,0.6723E-01,0.7091E-01,
	 0.7509E-01,0.7981E-01,0.8516E-01,0.9117E-01,0.9793E-01,0.1016E+00,
	 0.1055E+00,0.1140E+00,0.1234E+00,0.1338E+00,0.1454E+00,0.1582E+00,
	 0.1724E+00,0.1879E+00,0.2051E+00,0.2241E+00,0.2449E+00,0.2681E+00,
	 0.2937E+00,0.3220E+00,0.3531E+00,0.3873E+00,0.4247E+00,0.4656E+00,
	 0.5108E+00,0.5603E+00,0.6149E+00,0.6756E+00,0.7425E+00,0.8168E+00,
	 0.9003E+00,0.9939E+00,0.1101E+01,0.1226E+01,0.1374E+01,0.1557E+01,
	 0.1793E+01,0.2114E+01,0.2577E+01,0.3299E+01,0.4529E+01,0.6879E+01,
	 0.1204E+02,0.2596E+02,0.7866E+02,0.4906E+03,0.2124E+05
     },
     {
	 0.3397E+00,0.3323E+00,0.3646E+00,0.3493E+00,0.3179E+00,0.2889E+00,
	 0.2644E+00,0.2424E+00,0.2181E+00,0.1874E+00,0.1547E+00,0.1274E+00,
	 0.1062E+00,0.9063E-01,0.7928E-01,0.7107E-01,0.6509E-01,0.6076E-01,
	 0.5761E-01,0.5537E-01,0.5380E-01,0.5278E-01,0.5218E-01,0.5196E-01,
	 0.5206E-01,0.5246E-01,0.5317E-01,0.5415E-01,0.5542E-01,0.5697E-01,
	 0.5883E-01,0.6103E-01,0.6359E-01,0.6657E-01,0.6998E-01,0.7387E-01,
	 0.7829E-01,0.8327E-01,0.8891E-01,0.9524E-01,0.1024E+00,0.1063E+00,
	 0.1103E+00,0.1192E+00,0.1291E+00,0.1400E+00,0.1522E+00,0.1656E+00,
	 0.1805E+00,0.1968E+00,0.2148E+00,0.2346E+00,0.2565E+00,0.2807E+00,
	 0.3076E+00,0.3372E+00,0.3699E+00,0.4058E+00,0.4451E+00,0.4881E+00,
	 0.5357E+00,0.5878E+00,0.6454E+00,0.7094E+00,0.7800E+00,0.8586E+00,
	 0.9471E+00,0.1046E+01,0.1160E+01,0.1293E+01,0.1451E+01,0.1646E+01,
	 0.1899E+01,0.2242E+01,0.2738E+01,0.3509E+01,0.4820E+01,0.7310E+01,
	 0.1274E+02,0.2720E+02,0.8080E+02,0.4822E+03,0.1763E+05
     },
     {
	 0.3665E+00,0.3585E+00,0.3853E+00,0.3705E+00,0.3386E+00,0.3093E+00,
	 0.2869E+00,0.2705E+00,0.2507E+00,0.2187E+00,0.1832E+00,0.1512E+00,
	 0.1258E+00,0.1065E+00,0.9217E-01,0.8162E-01,0.7386E-01,0.6812E-01,
	 0.6393E-01,0.6088E-01,0.5870E-01,0.5723E-01,0.5631E-01,0.5585E-01,
	 0.5579E-01,0.5612E-01,0.5681E-01,0.5783E-01,0.5918E-01,0.6088E-01,
	 0.6291E-01,0.6532E-01,0.6815E-01,0.7143E-01,0.7521E-01,0.7951E-01,
	 0.8439E-01,0.8988E-01,0.9607E-01,0.1030E+00,0.1108E+00,0.1151E+00,
	 0.1196E+00,0.1293E+00,0.1400E+00,0.1520E+00,0.1652E+00,0.1799E+00,
	 0.1961E+00,0.2140E+00,0.2338E+00,0.2557E+00,0.2799E+00,0.3069E+00,
	 0.3367E+00,0.3696E+00,0.4060E+00,0.4461E+00,0.4901E+00,0.5388E+00,
	 0.5927E+00,0.6520E+00,0.7180E+00,0.7913E+00,0.8725E+00,0.9634E+00,
	 0.1066E+01,0.1181E+01,0.1314E+01,0.1469E+01,0.1655E+01,0.1885E+01,
	 0.2183E+01,0.2586E+01,0.3166E+01,0.4061E+01,0.5568E+01,0.8386E+01,
	 0.1440E+02,0.2992E+02,0.8452E+02,0.4537E+03,0.1132E+05
     },
     {
	 0.2248E+00,0.2041E+00,0.2013E+00,0.2015E+00,0.2038E+00,0.2142E+00,
	 0.2218E+00,0.2177E+00,0.2078E+00,0.1973E+00,0.1876E+00,0.1779E+00,
	 0.1666E+00,0.1530E+00,0.1377E+00,0.1221E+00,0.1078E+00,0.9531E-01,
	 0.8504E-01,0.7686E-01,0.7052E-01,0.6573E-01,0.6219E-01,0.5966E-01,
	 0.5794E-01,0.5689E-01,0.5645E-01,0.5656E-01,0.5718E-01,0.5825E-01,
	 0.5974E-01,0.6159E-01,0.6382E-01,0.6647E-01,0.6955E-01,0.7314E-01,
	 0.7723E-01,0.8187E-01,0.8711E-01,0.9302E-01,0.9976E-01,0.1035E+00,
	 0.1075E+00,0.1163E+00,0.1263E+00,0.1377E+00,0.1507E+00,0.1653E+00,
	 0.1819E+00,0.2008E+00,0.2222E+00,0.2467E+00,0.2745E+00,0.3060E+00,
	 0.3418E+00,0.3822E+00,0.4279E+00,0.4800E+00,0.5391E+00,0.6066E+00,
	 0.6838E+00,0.7715E+00,0.8718E+00,0.9864E+00,0.1117E+01,0.1268E+01,
	 0.1442E+01,0.1643E+01,0.1880E+01,0.2160E+01,0.2496E+01,0.2906E+01,
	 0.3423E+01,0.4095E+01,0.5014E+01,0.6356E+01,0.8465E+01,0.1211E+02,
	 0.1924E+02,0.3569E+02,0.8510E+02,0.3357E+03,0.3290E+04
     },
     {
	 0.8649E-01,0.6705E-01,0.5195E-01,0.7001E-01,0.7008E-01,0.6002E-01,
	 0.5176E-01,0.4616E-01,0.4241E-01,0.3977E-01,0.3795E-01,0.3668E-01,
	 0.3583E-01,0.3535E-01,0.3514E-01,0.3524E-01,0.3565E-01,0.3638E-01,
	 0.3751E-01,0.3892E-01,0.4055E-01,0.4217E-01,0.4354E-01,0.4447E-01,
	 0.4473E-01,0.4432E-01,0.4334E-01,0.4196E-01,0.4043E-01,0.3895E-01,
	 0.3767E-01,0.3668E-01,0.3599E-01,0.3567E-01,0.3568E-01,0.3603E-01,
	 0.3675E-01,0.3782E-01,0.3929E-01,0.4119E-01,0.4354E-01,0.4489E-01,
	 0.4638E-01,0.4977E-01,0.5377E-01,0.5848E-01,0.6402E-01,0.7052E-01,
	 0.7819E-01,0.8720E-01,0.9780E-01,0.1103E+00,0.1250E+00,0.1423E+00,
	 0.1629E+00,0.1872E+00,0.2164E+00,0.2514E+00,0.2934E+00,0.3442E+00,
	 0.4055E+00,0.4799E+00,0.5709E+00,0.6824E+00,0.8200E+00,0.9912E+00,
	 0.1205E+01,0.1474E+01,0.1814E+01,0.2247E+01,0.2801E+01,0.3520E+01,
	 0.4460E+01,0.5710E+01,0.7406E+01,0.9765E+01,0.1318E+02,0.1847E+02,
	 0.2749E+02,0.4547E+02,0.9155E+02,0.2798E+03,0.1582E+04
     },
     {
	 0.9344E-01,0.8261E-01,0.6680E-01,0.7550E-01,0.8962E-01,0.9095E-01,
	 0.8469E-01,0.7755E-01,0.7170E-01,0.6726E-01,0.6401E-01,0.6173E-01,
	 0.6034E-01,0.5974E-01,0.5979E-01,0.6028E-01,0.6096E-01,0.6155E-01,
	 0.6179E-01,0.6151E-01,0.6067E-01,0.5928E-01,0.5752E-01,0.5554E-01,
	 0.5354E-01,0.5165E-01,0.4997E-01,0.4858E-01,0.4752E-01,0.4683E-01,
	 0.4651E-01,0.4657E-01,0.4701E-01,0.4781E-01,0.4897E-01,0.5053E-01,
	 0.5250E-01,0.5493E-01,0.5787E-01,0.6137E-01,0.6550E-01,0.6782E-01,
	 0.7033E-01,0.7593E-01,0.8242E-01,0.8992E-01,0.9860E-01,0.1087E+00,
	 0.1203E+00,0.1339E+00,0.1497E+00,0.1682E+00,0.1896E+00,0.2147E+00,
	 0.2441E+00,0.2786E+00,0.3193E+00,0.3675E+00,0.4248E+00,0.4931E+00,
	 0.5747E+00,0.6726E+00,0.7902E+00,0.9324E+00,0.1105E+01,0.1316E+01,
	 0.1575E+01,0.1895E+01,0.2292E+01,0.2787E+01,0.3407E+01,0.4192E+01,
	 0.5195E+01,0.6498E+01,0.8221E+01,0.1057E+02,0.1389E+02,0.1886E+02,
	 0.2699E+02,0.4205E+02,0.7598E+02,0.1847E+03,0.5926E+03
     }},

    /* water model */
    {{
	    0.4115E+00,0.4045E+00,0.3805E+00,0.3495E+00,0.3192E+00,0.2943E+00,
	    0.2768E+00,0.2659E+00,0.2592E+00,0.2538E+00,0.2479E+00,0.2411E+00,
	    0.2336E+00,0.2255E+00,0.2175E+00,0.2098E+00,0.2026E+00,0.1961E+00,
	    0.1903E+00,0.1854E+00,0.1812E+00,0.1778E+00,0.1752E+00,0.1734E+00,
	    0.1723E+00,0.1719E+00,0.1724E+00,0.1736E+00,0.1756E+00,0.1784E+00,
	    0.1820E+00,0.1866E+00,0.1920E+00,0.1985E+00,0.2061E+00,0.2149E+00,
	    0.2249E+00,0.2363E+00,0.2492E+00,0.2638E+00,0.2803E+00,0.2893E+00,
	    0.2988E+00,0.3195E+00,0.3428E+00,0.3688E+00,0.3979E+00,0.4306E+00,
	    0.4671E+00,0.5079E+00,0.5537E+00,0.6048E+00,0.6622E+00,0.7264E+00,
	    0.7985E+00,0.8794E+00,0.9701E+00,0.1072E+01,0.1186E+01,0.1315E+01,
	    0.1460E+01,0.1622E+01,0.1805E+01,0.2011E+01,0.2242E+01,0.2503E+01,
	    0.2796E+01,0.3125E+01,0.3496E+01,0.3913E+01,0.4383E+01,0.4912E+01,
	    0.5510E+01,0.6185E+01,0.6951E+01,0.7825E+01,0.8828E+01,0.9991E+01,
	    0.1136E+02,0.1297E+02,0.1491E+02,0.1711E+02,0.1834E+02
	},
     {
	 0.3918E+00,0.3859E+00,0.3654E+00,0.3384E+00,0.3117E+00,0.2895E+00,
	 0.2736E+00,0.2635E+00,0.2571E+00,0.2522E+00,0.2470E+00,0.2411E+00,
	 0.2345E+00,0.2275E+00,0.2204E+00,0.2135E+00,0.2071E+00,0.2012E+00,
	 0.1959E+00,0.1914E+00,0.1875E+00,0.1844E+00,0.1820E+00,0.1804E+00,
	 0.1794E+00,0.1792E+00,0.1797E+00,0.1810E+00,0.1831E+00,0.1860E+00,
	 0.1898E+00,0.1945E+00,0.2001E+00,0.2068E+00,0.2146E+00,0.2236E+00,
	 0.2339E+00,0.2456E+00,0.2589E+00,0.2739E+00,0.2909E+00,0.3001E+00,
	 0.3099E+00,0.3312E+00,0.3552E+00,0.3820E+00,0.4119E+00,0.4455E+00,
	 0.4830E+00,0.5249E+00,0.5718E+00,0.6243E+00,0.6829E+00,0.7486E+00,
	 0.8221E+00,0.9045E+00,0.9968E+00,0.1100E+01,0.1216E+01,0.1346E+01,
	 0.1492E+01,0.1655E+01,0.1839E+01,0.2045E+01,0.2275E+01,0.2534E+01,
	 0.2824E+01,0.3149E+01,0.3513E+01,0.3920E+01,0.4375E+01,0.4884E+01,
	 0.5454E+01,0.6092E+01,0.6807E+01,0.7611E+01,0.8516E+01,0.9543E+01,
	 0.1071E+02,0.1205E+02,0.1357E+02,0.1518E+02,0.1599E+02
     },
     {
	 0.3872E+00,0.3816E+00,0.3620E+00,0.3360E+00,0.3102E+00,0.2887E+00,
	 0.2732E+00,0.2633E+00,0.2571E+00,0.2522E+00,0.2471E+00,0.2414E+00,
	 0.2350E+00,0.2283E+00,0.2214E+00,0.2148E+00,0.2085E+00,0.2028E+00,
	 0.1976E+00,0.1932E+00,0.1894E+00,0.1864E+00,0.1840E+00,0.1824E+00,
	 0.1815E+00,0.1813E+00,0.1819E+00,0.1832E+00,0.1853E+00,0.1883E+00,
	 0.1920E+00,0.1968E+00,0.2024E+00,0.2092E+00,0.2170E+00,0.2261E+00,
	 0.2364E+00,0.2483E+00,0.2617E+00,0.2768E+00,0.2939E+00,0.3032E+00,
	 0.3131E+00,0.3346E+00,0.3587E+00,0.3857E+00,0.4159E+00,0.4497E+00,
	 0.4875E+00,0.5297E+00,0.5769E+00,0.6297E+00,0.6887E+00,0.7547E+00,
	 0.8286E+00,0.9114E+00,0.1004E+01,0.1108E+01,0.1224E+01,0.1354E+01,
	 0.1500E+01,0.1664E+01,0.1847E+01,0.2053E+01,0.2284E+01,0.2542E+01,
	 0.2831E+01,0.3154E+01,0.3515E+01,0.3919E+01,0.4370E+01,0.4874E+01,
	 0.5436E+01,0.6064E+01,0.6765E+01,0.7549E+01,0.8430E+01,0.9422E+01,
	 0.1054E+02,0.1182E+02,0.1324E+02,0.1472E+02,0.1544E+02
     },
     {
	 0.3737E+00,0.3687E+00,0.3509E+00,0.3269E+00,0.3030E+00,0.2830E+00,
	 0.2686E+00,0.2593E+00,0.2535E+00,0.2490E+00,0.2444E+00,0.2393E+00,
	 0.2335E+00,0.2273E+00,0.2210E+00,0.2148E+00,0.2089E+00,0.2036E+00,
	 0.1987E+00,0.1945E+00,0.1910E+00,0.1881E+00,0.1859E+00,0.1844E+00,
	 0.1836E+00,0.1835E+00,0.1842E+00,0.1855E+00,0.1877E+00,0.1907E+00,
	 0.1945E+00,0.1993E+00,0.2051E+00,0.2118E+00,0.2198E+00,0.2289E+00,
	 0.2394E+00,0.2513E+00,0.2649E+00,0.2802E+00,0.2974E+00,0.3068E+00,
	 0.3168E+00,0.3385E+00,0.3628E+00,0.3901E+00,0.4206E+00,0.4547E+00,
	 0.4928E+00,0.5353E+00,0.5829E+00,0.6361E+00,0.6955E+00,0.7620E+00,
	 0.8363E+00,0.9195E+00,0.1013E+01,0.1117E+01,0.1233E+01,0.1364E+01,
	 0.1510E+01,0.1674E+01,0.1858E+01,0.2063E+01,0.2293E+01,0.2550E+01,
	 0.2838E+01,0.3160E+01,0.3518E+01,0.3919E+01,0.4365E+01,0.4863E+01,
	 0.5416E+01,0.6033E+01,0.6719E+01,0.7483E+01,0.8337E+01,0.9292E+01,
	 0.1036E+02,0.1156E+02,0.1289E+02,0.1423E+02,0.1486E+02
     },
     {
	 0.3651E+00,0.3607E+00,0.3449E+00,0.3233E+00,0.3016E+00,0.2832E+00,
	 0.2697E+00,0.2609E+00,0.2552E+00,0.2509E+00,0.2465E+00,0.2418E+00,
	 0.2364E+00,0.2307E+00,0.2249E+00,0.2191E+00,0.2137E+00,0.2086E+00,
	 0.2041E+00,0.2001E+00,0.1968E+00,0.1940E+00,0.1919E+00,0.1905E+00,
	 0.1898E+00,0.1897E+00,0.1904E+00,0.1919E+00,0.1941E+00,0.1971E+00,
	 0.2011E+00,0.2059E+00,0.2118E+00,0.2187E+00,0.2267E+00,0.2361E+00,
	 0.2467E+00,0.2589E+00,0.2727E+00,0.2883E+00,0.3059E+00,0.3155E+00,
	 0.3257E+00,0.3478E+00,0.3726E+00,0.4004E+00,0.4315E+00,0.4662E+00,
	 0.5050E+00,0.5483E+00,0.5967E+00,0.6507E+00,0.7110E+00,0.7783E+00,
	 0.8536E+00,0.9376E+00,0.1032E+01,0.1137E+01,0.1254E+01,0.1385E+01,
	 0.1531E+01,0.1695E+01,0.1878E+01,0.2083E+01,0.2311E+01,0.2566E+01,
	 0.2850E+01,0.3166E+01,0.3518E+01,0.3910E+01,0.4344E+01,0.4825E+01,
	 0.5358E+01,0.5947E+01,0.6597E+01,0.7314E+01,0.8106E+01,0.8978E+01,
	 0.9939E+01,0.1099E+02,0.1211E+02,0.1319E+02,0.1367E+02
     },
     {
	 0.3540E+00,0.3501E+00,0.3360E+00,0.3166E+00,0.2969E+00,0.2801E+00,
	 0.2677E+00,0.2594E+00,0.2541E+00,0.2500E+00,0.2461E+00,0.2417E+00,
	 0.2369E+00,0.2317E+00,0.2263E+00,0.2211E+00,0.2160E+00,0.2113E+00,
	 0.2070E+00,0.2033E+00,0.2001E+00,0.1976E+00,0.1956E+00,0.1943E+00,
	 0.1937E+00,0.1937E+00,0.1945E+00,0.1960E+00,0.1982E+00,0.2013E+00,
	 0.2053E+00,0.2102E+00,0.2162E+00,0.2232E+00,0.2313E+00,0.2408E+00,
	 0.2516E+00,0.2639E+00,0.2779E+00,0.2937E+00,0.3115E+00,0.3213E+00,
	 0.3315E+00,0.3540E+00,0.3791E+00,0.4073E+00,0.4387E+00,0.4739E+00,
	 0.5131E+00,0.5569E+00,0.6057E+00,0.6603E+00,0.7211E+00,0.7890E+00,
	 0.8647E+00,0.9493E+00,0.1044E+01,0.1149E+01,0.1267E+01,0.1398E+01,
	 0.1545E+01,0.1708E+01,0.1891E+01,0.2095E+01,0.2322E+01,0.2575E+01,
	 0.2856E+01,0.3169E+01,0.3517E+01,0.3902E+01,0.4328E+01,0.4799E+01,
	 0.5318E+01,0.5890E+01,0.6519E+01,0.7208E+01,0.7963E+01,0.8788E+01,
	 0.9685E+01,0.1065E+02,0.1166E+02,0.1261E+02,0.1301E+02
     },
     {
	 0.3121E+00,0.3097E+00,0.3008E+00,0.2882E+00,0.2753E+00,0.2643E+00,
	 0.2562E+00,0.2509E+00,0.2473E+00,0.2445E+00,0.2417E+00,0.2384E+00,
	 0.2348E+00,0.2307E+00,0.2265E+00,0.2223E+00,0.2182E+00,0.2144E+00,
	 0.2109E+00,0.2078E+00,0.2052E+00,0.2030E+00,0.2014E+00,0.2004E+00,
	 0.2000E+00,0.2002E+00,0.2011E+00,0.2027E+00,0.2051E+00,0.2082E+00,
	 0.2123E+00,0.2173E+00,0.2232E+00,0.2303E+00,0.2386E+00,0.2482E+00,
	 0.2591E+00,0.2717E+00,0.2859E+00,0.3019E+00,0.3201E+00,0.3300E+00,
	 0.3404E+00,0.3633E+00,0.3889E+00,0.4176E+00,0.4496E+00,0.4854E+00,
	 0.5253E+00,0.5699E+00,0.6196E+00,0.6749E+00,0.7367E+00,0.8055E+00,
	 0.8822E+00,0.9677E+00,0.1063E+01,0.1169E+01,0.1288E+01,0.1419E+01,
	 0.1566E+01,0.1730E+01,0.1912E+01,0.2115E+01,0.2341E+01,0.2591E+01,
	 0.2869E+01,0.3177E+01,0.3518E+01,0.3895E+01,0.4309E+01,0.4765E+01,
	 0.5265E+01,0.5811E+01,0.6405E+01,0.7049E+01,0.7744E+01,0.8489E+01,
	 0.9280E+01,0.1010E+02,0.1093E+02,0.1165E+02,0.1192E+02
     },
     {
	 0.3070E+00,0.3061E+00,0.3027E+00,0.2975E+00,0.2918E+00,0.2865E+00,
	 0.2821E+00,0.2787E+00,0.2760E+00,0.2735E+00,0.2711E+00,0.2684E+00,
	 0.2656E+00,0.2626E+00,0.2594E+00,0.2562E+00,0.2530E+00,0.2500E+00,
	 0.2471E+00,0.2446E+00,0.2423E+00,0.2404E+00,0.2390E+00,0.2380E+00,
	 0.2375E+00,0.2377E+00,0.2385E+00,0.2400E+00,0.2422E+00,0.2453E+00,
	 0.2493E+00,0.2543E+00,0.2604E+00,0.2677E+00,0.2762E+00,0.2861E+00,
	 0.2976E+00,0.3108E+00,0.3258E+00,0.3428E+00,0.3620E+00,0.3725E+00,
	 0.3836E+00,0.4079E+00,0.4351E+00,0.4655E+00,0.4993E+00,0.5371E+00,
	 0.5791E+00,0.6258E+00,0.6776E+00,0.7351E+00,0.7988E+00,0.8694E+00,
	 0.9476E+00,0.1034E+01,0.1130E+01,0.1236E+01,0.1353E+01,0.1482E+01,
	 0.1625E+01,0.1783E+01,0.1957E+01,0.2148E+01,0.2359E+01,0.2590E+01,
	 0.2844E+01,0.3121E+01,0.3424E+01,0.3754E+01,0.4112E+01,0.4498E+01,
	 0.4913E+01,0.5356E+01,0.5826E+01,0.6320E+01,0.6833E+01,0.7358E+01,
	 0.7884E+01,0.8390E+01,0.8846E+01,0.9187E+01,0.9295E+01
     },
     {
	 0.3321E+00,0.3315E+00,0.3294E+00,0.3266E+00,0.3238E+00,0.3214E+00,
	 0.3192E+00,0.3169E+00,0.3142E+00,0.3111E+00,0.3075E+00,0.3036E+00,
	 0.2994E+00,0.2950E+00,0.2905E+00,0.2860E+00,0.2817E+00,0.2775E+00,
	 0.2735E+00,0.2698E+00,0.2665E+00,0.2635E+00,0.2609E+00,0.2587E+00,
	 0.2571E+00,0.2561E+00,0.2556E+00,0.2558E+00,0.2568E+00,0.2586E+00,
	 0.2613E+00,0.2650E+00,0.2697E+00,0.2756E+00,0.2827E+00,0.2913E+00,
	 0.3013E+00,0.3131E+00,0.3267E+00,0.3422E+00,0.3600E+00,0.3698E+00,
	 0.3802E+00,0.4030E+00,0.4287E+00,0.4575E+00,0.4899E+00,0.5261E+00,
	 0.5665E+00,0.6115E+00,0.6617E+00,0.7175E+00,0.7795E+00,0.8484E+00,
	 0.9248E+00,0.1010E+01,0.1103E+01,0.1208E+01,0.1323E+01,0.1451E+01,
	 0.1592E+01,0.1749E+01,0.1922E+01,0.2113E+01,0.2324E+01,0.2557E+01,
	 0.2813E+01,0.3095E+01,0.3403E+01,0.3740E+01,0.4106E+01,0.4502E+01,
	 0.4928E+01,0.5383E+01,0.5863E+01,0.6364E+01,0.6878E+01,0.7395E+01,
	 0.7898E+01,0.8366E+01,0.8764E+01,0.9041E+01,0.9119E+01
     },
     {
	 0.4248E+00,0.4242E+00,0.4221E+00,0.4189E+00,0.4153E+00,0.4116E+00,
	 0.4081E+00,0.4045E+00,0.4006E+00,0.3964E+00,0.3918E+00,0.3869E+00,
	 0.3818E+00,0.3764E+00,0.3709E+00,0.3654E+00,0.3600E+00,0.3547E+00,
	 0.3495E+00,0.3446E+00,0.3401E+00,0.3359E+00,0.3321E+00,0.3288E+00,
	 0.3260E+00,0.3239E+00,0.3224E+00,0.3218E+00,0.3219E+00,0.3230E+00,
	 0.3251E+00,0.3282E+00,0.3326E+00,0.3383E+00,0.3455E+00,0.3542E+00,
	 0.3646E+00,0.3768E+00,0.3911E+00,0.4075E+00,0.4263E+00,0.4366E+00,
	 0.4476E+00,0.4717E+00,0.4989E+00,0.5293E+00,0.5633E+00,0.6011E+00,
	 0.6431E+00,0.6896E+00,0.7410E+00,0.7977E+00,0.8603E+00,0.9291E+00,
	 0.1005E+01,0.1088E+01,0.1179E+01,0.1278E+01,0.1387E+01,0.1506E+01,
	 0.1636E+01,0.1778E+01,0.1933E+01,0.2100E+01,0.2283E+01,0.2480E+01,
	 0.2693E+01,0.2923E+01,0.3169E+01,0.3433E+01,0.3713E+01,0.4009E+01,
	 0.4319E+01,0.4642E+01,0.4973E+01,0.5308E+01,0.5640E+01,0.5962E+01,
	 0.6262E+01,0.6528E+01,0.6740E+01,0.6876E+01,0.6911E+01
     }},

    /* ocean model */
    {{
	    0.7855E+00,0.6283E+00,0.5465E+00,0.4693E+00,0.4153E+00,0.3917E+00,
	    0.3657E+00,0.3378E+00,0.3161E+00,0.3025E+00,0.2972E+00,0.2990E+00,
	    0.3055E+00,0.3118E+00,0.3059E+00,0.2715E+00,0.2118E+00,0.1585E+00,
	    0.1230E+00,0.9913E-01,0.8327E-01,0.7292E-01,0.6585E-01,0.6171E-01,
	    0.5883E-01,0.5780E-01,0.5791E-01,0.5893E-01,0.6144E-01,0.6406E-01,
	    0.6717E-01,0.6966E-01,0.7130E-01,0.7291E-01,0.7434E-01,0.7626E-01,
	    0.7847E-01,0.8190E-01,0.8583E-01,0.9044E-01,0.9709E-01,0.1006E+00,
	    0.1045E+00,0.1128E+00,0.1239E+00,0.1360E+00,0.1497E+00,0.1667E+00,
	    0.1856E+00,0.2070E+00,0.2323E+00,0.2615E+00,0.2948E+00,0.3326E+00,
	    0.3772E+00,0.4263E+00,0.4840E+00,0.5492E+00,0.6242E+00,0.7103E+00,
	    0.8075E+00,0.9192E+00,0.1046E+01,0.1190E+01,0.1354E+01,0.1541E+01,
	    0.1756E+01,0.2002E+01,0.2277E+01,0.2603E+01,0.2976E+01,0.3416E+01,
	    0.3931E+01,0.4563E+01,0.5372E+01,0.6490E+01,0.8191E+01,0.1111E+02,
	    0.1692E+02,0.3097E+02,0.7524E+02,0.2992E+03,0.1697E+04
	},
     {
	 0.7129E+00,0.5739E+00,0.5059E+00,0.4429E+00,0.4035E+00,0.3898E+00,
	 0.3678E+00,0.3416E+00,0.3195E+00,0.3042E+00,0.2975E+00,0.2961E+00,
	 0.2987E+00,0.2994E+00,0.2909E+00,0.2614E+00,0.2134E+00,0.1670E+00,
	 0.1336E+00,0.1100E+00,0.9363E-01,0.8252E-01,0.7480E-01,0.6967E-01,
	 0.6621E-01,0.6499E-01,0.6438E-01,0.6506E-01,0.6656E-01,0.6880E-01,
	 0.7108E-01,0.7332E-01,0.7497E-01,0.7681E-01,0.7860E-01,0.8093E-01,
	 0.8357E-01,0.8723E-01,0.9184E-01,0.9665E-01,0.1036E+00,0.1075E+00,
	 0.1112E+00,0.1200E+00,0.1316E+00,0.1436E+00,0.1580E+00,0.1748E+00,
	 0.1937E+00,0.2154E+00,0.2413E+00,0.2704E+00,0.3031E+00,0.3421E+00,
	 0.3856E+00,0.4356E+00,0.4928E+00,0.5586E+00,0.6333E+00,0.7196E+00,
	 0.8188E+00,0.9313E+00,0.1060E+01,0.1208E+01,0.1375E+01,0.1568E+01,
	 0.1791E+01,0.2047E+01,0.2340E+01,0.2679E+01,0.3075E+01,0.3547E+01,
	 0.4107E+01,0.4805E+01,0.5714E+01,0.6981E+01,0.8889E+01,0.1212E+02,
	 0.1839E+02,0.3283E+02,0.7515E+02,0.2626E+03,0.1134E+04
     },
     {
	 0.6966E+00,0.5607E+00,0.4902E+00,0.4336E+00,0.3978E+00,0.3866E+00,
	 0.3674E+00,0.3412E+00,0.3187E+00,0.3039E+00,0.2960E+00,0.2945E+00,
	 0.2960E+00,0.2961E+00,0.2874E+00,0.2591E+00,0.2133E+00,0.1692E+00,
	 0.1362E+00,0.1129E+00,0.9630E-01,0.8484E-01,0.7707E-01,0.7190E-01,
	 0.6854E-01,0.6653E-01,0.6597E-01,0.6668E-01,0.6812E-01,0.7009E-01,
	 0.7216E-01,0.7425E-01,0.7580E-01,0.7758E-01,0.7959E-01,0.8174E-01,
	 0.8490E-01,0.8852E-01,0.9294E-01,0.9864E-01,0.1048E+00,0.1084E+00,
	 0.1128E+00,0.1220E+00,0.1325E+00,0.1453E+00,0.1596E+00,0.1762E+00,
	 0.1959E+00,0.2177E+00,0.2428E+00,0.2725E+00,0.3055E+00,0.3440E+00,
	 0.3882E+00,0.4382E+00,0.4953E+00,0.5613E+00,0.6365E+00,0.7225E+00,
	 0.8218E+00,0.9344E+00,0.1065E+01,0.1212E+01,0.1381E+01,0.1577E+01,
	 0.1801E+01,0.2059E+01,0.2360E+01,0.2701E+01,0.3107E+01,0.3586E+01,
	 0.4166E+01,0.4885E+01,0.5821E+01,0.7115E+01,0.9088E+01,0.1241E+02,
	 0.1877E+02,0.3323E+02,0.7480E+02,0.2523E+03,0.1018E+04
     },
     {
	 0.6774E+00,0.5476E+00,0.4775E+00,0.4252E+00,0.3937E+00,0.3855E+00,
	 0.3684E+00,0.3432E+00,0.3209E+00,0.3059E+00,0.2974E+00,0.2950E+00,
	 0.2951E+00,0.2935E+00,0.2832E+00,0.2550E+00,0.2114E+00,0.1697E+00,
	 0.1380E+00,0.1153E+00,0.9882E-01,0.8737E-01,0.7952E-01,0.7423E-01,
	 0.7074E-01,0.6859E-01,0.6788E-01,0.6842E-01,0.6969E-01,0.7150E-01,
	 0.7349E-01,0.7557E-01,0.7720E-01,0.7911E-01,0.8125E-01,0.8356E-01,
	 0.8685E-01,0.9062E-01,0.9516E-01,0.1010E+00,0.1073E+00,0.1109E+00,
	 0.1154E+00,0.1247E+00,0.1352E+00,0.1482E+00,0.1626E+00,0.1793E+00,
	 0.1991E+00,0.2210E+00,0.2462E+00,0.2760E+00,0.3091E+00,0.3477E+00,
	 0.3920E+00,0.4422E+00,0.4994E+00,0.5656E+00,0.6410E+00,0.7275E+00,
	 0.8272E+00,0.9405E+00,0.1071E+01,0.1220E+01,0.1391E+01,0.1588E+01,
	 0.1815E+01,0.2077E+01,0.2382E+01,0.2731E+01,0.3145E+01,0.3636E+01,
	 0.4233E+01,0.4974E+01,0.5942E+01,0.7282E+01,0.9319E+01,0.1273E+02,
	 0.1919E+02,0.3364E+02,0.7414E+02,0.2397E+03,0.8914E+03
     },
     {
	 0.6153E+00,0.5058E+00,0.4382E+00,0.3950E+00,0.3738E+00,0.3731E+00,
	 0.3585E+00,0.3354E+00,0.3139E+00,0.2983E+00,0.2892E+00,0.2849E+00,
	 0.2832E+00,0.2800E+00,0.2703E+00,0.2469E+00,0.2112E+00,0.1741E+00,
	 0.1442E+00,0.1219E+00,0.1054E+00,0.9356E-01,0.8531E-01,0.7966E-01,
	 0.7561E-01,0.7323E-01,0.7198E-01,0.7214E-01,0.7291E-01,0.7415E-01,
	 0.7601E-01,0.7747E-01,0.7901E-01,0.8091E-01,0.8293E-01,0.8564E-01,
	 0.8906E-01,0.9289E-01,0.9788E-01,0.1033E+00,0.1102E+00,0.1141E+00,
	 0.1181E+00,0.1275E+00,0.1385E+00,0.1511E+00,0.1660E+00,0.1823E+00,
	 0.2018E+00,0.2241E+00,0.2491E+00,0.2784E+00,0.3123E+00,0.3503E+00,
	 0.3942E+00,0.4451E+00,0.5020E+00,0.5684E+00,0.6448E+00,0.7319E+00,
	 0.8325E+00,0.9481E+00,0.1081E+01,0.1234E+01,0.1409E+01,0.1612E+01,
	 0.1846E+01,0.2118E+01,0.2440E+01,0.2809E+01,0.3249E+01,0.3773E+01,
	 0.4413E+01,0.5211E+01,0.6259E+01,0.7710E+01,0.9888E+01,0.1347E+02,
	 0.2009E+02,0.3435E+02,0.7217E+02,0.2130E+03,0.6728E+03
     },
     {
	 0.5916E+00,0.4877E+00,0.4171E+00,0.3786E+00,0.3632E+00,0.3654E+00,
	 0.3546E+00,0.3335E+00,0.3124E+00,0.2967E+00,0.2869E+00,0.2822E+00,
	 0.2792E+00,0.2744E+00,0.2635E+00,0.2413E+00,0.2085E+00,0.1740E+00,
	 0.1459E+00,0.1244E+00,0.1084E+00,0.9682E-01,0.8822E-01,0.8243E-01,
	 0.7835E-01,0.7606E-01,0.7463E-01,0.7441E-01,0.7473E-01,0.7609E-01,
	 0.7739E-01,0.7905E-01,0.8078E-01,0.8256E-01,0.8474E-01,0.8745E-01,
	 0.9082E-01,0.9490E-01,0.9996E-01,0.1057E+00,0.1127E+00,0.1166E+00,
	 0.1207E+00,0.1301E+00,0.1412E+00,0.1539E+00,0.1686E+00,0.1858E+00,
	 0.2048E+00,0.2270E+00,0.2528E+00,0.2818E+00,0.3154E+00,0.3545E+00,
	 0.3980E+00,0.4487E+00,0.5067E+00,0.5728E+00,0.6491E+00,0.7374E+00,
	 0.8386E+00,0.9547E+00,0.1090E+01,0.1244E+01,0.1423E+01,0.1630E+01,
	 0.1870E+01,0.2149E+01,0.2477E+01,0.2862E+01,0.3316E+01,0.3862E+01,
	 0.4527E+01,0.5365E+01,0.6458E+01,0.7974E+01,0.1023E+02,0.1390E+02,
	 0.2058E+02,0.3459E+02,0.7042E+02,0.1961E+03,0.5608E+03
     },
     {
	 0.5164E+00,0.4330E+00,0.3650E+00,0.3341E+00,0.3313E+00,0.3413E+00,
	 0.3356E+00,0.3182E+00,0.2998E+00,0.2844E+00,0.2744E+00,0.2677E+00,
	 0.2626E+00,0.2560E+00,0.2453E+00,0.2267E+00,0.2009E+00,0.1730E+00,
	 0.1485E+00,0.1291E+00,0.1141E+00,0.1028E+00,0.9425E-01,0.8828E-01,
	 0.8375E-01,0.8105E-01,0.7927E-01,0.7843E-01,0.7860E-01,0.7925E-01,
	 0.8010E-01,0.8165E-01,0.8331E-01,0.8499E-01,0.8754E-01,0.9034E-01,
	 0.9390E-01,0.9825E-01,0.1034E+00,0.1093E+00,0.1164E+00,0.1203E+00,
	 0.1246E+00,0.1342E+00,0.1452E+00,0.1582E+00,0.1728E+00,0.1896E+00,
	 0.2094E+00,0.2310E+00,0.2569E+00,0.2863E+00,0.3195E+00,0.3587E+00,
	 0.4030E+00,0.4534E+00,0.5122E+00,0.5794E+00,0.6565E+00,0.7463E+00,
	 0.8505E+00,0.9697E+00,0.1109E+01,0.1270E+01,0.1457E+01,0.1674E+01,
	 0.1929E+01,0.2226E+01,0.2578E+01,0.2997E+01,0.3495E+01,0.4096E+01,
	 0.4831E+01,0.5758E+01,0.6967E+01,0.8629E+01,0.1105E+02,0.1487E+02,
	 0.2152E+02,0.3465E+02,0.6548E+02,0.1595E+03,0.3700E+03
     },
     {
	 0.3257E+00,0.2888E+00,0.2378E+00,0.2215E+00,0.2345E+00,0.2532E+00,
	 0.2578E+00,0.2504E+00,0.2390E+00,0.2282E+00,0.2194E+00,0.2123E+00,
	 0.2059E+00,0.1991E+00,0.1906E+00,0.1797E+00,0.1665E+00,0.1520E+00,
	 0.1379E+00,0.1254E+00,0.1147E+00,0.1061E+00,0.9917E-01,0.9373E-01,
	 0.8960E-01,0.8656E-01,0.8438E-01,0.8306E-01,0.8243E-01,0.8240E-01,
	 0.8294E-01,0.8394E-01,0.8543E-01,0.8740E-01,0.8990E-01,0.9302E-01,
	 0.9681E-01,0.1013E+00,0.1067E+00,0.1129E+00,0.1200E+00,0.1240E+00,
	 0.1283E+00,0.1379E+00,0.1490E+00,0.1618E+00,0.1764E+00,0.1932E+00,
	 0.2124E+00,0.2345E+00,0.2599E+00,0.2892E+00,0.3231E+00,0.3622E+00,
	 0.4072E+00,0.4593E+00,0.5195E+00,0.5895E+00,0.6711E+00,0.7664E+00,
	 0.8781E+00,0.1009E+01,0.1163E+01,0.1343E+01,0.1556E+01,0.1808E+01,
	 0.2107E+01,0.2464E+01,0.2891E+01,0.3405E+01,0.4025E+01,0.4779E+01,
	 0.5707E+01,0.6863E+01,0.8338E+01,0.1027E+02,0.1291E+02,0.1670E+02,
	 0.2248E+02,0.3211E+02,0.5001E+02,0.8772E+02,0.1334E+03
     },
     {
	 0.2139E+00,0.1949E+00,0.1618E+00,0.1541E+00,0.1685E+00,0.1828E+00,
	 0.1856E+00,0.1800E+00,0.1718E+00,0.1642E+00,0.1581E+00,0.1534E+00,
	 0.1495E+00,0.1460E+00,0.1421E+00,0.1375E+00,0.1318E+00,0.1252E+00,
	 0.1178E+00,0.1105E+00,0.1036E+00,0.9754E-01,0.9237E-01,0.8811E-01,
	 0.8468E-01,0.8198E-01,0.7994E-01,0.7852E-01,0.7768E-01,0.7741E-01,
	 0.7767E-01,0.7843E-01,0.7969E-01,0.8144E-01,0.8373E-01,0.8662E-01,
	 0.9014E-01,0.9438E-01,0.9939E-01,0.1052E+00,0.1120E+00,0.1158E+00,
	 0.1198E+00,0.1289E+00,0.1394E+00,0.1514E+00,0.1653E+00,0.1813E+00,
	 0.1997E+00,0.2208E+00,0.2453E+00,0.2736E+00,0.3064E+00,0.3444E+00,
	 0.3886E+00,0.4400E+00,0.5000E+00,0.5703E+00,0.6528E+00,0.7502E+00,
	 0.8652E+00,0.1001E+01,0.1163E+01,0.1355E+01,0.1584E+01,0.1859E+01,
	 0.2188E+01,0.2586E+01,0.3067E+01,0.3649E+01,0.4358E+01,0.5222E+01,
	 0.6282E+01,0.7594E+01,0.9235E+01,0.1132E+02,0.1404E+02,0.1768E+02,
	 0.2278E+02,0.3033E+02,0.4233E+02,0.6237E+02,0.7953E+02
     },
     {  
	 0.2110E+00,0.2025E+00,0.1832E+00,0.1730E+00,0.1773E+00,0.1912E+00,
	 0.2055E+00,0.2138E+00,0.2152E+00,0.2113E+00,0.2040E+00,0.1946E+00,
	 0.1842E+00,0.1734E+00,0.1627E+00,0.1524E+00,0.1429E+00,0.1344E+00,
	 0.1268E+00,0.1203E+00,0.1149E+00,0.1104E+00,0.1068E+00,0.1040E+00,
	 0.1019E+00,0.1006E+00,0.9982E-01,0.9972E-01,0.1003E+00,0.1014E+00,
	 0.1031E+00,0.1054E+00,0.1084E+00,0.1119E+00,0.1162E+00,0.1212E+00,
	 0.1271E+00,0.1338E+00,0.1415E+00,0.1503E+00,0.1603E+00,0.1658E+00,
	 0.1717E+00,0.1847E+00,0.1995E+00,0.2163E+00,0.2354E+00,0.2571E+00,
	 0.2818E+00,0.3100E+00,0.3422E+00,0.3792E+00,0.4216E+00,0.4702E+00,
	 0.5261E+00,0.5903E+00,0.6644E+00,0.7500E+00,0.8493E+00,0.9645E+00,
	 0.1098E+01,0.1254E+01,0.1436E+01,0.1649E+01,0.1897E+01,0.2189E+01,
	 0.2531E+01,0.2934E+01,0.3408E+01,0.3968E+01,0.4630E+01,0.5415E+01,
	 0.6348E+01,0.7463E+01,0.8805E+01,0.1044E+02,0.1244E+02,0.1495E+02,
	 0.1816E+02,0.2237E+02,0.2799E+02,0.3517E+02,0.3934E+02
     }},

    /* soot model */
    {{
	    0.4897E+00,0.4896E+00,0.4890E+00,0.4881E+00,0.4867E+00,0.4849E+00,
	    0.4827E+00,0.4802E+00,0.4773E+00,0.4743E+00,0.4709E+00,0.4675E+00,
	    0.4638E+00,0.4601E+00,0.4563E+00,0.4526E+00,0.4489E+00,0.4453E+00,
	    0.4419E+00,0.4388E+00,0.4359E+00,0.4334E+00,0.4312E+00,0.4296E+00,
	    0.4285E+00,0.4281E+00,0.4283E+00,0.4293E+00,0.4312E+00,0.4341E+00,
	    0.4380E+00,0.4430E+00,0.4494E+00,0.4571E+00,0.4663E+00,0.4771E+00,
	    0.4896E+00,0.5041E+00,0.5206E+00,0.5392E+00,0.5603E+00,0.5717E+00,
	    0.5838E+00,0.6101E+00,0.6392E+00,0.6714E+00,0.7069E+00,0.7459E+00,
	    0.7886E+00,0.8352E+00,0.8860E+00,0.9411E+00,0.1001E+01,0.1065E+01,
	    0.1135E+01,0.1210E+01,0.1290E+01,0.1376E+01,0.1468E+01,0.1566E+01,
	    0.1670E+01,0.1781E+01,0.1897E+01,0.2019E+01,0.2148E+01,0.2282E+01,
	    0.2421E+01,0.2565E+01,0.2713E+01,0.2865E+01,0.3019E+01,0.3173E+01,
	    0.3327E+01,0.3479E+01,0.3625E+01,0.3765E+01,0.3894E+01,0.4011E+01,
	    0.4111E+01,0.4192E+01,0.4250E+01,0.4284E+01,0.4292E+01
	},
     {
	 0.5620E+00,0.5618E+00,0.5611E+00,0.5599E+00,0.5582E+00,0.5560E+00,
	 0.5533E+00,0.5502E+00,0.5467E+00,0.5428E+00,0.5387E+00,0.5342E+00,
	 0.5295E+00,0.5246E+00,0.5197E+00,0.5146E+00,0.5096E+00,0.5046E+00,
	 0.4998E+00,0.4951E+00,0.4907E+00,0.4866E+00,0.4829E+00,0.4797E+00,
	 0.4771E+00,0.4751E+00,0.4738E+00,0.4734E+00,0.4738E+00,0.4753E+00,
	 0.4779E+00,0.4817E+00,0.4868E+00,0.4934E+00,0.5016E+00,0.5114E+00,
	 0.5231E+00,0.5367E+00,0.5524E+00,0.5704E+00,0.5908E+00,0.6019E+00,
	 0.6137E+00,0.6393E+00,0.6678E+00,0.6993E+00,0.7340E+00,0.7720E+00,
	 0.8136E+00,0.8589E+00,0.9081E+00,0.9613E+00,0.1019E+01,0.1080E+01,
	 0.1147E+01,0.1218E+01,0.1293E+01,0.1373E+01,0.1459E+01,0.1549E+01,
	 0.1643E+01,0.1743E+01,0.1847E+01,0.1956E+01,0.2069E+01,0.2185E+01,
	 0.2305E+01,0.2428E+01,0.2553E+01,0.2679E+01,0.2806E+01,0.2931E+01,
	 0.3055E+01,0.3174E+01,0.3289E+01,0.3396E+01,0.3495E+01,0.3582E+01,
	 0.3656E+01,0.3716E+01,0.3758E+01,0.3782E+01,0.3788E+01

     },
     {
	 0.5834E+00,0.5832E+00,0.5825E+00,0.5813E+00,0.5795E+00,0.5771E+00,
	 0.5743E+00,0.5710E+00,0.5673E+00,0.5632E+00,0.5587E+00,0.5540E+00,
	 0.5490E+00,0.5438E+00,0.5384E+00,0.5330E+00,0.5275E+00,0.5221E+00,
	 0.5168E+00,0.5117E+00,0.5068E+00,0.5023E+00,0.4981E+00,0.4944E+00,
	 0.4913E+00,0.4889E+00,0.4871E+00,0.4862E+00,0.4862E+00,0.4872E+00,
	 0.4894E+00,0.4928E+00,0.4975E+00,0.5037E+00,0.5115E+00,0.5210E+00,
	 0.5324E+00,0.5457E+00,0.5611E+00,0.5788E+00,0.5988E+00,0.6098E+00,
	 0.6215E+00,0.6468E+00,0.6749E+00,0.7061E+00,0.7405E+00,0.7781E+00,
	 0.8193E+00,0.8641E+00,0.9127E+00,0.9652E+00,0.1022E+01,0.1083E+01,
	 0.1148E+01,0.1217E+01,0.1291E+01,0.1370E+01,0.1453E+01,0.1541E+01,
	 0.1633E+01,0.1730E+01,0.1831E+01,0.1936E+01,0.2045E+01,0.2157E+01,
	 0.2272E+01,0.2390E+01,0.2509E+01,0.2629E+01,0.2749E+01,0.2867E+01,
	 0.2984E+01,0.3096E+01,0.3203E+01,0.3304E+01,0.3395E+01,0.3476E+01,
	 0.3545E+01,0.3599E+01,0.3638E+01,0.3660E+01,0.3666E+01
     },
     {
	 0.6060E+00,0.6059E+00,0.6051E+00,0.6038E+00,0.6019E+00,0.5994E+00,
	 0.5964E+00,0.5929E+00,0.5889E+00,0.5846E+00,0.5798E+00,0.5747E+00,
	 0.5693E+00,0.5637E+00,0.5580E+00,0.5521E+00,0.5462E+00,0.5403E+00,
	 0.5345E+00,0.5289E+00,0.5235E+00,0.5185E+00,0.5138E+00,0.5096E+00,
	 0.5059E+00,0.5029E+00,0.5007E+00,0.4993E+00,0.4988E+00,0.4993E+00,
	 0.5010E+00,0.5040E+00,0.5083E+00,0.5142E+00,0.5216E+00,0.5307E+00,
	 0.5418E+00,0.5548E+00,0.5699E+00,0.5873E+00,0.6071E+00,0.6180E+00,
	 0.6295E+00,0.6546E+00,0.6825E+00,0.7134E+00,0.7474E+00,0.7848E+00,
	 0.8255E+00,0.8699E+00,0.9179E+00,0.9698E+00,0.1026E+01,0.1085E+01,
	 0.1150E+01,0.1218E+01,0.1290E+01,0.1367E+01,0.1448E+01,0.1534E+01,
	 0.1623E+01,0.1717E+01,0.1815E+01,0.1916E+01,0.2020E+01,0.2128E+01,
	 0.2237E+01,0.2349E+01,0.2462E+01,0.2576E+01,0.2688E+01,0.2800E+01,
	 0.2909E+01,0.3013E+01,0.3113E+01,0.3206E+01,0.3290E+01,0.3364E+01,
	 0.3427E+01,0.3477E+01,0.3512E+01,0.3532E+01,0.3537E+01
     },
     {
	 0.6604E+00,0.6602E+00,0.6593E+00,0.6578E+00,0.6556E+00,0.6528E+00,
	 0.6494E+00,0.6454E+00,0.6409E+00,0.6358E+00,0.6304E+00,0.6245E+00,
	 0.6182E+00,0.6117E+00,0.6050E+00,0.5981E+00,0.5911E+00,0.5841E+00,
	 0.5771E+00,0.5703E+00,0.5636E+00,0.5573E+00,0.5513E+00,0.5458E+00,
	 0.5409E+00,0.5366E+00,0.5331E+00,0.5305E+00,0.5288E+00,0.5281E+00,
	 0.5287E+00,0.5305E+00,0.5338E+00,0.5385E+00,0.5450E+00,0.5532E+00,
	 0.5633E+00,0.5754E+00,0.5897E+00,0.6062E+00,0.6252E+00,0.6356E+00,
	 0.6467E+00,0.6710E+00,0.6980E+00,0.7280E+00,0.7610E+00,0.7972E+00,
	 0.8367E+00,0.8797E+00,0.9261E+00,0.9762E+00,0.1030E+01,0.1087E+01,
	 0.1149E+01,0.1214E+01,0.1283E+01,0.1355E+01,0.1432E+01,0.1512E+01,
	 0.1595E+01,0.1682E+01,0.1772E+01,0.1865E+01,0.1961E+01,0.2058E+01,
	 0.2157E+01,0.2257E+01,0.2358E+01,0.2458E+01,0.2557E+01,0.2654E+01,
	 0.2748E+01,0.2838E+01,0.2923E+01,0.3001E+01,0.3072E+01,0.3134E+01,
	 0.3187E+01,0.3228E+01,0.3257E+01,0.3273E+01,0.3277E+01
     },
     {
	 0.6993E+00,0.6991E+00,0.6982E+00,0.6965E+00,0.6942E+00,0.6911E+00,
	 0.6874E+00,0.6830E+00,0.6781E+00,0.6726E+00,0.6666E+00,0.6601E+00,
	 0.6533E+00,0.6461E+00,0.6387E+00,0.6310E+00,0.6232E+00,0.6154E+00,
	 0.6076E+00,0.5998E+00,0.5923E+00,0.5851E+00,0.5782E+00,0.5717E+00,
	 0.5659E+00,0.5607E+00,0.5562E+00,0.5526E+00,0.5500E+00,0.5485E+00,
	 0.5482E+00,0.5491E+00,0.5515E+00,0.5555E+00,0.5611E+00,0.5686E+00,
	 0.5779E+00,0.5893E+00,0.6028E+00,0.6187E+00,0.6369E+00,0.6470E+00,
	 0.6577E+00,0.6812E+00,0.7074E+00,0.7366E+00,0.7687E+00,0.8040E+00,
	 0.8425E+00,0.8843E+00,0.9295E+00,0.9781E+00,0.1030E+01,0.1086E+01,
	 0.1145E+01,0.1208E+01,0.1274E+01,0.1344E+01,0.1417E+01,0.1494E+01,
	 0.1573E+01,0.1656E+01,0.1741E+01,0.1828E+01,0.1918E+01,0.2009E+01,
	 0.2101E+01,0.2194E+01,0.2287E+01,0.2380E+01,0.2470E+01,0.2559E+01,
	 0.2645E+01,0.2726E+01,0.2803E+01,0.2873E+01,0.2937E+01,0.2992E+01,
	 0.3038E+01,0.3075E+01,0.3100E+01,0.3115E+01,0.3118E+01
     },
     {
	 0.7916E+00,0.7914E+00,0.7903E+00,0.7883E+00,0.7855E+00,0.7818E+00,
	 0.7773E+00,0.7721E+00,0.7662E+00,0.7595E+00,0.7522E+00,0.7444E+00,
	 0.7360E+00,0.7272E+00,0.7180E+00,0.7085E+00,0.6988E+00,0.6889E+00,
	 0.6790E+00,0.6692E+00,0.6595E+00,0.6500E+00,0.6408E+00,0.6321E+00,
	 0.6239E+00,0.6164E+00,0.6097E+00,0.6038E+00,0.5989E+00,0.5952E+00,
	 0.5926E+00,0.5915E+00,0.5918E+00,0.5936E+00,0.5972E+00,0.6027E+00,
	 0.6101E+00,0.6195E+00,0.6311E+00,0.6451E+00,0.6614E+00,0.6705E+00,
	 0.6803E+00,0.7017E+00,0.7259E+00,0.7529E+00,0.7828E+00,0.8156E+00,
	 0.8514E+00,0.8903E+00,0.9323E+00,0.9774E+00,0.1026E+01,0.1077E+01,
	 0.1131E+01,0.1189E+01,0.1249E+01,0.1312E+01,0.1378E+01,0.1447E+01,
	 0.1518E+01,0.1590E+01,0.1665E+01,0.1741E+01,0.1819E+01,0.1897E+01,
	 0.1976E+01,0.2054E+01,0.2132E+01,0.2209E+01,0.2284E+01,0.2356E+01,
	 0.2426E+01,0.2491E+01,0.2552E+01,0.2607E+01,0.2657E+01,0.2700E+01,
	 0.2736E+01,0.2764E+01,0.2783E+01,0.2795E+01,0.2797E+01
     },
     {
	 0.1041E+01,0.1040E+01,0.1038E+01,0.1036E+01,0.1031E+01,0.1026E+01,
	 0.1019E+01,0.1011E+01,0.1002E+01,0.9924E+00,0.9814E+00,0.9694E+00,
	 0.9566E+00,0.9431E+00,0.9288E+00,0.9140E+00,0.8988E+00,0.8832E+00,
	 0.8673E+00,0.8513E+00,0.8353E+00,0.8194E+00,0.8038E+00,0.7885E+00,
	 0.7737E+00,0.7596E+00,0.7462E+00,0.7338E+00,0.7223E+00,0.7121E+00,
	 0.7031E+00,0.6955E+00,0.6895E+00,0.6852E+00,0.6827E+00,0.6820E+00,
	 0.6833E+00,0.6868E+00,0.6924E+00,0.7003E+00,0.7105E+00,0.7165E+00,
	 0.7232E+00,0.7383E+00,0.7559E+00,0.7760E+00,0.7987E+00,0.8240E+00,
	 0.8518E+00,0.8821E+00,0.9149E+00,0.9501E+00,0.9877E+00,0.1028E+01,
	 0.1069E+01,0.1113E+01,0.1159E+01,0.1207E+01,0.1256E+01,0.1306E+01,
	 0.1358E+01,0.1410E+01,0.1463E+01,0.1517E+01,0.1570E+01,0.1623E+01,
	 0.1676E+01,0.1727E+01,0.1778E+01,0.1827E+01,0.1873E+01,0.1918E+01,
	 0.1960E+01,0.1999E+01,0.2035E+01,0.2067E+01,0.2096E+01,0.2120E+01,
	 0.2140E+01,0.2156E+01,0.2167E+01,0.2173E+01,0.2174E+01
     },
     {
	 0.1182E+01,0.1181E+01,0.1179E+01,0.1176E+01,0.1171E+01,0.1164E+01,
	 0.1156E+01,0.1147E+01,0.1136E+01,0.1124E+01,0.1110E+01,0.1096E+01,
	 0.1080E+01,0.1064E+01,0.1046E+01,0.1028E+01,0.1009E+01,0.9903E+00,
	 0.9708E+00,0.9510E+00,0.9312E+00,0.9114E+00,0.8919E+00,0.8726E+00,
	 0.8539E+00,0.8357E+00,0.8184E+00,0.8019E+00,0.7866E+00,0.7724E+00,
	 0.7595E+00,0.7481E+00,0.7383E+00,0.7302E+00,0.7239E+00,0.7195E+00,
	 0.7171E+00,0.7168E+00,0.7188E+00,0.7229E+00,0.7294E+00,0.7335E+00,
	 0.7382E+00,0.7494E+00,0.7630E+00,0.7790E+00,0.7974E+00,0.8182E+00,
	 0.8414E+00,0.8668E+00,0.8944E+00,0.9242E+00,0.9561E+00,0.9898E+00,
	 0.1025E+01,0.1063E+01,0.1101E+01,0.1141E+01,0.1183E+01,0.1225E+01,
	 0.1268E+01,0.1311E+01,0.1355E+01,0.1399E+01,0.1442E+01,0.1485E+01,
	 0.1528E+01,0.1569E+01,0.1609E+01,0.1648E+01,0.1685E+01,0.1720E+01,
	 0.1753E+01,0.1783E+01,0.1811E+01,0.1836E+01,0.1858E+01,0.1876E+01,
	 0.1891E+01,0.1903E+01,0.1911E+01,0.1916E+01,0.1917E+01
     },
     {
	 0.1325E+01,0.1324E+01,0.1322E+01,0.1318E+01,0.1312E+01,0.1304E+01,
	 0.1294E+01,0.1283E+01,0.1270E+01,0.1256E+01,0.1240E+01,0.1222E+01,
	 0.1204E+01,0.1184E+01,0.1163E+01,0.1142E+01,0.1119E+01,0.1096E+01,
	 0.1073E+01,0.1049E+01,0.1025E+01,0.1001E+01,0.9776E+00,0.9541E+00,
	 0.9312E+00,0.9088E+00,0.8872E+00,0.8666E+00,0.8471E+00,0.8287E+00,
	 0.8118E+00,0.7963E+00,0.7825E+00,0.7704E+00,0.7602E+00,0.7519E+00,
	 0.7457E+00,0.7415E+00,0.7396E+00,0.7399E+00,0.7424E+00,0.7446E+00,
	 0.7473E+00,0.7545E+00,0.7640E+00,0.7758E+00,0.7899E+00,0.8063E+00,
	 0.8248E+00,0.8455E+00,0.8681E+00,0.8928E+00,0.9192E+00,0.9473E+00,
	 0.9771E+00,0.1008E+01,0.1041E+01,0.1074E+01,0.1109E+01,0.1144E+01,
	 0.1179E+01,0.1215E+01,0.1252E+01,0.1288E+01,0.1324E+01,0.1359E+01,
	 0.1393E+01,0.1427E+01,0.1460E+01,0.1491E+01,0.1521E+01,0.1549E+01,
	 0.1575E+01,0.1599E+01,0.1622E+01,0.1641E+01,0.1658E+01,0.1673E+01,
	 0.1685E+01,0.1694E+01,0.1701E+01,0.1704E+01,0.1705E+01
     }},

    /* user defined model */
    {{0},{0},{0},{0},{0},{0},{0},{0}},	

    /* pointer to current active model */
    0		
};

