// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/securitycenter/v1p1beta1/securitycenter_service.proto

package securitycenter

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The change in state of the asset.
//
// When querying across two points in time this describes
// the change between the two points: ADDED, REMOVED, or ACTIVE.
// If there was no compare_duration supplied in the request the state change
// will be: UNUSED
type ListAssetsResponse_ListAssetsResult_StateChange int32

const (
	// State change is unused, this is the canonical default for this enum.
	ListAssetsResponse_ListAssetsResult_UNUSED ListAssetsResponse_ListAssetsResult_StateChange = 0
	// Asset was added between the points in time.
	ListAssetsResponse_ListAssetsResult_ADDED ListAssetsResponse_ListAssetsResult_StateChange = 1
	// Asset was removed between the points in time.
	ListAssetsResponse_ListAssetsResult_REMOVED ListAssetsResponse_ListAssetsResult_StateChange = 2
	// Asset was present at both point(s) in time.
	ListAssetsResponse_ListAssetsResult_ACTIVE ListAssetsResponse_ListAssetsResult_StateChange = 3
)

var ListAssetsResponse_ListAssetsResult_StateChange_name = map[int32]string{
	0: "UNUSED",
	1: "ADDED",
	2: "REMOVED",
	3: "ACTIVE",
}

var ListAssetsResponse_ListAssetsResult_StateChange_value = map[string]int32{
	"UNUSED":  0,
	"ADDED":   1,
	"REMOVED": 2,
	"ACTIVE":  3,
}

func (x ListAssetsResponse_ListAssetsResult_StateChange) String() string {
	return proto.EnumName(ListAssetsResponse_ListAssetsResult_StateChange_name, int32(x))
}

func (ListAssetsResponse_ListAssetsResult_StateChange) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{17, 0, 0}
}

// The change in state of the finding.
//
// When querying across two points in time this describes
// the change in the finding between the two points: CHANGED, UNCHANGED,
// ADDED, or REMOVED. Findings can not be deleted, so REMOVED implies that
// the finding at timestamp does not match the filter specified, but it did
// at timestamp - compare_duration. If there was no compare_duration
// supplied in the request the state change will be: UNUSED
type ListFindingsResponse_ListFindingsResult_StateChange int32

const (
	// State change is unused, this is the canonical default for this enum.
	ListFindingsResponse_ListFindingsResult_UNUSED ListFindingsResponse_ListFindingsResult_StateChange = 0
	// The finding has changed state in some way between the points in time
	// and existed at both points.
	ListFindingsResponse_ListFindingsResult_CHANGED ListFindingsResponse_ListFindingsResult_StateChange = 1
	// The finding has not changed state between the points in time and
	// existed at both points.
	ListFindingsResponse_ListFindingsResult_UNCHANGED ListFindingsResponse_ListFindingsResult_StateChange = 2
	// The finding was created between the points in time.
	ListFindingsResponse_ListFindingsResult_ADDED ListFindingsResponse_ListFindingsResult_StateChange = 3
	// The finding at timestamp does not match the filter specified, but it
	// did at timestamp - compare_duration.
	ListFindingsResponse_ListFindingsResult_REMOVED ListFindingsResponse_ListFindingsResult_StateChange = 4
)

var ListFindingsResponse_ListFindingsResult_StateChange_name = map[int32]string{
	0: "UNUSED",
	1: "CHANGED",
	2: "UNCHANGED",
	3: "ADDED",
	4: "REMOVED",
}

var ListFindingsResponse_ListFindingsResult_StateChange_value = map[string]int32{
	"UNUSED":    0,
	"CHANGED":   1,
	"UNCHANGED": 2,
	"ADDED":     3,
	"REMOVED":   4,
}

func (x ListFindingsResponse_ListFindingsResult_StateChange) String() string {
	return proto.EnumName(ListFindingsResponse_ListFindingsResult_StateChange_name, int32(x))
}

func (ListFindingsResponse_ListFindingsResult_StateChange) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{19, 0, 0}
}

// Request message for creating a finding.
type CreateFindingRequest struct {
	// Required. Resource name of the new finding's parent. Its format should be
	// "organizations/[organization_id]/sources/[source_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Unique identifier provided by the client within the parent scope.
	// It must be alphanumeric and less than or equal to 32 characters and
	// greater than 0 characters in length.
	FindingId string `protobuf:"bytes,2,opt,name=finding_id,json=findingId,proto3" json:"finding_id,omitempty"`
	// Required. The Finding being created. The name and security_marks will be
	// ignored as they are both output only fields on this resource.
	Finding              *Finding `protobuf:"bytes,3,opt,name=finding,proto3" json:"finding,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFindingRequest) Reset()         { *m = CreateFindingRequest{} }
func (m *CreateFindingRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFindingRequest) ProtoMessage()    {}
func (*CreateFindingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{0}
}

func (m *CreateFindingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFindingRequest.Unmarshal(m, b)
}
func (m *CreateFindingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFindingRequest.Marshal(b, m, deterministic)
}
func (m *CreateFindingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFindingRequest.Merge(m, src)
}
func (m *CreateFindingRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFindingRequest.Size(m)
}
func (m *CreateFindingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFindingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFindingRequest proto.InternalMessageInfo

func (m *CreateFindingRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateFindingRequest) GetFindingId() string {
	if m != nil {
		return m.FindingId
	}
	return ""
}

func (m *CreateFindingRequest) GetFinding() *Finding {
	if m != nil {
		return m.Finding
	}
	return nil
}

// Request message for creating a notification config.
type CreateNotificationConfigRequest struct {
	// Resource name of the new notification config's parent. Its format is
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Unique identifier provided by the client within the parent scope.
	// It must be between 1 and 128 characters, and contains alphanumeric
	// characters, underscores or hyphens only.
	ConfigId string `protobuf:"bytes,2,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// The notification config being created. The name and the service account
	// will be ignored as they are both output only fields on this resource.
	NotificationConfig   *NotificationConfig `protobuf:"bytes,3,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CreateNotificationConfigRequest) Reset()         { *m = CreateNotificationConfigRequest{} }
func (m *CreateNotificationConfigRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNotificationConfigRequest) ProtoMessage()    {}
func (*CreateNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{1}
}

func (m *CreateNotificationConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNotificationConfigRequest.Unmarshal(m, b)
}
func (m *CreateNotificationConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNotificationConfigRequest.Marshal(b, m, deterministic)
}
func (m *CreateNotificationConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNotificationConfigRequest.Merge(m, src)
}
func (m *CreateNotificationConfigRequest) XXX_Size() int {
	return xxx_messageInfo_CreateNotificationConfigRequest.Size(m)
}
func (m *CreateNotificationConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNotificationConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNotificationConfigRequest proto.InternalMessageInfo

func (m *CreateNotificationConfigRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateNotificationConfigRequest) GetConfigId() string {
	if m != nil {
		return m.ConfigId
	}
	return ""
}

func (m *CreateNotificationConfigRequest) GetNotificationConfig() *NotificationConfig {
	if m != nil {
		return m.NotificationConfig
	}
	return nil
}

// Request message for creating a source.
type CreateSourceRequest struct {
	// Required. Resource name of the new source's parent. Its format should be
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Source being created, only the display_name and description
	// will be used. All other fields will be ignored.
	Source               *Source  `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSourceRequest) Reset()         { *m = CreateSourceRequest{} }
func (m *CreateSourceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSourceRequest) ProtoMessage()    {}
func (*CreateSourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{2}
}

func (m *CreateSourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSourceRequest.Unmarshal(m, b)
}
func (m *CreateSourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSourceRequest.Marshal(b, m, deterministic)
}
func (m *CreateSourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSourceRequest.Merge(m, src)
}
func (m *CreateSourceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSourceRequest.Size(m)
}
func (m *CreateSourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSourceRequest proto.InternalMessageInfo

func (m *CreateSourceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSourceRequest) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

// Request message for deleting a notification config.
type DeleteNotificationConfigRequest struct {
	// Name of the notification config to delete. Its format is
	// "organizations/[organization_id]/notificationConfigs/[config_id]".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNotificationConfigRequest) Reset()         { *m = DeleteNotificationConfigRequest{} }
func (m *DeleteNotificationConfigRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNotificationConfigRequest) ProtoMessage()    {}
func (*DeleteNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{3}
}

func (m *DeleteNotificationConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNotificationConfigRequest.Unmarshal(m, b)
}
func (m *DeleteNotificationConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNotificationConfigRequest.Marshal(b, m, deterministic)
}
func (m *DeleteNotificationConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNotificationConfigRequest.Merge(m, src)
}
func (m *DeleteNotificationConfigRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNotificationConfigRequest.Size(m)
}
func (m *DeleteNotificationConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNotificationConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNotificationConfigRequest proto.InternalMessageInfo

func (m *DeleteNotificationConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for getting a notification config.
type GetNotificationConfigRequest struct {
	// Name of the notification config to get. Its format is
	// "organizations/[organization_id]/notificationConfigs/[config_id]".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNotificationConfigRequest) Reset()         { *m = GetNotificationConfigRequest{} }
func (m *GetNotificationConfigRequest) String() string { return proto.CompactTextString(m) }
func (*GetNotificationConfigRequest) ProtoMessage()    {}
func (*GetNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{4}
}

func (m *GetNotificationConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNotificationConfigRequest.Unmarshal(m, b)
}
func (m *GetNotificationConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNotificationConfigRequest.Marshal(b, m, deterministic)
}
func (m *GetNotificationConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNotificationConfigRequest.Merge(m, src)
}
func (m *GetNotificationConfigRequest) XXX_Size() int {
	return xxx_messageInfo_GetNotificationConfigRequest.Size(m)
}
func (m *GetNotificationConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNotificationConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNotificationConfigRequest proto.InternalMessageInfo

func (m *GetNotificationConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for getting organization settings.
type GetOrganizationSettingsRequest struct {
	// Required. Name of the organization to get organization settings for. Its
	// format is "organizations/[organization_id]/organizationSettings".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOrganizationSettingsRequest) Reset()         { *m = GetOrganizationSettingsRequest{} }
func (m *GetOrganizationSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*GetOrganizationSettingsRequest) ProtoMessage()    {}
func (*GetOrganizationSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{5}
}

func (m *GetOrganizationSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOrganizationSettingsRequest.Unmarshal(m, b)
}
func (m *GetOrganizationSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOrganizationSettingsRequest.Marshal(b, m, deterministic)
}
func (m *GetOrganizationSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOrganizationSettingsRequest.Merge(m, src)
}
func (m *GetOrganizationSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_GetOrganizationSettingsRequest.Size(m)
}
func (m *GetOrganizationSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOrganizationSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOrganizationSettingsRequest proto.InternalMessageInfo

func (m *GetOrganizationSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for getting a source.
type GetSourceRequest struct {
	// Required. Relative resource name of the source. Its format is
	// "organizations/[organization_id]/source/[source_id]".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSourceRequest) Reset()         { *m = GetSourceRequest{} }
func (m *GetSourceRequest) String() string { return proto.CompactTextString(m) }
func (*GetSourceRequest) ProtoMessage()    {}
func (*GetSourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{6}
}

func (m *GetSourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSourceRequest.Unmarshal(m, b)
}
func (m *GetSourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSourceRequest.Marshal(b, m, deterministic)
}
func (m *GetSourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSourceRequest.Merge(m, src)
}
func (m *GetSourceRequest) XXX_Size() int {
	return xxx_messageInfo_GetSourceRequest.Size(m)
}
func (m *GetSourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSourceRequest proto.InternalMessageInfo

func (m *GetSourceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for grouping by assets.
type GroupAssetsRequest struct {
	// Required. Name of the organization to groupBy. Its format is
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across assets.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. The fields map to those
	// defined in the Asset resource. Examples include:
	//
	// * name
	// * security_center_properties.resource_name
	// * resource_properties.a_property
	// * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * update_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     "update_time = \"2019-06-10T16:07:18-07:00\""
	//     "update_time = 1560208038000"
	//
	// * create_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     "create_time = \"2019-06-10T16:07:18-07:00\""
	//     "create_time = 1560208038000"
	//
	// * iam_policy.policy_blob: `=`, `:`
	// * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	// * security_marks.marks: `=`, `:`
	// * security_center_properties.resource_name: `=`, `:`
	// * security_center_properties.resource_name_display_name: `=`, `:`
	// * security_center_properties.resource_type: `=`, `:`
	// * security_center_properties.resource_parent: `=`, `:`
	// * security_center_properties.resource_parent_display_name: `=`, `:`
	// * security_center_properties.resource_project: `=`, `:`
	// * security_center_properties.resource_project_display_name: `=`, `:`
	// * security_center_properties.resource_owners: `=`, `:`
	//
	// For example, `resource_properties.size = 100` is a valid filter string.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Expression that defines what assets fields to use for grouping.
	// The string value should follow SQL syntax: comma separated list of fields.
	// For example:
	// "security_center_properties.resource_project,security_center_properties.project".
	//
	// The following fields are supported when compare_duration is not set:
	//
	// * security_center_properties.resource_project
	// * security_center_properties.resource_project_display_name
	// * security_center_properties.resource_type
	// * security_center_properties.resource_parent
	// * security_center_properties.resource_parent_display_name
	//
	// The following fields are supported when compare_duration is set:
	//
	// * security_center_properties.resource_type
	// * security_center_properties.resource_project_display_name
	// * security_center_properties.resource_parent_display_name
	GroupBy string `protobuf:"bytes,3,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// When compare_duration is set, the GroupResult's "state_change" property is
	// updated to indicate whether the asset was added, removed, or remained
	// present during the compare_duration period of time that precedes the
	// read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state change value is derived based on the presence of the asset at the
	// two points in time. Intermediate state changes between the two times don't
	// affect the result. For example, the results aren't affected if the asset is
	// removed and re-created again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "ADDED":   indicates that the asset was not present at the start of
	//                compare_duration, but present at reference_time.
	// * "REMOVED": indicates that the asset was present at the start of
	//                compare_duration, but not present at reference_time.
	// * "ACTIVE":  indicates that the asset was present at both the
	//                start and the end of the time period defined by
	//                compare_duration and reference_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED", which will be the state_change set for all assets present at
	// read_time.
	//
	// If this field is set then `state_change` must be a specified field in
	// `group_by`.
	CompareDuration *duration.Duration `protobuf:"bytes,4,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// Time used as a reference point when filtering assets. The filter is limited
	// to assets existing at the supplied time and their values are those at that
	// specific time. Absence of this field will default to the API's version of
	// NOW.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Filter that specifies what fields to further filter on *after* the query
	// filter has been executed. Currently only `state_change` is supported and
	// requires compare_duration to be specified.
	Having string `protobuf:"bytes,6,opt,name=having,proto3" json:"having,omitempty"`
	// The value returned by the last `GroupAssetsResponse`; indicates
	// that this is a continuation of a prior `GroupAssets` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupAssetsRequest) Reset()         { *m = GroupAssetsRequest{} }
func (m *GroupAssetsRequest) String() string { return proto.CompactTextString(m) }
func (*GroupAssetsRequest) ProtoMessage()    {}
func (*GroupAssetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{7}
}

func (m *GroupAssetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupAssetsRequest.Unmarshal(m, b)
}
func (m *GroupAssetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupAssetsRequest.Marshal(b, m, deterministic)
}
func (m *GroupAssetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupAssetsRequest.Merge(m, src)
}
func (m *GroupAssetsRequest) XXX_Size() int {
	return xxx_messageInfo_GroupAssetsRequest.Size(m)
}
func (m *GroupAssetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupAssetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GroupAssetsRequest proto.InternalMessageInfo

func (m *GroupAssetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GroupAssetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *GroupAssetsRequest) GetGroupBy() string {
	if m != nil {
		return m.GroupBy
	}
	return ""
}

func (m *GroupAssetsRequest) GetCompareDuration() *duration.Duration {
	if m != nil {
		return m.CompareDuration
	}
	return nil
}

func (m *GroupAssetsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *GroupAssetsRequest) GetHaving() string {
	if m != nil {
		return m.Having
	}
	return ""
}

func (m *GroupAssetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *GroupAssetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for grouping by assets.
type GroupAssetsResponse struct {
	// Group results. There exists an element for each existing unique
	// combination of property/values. The element contains a count for the number
	// of times those specific property/values appear.
	GroupByResults []*GroupResult `protobuf:"bytes,1,rep,name=group_by_results,json=groupByResults,proto3" json:"group_by_results,omitempty"`
	// Time used for executing the groupBy request.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of results matching the query.
	TotalSize            int32    `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupAssetsResponse) Reset()         { *m = GroupAssetsResponse{} }
func (m *GroupAssetsResponse) String() string { return proto.CompactTextString(m) }
func (*GroupAssetsResponse) ProtoMessage()    {}
func (*GroupAssetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{8}
}

func (m *GroupAssetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupAssetsResponse.Unmarshal(m, b)
}
func (m *GroupAssetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupAssetsResponse.Marshal(b, m, deterministic)
}
func (m *GroupAssetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupAssetsResponse.Merge(m, src)
}
func (m *GroupAssetsResponse) XXX_Size() int {
	return xxx_messageInfo_GroupAssetsResponse.Size(m)
}
func (m *GroupAssetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupAssetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GroupAssetsResponse proto.InternalMessageInfo

func (m *GroupAssetsResponse) GetGroupByResults() []*GroupResult {
	if m != nil {
		return m.GroupByResults
	}
	return nil
}

func (m *GroupAssetsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *GroupAssetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *GroupAssetsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for grouping by findings.
type GroupFindingsRequest struct {
	// Required. Name of the source to groupBy. Its format is
	// "organizations/[organization_id]/sources/[source_id]". To groupBy across
	// all sources provide a source_id of `-`. For example:
	// organizations/{organization_id}/sources/-
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//  * name
	//  * source_properties.a_property
	//  * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * parent: `=`, `:`
	// * resource_name: `=`, `:`
	// * state: `=`, `:`
	// * category: `=`, `:`
	// * external_uri: `=`, `:`
	// * event_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     "event_time = \"2019-06-10T16:07:18-07:00\""
	//     "event_time = 1560208038000"
	//
	// * security_marks.marks: `=`, `:`
	// * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	//
	// For example, `source_properties.size = 100` is a valid filter string.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Expression that defines what assets fields to use for grouping
	// (including `state_change`). The string value should follow SQL syntax:
	// comma separated list of fields. For example: "parent,resource_name".
	//
	// The following fields are supported:
	//
	// * resource_name
	// * category
	// * state
	// * parent
	//
	// The following fields are supported when compare_duration is set:
	//
	// * state_change
	GroupBy string `protobuf:"bytes,3,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// Time used as a reference point when filtering findings. The filter is
	// limited to findings existing at the supplied time and their values are
	// those at that specific time. Absence of this field will default to the
	// API's version of NOW.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the GroupResult's "state_change" attribute is
	// updated to indicate whether the finding had its state changed, the
	// finding's state remained unchanged, or if the finding was added during the
	// compare_duration period of time that precedes the read_time. This is the
	// time between (read_time - compare_duration) and read_time.
	//
	// The state_change value is derived based on the presence and state of the
	// finding at the two points in time. Intermediate state changes between the
	// two times don't affect the result. For example, the results aren't affected
	// if the finding is made inactive and then active again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "CHANGED":   indicates that the finding was present at the start of
	//                  compare_duration, but changed its state at read_time.
	// * "UNCHANGED": indicates that the finding was present at the start of
	//                  compare_duration and did not change state at read_time.
	// * "ADDED":     indicates that the finding was not present at the start
	//                  of compare_duration, but was present at read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED",  which will be the state_change set for all findings present
	// at read_time.
	//
	// If this field is set then `state_change` must be a specified field in
	// `group_by`.
	CompareDuration *duration.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// Filter that specifies what fields to further filter on *after* the query
	// filter has been executed. Currently only `finding.state` and `state_change`
	// are supported and requires compare_duration to be specified.
	Having string `protobuf:"bytes,6,opt,name=having,proto3" json:"having,omitempty"`
	// The value returned by the last `GroupFindingsResponse`; indicates
	// that this is a continuation of a prior `GroupFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupFindingsRequest) Reset()         { *m = GroupFindingsRequest{} }
func (m *GroupFindingsRequest) String() string { return proto.CompactTextString(m) }
func (*GroupFindingsRequest) ProtoMessage()    {}
func (*GroupFindingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{9}
}

func (m *GroupFindingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupFindingsRequest.Unmarshal(m, b)
}
func (m *GroupFindingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupFindingsRequest.Marshal(b, m, deterministic)
}
func (m *GroupFindingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupFindingsRequest.Merge(m, src)
}
func (m *GroupFindingsRequest) XXX_Size() int {
	return xxx_messageInfo_GroupFindingsRequest.Size(m)
}
func (m *GroupFindingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupFindingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GroupFindingsRequest proto.InternalMessageInfo

func (m *GroupFindingsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GroupFindingsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *GroupFindingsRequest) GetGroupBy() string {
	if m != nil {
		return m.GroupBy
	}
	return ""
}

func (m *GroupFindingsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *GroupFindingsRequest) GetCompareDuration() *duration.Duration {
	if m != nil {
		return m.CompareDuration
	}
	return nil
}

func (m *GroupFindingsRequest) GetHaving() string {
	if m != nil {
		return m.Having
	}
	return ""
}

func (m *GroupFindingsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *GroupFindingsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for group by findings.
type GroupFindingsResponse struct {
	// Group results. There exists an element for each existing unique
	// combination of property/values. The element contains a count for the number
	// of times those specific property/values appear.
	GroupByResults []*GroupResult `protobuf:"bytes,1,rep,name=group_by_results,json=groupByResults,proto3" json:"group_by_results,omitempty"`
	// Time used for executing the groupBy request.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of results matching the query.
	TotalSize            int32    `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupFindingsResponse) Reset()         { *m = GroupFindingsResponse{} }
func (m *GroupFindingsResponse) String() string { return proto.CompactTextString(m) }
func (*GroupFindingsResponse) ProtoMessage()    {}
func (*GroupFindingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{10}
}

func (m *GroupFindingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupFindingsResponse.Unmarshal(m, b)
}
func (m *GroupFindingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupFindingsResponse.Marshal(b, m, deterministic)
}
func (m *GroupFindingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupFindingsResponse.Merge(m, src)
}
func (m *GroupFindingsResponse) XXX_Size() int {
	return xxx_messageInfo_GroupFindingsResponse.Size(m)
}
func (m *GroupFindingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupFindingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GroupFindingsResponse proto.InternalMessageInfo

func (m *GroupFindingsResponse) GetGroupByResults() []*GroupResult {
	if m != nil {
		return m.GroupByResults
	}
	return nil
}

func (m *GroupFindingsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *GroupFindingsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *GroupFindingsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Result containing the properties and count of a groupBy request.
type GroupResult struct {
	// Properties matching the groupBy fields in the request.
	Properties map[string]*_struct.Value `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Total count of resources for the given properties.
	Count                int64    `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupResult) Reset()         { *m = GroupResult{} }
func (m *GroupResult) String() string { return proto.CompactTextString(m) }
func (*GroupResult) ProtoMessage()    {}
func (*GroupResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{11}
}

func (m *GroupResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupResult.Unmarshal(m, b)
}
func (m *GroupResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupResult.Marshal(b, m, deterministic)
}
func (m *GroupResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupResult.Merge(m, src)
}
func (m *GroupResult) XXX_Size() int {
	return xxx_messageInfo_GroupResult.Size(m)
}
func (m *GroupResult) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupResult.DiscardUnknown(m)
}

var xxx_messageInfo_GroupResult proto.InternalMessageInfo

func (m *GroupResult) GetProperties() map[string]*_struct.Value {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *GroupResult) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// Request message for listing notification configs.
type ListNotificationConfigsRequest struct {
	// Name of the organization to list notification configs.
	// Its format is "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The value returned by the last `ListNotificationConfigsResponse`; indicates
	// that this is a continuation of a prior `ListNotificationConfigs` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNotificationConfigsRequest) Reset()         { *m = ListNotificationConfigsRequest{} }
func (m *ListNotificationConfigsRequest) String() string { return proto.CompactTextString(m) }
func (*ListNotificationConfigsRequest) ProtoMessage()    {}
func (*ListNotificationConfigsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{12}
}

func (m *ListNotificationConfigsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNotificationConfigsRequest.Unmarshal(m, b)
}
func (m *ListNotificationConfigsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNotificationConfigsRequest.Marshal(b, m, deterministic)
}
func (m *ListNotificationConfigsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNotificationConfigsRequest.Merge(m, src)
}
func (m *ListNotificationConfigsRequest) XXX_Size() int {
	return xxx_messageInfo_ListNotificationConfigsRequest.Size(m)
}
func (m *ListNotificationConfigsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNotificationConfigsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNotificationConfigsRequest proto.InternalMessageInfo

func (m *ListNotificationConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListNotificationConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListNotificationConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for listing notification configs.
type ListNotificationConfigsResponse struct {
	// Notification configs belonging to the requested parent.
	NotificationConfigs []*NotificationConfig `protobuf:"bytes,1,rep,name=notification_configs,json=notificationConfigs,proto3" json:"notification_configs,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNotificationConfigsResponse) Reset()         { *m = ListNotificationConfigsResponse{} }
func (m *ListNotificationConfigsResponse) String() string { return proto.CompactTextString(m) }
func (*ListNotificationConfigsResponse) ProtoMessage()    {}
func (*ListNotificationConfigsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{13}
}

func (m *ListNotificationConfigsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNotificationConfigsResponse.Unmarshal(m, b)
}
func (m *ListNotificationConfigsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNotificationConfigsResponse.Marshal(b, m, deterministic)
}
func (m *ListNotificationConfigsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNotificationConfigsResponse.Merge(m, src)
}
func (m *ListNotificationConfigsResponse) XXX_Size() int {
	return xxx_messageInfo_ListNotificationConfigsResponse.Size(m)
}
func (m *ListNotificationConfigsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNotificationConfigsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNotificationConfigsResponse proto.InternalMessageInfo

func (m *ListNotificationConfigsResponse) GetNotificationConfigs() []*NotificationConfig {
	if m != nil {
		return m.NotificationConfigs
	}
	return nil
}

func (m *ListNotificationConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for listing sources.
type ListSourcesRequest struct {
	// Required. Resource name of the parent of sources to list. Its format should
	// be "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The value returned by the last `ListSourcesResponse`; indicates
	// that this is a continuation of a prior `ListSources` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSourcesRequest) Reset()         { *m = ListSourcesRequest{} }
func (m *ListSourcesRequest) String() string { return proto.CompactTextString(m) }
func (*ListSourcesRequest) ProtoMessage()    {}
func (*ListSourcesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{14}
}

func (m *ListSourcesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSourcesRequest.Unmarshal(m, b)
}
func (m *ListSourcesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSourcesRequest.Marshal(b, m, deterministic)
}
func (m *ListSourcesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSourcesRequest.Merge(m, src)
}
func (m *ListSourcesRequest) XXX_Size() int {
	return xxx_messageInfo_ListSourcesRequest.Size(m)
}
func (m *ListSourcesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSourcesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSourcesRequest proto.InternalMessageInfo

func (m *ListSourcesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSourcesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListSourcesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for listing sources.
type ListSourcesResponse struct {
	// Sources belonging to the requested parent.
	Sources []*Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSourcesResponse) Reset()         { *m = ListSourcesResponse{} }
func (m *ListSourcesResponse) String() string { return proto.CompactTextString(m) }
func (*ListSourcesResponse) ProtoMessage()    {}
func (*ListSourcesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{15}
}

func (m *ListSourcesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSourcesResponse.Unmarshal(m, b)
}
func (m *ListSourcesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSourcesResponse.Marshal(b, m, deterministic)
}
func (m *ListSourcesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSourcesResponse.Merge(m, src)
}
func (m *ListSourcesResponse) XXX_Size() int {
	return xxx_messageInfo_ListSourcesResponse.Size(m)
}
func (m *ListSourcesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSourcesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSourcesResponse proto.InternalMessageInfo

func (m *ListSourcesResponse) GetSources() []*Source {
	if m != nil {
		return m.Sources
	}
	return nil
}

func (m *ListSourcesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for listing assets.
type ListAssetsRequest struct {
	// Required. Name of the organization assets should belong to. Its format is
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across assets.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. The fields map to those
	// defined in the Asset resource. Examples include:
	//
	// * name
	// * security_center_properties.resource_name
	// * resource_properties.a_property
	// * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following are the allowed field and operator combinations:
	//
	// * name: `=`
	// * update_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     "update_time = \"2019-06-10T16:07:18-07:00\""
	//     "update_time = 1560208038000"
	//
	// * create_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     "create_time = \"2019-06-10T16:07:18-07:00\""
	//     "create_time = 1560208038000"
	//
	// * iam_policy.policy_blob: `=`, `:`
	// * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	// * security_marks.marks: `=`, `:`
	// * security_center_properties.resource_name: `=`, `:`
	// * security_center_properties.resource_display_name: `=`, `:`
	// * security_center_properties.resource_type: `=`, `:`
	// * security_center_properties.resource_parent: `=`, `:`
	// * security_center_properties.resource_parent_display_name: `=`, `:`
	// * security_center_properties.resource_project: `=`, `:`
	// * security_center_properties.resource_project_display_name: `=`, `:`
	// * security_center_properties.resource_owners: `=`, `:`
	//
	// For example, `resource_properties.size = 100` is a valid filter string.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what fields and order to use for sorting. The
	// string value should follow SQL syntax: comma separated list of fields. For
	// example: "name,resource_properties.a_property". The default sorting order
	// is ascending. To specify descending order for a field, a suffix " desc"
	// should be appended to the field name. For example: "name
	// desc,resource_properties.a_property". Redundant space characters in the
	// syntax are insignificant. "name desc,resource_properties.a_property" and "
	// name     desc  ,   resource_properties.a_property  " are equivalent.
	//
	// The following fields are supported:
	// name
	// update_time
	// resource_properties
	// security_marks.marks
	// security_center_properties.resource_name
	// security_center_properties.resource_display_name
	// security_center_properties.resource_parent
	// security_center_properties.resource_parent_display_name
	// security_center_properties.resource_project
	// security_center_properties.resource_project_display_name
	// security_center_properties.resource_type
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Time used as a reference point when filtering assets. The filter is limited
	// to assets existing at the supplied time and their values are those at that
	// specific time. Absence of this field will default to the API's version of
	// NOW.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the ListAssetsResult's "state_change"
	// attribute is updated to indicate whether the asset was added, removed, or
	// remained present during the compare_duration period of time that precedes
	// the read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state_change value is derived based on the presence of the asset at the
	// two points in time. Intermediate state changes between the two times don't
	// affect the result. For example, the results aren't affected if the asset is
	// removed and re-created again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "ADDED":   indicates that the asset was not present at the start of
	//                compare_duration, but present at read_time.
	// * "REMOVED": indicates that the asset was present at the start of
	//                compare_duration, but not present at read_time.
	// * "ACTIVE":  indicates that the asset was present at both the
	//                start and the end of the time period defined by
	//                compare_duration and read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED",  which will be the state_change set for all assets present at
	// read_time.
	CompareDuration *duration.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// Filter that specifies what fields to further filter on *after* the query
	// filter has been executed. Currently only `state_change` is supported and
	// requires compare_duration to be specified.
	Having string `protobuf:"bytes,6,opt,name=having,proto3" json:"having,omitempty"`
	// Optional.
	// A field mask to specify the ListAssetsResult fields to be listed in the
	// response.
	// An empty field mask will list all fields.
	FieldMask *field_mask.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The value returned by the last `ListAssetsResponse`; indicates
	// that this is a continuation of a prior `ListAssets` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAssetsRequest) Reset()         { *m = ListAssetsRequest{} }
func (m *ListAssetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAssetsRequest) ProtoMessage()    {}
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{16}
}

func (m *ListAssetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssetsRequest.Unmarshal(m, b)
}
func (m *ListAssetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssetsRequest.Marshal(b, m, deterministic)
}
func (m *ListAssetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssetsRequest.Merge(m, src)
}
func (m *ListAssetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAssetsRequest.Size(m)
}
func (m *ListAssetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssetsRequest proto.InternalMessageInfo

func (m *ListAssetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAssetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListAssetsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListAssetsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ListAssetsRequest) GetCompareDuration() *duration.Duration {
	if m != nil {
		return m.CompareDuration
	}
	return nil
}

func (m *ListAssetsRequest) GetHaving() string {
	if m != nil {
		return m.Having
	}
	return ""
}

func (m *ListAssetsRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

func (m *ListAssetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListAssetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for listing assets.
type ListAssetsResponse struct {
	// Assets matching the list request.
	ListAssetsResults []*ListAssetsResponse_ListAssetsResult `protobuf:"bytes,1,rep,name=list_assets_results,json=listAssetsResults,proto3" json:"list_assets_results,omitempty"`
	// Time used for executing the list request.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of assets matching the query.
	TotalSize            int32    `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAssetsResponse) Reset()         { *m = ListAssetsResponse{} }
func (m *ListAssetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAssetsResponse) ProtoMessage()    {}
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{17}
}

func (m *ListAssetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssetsResponse.Unmarshal(m, b)
}
func (m *ListAssetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssetsResponse.Marshal(b, m, deterministic)
}
func (m *ListAssetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssetsResponse.Merge(m, src)
}
func (m *ListAssetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAssetsResponse.Size(m)
}
func (m *ListAssetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssetsResponse proto.InternalMessageInfo

func (m *ListAssetsResponse) GetListAssetsResults() []*ListAssetsResponse_ListAssetsResult {
	if m != nil {
		return m.ListAssetsResults
	}
	return nil
}

func (m *ListAssetsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ListAssetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListAssetsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Result containing the Asset and its State.
type ListAssetsResponse_ListAssetsResult struct {
	// Asset matching the search request.
	Asset *Asset `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// State change of the asset between the points in time.
	StateChange          ListAssetsResponse_ListAssetsResult_StateChange `protobuf:"varint,2,opt,name=state_change,json=stateChange,proto3,enum=google.cloud.securitycenter.v1p1beta1.ListAssetsResponse_ListAssetsResult_StateChange" json:"state_change,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *ListAssetsResponse_ListAssetsResult) Reset()         { *m = ListAssetsResponse_ListAssetsResult{} }
func (m *ListAssetsResponse_ListAssetsResult) String() string { return proto.CompactTextString(m) }
func (*ListAssetsResponse_ListAssetsResult) ProtoMessage()    {}
func (*ListAssetsResponse_ListAssetsResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{17, 0}
}

func (m *ListAssetsResponse_ListAssetsResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssetsResponse_ListAssetsResult.Unmarshal(m, b)
}
func (m *ListAssetsResponse_ListAssetsResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssetsResponse_ListAssetsResult.Marshal(b, m, deterministic)
}
func (m *ListAssetsResponse_ListAssetsResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssetsResponse_ListAssetsResult.Merge(m, src)
}
func (m *ListAssetsResponse_ListAssetsResult) XXX_Size() int {
	return xxx_messageInfo_ListAssetsResponse_ListAssetsResult.Size(m)
}
func (m *ListAssetsResponse_ListAssetsResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssetsResponse_ListAssetsResult.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssetsResponse_ListAssetsResult proto.InternalMessageInfo

func (m *ListAssetsResponse_ListAssetsResult) GetAsset() *Asset {
	if m != nil {
		return m.Asset
	}
	return nil
}

func (m *ListAssetsResponse_ListAssetsResult) GetStateChange() ListAssetsResponse_ListAssetsResult_StateChange {
	if m != nil {
		return m.StateChange
	}
	return ListAssetsResponse_ListAssetsResult_UNUSED
}

// Request message for listing findings.
type ListFindingsRequest struct {
	// Required. Name of the source the findings belong to. Its format is
	// "organizations/[organization_id]/sources/[source_id]". To list across all
	// sources provide a source_id of `-`. For example:
	// organizations/{organization_id}/sources/-
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//  * name
	//  * source_properties.a_property
	//  * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// name: `=`
	// parent: `=`, `:`
	// resource_name: `=`, `:`
	// state: `=`, `:`
	// category: `=`, `:`
	// external_uri: `=`, `:`
	// event_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//   Usage: This should be milliseconds since epoch or an RFC3339 string.
	//   Examples:
	//     "event_time = \"2019-06-10T16:07:18-07:00\""
	//     "event_time = 1560208038000"
	//
	// security_marks.marks: `=`, `:`
	// source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	//
	// For example, `source_properties.size = 100` is a valid filter string.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what fields and order to use for sorting. The
	// string value should follow SQL syntax: comma separated list of fields. For
	// example: "name,resource_properties.a_property". The default sorting order
	// is ascending. To specify descending order for a field, a suffix " desc"
	// should be appended to the field name. For example: "name
	// desc,source_properties.a_property". Redundant space characters in the
	// syntax are insignificant. "name desc,source_properties.a_property" and "
	// name     desc  ,   source_properties.a_property  " are equivalent.
	//
	// The following fields are supported:
	// name
	// parent
	// state
	// category
	// resource_name
	// event_time
	// source_properties
	// security_marks.marks
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Time used as a reference point when filtering findings. The filter is
	// limited to findings existing at the supplied time and their values are
	// those at that specific time. Absence of this field will default to the
	// API's version of NOW.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the ListFindingsResult's "state_change"
	// attribute is updated to indicate whether the finding had its state changed,
	// the finding's state remained unchanged, or if the finding was added in any
	// state during the compare_duration period of time that precedes the
	// read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state_change value is derived based on the presence and state of the
	// finding at the two points in time. Intermediate state changes between the
	// two times don't affect the result. For example, the results aren't affected
	// if the finding is made inactive and then active again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "CHANGED":   indicates that the finding was present at the start of
	//                  compare_duration, but changed its state at read_time.
	// * "UNCHANGED": indicates that the finding was present at the start of
	//                  compare_duration and did not change state at read_time.
	// * "ADDED":     indicates that the finding was not present at the start
	//                  of compare_duration, but was present at read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED", which will be the state_change set for all findings present at
	// read_time.
	CompareDuration *duration.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// Filter that specifies what fields to further filter on *after* the query
	// filter has been executed. Currently only `finding.state` and `state_change`
	// are supported and requires compare_duration to be specified.
	Having string `protobuf:"bytes,6,opt,name=having,proto3" json:"having,omitempty"`
	// Optional.
	// A field mask to specify the Finding fields to be listed in the response.
	// An empty field mask will list all fields.
	FieldMask *field_mask.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The value returned by the last `ListFindingsResponse`; indicates
	// that this is a continuation of a prior `ListFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFindingsRequest) Reset()         { *m = ListFindingsRequest{} }
func (m *ListFindingsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFindingsRequest) ProtoMessage()    {}
func (*ListFindingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{18}
}

func (m *ListFindingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFindingsRequest.Unmarshal(m, b)
}
func (m *ListFindingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFindingsRequest.Marshal(b, m, deterministic)
}
func (m *ListFindingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFindingsRequest.Merge(m, src)
}
func (m *ListFindingsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFindingsRequest.Size(m)
}
func (m *ListFindingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFindingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFindingsRequest proto.InternalMessageInfo

func (m *ListFindingsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListFindingsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListFindingsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListFindingsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ListFindingsRequest) GetCompareDuration() *duration.Duration {
	if m != nil {
		return m.CompareDuration
	}
	return nil
}

func (m *ListFindingsRequest) GetHaving() string {
	if m != nil {
		return m.Having
	}
	return ""
}

func (m *ListFindingsRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

func (m *ListFindingsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFindingsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for listing findings.
type ListFindingsResponse struct {
	// Findings matching the list request.
	ListFindingsResults []*ListFindingsResponse_ListFindingsResult `protobuf:"bytes,1,rep,name=list_findings_results,json=listFindingsResults,proto3" json:"list_findings_results,omitempty"`
	// Time used for executing the list request.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of findings matching the query.
	TotalSize            int32    `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFindingsResponse) Reset()         { *m = ListFindingsResponse{} }
func (m *ListFindingsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFindingsResponse) ProtoMessage()    {}
func (*ListFindingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{19}
}

func (m *ListFindingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFindingsResponse.Unmarshal(m, b)
}
func (m *ListFindingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFindingsResponse.Marshal(b, m, deterministic)
}
func (m *ListFindingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFindingsResponse.Merge(m, src)
}
func (m *ListFindingsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFindingsResponse.Size(m)
}
func (m *ListFindingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFindingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFindingsResponse proto.InternalMessageInfo

func (m *ListFindingsResponse) GetListFindingsResults() []*ListFindingsResponse_ListFindingsResult {
	if m != nil {
		return m.ListFindingsResults
	}
	return nil
}

func (m *ListFindingsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ListFindingsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListFindingsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Result containing the Finding and its StateChange.
type ListFindingsResponse_ListFindingsResult struct {
	// Finding matching the search request.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// State change of the finding between the points in time.
	StateChange ListFindingsResponse_ListFindingsResult_StateChange `protobuf:"varint,2,opt,name=state_change,json=stateChange,proto3,enum=google.cloud.securitycenter.v1p1beta1.ListFindingsResponse_ListFindingsResult_StateChange" json:"state_change,omitempty"`
	// Output only. Resource that is associated with this finding.
	Resource             *ListFindingsResponse_ListFindingsResult_Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *ListFindingsResponse_ListFindingsResult) Reset() {
	*m = ListFindingsResponse_ListFindingsResult{}
}
func (m *ListFindingsResponse_ListFindingsResult) String() string { return proto.CompactTextString(m) }
func (*ListFindingsResponse_ListFindingsResult) ProtoMessage()    {}
func (*ListFindingsResponse_ListFindingsResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{19, 0}
}

func (m *ListFindingsResponse_ListFindingsResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFindingsResponse_ListFindingsResult.Unmarshal(m, b)
}
func (m *ListFindingsResponse_ListFindingsResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFindingsResponse_ListFindingsResult.Marshal(b, m, deterministic)
}
func (m *ListFindingsResponse_ListFindingsResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFindingsResponse_ListFindingsResult.Merge(m, src)
}
func (m *ListFindingsResponse_ListFindingsResult) XXX_Size() int {
	return xxx_messageInfo_ListFindingsResponse_ListFindingsResult.Size(m)
}
func (m *ListFindingsResponse_ListFindingsResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFindingsResponse_ListFindingsResult.DiscardUnknown(m)
}

var xxx_messageInfo_ListFindingsResponse_ListFindingsResult proto.InternalMessageInfo

func (m *ListFindingsResponse_ListFindingsResult) GetFinding() *Finding {
	if m != nil {
		return m.Finding
	}
	return nil
}

func (m *ListFindingsResponse_ListFindingsResult) GetStateChange() ListFindingsResponse_ListFindingsResult_StateChange {
	if m != nil {
		return m.StateChange
	}
	return ListFindingsResponse_ListFindingsResult_UNUSED
}

func (m *ListFindingsResponse_ListFindingsResult) GetResource() *ListFindingsResponse_ListFindingsResult_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Information related to the Google Cloud Platform (GCP) resource that is
// associated with this finding.
type ListFindingsResponse_ListFindingsResult_Resource struct {
	// The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The full resource name of project that the resource belongs to.
	ProjectName string `protobuf:"bytes,2,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// The human readable name of project that the resource belongs to.
	ProjectDisplayName string `protobuf:"bytes,3,opt,name=project_display_name,json=projectDisplayName,proto3" json:"project_display_name,omitempty"`
	// The full resource name of resource's parent.
	ParentName string `protobuf:"bytes,4,opt,name=parent_name,json=parentName,proto3" json:"parent_name,omitempty"`
	// The human readable name of resource's parent.
	ParentDisplayName    string   `protobuf:"bytes,5,opt,name=parent_display_name,json=parentDisplayName,proto3" json:"parent_display_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFindingsResponse_ListFindingsResult_Resource) Reset() {
	*m = ListFindingsResponse_ListFindingsResult_Resource{}
}
func (m *ListFindingsResponse_ListFindingsResult_Resource) String() string {
	return proto.CompactTextString(m)
}
func (*ListFindingsResponse_ListFindingsResult_Resource) ProtoMessage() {}
func (*ListFindingsResponse_ListFindingsResult_Resource) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{19, 0, 0}
}

func (m *ListFindingsResponse_ListFindingsResult_Resource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFindingsResponse_ListFindingsResult_Resource.Unmarshal(m, b)
}
func (m *ListFindingsResponse_ListFindingsResult_Resource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFindingsResponse_ListFindingsResult_Resource.Marshal(b, m, deterministic)
}
func (m *ListFindingsResponse_ListFindingsResult_Resource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFindingsResponse_ListFindingsResult_Resource.Merge(m, src)
}
func (m *ListFindingsResponse_ListFindingsResult_Resource) XXX_Size() int {
	return xxx_messageInfo_ListFindingsResponse_ListFindingsResult_Resource.Size(m)
}
func (m *ListFindingsResponse_ListFindingsResult_Resource) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFindingsResponse_ListFindingsResult_Resource.DiscardUnknown(m)
}

var xxx_messageInfo_ListFindingsResponse_ListFindingsResult_Resource proto.InternalMessageInfo

func (m *ListFindingsResponse_ListFindingsResult_Resource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListFindingsResponse_ListFindingsResult_Resource) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

func (m *ListFindingsResponse_ListFindingsResult_Resource) GetProjectDisplayName() string {
	if m != nil {
		return m.ProjectDisplayName
	}
	return ""
}

func (m *ListFindingsResponse_ListFindingsResult_Resource) GetParentName() string {
	if m != nil {
		return m.ParentName
	}
	return ""
}

func (m *ListFindingsResponse_ListFindingsResult_Resource) GetParentDisplayName() string {
	if m != nil {
		return m.ParentDisplayName
	}
	return ""
}

// Request message for updating a finding's state.
type SetFindingStateRequest struct {
	// Required. The relative resource name of the finding. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/sources/{source_id}/finding/{finding_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired State of the finding.
	State Finding_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.securitycenter.v1p1beta1.Finding_State" json:"state,omitempty"`
	// Required. The time at which the updated state takes effect.
	StartTime            *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SetFindingStateRequest) Reset()         { *m = SetFindingStateRequest{} }
func (m *SetFindingStateRequest) String() string { return proto.CompactTextString(m) }
func (*SetFindingStateRequest) ProtoMessage()    {}
func (*SetFindingStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{20}
}

func (m *SetFindingStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetFindingStateRequest.Unmarshal(m, b)
}
func (m *SetFindingStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetFindingStateRequest.Marshal(b, m, deterministic)
}
func (m *SetFindingStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetFindingStateRequest.Merge(m, src)
}
func (m *SetFindingStateRequest) XXX_Size() int {
	return xxx_messageInfo_SetFindingStateRequest.Size(m)
}
func (m *SetFindingStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetFindingStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetFindingStateRequest proto.InternalMessageInfo

func (m *SetFindingStateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SetFindingStateRequest) GetState() Finding_State {
	if m != nil {
		return m.State
	}
	return Finding_STATE_UNSPECIFIED
}

func (m *SetFindingStateRequest) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

// Request message for running asset discovery for an organization.
type RunAssetDiscoveryRequest struct {
	// Required. Name of the organization to run asset discovery for. Its format
	// is "organizations/[organization_id]".
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunAssetDiscoveryRequest) Reset()         { *m = RunAssetDiscoveryRequest{} }
func (m *RunAssetDiscoveryRequest) String() string { return proto.CompactTextString(m) }
func (*RunAssetDiscoveryRequest) ProtoMessage()    {}
func (*RunAssetDiscoveryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{21}
}

func (m *RunAssetDiscoveryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunAssetDiscoveryRequest.Unmarshal(m, b)
}
func (m *RunAssetDiscoveryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunAssetDiscoveryRequest.Marshal(b, m, deterministic)
}
func (m *RunAssetDiscoveryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunAssetDiscoveryRequest.Merge(m, src)
}
func (m *RunAssetDiscoveryRequest) XXX_Size() int {
	return xxx_messageInfo_RunAssetDiscoveryRequest.Size(m)
}
func (m *RunAssetDiscoveryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunAssetDiscoveryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunAssetDiscoveryRequest proto.InternalMessageInfo

func (m *RunAssetDiscoveryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// Request message for updating or creating a finding.
type UpdateFindingRequest struct {
	// Required. The finding resource to update or create if it does not already
	// exist. parent, security_marks, and update_time will be ignored.
	//
	// In the case of creation, the finding id portion of the name must be
	// alphanumeric and less than or equal to 32 characters and greater than 0
	// characters in length.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// The FieldMask to use when updating the finding resource. This field should
	// not be specified when creating a finding.
	//
	// When updating a finding, an empty mask is treated as updating all mutable
	// fields and replacing source_properties.  Individual source_properties can
	// be added/updated by using "source_properties.<property key>" in the field
	// mask.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateFindingRequest) Reset()         { *m = UpdateFindingRequest{} }
func (m *UpdateFindingRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFindingRequest) ProtoMessage()    {}
func (*UpdateFindingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{22}
}

func (m *UpdateFindingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFindingRequest.Unmarshal(m, b)
}
func (m *UpdateFindingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFindingRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFindingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFindingRequest.Merge(m, src)
}
func (m *UpdateFindingRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFindingRequest.Size(m)
}
func (m *UpdateFindingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFindingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFindingRequest proto.InternalMessageInfo

func (m *UpdateFindingRequest) GetFinding() *Finding {
	if m != nil {
		return m.Finding
	}
	return nil
}

func (m *UpdateFindingRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for updating a notification config.
type UpdateNotificationConfigRequest struct {
	// The notification config to update.
	NotificationConfig *NotificationConfig `protobuf:"bytes,1,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// The FieldMask to use when updating the notification config.
	//
	// If empty all mutable fields will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateNotificationConfigRequest) Reset()         { *m = UpdateNotificationConfigRequest{} }
func (m *UpdateNotificationConfigRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNotificationConfigRequest) ProtoMessage()    {}
func (*UpdateNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{23}
}

func (m *UpdateNotificationConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNotificationConfigRequest.Unmarshal(m, b)
}
func (m *UpdateNotificationConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNotificationConfigRequest.Marshal(b, m, deterministic)
}
func (m *UpdateNotificationConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNotificationConfigRequest.Merge(m, src)
}
func (m *UpdateNotificationConfigRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateNotificationConfigRequest.Size(m)
}
func (m *UpdateNotificationConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNotificationConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNotificationConfigRequest proto.InternalMessageInfo

func (m *UpdateNotificationConfigRequest) GetNotificationConfig() *NotificationConfig {
	if m != nil {
		return m.NotificationConfig
	}
	return nil
}

func (m *UpdateNotificationConfigRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for updating an organization's settings.
type UpdateOrganizationSettingsRequest struct {
	// Required. The organization settings resource to update.
	OrganizationSettings *OrganizationSettings `protobuf:"bytes,1,opt,name=organization_settings,json=organizationSettings,proto3" json:"organization_settings,omitempty"`
	// The FieldMask to use when updating the settings resource.
	//
	//  If empty all mutable fields will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateOrganizationSettingsRequest) Reset()         { *m = UpdateOrganizationSettingsRequest{} }
func (m *UpdateOrganizationSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateOrganizationSettingsRequest) ProtoMessage()    {}
func (*UpdateOrganizationSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{24}
}

func (m *UpdateOrganizationSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateOrganizationSettingsRequest.Unmarshal(m, b)
}
func (m *UpdateOrganizationSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateOrganizationSettingsRequest.Marshal(b, m, deterministic)
}
func (m *UpdateOrganizationSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateOrganizationSettingsRequest.Merge(m, src)
}
func (m *UpdateOrganizationSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateOrganizationSettingsRequest.Size(m)
}
func (m *UpdateOrganizationSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateOrganizationSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateOrganizationSettingsRequest proto.InternalMessageInfo

func (m *UpdateOrganizationSettingsRequest) GetOrganizationSettings() *OrganizationSettings {
	if m != nil {
		return m.OrganizationSettings
	}
	return nil
}

func (m *UpdateOrganizationSettingsRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for updating a source.
type UpdateSourceRequest struct {
	// Required. The source resource to update.
	Source *Source `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The FieldMask to use when updating the source resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSourceRequest) Reset()         { *m = UpdateSourceRequest{} }
func (m *UpdateSourceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSourceRequest) ProtoMessage()    {}
func (*UpdateSourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{25}
}

func (m *UpdateSourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSourceRequest.Unmarshal(m, b)
}
func (m *UpdateSourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSourceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSourceRequest.Merge(m, src)
}
func (m *UpdateSourceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSourceRequest.Size(m)
}
func (m *UpdateSourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSourceRequest proto.InternalMessageInfo

func (m *UpdateSourceRequest) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *UpdateSourceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for updating a SecurityMarks resource.
type UpdateSecurityMarksRequest struct {
	// Required. The security marks resource to update.
	SecurityMarks *SecurityMarks `protobuf:"bytes,1,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The FieldMask to use when updating the security marks resource.
	//
	// The field mask must not contain duplicate fields.
	// If empty or set to "marks", all marks will be replaced.  Individual
	// marks can be updated using "marks.<mark_key>".
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The time at which the updated SecurityMarks take effect.
	// If not set uses current server time.  Updates will be applied to the
	// SecurityMarks that are active immediately preceding this time.
	StartTime            *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateSecurityMarksRequest) Reset()         { *m = UpdateSecurityMarksRequest{} }
func (m *UpdateSecurityMarksRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSecurityMarksRequest) ProtoMessage()    {}
func (*UpdateSecurityMarksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dcfd9d30085cdb4, []int{26}
}

func (m *UpdateSecurityMarksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSecurityMarksRequest.Unmarshal(m, b)
}
func (m *UpdateSecurityMarksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSecurityMarksRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSecurityMarksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSecurityMarksRequest.Merge(m, src)
}
func (m *UpdateSecurityMarksRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSecurityMarksRequest.Size(m)
}
func (m *UpdateSecurityMarksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSecurityMarksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSecurityMarksRequest proto.InternalMessageInfo

func (m *UpdateSecurityMarksRequest) GetSecurityMarks() *SecurityMarks {
	if m != nil {
		return m.SecurityMarks
	}
	return nil
}

func (m *UpdateSecurityMarksRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateSecurityMarksRequest) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.securitycenter.v1p1beta1.ListAssetsResponse_ListAssetsResult_StateChange", ListAssetsResponse_ListAssetsResult_StateChange_name, ListAssetsResponse_ListAssetsResult_StateChange_value)
	proto.RegisterEnum("google.cloud.securitycenter.v1p1beta1.ListFindingsResponse_ListFindingsResult_StateChange", ListFindingsResponse_ListFindingsResult_StateChange_name, ListFindingsResponse_ListFindingsResult_StateChange_value)
	proto.RegisterType((*CreateFindingRequest)(nil), "google.cloud.securitycenter.v1p1beta1.CreateFindingRequest")
	proto.RegisterType((*CreateNotificationConfigRequest)(nil), "google.cloud.securitycenter.v1p1beta1.CreateNotificationConfigRequest")
	proto.RegisterType((*CreateSourceRequest)(nil), "google.cloud.securitycenter.v1p1beta1.CreateSourceRequest")
	proto.RegisterType((*DeleteNotificationConfigRequest)(nil), "google.cloud.securitycenter.v1p1beta1.DeleteNotificationConfigRequest")
	proto.RegisterType((*GetNotificationConfigRequest)(nil), "google.cloud.securitycenter.v1p1beta1.GetNotificationConfigRequest")
	proto.RegisterType((*GetOrganizationSettingsRequest)(nil), "google.cloud.securitycenter.v1p1beta1.GetOrganizationSettingsRequest")
	proto.RegisterType((*GetSourceRequest)(nil), "google.cloud.securitycenter.v1p1beta1.GetSourceRequest")
	proto.RegisterType((*GroupAssetsRequest)(nil), "google.cloud.securitycenter.v1p1beta1.GroupAssetsRequest")
	proto.RegisterType((*GroupAssetsResponse)(nil), "google.cloud.securitycenter.v1p1beta1.GroupAssetsResponse")
	proto.RegisterType((*GroupFindingsRequest)(nil), "google.cloud.securitycenter.v1p1beta1.GroupFindingsRequest")
	proto.RegisterType((*GroupFindingsResponse)(nil), "google.cloud.securitycenter.v1p1beta1.GroupFindingsResponse")
	proto.RegisterType((*GroupResult)(nil), "google.cloud.securitycenter.v1p1beta1.GroupResult")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.securitycenter.v1p1beta1.GroupResult.PropertiesEntry")
	proto.RegisterType((*ListNotificationConfigsRequest)(nil), "google.cloud.securitycenter.v1p1beta1.ListNotificationConfigsRequest")
	proto.RegisterType((*ListNotificationConfigsResponse)(nil), "google.cloud.securitycenter.v1p1beta1.ListNotificationConfigsResponse")
	proto.RegisterType((*ListSourcesRequest)(nil), "google.cloud.securitycenter.v1p1beta1.ListSourcesRequest")
	proto.RegisterType((*ListSourcesResponse)(nil), "google.cloud.securitycenter.v1p1beta1.ListSourcesResponse")
	proto.RegisterType((*ListAssetsRequest)(nil), "google.cloud.securitycenter.v1p1beta1.ListAssetsRequest")
	proto.RegisterType((*ListAssetsResponse)(nil), "google.cloud.securitycenter.v1p1beta1.ListAssetsResponse")
	proto.RegisterType((*ListAssetsResponse_ListAssetsResult)(nil), "google.cloud.securitycenter.v1p1beta1.ListAssetsResponse.ListAssetsResult")
	proto.RegisterType((*ListFindingsRequest)(nil), "google.cloud.securitycenter.v1p1beta1.ListFindingsRequest")
	proto.RegisterType((*ListFindingsResponse)(nil), "google.cloud.securitycenter.v1p1beta1.ListFindingsResponse")
	proto.RegisterType((*ListFindingsResponse_ListFindingsResult)(nil), "google.cloud.securitycenter.v1p1beta1.ListFindingsResponse.ListFindingsResult")
	proto.RegisterType((*ListFindingsResponse_ListFindingsResult_Resource)(nil), "google.cloud.securitycenter.v1p1beta1.ListFindingsResponse.ListFindingsResult.Resource")
	proto.RegisterType((*SetFindingStateRequest)(nil), "google.cloud.securitycenter.v1p1beta1.SetFindingStateRequest")
	proto.RegisterType((*RunAssetDiscoveryRequest)(nil), "google.cloud.securitycenter.v1p1beta1.RunAssetDiscoveryRequest")
	proto.RegisterType((*UpdateFindingRequest)(nil), "google.cloud.securitycenter.v1p1beta1.UpdateFindingRequest")
	proto.RegisterType((*UpdateNotificationConfigRequest)(nil), "google.cloud.securitycenter.v1p1beta1.UpdateNotificationConfigRequest")
	proto.RegisterType((*UpdateOrganizationSettingsRequest)(nil), "google.cloud.securitycenter.v1p1beta1.UpdateOrganizationSettingsRequest")
	proto.RegisterType((*UpdateSourceRequest)(nil), "google.cloud.securitycenter.v1p1beta1.UpdateSourceRequest")
	proto.RegisterType((*UpdateSecurityMarksRequest)(nil), "google.cloud.securitycenter.v1p1beta1.UpdateSecurityMarksRequest")
}

func init() {
	proto.RegisterFile("google/cloud/securitycenter/v1p1beta1/securitycenter_service.proto", fileDescriptor_9dcfd9d30085cdb4)
}

var fileDescriptor_9dcfd9d30085cdb4 = []byte{
	// 2826 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5b, 0x5d, 0x6c, 0x1c, 0x57,
	0x15, 0xee, 0xdd, 0xf5, 0xef, 0x59, 0x3b, 0x71, 0xae, 0xed, 0x76, 0x33, 0x6d, 0x62, 0x77, 0x68,
	0x8b, 0x9b, 0x3a, 0xbb, 0xf5, 0xb6, 0xb4, 0xc9, 0x3a, 0x6d, 0x18, 0x7b, 0x1d, 0x27, 0x6d, 0xec,
	0x98, 0x71, 0x62, 0x20, 0x8a, 0xb4, 0x1d, 0xef, 0x5e, 0x6f, 0x06, 0xef, 0xce, 0x2c, 0x33, 0xb3,
	0x0e, 0x0e, 0x8a, 0x90, 0x8a, 0xc8, 0x33, 0x12, 0x2f, 0x3c, 0x00, 0xe2, 0xa7, 0x42, 0x02, 0x24,
	0x78, 0xe0, 0x01, 0x9e, 0x50, 0x41, 0x88, 0x87, 0xbc, 0x14, 0xc1, 0x03, 0xd2, 0x22, 0x41, 0x1f,
	0x82, 0x40, 0x08, 0x1e, 0x00, 0x95, 0x07, 0xa4, 0x4a, 0x68, 0xee, 0xcf, 0x7a, 0x66, 0x76, 0xbc,
	0x9e, 0xd9, 0x8d, 0x9b, 0x4a, 0xf0, 0x94, 0xcc, 0xbd, 0xe7, 0x9e, 0x73, 0xbe, 0x73, 0xcf, 0x3d,
	0xf7, 0xdc, 0x73, 0xd6, 0xb0, 0x50, 0x31, 0xcd, 0x4a, 0x95, 0x64, 0x4b, 0x55, 0xb3, 0x51, 0xce,
	0xda, 0xa4, 0xd4, 0xb0, 0x74, 0x67, 0xb7, 0x44, 0x0c, 0x87, 0x58, 0xd9, 0x9d, 0xb9, 0xfa, 0xdc,
	0x26, 0x71, 0xb4, 0xb9, 0xc0, 0x44, 0xd1, 0x26, 0xd6, 0x8e, 0x5e, 0x22, 0x99, 0xba, 0x65, 0x3a,
	0x26, 0x7e, 0x9a, 0xf1, 0xc8, 0x50, 0x1e, 0x19, 0x3f, 0x69, 0xa6, 0xc5, 0x43, 0xba, 0x18, 0x4d,
	0x94, 0xd5, 0x30, 0x8a, 0x9a, 0x6d, 0x13, 0xa7, 0x58, 0xd6, 0xed, 0x92, 0xb9, 0x43, 0xac, 0xdd,
	0xa2, 0x45, 0xec, 0xba, 0x69, 0xd8, 0x5c, 0xa0, 0xf4, 0x04, 0xe7, 0xa4, 0xd5, 0xf5, 0xac, 0x66,
	0x18, 0xa6, 0xa3, 0x39, 0xba, 0x69, 0xd8, 0x7c, 0xf6, 0x31, 0xcf, 0x6c, 0xa9, 0xaa, 0x13, 0xc3,
	0xe1, 0x13, 0x53, 0x9e, 0x89, 0x2d, 0x9d, 0x54, 0xcb, 0xc5, 0x4d, 0x72, 0x53, 0xdb, 0xd1, 0x4d,
	0x8b, 0x13, 0x1c, 0xf7, 0x10, 0x58, 0xc4, 0x36, 0x1b, 0x96, 0xc0, 0x28, 0xcd, 0x45, 0x53, 0x9e,
	0x2a, 0xce, 0x97, 0xbc, 0x10, 0x6d, 0xc9, 0x96, 0x6e, 0x94, 0x75, 0xa3, 0xc2, 0x17, 0x9d, 0x8f,
	0xb6, 0xc8, 0x30, 0x1d, 0x7d, 0x4b, 0x2f, 0x51, 0xdc, 0xc5, 0x92, 0x69, 0x6c, 0xe9, 0x82, 0x81,
	0x12, 0x8d, 0x81, 0x69, 0x55, 0x34, 0x43, 0xbf, 0xcd, 0x18, 0xd8, 0xc4, 0x71, 0x74, 0xa3, 0x22,
	0x0c, 0x98, 0x8f, 0xe7, 0x13, 0xc5, 0x9a, 0x66, 0x6d, 0x8b, 0xb5, 0xb9, 0x88, 0x6b, 0xbd, 0xb6,
	0x3d, 0xc9, 0xd7, 0xe8, 0x5a, 0x2d, 0xbb, 0x33, 0xe7, 0xfe, 0x53, 0xac, 0x9b, 0x55, 0xbd, 0xb4,
	0xcb, 0xe7, 0x25, 0xff, 0xbc, 0x6f, 0xee, 0x23, 0x7c, 0xae, 0x6a, 0x1a, 0x15, 0xab, 0x61, 0x18,
	0xba, 0x51, 0xc9, 0x9a, 0x75, 0x62, 0xf9, 0x3c, 0x42, 0x08, 0xa0, 0x5f, 0x9b, 0x8d, 0xad, 0x6c,
	0xb9, 0xc1, 0x08, 0xf8, 0xfc, 0xe3, 0xc1, 0x79, 0x52, 0xab, 0x3b, 0x42, 0xc2, 0x74, 0x70, 0x92,
	0xb9, 0x4e, 0x4d, 0xb3, 0xb7, 0x03, 0xee, 0xd8, 0xa2, 0xb0, 0x1d, 0xab, 0x51, 0x0a, 0x7a, 0x5d,
	0x6b, 0xd6, 0xd1, 0x6b, 0xc4, 0x76, 0xb4, 0x5a, 0x9d, 0x11, 0xc8, 0xef, 0x20, 0x98, 0x58, 0xb4,
	0x88, 0xe6, 0x90, 0x0b, 0xcc, 0x15, 0x54, 0xf2, 0xd9, 0x06, 0xb1, 0x1d, 0x5c, 0x80, 0x81, 0xba,
	0x66, 0x11, 0xc3, 0x49, 0xa3, 0x69, 0x34, 0x33, 0xbc, 0x30, 0xfb, 0xae, 0x92, 0xf8, 0x8f, 0xf2,
	0x0c, 0x3c, 0x15, 0x38, 0x62, 0x4c, 0x80, 0x56, 0xd7, 0xed, 0x4c, 0xc9, 0xac, 0x65, 0xd7, 0xa9,
	0x6d, 0x55, 0xbe, 0x16, 0xcb, 0x00, 0xdc, 0xc5, 0x8a, 0x7a, 0x39, 0x9d, 0xa0, 0x9c, 0x92, 0xef,
	0x2a, 0x09, 0x75, 0x98, 0x0f, 0x5f, 0x2a, 0xe3, 0x15, 0x18, 0xe4, 0x1f, 0xe9, 0xe4, 0x34, 0x9a,
	0x49, 0xe5, 0x32, 0x99, 0x48, 0x67, 0x3a, 0xc3, 0x35, 0x66, 0x0c, 0x05, 0x0f, 0xf9, 0x6e, 0x02,
	0xa6, 0x18, 0xa2, 0x55, 0x8f, 0x9f, 0x2e, 0x52, 0x37, 0x15, 0xe0, 0xd6, 0x02, 0xe0, 0xce, 0x50,
	0x70, 0x39, 0x78, 0x9e, 0x4a, 0x14, 0xa7, 0xaf, 0xa6, 0x19, 0x5a, 0xa5, 0x1d, 0xe2, 0x15, 0x8f,
	0xf7, 0xb6, 0x80, 0x4e, 0xc3, 0x30, 0x3b, 0x09, 0x01, 0x9c, 0x43, 0x6c, 0xf4, 0x52, 0x19, 0x9b,
	0x30, 0x1e, 0x72, 0x70, 0x38, 0xe4, 0xb3, 0x11, 0x21, 0xb7, 0x43, 0x62, 0x62, 0xb0, 0xd1, 0x36,
	0x21, 0xff, 0x18, 0xc1, 0x38, 0x33, 0x04, 0xdf, 0x94, 0x43, 0x03, 0xff, 0x1a, 0x0c, 0xb0, 0x45,
	0x14, 0x79, 0x2a, 0x77, 0x3a, 0x22, 0x1a, 0xa6, 0x17, 0x43, 0xc0, 0x39, 0xc8, 0x26, 0x4c, 0x15,
	0x48, 0x95, 0x74, 0xda, 0xbd, 0xcb, 0xd0, 0x67, 0x68, 0x35, 0x12, 0x54, 0xbf, 0xb3, 0x63, 0x86,
	0xb0, 0xa3, 0x5c, 0xe4, 0x2a, 0x3c, 0xb1, 0x4c, 0x9c, 0x0f, 0x4a, 0x5a, 0x1d, 0x4e, 0x2e, 0x13,
	0xc7, 0x6b, 0xc5, 0x75, 0x1e, 0xff, 0x84, 0xbc, 0x55, 0x9f, 0xbc, 0x3c, 0x95, 0xf7, 0x22, 0xe4,
	0x3a, 0xcb, 0x0b, 0x65, 0xc8, 0x24, 0x5e, 0x85, 0xb1, 0x65, 0xe2, 0xf8, 0x5d, 0xe0, 0xe3, 0x3e,
	0x19, 0xf1, 0x8e, 0x36, 0xe3, 0xfa, 0x8f, 0x04, 0xe0, 0x65, 0xcb, 0x6c, 0xd4, 0x15, 0xf7, 0xd2,
	0xb1, 0x0f, 0xcf, 0xb7, 0x1e, 0x85, 0x81, 0x2d, 0xbd, 0xea, 0x10, 0x8b, 0x9d, 0x2a, 0x95, 0x7f,
	0xe1, 0x93, 0x30, 0x54, 0x71, 0xe5, 0x17, 0x37, 0x77, 0xe9, 0x19, 0xe2, 0xe7, 0x6d, 0x90, 0x0e,
	0x2e, 0xec, 0xe2, 0x02, 0x8c, 0x95, 0xcc, 0x9a, 0xcb, 0xa4, 0x28, 0x02, 0x6e, 0xba, 0x8f, 0x7a,
	0xe7, 0x71, 0xe1, 0x9d, 0x22, 0x28, 0x66, 0x0a, 0x9c, 0x40, 0x3d, 0xca, 0x97, 0x88, 0x01, 0xfc,
	0x32, 0x0c, 0x5b, 0x44, 0x2b, 0x17, 0xdd, 0xb0, 0x99, 0xee, 0xa7, 0xcb, 0xa5, 0xb6, 0xe5, 0x57,
	0x45, 0x4c, 0x55, 0x87, 0x5c, 0x62, 0xf7, 0xd3, 0x55, 0xdb, 0xbd, 0xdd, 0x8d, 0x4a, 0x7a, 0x80,
	0xa9, 0xcd, 0xbe, 0xf0, 0x09, 0x80, 0xba, 0x56, 0x21, 0x45, 0xc7, 0xdc, 0x26, 0x46, 0x7a, 0x90,
	0xce, 0x0d, 0xbb, 0x23, 0x57, 0xdd, 0x01, 0xfc, 0x38, 0xd0, 0x8f, 0xa2, 0xad, 0xdf, 0x26, 0xe9,
	0xa1, 0x69, 0x34, 0xd3, 0xaf, 0x0e, 0xb9, 0x03, 0xeb, 0xfa, 0x6d, 0x22, 0xff, 0x0b, 0xc1, 0xb8,
	0xcf, 0xe6, 0x2c, 0x2f, 0xc1, 0x37, 0x60, 0x4c, 0x98, 0xc2, 0x4d, 0x56, 0x1a, 0x55, 0xc7, 0x4e,
	0xa3, 0xe9, 0xe4, 0x4c, 0x2a, 0x97, 0x8b, 0x78, 0x10, 0x29, 0x57, 0x95, 0x2e, 0x55, 0x8f, 0x70,
	0x0b, 0xb2, 0x4f, 0xdb, 0x6f, 0x82, 0x44, 0x0c, 0x13, 0x3c, 0x03, 0x47, 0x0d, 0xf2, 0x39, 0xa7,
	0xe8, 0xc1, 0x4b, 0x37, 0x4a, 0x1d, 0x75, 0x87, 0xd7, 0x5a, 0x98, 0x4f, 0x00, 0x38, 0xa6, 0xa3,
	0x55, 0x19, 0xe8, 0x3e, 0x0a, 0x7a, 0x98, 0x8e, 0x50, 0xd4, 0x7f, 0x4e, 0xc0, 0x04, 0xd5, 0x8f,
	0x87, 0x7b, 0xfb, 0xc1, 0xde, 0x50, 0xdd, 0xfa, 0x97, 0xcf, 0x2c, 0x7d, 0x31, 0xcc, 0x12, 0xe6,
	0x98, 0xfd, 0xb1, 0x1d, 0xf3, 0x30, 0xfc, 0xeb, 0x3d, 0x04, 0x93, 0x01, 0x4b, 0xff, 0x4f, 0x78,
	0xd8, 0x1f, 0x10, 0xa4, 0x3c, 0xfa, 0xe1, 0x4d, 0x80, 0xba, 0xe5, 0xe6, 0x71, 0x8e, 0x4e, 0x04,
	0xce, 0x85, 0xf8, 0x38, 0x33, 0x6b, 0x2d, 0x26, 0x4b, 0x86, 0x63, 0xed, 0xaa, 0x1e, 0xae, 0x78,
	0x02, 0xfa, 0x4b, 0x66, 0xc3, 0x70, 0x28, 0xde, 0xa4, 0xca, 0x3e, 0xa4, 0x6b, 0x70, 0x34, 0xb0,
	0x08, 0x8f, 0x41, 0x72, 0x9b, 0xec, 0x32, 0x17, 0x57, 0xdd, 0xff, 0xe2, 0x59, 0xe8, 0xdf, 0xd1,
	0xaa, 0x0d, 0x61, 0xaa, 0x47, 0xdb, 0x4c, 0xb5, 0xe1, 0xce, 0xaa, 0x8c, 0x28, 0x9f, 0x38, 0x83,
	0xe4, 0x1f, 0x22, 0x38, 0x79, 0x59, 0xb7, 0x43, 0x2e, 0xb9, 0x43, 0x0c, 0xdc, 0x7e, 0x4f, 0x4c,
	0x74, 0xf4, 0xc4, 0x64, 0xc0, 0x13, 0x7f, 0x82, 0x60, 0x6a, 0x5f, 0x85, 0xb9, 0x4f, 0x56, 0x61,
	0x22, 0x24, 0x9f, 0x12, 0xfb, 0xd5, 0x7d, 0x42, 0xa5, 0x8e, 0xb7, 0xe7, 0x52, 0x76, 0x98, 0xab,
	0x25, 0x42, 0x5c, 0x4d, 0xfe, 0x36, 0x02, 0xec, 0x6a, 0xce, 0xa2, 0xcc, 0x87, 0xc4, 0xbc, 0x83,
	0x01, 0xf3, 0xde, 0x45, 0x30, 0xee, 0x53, 0x92, 0x9b, 0x74, 0x19, 0x06, 0x99, 0x22, 0xc2, 0x8a,
	0xf1, 0x12, 0x39, 0x55, 0xac, 0x8e, 0x6c, 0xad, 0x1f, 0x24, 0xe1, 0x98, 0xab, 0xc8, 0xc3, 0x4a,
	0x22, 0x8e, 0xc3, 0x90, 0x69, 0x95, 0x89, 0xd5, 0x0a, 0xf2, 0xea, 0x20, 0xfd, 0xfe, 0xf0, 0xc6,
	0xf7, 0x57, 0xdd, 0x07, 0x95, 0x78, 0x02, 0xd2, 0x8d, 0x0d, 0xd3, 0xeb, 0x82, 0x4b, 0xb2, 0xa2,
	0xd9, 0xdb, 0xee, 0xa5, 0x85, 0xdc, 0xc7, 0x16, 0xff, 0x0e, 0xb8, 0xcd, 0x50, 0x47, 0xb7, 0x19,
	0x0e, 0xb8, 0xcd, 0x77, 0xfa, 0x98, 0x6f, 0x07, 0xd2, 0x8f, 0xdb, 0x30, 0x5e, 0xd5, 0x6d, 0x87,
	0xd5, 0x4d, 0xec, 0xc0, 0xfd, 0xf0, 0x5a, 0x44, 0x0f, 0x6a, 0xe7, 0xeb, 0x1f, 0x72, 0xef, 0x8d,
	0x63, 0xd5, 0xc0, 0xc8, 0x43, 0xbf, 0x3a, 0xa4, 0x2f, 0x27, 0x60, 0x2c, 0xa8, 0x27, 0x5e, 0x80,
	0x7e, 0x6a, 0x0b, 0xea, 0xbe, 0xa9, 0xdc, 0x6c, 0x44, 0x13, 0x50, 0x1e, 0x2a, 0x5b, 0x8a, 0x77,
	0x61, 0xc4, 0x76, 0x34, 0x87, 0x14, 0x4b, 0x37, 0x35, 0xa3, 0xc2, 0xb0, 0x1d, 0xc9, 0x6d, 0x3c,
	0x38, 0x6b, 0x66, 0xd6, 0x5d, 0xf6, 0x8b, 0x94, 0xbb, 0x9a, 0xb2, 0xf7, 0x3e, 0xe4, 0x57, 0x20,
	0xe5, 0x99, 0xc3, 0x00, 0x03, 0xd7, 0x56, 0xaf, 0xad, 0x2f, 0x15, 0xc6, 0x1e, 0xc1, 0xc3, 0xd0,
	0xaf, 0x14, 0x0a, 0x4b, 0x85, 0x31, 0x84, 0x53, 0x30, 0xa8, 0x2e, 0xad, 0x5c, 0xd9, 0x58, 0x2a,
	0x8c, 0x25, 0x5c, 0x1a, 0x65, 0xf1, 0xea, 0xa5, 0x8d, 0xa5, 0xb1, 0xa4, 0xfc, 0xad, 0x24, 0x0b,
	0x2e, 0x1f, 0x6c, 0xba, 0xf6, 0xff, 0x93, 0x1c, 0xe7, 0x24, 0xdf, 0x1d, 0x84, 0x09, 0xff, 0x1e,
	0xf1, 0xb3, 0xfc, 0x26, 0x82, 0x49, 0x7a, 0x98, 0x79, 0x35, 0x25, 0x78, 0x9c, 0x57, 0x63, 0x38,
	0x60, 0x90, 0x79, 0x70, 0xd0, 0x3d, 0xd2, 0x34, 0x72, 0xf8, 0xc7, 0x1e, 0xfe, 0xa1, 0xfe, 0x0b,
	0x8f, 0x73, 0x7e, 0xbd, 0xf0, 0xc5, 0xbd, 0x3a, 0x15, 0xea, 0xa6, 0x4e, 0xd5, 0x2a, 0x51, 0xe1,
	0x3b, 0xa1, 0x87, 0xfb, 0xfa, 0x83, 0xb5, 0xed, 0xbe, 0x07, 0x1c, 0xdb, 0x30, 0x24, 0x2e, 0x51,
	0x5e, 0x7e, 0xfa, 0xe4, 0x03, 0x16, 0xad, 0x72, 0xf6, 0x6a, 0x4b, 0x90, 0xf4, 0x4b, 0x04, 0x43,
	0x62, 0x18, 0x63, 0x6f, 0xfd, 0x81, 0x55, 0x14, 0xf0, 0x93, 0x30, 0x52, 0xb7, 0xcc, 0xcf, 0x90,
	0x92, 0x53, 0xa4, 0x73, 0xec, 0x7c, 0xa7, 0xf8, 0xd8, 0xaa, 0x4b, 0xf2, 0x3c, 0x4c, 0x08, 0x92,
	0xb2, 0x6e, 0xd7, 0xab, 0xda, 0x2e, 0x23, 0x65, 0x9b, 0x8c, 0xf9, 0x5c, 0x81, 0x4d, 0xd1, 0x15,
	0x53, 0x90, 0x62, 0x81, 0x83, 0x11, 0xf6, 0x51, 0x42, 0x60, 0x43, 0x94, 0x20, 0x03, 0xe3, 0x9c,
	0xc0, 0xc7, 0xb1, 0x9f, 0x12, 0x1e, 0x63, 0x53, 0x1e, 0x86, 0xf2, 0xca, 0xfe, 0xc1, 0x31, 0x05,
	0x83, 0x8b, 0x17, 0x95, 0xd5, 0x65, 0x1a, 0x1e, 0x47, 0x61, 0xf8, 0xda, 0xaa, 0xf8, 0x4c, 0xec,
	0x05, 0xce, 0xa4, 0x37, 0x70, 0xf6, 0xc9, 0x7f, 0x43, 0xf0, 0xe8, 0x3a, 0x11, 0xe6, 0xa3, 0x9c,
	0x45, 0xbc, 0x54, 0x7c, 0x35, 0x9a, 0xd3, 0x34, 0x5a, 0x7e, 0x14, 0x9e, 0xee, 0x1c, 0x2d, 0x85,
	0xab, 0x31, 0x93, 0x5e, 0x81, 0x7e, 0xba, 0xef, 0xdc, 0xc1, 0x5e, 0x8c, 0xe7, 0xaf, 0xcc, 0x81,
	0xd8, 0xb3, 0x97, 0xf1, 0x71, 0x63, 0x96, 0xed, 0x68, 0x96, 0xc3, 0x8e, 0x66, 0xf2, 0xa0, 0xa3,
	0xc9, 0x4b, 0xbd, 0x74, 0x89, 0x3b, 0x28, 0x57, 0x21, 0xad, 0x36, 0x0c, 0x7a, 0x0d, 0x15, 0x44,
	0x7f, 0xe5, 0xd0, 0xb2, 0x3e, 0x37, 0x17, 0x9f, 0xb8, 0x56, 0x2f, 0xb7, 0xd7, 0xb6, 0x57, 0x7a,
	0x3c, 0xc9, 0xfe, 0x8a, 0x33, 0x9e, 0x87, 0x54, 0x83, 0x8a, 0x61, 0xa1, 0x3c, 0x71, 0x50, 0x28,
	0x57, 0x81, 0x91, 0xbb, 0xff, 0x97, 0xbf, 0x94, 0x80, 0x29, 0xa6, 0xe4, 0xfe, 0x25, 0xc8, 0xb7,
	0x50, 0x78, 0xed, 0x18, 0xf5, 0x5a, 0x3b, 0xee, 0xbe, 0x9a, 0x19, 0x52, 0x70, 0xee, 0xcd, 0x0e,
	0xbf, 0x43, 0xf0, 0x24, 0xb3, 0x43, 0xa7, 0xe2, 0x68, 0x03, 0x26, 0x43, 0x9b, 0x47, 0xdc, 0x14,
	0xf3, 0x11, 0x4d, 0x11, 0x26, 0x82, 0x6d, 0xea, 0x84, 0x19, 0x32, 0xd5, 0x1b, 0xb2, 0x6f, 0x20,
	0x18, 0x67, 0xc8, 0xfc, 0x45, 0xd8, 0xbd, 0xaa, 0x39, 0xea, 0xb5, 0x6a, 0xde, 0x9b, 0x82, 0xff,
	0x46, 0x20, 0x71, 0x05, 0xb9, 0xcc, 0x15, 0xcd, 0xda, 0x6e, 0xd9, 0xfc, 0x0d, 0x38, 0xe2, 0xef,
	0xb6, 0x71, 0x7d, 0xa3, 0x86, 0x13, 0x1f, 0x53, 0xa6, 0xf6, 0xa8, 0xed, 0x1d, 0xeb, 0x49, 0x7b,
	0x7c, 0x36, 0x5e, 0x4c, 0xf2, 0x84, 0xa3, 0xdc, 0xdd, 0xe7, 0xe0, 0x88, 0xd0, 0x6e, 0x91, 0xaa,
	0x8d, 0x7f, 0x85, 0x60, 0xc4, 0xdb, 0x34, 0xc1, 0xf9, 0x88, 0x28, 0x43, 0x3a, 0x2d, 0x52, 0xbc,
	0x1d, 0x95, 0x5f, 0x6f, 0x2a, 0xa3, 0x2c, 0x74, 0xcd, 0xb2, 0x6d, 0x7d, 0xf3, 0xb7, 0xf7, 0xbf,
	0x92, 0xf8, 0x98, 0xfc, 0x9c, 0xa7, 0x77, 0xf9, 0x79, 0x46, 0xf0, 0x8a, 0xd7, 0x4d, 0xed, 0xec,
	0xa9, 0x3b, 0xbc, 0xa9, 0x69, 0xe7, 0x85, 0x47, 0xbc, 0x8f, 0x60, 0xd4, 0xd7, 0xd8, 0xc3, 0xf3,
	0xb1, 0x90, 0xf8, 0x43, 0xa6, 0x14, 0x33, 0x42, 0xca, 0x5f, 0x68, 0x2a, 0xc7, 0x39, 0x96, 0xbd,
	0x06, 0xa0, 0xf8, 0x6f, 0xdb, 0x9c, 0x87, 0x86, 0x62, 0x56, 0xe4, 0x97, 0x0e, 0xc6, 0x2c, 0x20,
	0xbb, 0xe8, 0x45, 0xba, 0x9a, 0x6f, 0x05, 0xe5, 0x9f, 0x26, 0x20, 0xbd, 0x5f, 0x1b, 0x10, 0x5f,
	0x88, 0x65, 0x8a, 0x7d, 0x03, 0xb3, 0xd4, 0x7d, 0xe8, 0x95, 0xbf, 0x8a, 0x9a, 0xca, 0x53, 0xdc,
	0x0a, 0xad, 0xce, 0xe1, 0x6c, 0x48, 0x94, 0x6f, 0x2a, 0x12, 0x27, 0x0b, 0x99, 0xa4, 0xd6, 0x5a,
	0x95, 0x5f, 0x8e, 0xe2, 0x21, 0x21, 0x65, 0xad, 0x7c, 0xd8, 0xb5, 0x82, 0x7f, 0x81, 0x20, 0xbd,
	0x5f, 0x0f, 0x2e, 0xb2, 0xe9, 0x0e, 0x68, 0xe2, 0x49, 0xed, 0x65, 0xcb, 0xa5, 0x5a, 0xdd, 0xd9,
	0x95, 0x2f, 0x34, 0x15, 0x9a, 0xbc, 0x50, 0x64, 0x67, 0x4f, 0xf9, 0x90, 0xb9, 0xe3, 0x6d, 0x5e,
	0x10, 0x02, 0x2b, 0x7b, 0xea, 0x0e, 0xfe, 0x3a, 0x82, 0x91, 0x65, 0xe2, 0x5c, 0xd2, 0x6a, 0x6b,
	0xb4, 0x65, 0x8f, 0x65, 0x21, 0x50, 0xd7, 0x6a, 0x99, 0x9d, 0xb9, 0x8c, 0x77, 0x52, 0x28, 0x35,
	0x19, 0xa0, 0x61, 0xb3, 0xb2, 0xda, 0x54, 0x5a, 0x89, 0x2c, 0xf7, 0xcf, 0x73, 0x5e, 0xbd, 0xc4,
	0x5c, 0x07, 0x0f, 0xcd, 0x57, 0x3c, 0xe2, 0xf2, 0xe8, 0x14, 0xfe, 0x23, 0x82, 0xc9, 0xd0, 0xbe,
	0x23, 0x5e, 0x8c, 0x5a, 0x6a, 0xee, 0xd0, 0xb5, 0xec, 0xc5, 0x33, 0xfd, 0x3b, 0x80, 0xbb, 0xde,
	0x81, 0xfb, 0x08, 0x1e, 0xdb, 0xa7, 0xd7, 0x89, 0x97, 0xa2, 0x63, 0xec, 0x90, 0x0e, 0x48, 0xbd,
	0xdc, 0xf7, 0xf2, 0x92, 0x17, 0xe7, 0x19, 0xfc, 0xd2, 0x81, 0x38, 0xc3, 0x52, 0x83, 0x3b, 0xf8,
	0x47, 0x08, 0x86, 0x5b, 0x0d, 0x56, 0xfc, 0x72, 0x74, 0x60, 0x3d, 0xdd, 0x15, 0x79, 0xaf, 0xf2,
	0xa7, 0xf1, 0x73, 0x07, 0x2a, 0xbf, 0xe7, 0x8a, 0xf8, 0xe7, 0xa2, 0xdf, 0xc1, 0xea, 0x41, 0xf8,
	0x6c, 0x9c, 0xde, 0x86, 0xaf, 0x54, 0x2b, 0xe5, 0xbb, 0x59, 0xca, 0xde, 0x8d, 0xf2, 0x3c, 0xbf,
	0xde, 0x9e, 0x8f, 0x12, 0xbc, 0x58, 0x71, 0x31, 0x4f, 0x3b, 0x47, 0xee, 0xf1, 0xf9, 0x13, 0x82,
	0x51, 0x5f, 0xaf, 0x2a, 0xf2, 0xf5, 0x16, 0xd6, 0x4b, 0x94, 0xce, 0x75, 0xb7, 0x98, 0x23, 0xf9,
	0x74, 0x53, 0x39, 0xca, 0x63, 0xb4, 0x68, 0x93, 0x85, 0x85, 0x89, 0x18, 0xd7, 0x58, 0x0b, 0xe7,
	0xcf, 0x10, 0xc0, 0x5e, 0xe9, 0x0e, 0x9f, 0xe9, 0xa2, 0x00, 0x18, 0x2f, 0x20, 0xb4, 0x97, 0x0e,
	0xe5, 0xf9, 0xa6, 0xc2, 0x9f, 0x54, 0x14, 0xd5, 0x2c, 0x3e, 0x15, 0x7d, 0xc7, 0xf0, 0xaf, 0x11,
	0x8c, 0x78, 0x2b, 0x04, 0x91, 0x13, 0xaa, 0x90, 0x1a, 0x62, 0xe4, 0xf3, 0x1e, 0x56, 0xa7, 0x90,
	0x97, 0xfd, 0x30, 0x02, 0x27, 0x3e, 0xfa, 0xe6, 0xe0, 0x7f, 0x22, 0x78, 0x6c, 0x9f, 0xee, 0x54,
	0xe4, 0xc0, 0xd6, 0xb9, 0x1d, 0x27, 0x5d, 0xe8, 0x95, 0x0d, 0xc7, 0x7c, 0xd1, 0x8f, 0x39, 0x10,
	0xcd, 0x63, 0x64, 0x0a, 0x6e, 0x52, 0x90, 0xf2, 0xf4, 0x8c, 0x70, 0x1c, 0x7f, 0xf2, 0x37, 0xc3,
	0xa4, 0x7c, 0x37, 0x4b, 0x39, 0xa0, 0x73, 0x7e, 0x40, 0x81, 0xc8, 0x77, 0x40, 0x72, 0x8c, 0xbf,
	0x96, 0x80, 0x63, 0x6d, 0x05, 0x08, 0x7c, 0x3e, 0xa2, 0x3e, 0xfb, 0x95, 0x2e, 0xa4, 0x13, 0x82,
	0x81, 0xe7, 0x87, 0x80, 0x99, 0x2b, 0xe2, 0x87, 0x80, 0xf2, 0x77, 0xd1, 0x3d, 0xe5, 0x53, 0x70,
	0xbe, 0x6b, 0x21, 0xbc, 0x36, 0x3b, 0x19, 0x9a, 0x30, 0xf9, 0xed, 0x71, 0x2e, 0x5a, 0x2a, 0xc8,
	0xa3, 0xa9, 0xd5, 0x30, 0x5a, 0x62, 0xdc, 0x60, 0x73, 0x1f, 0xc1, 0xd1, 0x40, 0x35, 0x0a, 0xbf,
	0x12, 0xf9, 0x95, 0x17, 0x56, 0xc5, 0x8a, 0xfd, 0x6e, 0xd8, 0x6c, 0x2a, 0x93, 0xee, 0xfd, 0x35,
	0x4b, 0x0b, 0x4e, 0xb3, 0x7b, 0x2f, 0x3b, 0x0a, 0xaf, 0x20, 0x9f, 0x8f, 0x7e, 0xd1, 0xb5, 0x0e,
	0xac, 0x9b, 0x7e, 0xd9, 0xc4, 0xa1, 0x7a, 0xb9, 0x30, 0xdf, 0x42, 0x30, 0xb2, 0xde, 0x29, 0x35,
	0x5c, 0x8f, 0x9e, 0x1a, 0xba, 0xa1, 0x5f, 0xa4, 0x7f, 0xb3, 0xec, 0xc7, 0xa1, 0xdd, 0x66, 0x88,
	0x76, 0x20, 0x43, 0x7c, 0x07, 0x01, 0xbe, 0x4a, 0x6c, 0x3a, 0x48, 0xac, 0x9a, 0x6e, 0xdb, 0xee,
	0x1a, 0x3c, 0x13, 0x50, 0xa4, 0x9d, 0x44, 0xa8, 0xfc, 0x6c, 0x04, 0x4a, 0x7e, 0xac, 0xca, 0x4d,
	0x65, 0x62, 0x0f, 0xc6, 0x1e, 0x01, 0xc5, 0xb2, 0x2c, 0x2f, 0xc4, 0xc5, 0xe2, 0xb4, 0x89, 0x72,
	0x11, 0xfd, 0x1d, 0xc1, 0xa8, 0xaf, 0x20, 0x17, 0xf9, 0xd2, 0x0e, 0x2b, 0xe3, 0xc5, 0xf6, 0x2d,
	0xb3, 0xa9, 0x0c, 0xb6, 0x5e, 0xa0, 0xe3, 0xe2, 0xe9, 0xe9, 0xa9, 0x3c, 0x50, 0xb4, 0x97, 0x72,
	0xaf, 0x7a, 0xd1, 0x8a, 0x5f, 0x48, 0xc7, 0xf0, 0xb5, 0xd6, 0x1b, 0xf4, 0xed, 0x04, 0xa4, 0xf7,
	0xab, 0xed, 0x45, 0x7e, 0x48, 0x1d, 0x50, 0x1c, 0xec, 0x25, 0xd3, 0xff, 0x26, 0x6a, 0x2a, 0xe3,
	0xa1, 0x4f, 0xce, 0xa9, 0x90, 0xd1, 0x36, 0x4b, 0x6d, 0xe6, 0x5e, 0xf7, 0x9d, 0xc6, 0x90, 0x9f,
	0x85, 0xc7, 0x78, 0x2f, 0x84, 0xbf, 0x45, 0xbf, 0x97, 0x10, 0xb5, 0xa9, 0xd0, 0x77, 0xc4, 0xc5,
	0x58, 0x46, 0x3c, 0xb4, 0xa7, 0xc4, 0x17, 0x51, 0x53, 0x09, 0x2f, 0x4c, 0x52, 0x43, 0x91, 0xdc,
	0x65, 0xaf, 0xa1, 0xc2, 0x7f, 0xfe, 0x1e, 0xfd, 0xc9, 0x91, 0x0f, 0x17, 0x85, 0x7f, 0x8f, 0x60,
	0xc4, 0x5b, 0x68, 0x8c, 0x9c, 0x6a, 0x85, 0x54, 0x27, 0xe3, 0xbe, 0x47, 0xde, 0x68, 0x2a, 0xbc,
	0xf2, 0xd4, 0x54, 0x30, 0x8f, 0x23, 0x41, 0x7f, 0x39, 0x97, 0xcb, 0x79, 0xcd, 0xc0, 0x7f, 0x86,
	0x7f, 0xc0, 0x6b, 0xa5, 0x55, 0xd0, 0xba, 0x9b, 0x6c, 0x95, 0x51, 0x7d, 0xc5, 0x43, 0x25, 0x1e,
	0xc8, 0x90, 0x0a, 0xa7, 0xd4, 0x55, 0x25, 0x53, 0x7e, 0x0f, 0x35, 0x95, 0x40, 0x65, 0xb4, 0xa9,
	0x48, 0xfe, 0x81, 0x36, 0x1b, 0xbc, 0x8d, 0x72, 0xcb, 0x3e, 0x23, 0xf8, 0xff, 0x8e, 0x21, 0xd4,
	0x18, 0xec, 0xb6, 0x76, 0xad, 0xe2, 0x95, 0x7f, 0x27, 0x1f, 0x10, 0x7e, 0x9d, 0xe4, 0xd6, 0xe3,
	0xb2, 0x0e, 0x0b, 0x60, 0x07, 0x88, 0x91, 0x3e, 0x71, 0x4f, 0x39, 0xd1, 0xb1, 0x5f, 0xf0, 0x1b,
	0x25, 0x73, 0xd3, 0x71, 0xea, 0x76, 0x3e, 0x9b, 0xbd, 0x75, 0xeb, 0x56, 0xb0, 0x99, 0xa0, 0x35,
	0x9c, 0x9b, 0xec, 0x2f, 0x34, 0x4e, 0xd7, 0xab, 0x9a, 0xb3, 0x65, 0x5a, 0xb5, 0x85, 0xf7, 0x11,
	0x3c, 0x5b, 0x32, 0x6b, 0xd1, 0xb6, 0x61, 0x0d, 0x5d, 0x5f, 0xe7, 0x84, 0x15, 0xb3, 0xaa, 0x19,
	0x95, 0x8c, 0x69, 0x55, 0xb2, 0x15, 0x62, 0xd0, 0xc4, 0x28, 0xbb, 0x27, 0xee, 0x80, 0xbf, 0x03,
	0x99, 0xf7, 0x4f, 0x7c, 0x3f, 0xf1, 0xf4, 0x32, 0xe3, 0xba, 0x48, 0xc5, 0xfb, 0x0b, 0xc3, 0x99,
	0x8d, 0xb9, 0xb5, 0xb9, 0x05, 0x77, 0xd9, 0x3d, 0x41, 0x77, 0x83, 0xd2, 0xdd, 0xf0, 0xd3, 0xdd,
	0xd8, 0x10, 0xec, 0xff, 0x9a, 0x98, 0x61, 0x74, 0xf9, 0x3c, 0x25, 0xcc, 0xe7, 0xfd, 0x94, 0xf9,
	0xbc, 0x4b, 0x4a, 0x59, 0xae, 0x3d, 0xb2, 0x39, 0x40, 0x95, 0x7f, 0xe1, 0xbf, 0x01, 0x00, 0x00,
	0xff, 0xff, 0x42, 0x49, 0x3f, 0x56, 0x13, 0x35, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SecurityCenterClient is the client API for SecurityCenter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityCenterClient interface {
	// Creates a source.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	//
	// Creates a finding. The corresponding source must exist for finding
	// creation to succeed.
	CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Creates a notification config.
	CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Deletes a notification config.
	DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets a notification config.
	GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Gets a source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1p1beta1/organizations/{organization_id}/sources/-/findings
	GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error)
	// Lists an organization's assets.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1p1beta1/organizations/{organization_id}/sources/-/findings
	ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	//
	// Updates the state of a finding.
	SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	//
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates a notification config.
	UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Updates a source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error)
}

type securityCenterClient struct {
	cc *grpc.ClientConn
}

func NewSecurityCenterClient(cc *grpc.ClientConn) SecurityCenterClient {
	return &securityCenterClient{cc}
}

func (c *securityCenterClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/CreateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/CreateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/CreateNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/DeleteNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GetNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GetOrganizationSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GetSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error) {
	out := new(GroupAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GroupAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error) {
	out := new(GroupFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GroupFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/ListAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error) {
	out := new(ListFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/ListFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error) {
	out := new(ListNotificationConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/ListNotificationConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/ListSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/RunAssetDiscovery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/SetFindingState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateOrganizationSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error) {
	out := new(SecurityMarks)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateSecurityMarks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterServer is the server API for SecurityCenter service.
type SecurityCenterServer interface {
	// Creates a source.
	CreateSource(context.Context, *CreateSourceRequest) (*Source, error)
	//
	// Creates a finding. The corresponding source must exist for finding
	// creation to succeed.
	CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error)
	// Creates a notification config.
	CreateNotificationConfig(context.Context, *CreateNotificationConfigRequest) (*NotificationConfig, error)
	// Deletes a notification config.
	DeleteNotificationConfig(context.Context, *DeleteNotificationConfigRequest) (*empty.Empty, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Gets a notification config.
	GetNotificationConfig(context.Context, *GetNotificationConfigRequest) (*NotificationConfig, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Gets a source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1p1beta1/organizations/{organization_id}/sources/-/findings
	GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error)
	// Lists an organization's assets.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1p1beta1/organizations/{organization_id}/sources/-/findings
	ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(context.Context, *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunning.Operation, error)
	//
	// Updates the state of a finding.
	SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	//
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error)
	// Updates a notification config.
	UpdateNotificationConfig(context.Context, *UpdateNotificationConfigRequest) (*NotificationConfig, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Updates a source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error)
}

// UnimplementedSecurityCenterServer can be embedded to have forward compatible implementations.
type UnimplementedSecurityCenterServer struct {
}

func (*UnimplementedSecurityCenterServer) CreateSource(ctx context.Context, req *CreateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSource not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateFinding(ctx context.Context, req *CreateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFinding not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateNotificationConfig(ctx context.Context, req *CreateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteNotificationConfig(ctx context.Context, req *DeleteNotificationConfigRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedSecurityCenterServer) GetNotificationConfig(ctx context.Context, req *GetNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetOrganizationSettings(ctx context.Context, req *GetOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganizationSettings not implemented")
}
func (*UnimplementedSecurityCenterServer) GetSource(ctx context.Context, req *GetSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSource not implemented")
}
func (*UnimplementedSecurityCenterServer) GroupAssets(ctx context.Context, req *GroupAssetsRequest) (*GroupAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupAssets not implemented")
}
func (*UnimplementedSecurityCenterServer) GroupFindings(ctx context.Context, req *GroupFindingsRequest) (*GroupFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) ListAssets(ctx context.Context, req *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (*UnimplementedSecurityCenterServer) ListFindings(ctx context.Context, req *ListFindingsRequest) (*ListFindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) ListNotificationConfigs(ctx context.Context, req *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotificationConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) ListSources(ctx context.Context, req *ListSourcesRequest) (*ListSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSources not implemented")
}
func (*UnimplementedSecurityCenterServer) RunAssetDiscovery(ctx context.Context, req *RunAssetDiscoveryRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunAssetDiscovery not implemented")
}
func (*UnimplementedSecurityCenterServer) SetFindingState(ctx context.Context, req *SetFindingStateRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetFindingState not implemented")
}
func (*UnimplementedSecurityCenterServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedSecurityCenterServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateFinding(ctx context.Context, req *UpdateFindingRequest) (*Finding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFinding not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateNotificationConfig(ctx context.Context, req *UpdateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateOrganizationSettings(ctx context.Context, req *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOrganizationSettings not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateSource(ctx context.Context, req *UpdateSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSource not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateSecurityMarks(ctx context.Context, req *UpdateSecurityMarksRequest) (*SecurityMarks, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecurityMarks not implemented")
}

func RegisterSecurityCenterServer(s *grpc.Server, srv SecurityCenterServer) {
	s.RegisterService(&_SecurityCenter_serviceDesc, srv)
}

func _SecurityCenter_CreateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/CreateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateSource(ctx, req.(*CreateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/CreateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateFinding(ctx, req.(*CreateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/CreateNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, req.(*CreateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/DeleteNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, req.(*DeleteNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GetNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, req.(*GetNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GetOrganizationSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, req.(*GetOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GetSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSource(ctx, req.(*GetSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GroupAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupAssets(ctx, req.(*GroupAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/GroupFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupFindings(ctx, req.(*GroupFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/ListAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/ListFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListFindings(ctx, req.(*ListFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListNotificationConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/ListNotificationConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, req.(*ListNotificationConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/ListSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListSources(ctx, req.(*ListSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_RunAssetDiscovery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunAssetDiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/RunAssetDiscovery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, req.(*RunAssetDiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetFindingState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFindingStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetFindingState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/SetFindingState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetFindingState(ctx, req.(*SetFindingStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, req.(*UpdateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, req.(*UpdateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateOrganizationSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, req.(*UpdateOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSource(ctx, req.(*UpdateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSecurityMarks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityMarksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1p1beta1.SecurityCenter/UpdateSecurityMarks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, req.(*UpdateSecurityMarksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityCenter_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycenter.v1p1beta1.SecurityCenter",
	HandlerType: (*SecurityCenterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSource",
			Handler:    _SecurityCenter_CreateSource_Handler,
		},
		{
			MethodName: "CreateFinding",
			Handler:    _SecurityCenter_CreateFinding_Handler,
		},
		{
			MethodName: "CreateNotificationConfig",
			Handler:    _SecurityCenter_CreateNotificationConfig_Handler,
		},
		{
			MethodName: "DeleteNotificationConfig",
			Handler:    _SecurityCenter_DeleteNotificationConfig_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SecurityCenter_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetNotificationConfig",
			Handler:    _SecurityCenter_GetNotificationConfig_Handler,
		},
		{
			MethodName: "GetOrganizationSettings",
			Handler:    _SecurityCenter_GetOrganizationSettings_Handler,
		},
		{
			MethodName: "GetSource",
			Handler:    _SecurityCenter_GetSource_Handler,
		},
		{
			MethodName: "GroupAssets",
			Handler:    _SecurityCenter_GroupAssets_Handler,
		},
		{
			MethodName: "GroupFindings",
			Handler:    _SecurityCenter_GroupFindings_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _SecurityCenter_ListAssets_Handler,
		},
		{
			MethodName: "ListFindings",
			Handler:    _SecurityCenter_ListFindings_Handler,
		},
		{
			MethodName: "ListNotificationConfigs",
			Handler:    _SecurityCenter_ListNotificationConfigs_Handler,
		},
		{
			MethodName: "ListSources",
			Handler:    _SecurityCenter_ListSources_Handler,
		},
		{
			MethodName: "RunAssetDiscovery",
			Handler:    _SecurityCenter_RunAssetDiscovery_Handler,
		},
		{
			MethodName: "SetFindingState",
			Handler:    _SecurityCenter_SetFindingState_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SecurityCenter_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SecurityCenter_TestIamPermissions_Handler,
		},
		{
			MethodName: "UpdateFinding",
			Handler:    _SecurityCenter_UpdateFinding_Handler,
		},
		{
			MethodName: "UpdateNotificationConfig",
			Handler:    _SecurityCenter_UpdateNotificationConfig_Handler,
		},
		{
			MethodName: "UpdateOrganizationSettings",
			Handler:    _SecurityCenter_UpdateOrganizationSettings_Handler,
		},
		{
			MethodName: "UpdateSource",
			Handler:    _SecurityCenter_UpdateSource_Handler,
		},
		{
			MethodName: "UpdateSecurityMarks",
			Handler:    _SecurityCenter_UpdateSecurityMarks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycenter/v1p1beta1/securitycenter_service.proto",
}
