/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// SecurityGroupProperties struct for SecurityGroupProperties
type SecurityGroupProperties struct {
	// The name of the security group.
	Name *string `json:"name"`
	// The description of the security group.
	Description *string `json:"description,omitempty"`
}

// NewSecurityGroupProperties instantiates a new SecurityGroupProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSecurityGroupProperties(name string) *SecurityGroupProperties {
	this := SecurityGroupProperties{}

	this.Name = &name

	return &this
}

// NewSecurityGroupPropertiesWithDefaults instantiates a new SecurityGroupProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSecurityGroupPropertiesWithDefaults() *SecurityGroupProperties {
	this := SecurityGroupProperties{}
	return &this
}

// GetName returns the Name field value
// If the value is explicit nil, nil is returned
func (o *SecurityGroupProperties) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name

}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SecurityGroupProperties) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Name, true
}

// SetName sets field value
func (o *SecurityGroupProperties) SetName(v string) {

	o.Name = &v

}

// HasName returns a boolean if a field has been set.
func (o *SecurityGroupProperties) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// GetDescription returns the Description field value
// If the value is explicit nil, nil is returned
func (o *SecurityGroupProperties) GetDescription() *string {
	if o == nil {
		return nil
	}

	return o.Description

}

// GetDescriptionOk returns a tuple with the Description field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SecurityGroupProperties) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Description, true
}

// SetDescription sets field value
func (o *SecurityGroupProperties) SetDescription(v string) {

	o.Description = &v

}

// HasDescription returns a boolean if a field has been set.
func (o *SecurityGroupProperties) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

func (o SecurityGroupProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}

	if o.Description != nil {
		toSerialize["description"] = o.Description
	}

	return json.Marshal(toSerialize)
}

type NullableSecurityGroupProperties struct {
	value *SecurityGroupProperties
	isSet bool
}

func (v NullableSecurityGroupProperties) Get() *SecurityGroupProperties {
	return v.value
}

func (v *NullableSecurityGroupProperties) Set(val *SecurityGroupProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableSecurityGroupProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableSecurityGroupProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSecurityGroupProperties(val *SecurityGroupProperties) *NullableSecurityGroupProperties {
	return &NullableSecurityGroupProperties{value: val, isSet: true}
}

func (v NullableSecurityGroupProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSecurityGroupProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
