/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// ApplicationLoadBalancerForwardingRule struct for ApplicationLoadBalancerForwardingRule
type ApplicationLoadBalancerForwardingRule struct {
	// The URL to the object representation (absolute path).
	Href *string `json:"href,omitempty"`
	// The resource's unique identifier.
	Id         *string                                          `json:"id,omitempty"`
	Metadata   *DatacenterElementMetadata                       `json:"metadata,omitempty"`
	Properties *ApplicationLoadBalancerForwardingRuleProperties `json:"properties"`
	// The type of object that has been created.
	Type *Type `json:"type,omitempty"`
}

// NewApplicationLoadBalancerForwardingRule instantiates a new ApplicationLoadBalancerForwardingRule object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewApplicationLoadBalancerForwardingRule(properties ApplicationLoadBalancerForwardingRuleProperties) *ApplicationLoadBalancerForwardingRule {
	this := ApplicationLoadBalancerForwardingRule{}

	this.Properties = &properties

	return &this
}

// NewApplicationLoadBalancerForwardingRuleWithDefaults instantiates a new ApplicationLoadBalancerForwardingRule object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewApplicationLoadBalancerForwardingRuleWithDefaults() *ApplicationLoadBalancerForwardingRule {
	this := ApplicationLoadBalancerForwardingRule{}
	return &this
}

// GetHref returns the Href field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerForwardingRule) GetHref() *string {
	if o == nil {
		return nil
	}

	return o.Href

}

// GetHrefOk returns a tuple with the Href field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerForwardingRule) GetHrefOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Href, true
}

// SetHref sets field value
func (o *ApplicationLoadBalancerForwardingRule) SetHref(v string) {

	o.Href = &v

}

// HasHref returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerForwardingRule) HasHref() bool {
	if o != nil && o.Href != nil {
		return true
	}

	return false
}

// GetId returns the Id field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerForwardingRule) GetId() *string {
	if o == nil {
		return nil
	}

	return o.Id

}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerForwardingRule) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Id, true
}

// SetId sets field value
func (o *ApplicationLoadBalancerForwardingRule) SetId(v string) {

	o.Id = &v

}

// HasId returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerForwardingRule) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// GetMetadata returns the Metadata field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerForwardingRule) GetMetadata() *DatacenterElementMetadata {
	if o == nil {
		return nil
	}

	return o.Metadata

}

// GetMetadataOk returns a tuple with the Metadata field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerForwardingRule) GetMetadataOk() (*DatacenterElementMetadata, bool) {
	if o == nil {
		return nil, false
	}

	return o.Metadata, true
}

// SetMetadata sets field value
func (o *ApplicationLoadBalancerForwardingRule) SetMetadata(v DatacenterElementMetadata) {

	o.Metadata = &v

}

// HasMetadata returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerForwardingRule) HasMetadata() bool {
	if o != nil && o.Metadata != nil {
		return true
	}

	return false
}

// GetProperties returns the Properties field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerForwardingRule) GetProperties() *ApplicationLoadBalancerForwardingRuleProperties {
	if o == nil {
		return nil
	}

	return o.Properties

}

// GetPropertiesOk returns a tuple with the Properties field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerForwardingRule) GetPropertiesOk() (*ApplicationLoadBalancerForwardingRuleProperties, bool) {
	if o == nil {
		return nil, false
	}

	return o.Properties, true
}

// SetProperties sets field value
func (o *ApplicationLoadBalancerForwardingRule) SetProperties(v ApplicationLoadBalancerForwardingRuleProperties) {

	o.Properties = &v

}

// HasProperties returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerForwardingRule) HasProperties() bool {
	if o != nil && o.Properties != nil {
		return true
	}

	return false
}

// GetType returns the Type field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerForwardingRule) GetType() *Type {
	if o == nil {
		return nil
	}

	return o.Type

}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerForwardingRule) GetTypeOk() (*Type, bool) {
	if o == nil {
		return nil, false
	}

	return o.Type, true
}

// SetType sets field value
func (o *ApplicationLoadBalancerForwardingRule) SetType(v Type) {

	o.Type = &v

}

// HasType returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerForwardingRule) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

func (o ApplicationLoadBalancerForwardingRule) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Href != nil {
		toSerialize["href"] = o.Href
	}

	if o.Id != nil {
		toSerialize["id"] = o.Id
	}

	if o.Metadata != nil {
		toSerialize["metadata"] = o.Metadata
	}

	if o.Properties != nil {
		toSerialize["properties"] = o.Properties
	}

	if o.Type != nil {
		toSerialize["type"] = o.Type
	}

	return json.Marshal(toSerialize)
}

type NullableApplicationLoadBalancerForwardingRule struct {
	value *ApplicationLoadBalancerForwardingRule
	isSet bool
}

func (v NullableApplicationLoadBalancerForwardingRule) Get() *ApplicationLoadBalancerForwardingRule {
	return v.value
}

func (v *NullableApplicationLoadBalancerForwardingRule) Set(val *ApplicationLoadBalancerForwardingRule) {
	v.value = val
	v.isSet = true
}

func (v NullableApplicationLoadBalancerForwardingRule) IsSet() bool {
	return v.isSet
}

func (v *NullableApplicationLoadBalancerForwardingRule) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableApplicationLoadBalancerForwardingRule(val *ApplicationLoadBalancerForwardingRule) *NullableApplicationLoadBalancerForwardingRule {
	return &NullableApplicationLoadBalancerForwardingRule{value: val, isSet: true}
}

func (v NullableApplicationLoadBalancerForwardingRule) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableApplicationLoadBalancerForwardingRule) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
