package runtime

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v3.0/luis/runtime"

// DynamicList defines an extension for a list entity.
type DynamicList struct {
	// ListEntityName - The name of the list entity to extend.
	ListEntityName *string `json:"listEntityName,omitempty"`
	// RequestLists - The lists to append on the extended list entity.
	RequestLists *[]RequestList `json:"requestLists,omitempty"`
}

// Error represents the error that occurred.
type Error struct {
	Error *ErrorBody `json:"error,omitempty"`
}

// ErrorBody represents the definition of the error that occurred.
type ErrorBody struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// ExternalEntity defines a user predicted entity that extends an already existing one.
type ExternalEntity struct {
	// EntityName - The name of the entity to extend.
	EntityName *string `json:"entityName,omitempty"`
	// StartIndex - The start character index of the predicted entity.
	StartIndex *int32 `json:"startIndex,omitempty"`
	// EntityLength - The length of the predicted entity.
	EntityLength *int32 `json:"entityLength,omitempty"`
	// Resolution - A user supplied custom resolution to return as the entity's prediction.
	Resolution interface{} `json:"resolution,omitempty"`
	// Score - A user supplied score to return as the entity's prediction score.
	Score *float64 `json:"score,omitempty"`
}

// Intent represents an intent prediction.
type Intent struct {
	// Score - The score of the fired intent.
	Score *float64 `json:"score,omitempty"`
	// ChildApp - The prediction of the dispatched application.
	ChildApp *Prediction `json:"childApp,omitempty"`
}

// Prediction represents the prediction of a query.
type Prediction struct {
	// AlteredQuery - The query after spell checking. Only set if spell check was enabled and a spelling mistake was found.
	AlteredQuery *string `json:"alteredQuery,omitempty"`
	// TopIntent - The name of the top scoring intent.
	TopIntent *string `json:"topIntent,omitempty"`
	// Intents - A dictionary representing the intents that fired.
	Intents map[string]*Intent `json:"intents"`
	// Entities - A dictionary representing the entities that fired.
	Entities map[string]interface{} `json:"entities"`
	// Sentiment - The result of the sentiment analysis.
	Sentiment *Sentiment `json:"sentiment,omitempty"`
}

// MarshalJSON is the custom marshaler for Prediction.
func (p Prediction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.AlteredQuery != nil {
		objectMap["alteredQuery"] = p.AlteredQuery
	}
	if p.TopIntent != nil {
		objectMap["topIntent"] = p.TopIntent
	}
	if p.Intents != nil {
		objectMap["intents"] = p.Intents
	}
	if p.Entities != nil {
		objectMap["entities"] = p.Entities
	}
	if p.Sentiment != nil {
		objectMap["sentiment"] = p.Sentiment
	}
	return json.Marshal(objectMap)
}

// PredictionRequest represents the prediction request parameters.
type PredictionRequest struct {
	// Query - The query to predict.
	Query *string `json:"query,omitempty"`
	// Options - The custom options defined for this request.
	Options *PredictionRequestOptions `json:"options,omitempty"`
	// ExternalEntities - The externally predicted entities for this request.
	ExternalEntities *[]ExternalEntity `json:"externalEntities,omitempty"`
	// DynamicLists - The dynamically created list entities for this request.
	DynamicLists *[]DynamicList `json:"dynamicLists,omitempty"`
}

// PredictionRequestOptions the custom options for the prediction request.
type PredictionRequestOptions struct {
	// DatetimeReference - The reference DateTime used for predicting datetime entities.
	DatetimeReference *date.Time `json:"datetimeReference,omitempty"`
	// PreferExternalEntities - Whether to make the external entities resolution override the predictions if an overlap occurs.
	PreferExternalEntities *bool `json:"preferExternalEntities,omitempty"`
}

// PredictionResponse represents the prediction response.
type PredictionResponse struct {
	autorest.Response `json:"-"`
	// Query - The query used in the prediction.
	Query *string `json:"query,omitempty"`
	// Prediction - The prediction of the requested query.
	Prediction *Prediction `json:"prediction,omitempty"`
}

// RequestList defines a sub-list to append to an existing list entity.
type RequestList struct {
	// Name - The name of the sub-list.
	Name *string `json:"name,omitempty"`
	// CanonicalForm - The canonical form of the sub-list.
	CanonicalForm *string `json:"canonicalForm,omitempty"`
	// Synonyms - The synonyms of the canonical form.
	Synonyms *[]string `json:"synonyms,omitempty"`
}

// Sentiment the result of the sentiment analysis.
type Sentiment struct {
	// Label - The label of the sentiment analysis result.
	Label *string `json:"label,omitempty"`
	// Score - The sentiment score of the query.
	Score *float64 `json:"score,omitempty"`
}
