package newssearchapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v1.0/newssearch"
)

// NewsClientAPI contains the set of methods on the NewsClient type.
type NewsClientAPI interface {
	Category(ctx context.Context, acceptLanguage string, userAgent string, clientID string, clientIP string, location string, countryCode string, category string, count *int32, headlineCount *int32, market string, offset *int32, originalImage *bool, safeSearch newssearch.SafeSearch, setLang string, textDecorations *bool, textFormat newssearch.TextFormat) (result newssearch.News, err error)
	Search(ctx context.Context, query string, acceptLanguage string, userAgent string, clientID string, clientIP string, location string, countryCode string, count *int32, freshness newssearch.Freshness, market string, offset *int32, originalImage *bool, safeSearch newssearch.SafeSearch, setLang string, sortBy string, textDecorations *bool, textFormat newssearch.TextFormat) (result newssearch.News, err error)
	Trending(ctx context.Context, acceptLanguage string, userAgent string, clientID string, clientIP string, location string, countryCode string, count *int32, market string, offset *int32, safeSearch newssearch.SafeSearch, setLang string, since *int64, sortBy string, textDecorations *bool, textFormat newssearch.TextFormat) (result newssearch.TrendingTopics, err error)
}

var _ NewsClientAPI = (*newssearch.NewsClient)(nil)
