/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2006-2011 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMDATABASE_H
#define GMDATABASE_H

class GMQuery;

class GMDatabase {
friend class GMQuery;
private:
  FXbool opened;
  GMDatabaseEngine * db;
public:
  /// Constructor: database is not opened
  GMDatabase();

  /// Open Database; Return TRUE if succeeds else FALSE
  FXbool open(const FXString & filename);

  /// Return error message of last failed function
  const FXchar * getError();

  /// Return TRUE if database is opened
  FXbool isOpen() { return opened; }

  /// Close Database
  void close();

  /// Clear Database
  void clear();

  /// Clear Tables
  void clearTables();

  /// Begin Transaction
  FXbool begin();

  /// Commit Transaction()
  FXbool commit();

  /// Rollback a transaction
  FXbool rollback();

  /// End Transaction
  FXbool end();

  /// Return Last Inserted Row Id
  FXint lastInsertRow();


  FXint changes() const;

  /// Set Version
  void setVersion(FXint v);

  /// Get Version
  FXint getVersion();

  /// Return TRUE if table exists
  FXbool hasTable(const FXString & table);

  /// Return TRUE if view exists
  FXbool hasView(const FXString & view);

  /// Return TRUE if index exists
  FXbool hasIndex(const FXString & index);

  /// Return a list of tables in the database
  void listTables(FXStringList & list);

  /// Return a list of views in the database
  void listViews(FXStringList & list);

  /// Return num changes by recent query
  FXint getNumChanges() const;

  /// Return total changes since opening database
  FXint getTotalChanges() const;

  /// Execute Simple Query
  FXbool execute(const FXchar * query);
  FXbool execute(const FXString & query);
  FXbool execute_with_result(const FXString & query,FXint & val);

  /// Close Database
  virtual ~GMDatabase();
  };

#endif

