/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/* This file is automatically generated using bindtool */

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/thread_group.h>

void bind_thread_group(py::module& m)
{
    using thread_group = gr::thread_group;


    py::class_<thread_group,
               boost::noncopyable_::noncopyable,
               std::shared_ptr<thread_group>>(m, "thread_group")

        .def(py::init<>())

        .def("create_thread", &thread_group::create_thread, py::arg("threadfunc"))
        .def("add_thread", &thread_group::add_thread, py::arg("thrd"))
        .def("remove_thread", &thread_group::remove_thread, py::arg("thrd"))
        .def("join_all", &thread_group::join_all)
        .def("interrupt_all", &thread_group::interrupt_all)
        .def("size", &thread_group::size);
}
