with Ada.Strings.Unbounded;			use Ada.Strings.Unbounded;
with Persistent;				use Persistent;

package String_Table is

   Out_Of_Range : exception;
   Table_Full   : exception;

   type String_Array_Type is array( Natural range <> ) of Unbounded_String;

   type Object( Size : Natural ) is new Persistent.Object with record
          Strings : String_Array_Type(1..Size) := (others => Null_Unbounded_String);
       end record;

   procedure Add(
      This  : in out Object;
      Value : in Unbounded_String );

   procedure Add(
      This  : in out Object;
      Value : in String );


   procedure Get(
      This   : in out Object;
      Pos    : Natural;
      Result : out Unbounded_String);

   function Contains(
      This   : in Object;
      Value  : in Unbounded_String ) return Boolean;

   procedure Delete(
      This : in out Object;
      Pos  : in Natural );

end String_Table;
