
DeclareSynonym( "MapNearRing", TransformationNearRing );

#############################################################################
##
#O  PolynomialNearRing( <G> ). . . . . . . . . .  compute the nearring 
##  of all polynomials on the group G
##
##  Constructor function for nearrings. 
##  Returns the nearring P(G).
##

DeclareOperation ("PolynomialNearRing", [IsGroup]);

#############################################################################
##
#P  PolynomialNearRingFlag	is set to true if the near ring is a
##				polynomial nearring

DeclareProperty( "PolynomialNearRingFlag", IsTransformationNearRing );

DeclareSynonym( "IsPolynomialNearRing", HasPolynomialNearRingFlag );

#############################################################################
##
#O  EndomorphismNearRing( <G> ). . . . . . . . . .  compute the nearring 
##  generated by all endomorphisms in G.
##
##  Constructor function for nearrings. 
##  Returns the nearring E(G).
##

DeclareOperation ("EndomorphismNearRing", [IsGroup]);

#############################################################################
##
#P  EndomorphismNearRingFlag	is set to true if the near ring is a
##				Endomorphism nearring

DeclareProperty( "EndomorphismNearRingFlag", IsTransformationNearRing );

DeclareSynonym( "IsEndomorphismNearRing", HasEndomorphismNearRingFlag );

#############################################################################
##
#O  AutomorphismNearRing( <G> ). . . . . . . . . .  compute the nearring 
##  generated by all Automorphisms in G.
##
##  Constructor function for nearrings. 
##  Returns the nearring A(G).
##

DeclareOperation ("AutomorphismNearRing", [IsGroup]);

#############################################################################
##
#P  AutomorphismNearRingFlag	is set to true if the near ring is a
##				Automorphism nearring

DeclareProperty( "AutomorphismNearRingFlag", IsTransformationNearRing );

DeclareSynonym( "IsAutomorphismNearRing", HasAutomorphismNearRingFlag );

#############################################################################
##
#O  InnerAutomorphismNearRing( <G> ). . . . . . . . . .  compute the nearring 
##  generated by all inner automorphisms in G.
##
##  Constructor function for nearrings. 
##  Returns the nearring A(G).
##

DeclareOperation ("InnerAutomorphismNearRing", [IsGroup]);

#############################################################################
##
#P  InnerAutomorphismNearRingFlag	is set to true if the near ring is a
##				InnerAutomorphism nearring

DeclareProperty( "InnerAutomorphismNearRingFlag", IsTransformationNearRing );

DeclareSynonym( "IsInnerAutomorphismNearRing",
			HasInnerAutomorphismNearRingFlag );

#############################################################################
##
#O  InnerAutomorphismNearRingGeneratedByCommutators( <G> ) 
##    computes the nearring generated by all inner automorphisms 
##    on G.
##
##  Constructor function for nearrings. 
##  Returns the nearring I(G).

DeclareOperation ("InnerAutomorphismNearRingGeneratedByCommutators",
		[IsGroup]);

#############################################################################
##
#P  InnerAutomorphismNearRingByCommutatorsFlag		is set to true if the
##							near ring is a
##							polynomial nearring

DeclareProperty( "InnerAutomorphismNearRingByCommutatorsFlag",
		IsTransformationNearRing );

DeclareSynonym( "IsInnerAutomorphismNearRingByCommutators",
		HasInnerAutomorphismNearRingByCommutatorsFlag );

#############################################################################
##
#O  CentralizerNearRing ( <G>, <endos> )
##    computes the nearring of all mappings m on G with the property that
##    m(e(x)) = e(m(x)) for all e in <endos> and x in <G>.
## 
##  Constructor function for nearrings. 
##  Returns the nearring M_{<endos>}(<G>). Note that the resulting nearring
##  need not be zerosymmetric if the zero-endomorphism is not included
##  in <endos>.
##

DeclareOperation ("CentralizerNearRing", [IsGroup, IsListOrCollection]);

#############################################################################
##
#P  CentralizerNearRingFlag	is set to true if the near ring is a
##				Centralizer nearring

DeclareProperty( "CentralizerNearRingFlag", IsTransformationNearRing );

DeclareSynonym( "IsCentralizerNearRing", HasCentralizerNearRingFlag );

##############################################################################
##
#O  RestrictedEndomorphismNearRing ( <G>, <U> )
##		Returns the near-ring H(G,U), which is the
##		near-ring that is addidtively generated by the set
##		of all endomorphisms of G whose range is a subset
##		of U.
##

DeclareOperation( "RestrictedEndomorphismNearRing", [IsGroup, IsGroup] );

#############################################################################
##
#P  RestrictedEndomorphismNearRingFlag	is set to true if the near ring is a
##				RestrictedEndomorphism nearring

DeclareProperty( "RestrictedEndomorphismNearRingFlag",
		IsTransformationNearRing );

DeclareSynonym( "IsRestrictedEndomorphismNearRing",
		HasRestrictedEndomorphismNearRingFlag );

#############################################################################
##
#O  LocalInterpolationNearRing ( <NR>, <m> )
##    Suppose that NR is a near-ring of functions on G (= NR.Gamma).
##    computes the nearring of all mappings on G that can be 
##    interpolated at any m places by an element in <NR>
##

DeclareOperation( "LocalInterpolationNearRing",
		[IsTransformationNearRing, IsInt and IsPosRat] );

#############################################################################
##
#P  LocalInterpolationNearRingFlag	is set to true if the near ring is a
##				Local nearring

DeclareProperty( "LocalInterpolationNearRingFlag", IsTransformationNearRing );

DeclareSynonym( "IsLocalInterpolationNearRing", HasLocalInterpolationNearRingFlag );

#############################################################################
##
#O  NoetherianQuotient2 ( <NR>, <Gamma>, <Target>, <Source> )
##
##    for transformation nearrings:
##    Input conditions: (1) <NR> is a near-ring of functions on <Gamma>,
##                      (2) <Target> is a subgroup of G,
##                      (3) <Source> is a subset of G,
##                      (4) <Target> is a subset of <Source>.
##    Then this function returns all mappings in <NR> that
##    map <Source> into <Target>.
##    Condition (4) guarantees that the resulting functions are closed
##    under composition. 
##    
##    for NGroups:
##    Input conditions: (1) <NR> is a near-ring acting on the N-group <Gamma>
##			(2) <Target> is a subset of <Gamma>
##			(3) <Source> is a subset of <Gamma>
##    Then this function returns all elements n in <NR> such that
##    n <Source> \subseteq <Target>.

DeclareOperation( "NoetherianQuotient2",
		[IsNearRing, IsGroup, IsCollection, IsCollection] );



#############################################################################
##
#O  CongruenceNoetherianQuotient ( <P>, <A>, <B>, <C> )
##
##    for nearrings of all polynomial functions.
##    Input conditions: (1) <P> is the near-ring of polynomial 
##                              functions on a group G,
##                      (2) <A> is a normal subgroup of G,
##                      (3) <B> is a normal subgroup of G,
##                      (4) <C> is a normal subgroup of G.
##    Then this function returns all mappings in <P> that
##    map every element of P into C, and maps two elements that
##    are congruent modulo B into elements that are congruent modulo
##    A.

DeclareOperation( "CongruenceNoetherianQuotient",
		[IsPolynomialNearRing, IsGroup, IsGroup, IsGroup] );


#############################################################################
##
#O  CongruenceNoetherianQuotientForInnerAutomorphismNearRings 
##             ( <I>, <A>, <B>, <C> )
##
##    for inner automorphism nearrings.
##    Input conditions: (1) <I> is the inner automorphism of G,
##                              functions on a group G,
##                      (2) <A> is a normal subgroup of G,
##                      (3) <B> is a normal subgroup of G,
##                      (4) <C> is a normal subgroup of G.
##    Then this function returns all mappings in <I> that
##    map every element of P into C, and maps two elements that
##    are congruent modulo B into elements that are congruent modulo
##    A.

DeclareOperation( "CongruenceNoetherianQuotientForInnerAutomorphismNearRings",
		[IsInnerAutomorphismNearRing, IsGroup, IsGroup, IsGroup] );




##############################################################################
##
#A  ZeroSymmetricPart ( <NR> )
##   returns the zerosymmetric part of <NR>
##

DeclareAttribute( "ZeroSymmetricPart", IsNearRing );





##############################################################################
##
#P  IsClosedUnderComposition ( <L> )
##
##     interesting, e.g., for left ideals.
##  

DeclareProperty ("IsClosedUnderComposition", IsNearRingElementCollection);

##############################################################################
##
#P  NoetherianQuotientFlag ( <N> )
##
##     true if N is a left ideal constructed as a noetherian quotient.
##  

DeclareProperty ("NoetherianQuotientFlag", IsNearRingElementCollection);

DeclareSynonym( "IsNoetherianQuotient", HasNoetherianQuotientFlag );