/* callhandler.c generated by valac 0.16.1, the Vala compiler
 * generated from callhandler.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsobasics.h>
#include <fsogsm.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gisicomm.h>
#include <freesmartphone.h>
#include <call.h>
#include <gio/gio.h>


#define FSO_GSM_TYPE_ISI_CALL_HANDLER (fso_gsm_isi_call_handler_get_type ())
#define FSO_GSM_ISI_CALL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_GSM_TYPE_ISI_CALL_HANDLER, FsoGsmIsiCallHandler))
#define FSO_GSM_ISI_CALL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_GSM_TYPE_ISI_CALL_HANDLER, FsoGsmIsiCallHandlerClass))
#define FSO_GSM_IS_ISI_CALL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_GSM_TYPE_ISI_CALL_HANDLER))
#define FSO_GSM_IS_ISI_CALL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_GSM_TYPE_ISI_CALL_HANDLER))
#define FSO_GSM_ISI_CALL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_GSM_TYPE_ISI_CALL_HANDLER, FsoGsmIsiCallHandlerClass))

typedef struct _FsoGsmIsiCallHandler FsoGsmIsiCallHandler;
typedef struct _FsoGsmIsiCallHandlerClass FsoGsmIsiCallHandlerClass;
typedef struct _FsoGsmIsiCallHandlerPrivate FsoGsmIsiCallHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fso_gsm_call_unref0(var) ((var == NULL) ? NULL : (var = (fso_gsm_call_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _FsoGsmIsiCallHandlerActivateData FsoGsmIsiCallHandlerActivateData;
typedef struct _Block2Data Block2Data;
typedef struct _FsoGsmIsiCallHandlerInitiateData FsoGsmIsiCallHandlerInitiateData;
typedef struct _FsoGsmIsiCallHandlerHoldData FsoGsmIsiCallHandlerHoldData;
typedef struct _Block3Data Block3Data;
typedef struct _FsoGsmIsiCallHandlerReleaseData FsoGsmIsiCallHandlerReleaseData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _fso_gsm_isi_call_handler_releaseAllData fso_gsm_isi_call_handler_releaseAllData;
typedef struct _fso_gsm_isi_call_handler_listCallsData fso_gsm_isi_call_handler_listCallsData;
typedef struct _FsoGsmIsiCallHandlerTransferData FsoGsmIsiCallHandlerTransferData;
typedef struct _FsoGsmIsiCallHandlerDeflectData FsoGsmIsiCallHandlerDeflectData;
typedef struct _FsoGsmIsiCallHandlerConferenceData FsoGsmIsiCallHandlerConferenceData;
typedef struct _FsoGsmIsiCallHandlerJoinData FsoGsmIsiCallHandlerJoinData;

struct _FsoGsmIsiCallHandler {
	FsoFrameworkAbstractObject parent_instance;
	FsoGsmIsiCallHandlerPrivate * priv;
	GeeHashMap* calls;
};

struct _FsoGsmIsiCallHandlerClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _FsoGsmIsiCallHandlerPrivate {
	FsoGsmModem* modem;
};

struct _Block1Data {
	int _ref_count_;
	FsoGsmIsiCallHandler * self;
	gpointer _async_data_;
};

struct _FsoGsmIsiCallHandlerActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
	gint id;
	Block1Data* _data1_;
	GIsiCommModemAccess* _tmp0_;
	GIsiCommCall* _tmp1_;
	gint _tmp2_;
};

struct _Block2Data {
	int _ref_count_;
	FsoGsmIsiCallHandler * self;
	gpointer _async_data_;
};

struct _FsoGsmIsiCallHandlerInitiateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
	gchar* number;
	gchar* ctype;
	gint result;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	GError* _tmp1_;
	guint8 ntype;
	const gchar* _tmp2_;
	guint8 _tmp3_;
	gchar* _tmp4_;
	gchar* gsmnumber;
	GIsiCommModemAccess* _tmp5_;
	GIsiCommCall* _tmp6_;
	GError * _inner_error_;
};

struct _FsoGsmIsiCallHandlerHoldData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	FsoGsmIsiCallHandler * self;
	gpointer _async_data_;
};

struct _FsoGsmIsiCallHandlerReleaseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
	gint id;
	Block3Data* _data3_;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	GError* _tmp3_;
	GeeHashMap* _tmp4_;
	gint _tmp5_;
	gpointer _tmp6_;
	FsoGsmCall* _tmp7_;
	FreeSmartphoneGSMCallDetail _tmp8_;
	FreeSmartphoneGSMCallStatus _tmp9_;
	gboolean _tmp10_;
	GError* _tmp11_;
	GIsiCommModemAccess* _tmp12_;
	GIsiCommCall* _tmp13_;
	gint _tmp14_;
	GError * _inner_error_;
};

struct _fso_gsm_isi_call_handler_releaseAllData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _call_it;
	GeeIterator* _tmp6_;
	gboolean _tmp7_;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	FsoGsmCall* call;
	FsoGsmCall* _tmp10_;
	FreeSmartphoneGSMCallDetail _tmp11_;
	FreeSmartphoneGSMCallStatus _tmp12_;
	FsoGsmCall* _tmp13_;
	FreeSmartphoneGSMCallDetail _tmp14_;
	gint _tmp15_;
	GError* err;
	GError * _inner_error_;
};

struct _fso_gsm_isi_call_handler_listCallsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
	FreeSmartphoneGSMCallDetail* result;
	gint result_length1;
	FreeSmartphoneGSMCallDetail* _tmp0_;
	FreeSmartphoneGSMCallDetail* ret;
	gint ret_length1;
	gint _ret_size_;
	GeeHashMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _call_it;
	GeeIterator* _tmp7_;
	gboolean _tmp8_;
	GeeIterator* _tmp9_;
	gpointer _tmp10_;
	FsoGsmCall* call;
	FsoGsmCall* _tmp11_;
	FreeSmartphoneGSMCallDetail _tmp12_;
	FreeSmartphoneGSMCallStatus _tmp13_;
	FreeSmartphoneGSMCallDetail* _tmp14_;
	gint _tmp14__length1;
	FsoGsmCall* _tmp15_;
	FreeSmartphoneGSMCallDetail _tmp16_;
	FreeSmartphoneGSMCallDetail _tmp17_;
	FreeSmartphoneGSMCallDetail* _tmp18_;
	gint _tmp18__length1;
};

struct _FsoGsmIsiCallHandlerTransferData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
};

struct _FsoGsmIsiCallHandlerDeflectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
	gchar* number;
};

struct _FsoGsmIsiCallHandlerConferenceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
	gint id;
};

struct _FsoGsmIsiCallHandlerJoinData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FsoGsmIsiCallHandler* self;
};


static gpointer fso_gsm_isi_call_handler_parent_class = NULL;
extern GIsiCommModemAccess* nokia_isi_isimodem;
static FsoGsmCallHandlerIface* fso_gsm_isi_call_handler_fso_gsm_call_handler_parent_iface = NULL;
static GType fso_gsm_isi_call_handler_type_id = 0;

GType fso_gsm_isi_call_handler_get_type (void) G_GNUC_CONST;
GType fso_gsm_isi_call_handler_register_type (GTypeModule * module);
#define FSO_GSM_ISI_CALL_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_GSM_TYPE_ISI_CALL_HANDLER, FsoGsmIsiCallHandlerPrivate))
enum  {
	FSO_GSM_ISI_CALL_HANDLER_DUMMY_PROPERTY
};
FsoGsmIsiCallHandler* fso_gsm_isi_call_handler_new (FsoGsmModem* modem);
FsoGsmIsiCallHandler* fso_gsm_isi_call_handler_construct (GType object_type, FsoGsmModem* modem);
static gchar* fso_gsm_isi_call_handler_real_repr (FsoFrameworkAbstractObject* base);
void fso_gsm_isi_call_handler_handleStatusUpdate (FsoGsmIsiCallHandler* self, GIsiCommCallISI_CallStatus* istatus);
static void ___lambda2_ (FsoGsmIsiCallHandler* self, gint id, FreeSmartphoneGSMCallStatus status, GHashTable* properties);
static void ____lambda2__fso_gsm_call_status_changed (FsoGsmCall* _sender, gint id, FreeSmartphoneGSMCallStatus status, GHashTable* properties, gpointer self);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static GVariant* _variant_new4 (gchar* value);
const gchar* CALL_status_to_string (guint8 self);
static const char* _CALL_status_to_string (guint8 value);
static void fso_gsm_isi_call_handler_real_handleIncomingCall (FsoGsmCallHandler* base, FsoGsmCallInfo* call_info);
static void fso_gsm_isi_call_handler_real_handleConnectingCall (FsoGsmCallHandler* base, FsoGsmCallInfo* call_info);
static void fso_gsm_isi_call_handler_real_handleEndingCall (FsoGsmCallHandler* base, FsoGsmCallInfo* call_info);
static void fso_gsm_isi_call_handler_real_addSupplementaryInformation (FsoGsmCallHandler* base, const gchar* direction, const gchar* info);
static void fso_gsm_isi_call_handler_real_activate_data_free (gpointer _data);
static void fso_gsm_isi_call_handler_real_activate (FsoGsmCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_isi_call_handler_real_activate_co (FsoGsmIsiCallHandlerActivateData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda3_ (Block1Data* _data1_, GIsiCommErrorCode _error_);
static void ___lambda3__gisi_comm_void_result_func (GIsiCommErrorCode _error_, gpointer self);
static void fso_gsm_isi_call_handler_real_initiate_data_free (gpointer _data);
static void fso_gsm_isi_call_handler_real_initiate (FsoGsmCallHandler* base, const gchar* number, const gchar* ctype, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_isi_call_handler_real_initiate_co (FsoGsmIsiCallHandlerInitiateData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda4_ (Block2Data* _data2_, GIsiCommErrorCode _error_, gint id);
static void ___lambda4__gisi_comm_int_result_func (GIsiCommErrorCode _error_, gint _result_, gpointer self);
static void fso_gsm_isi_call_handler_real_hold_data_free (gpointer _data);
static void fso_gsm_isi_call_handler_real_hold (FsoGsmCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_isi_call_handler_real_hold_co (FsoGsmIsiCallHandlerHoldData* _data_);
static void fso_gsm_isi_call_handler_real_release_data_free (gpointer _data);
static void fso_gsm_isi_call_handler_real_release (FsoGsmCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_isi_call_handler_real_release_co (FsoGsmIsiCallHandlerReleaseData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda5_ (Block3Data* _data3_, GIsiCommErrorCode _error_);
static void ___lambda5__gisi_comm_void_result_func (GIsiCommErrorCode _error_, gpointer self);
static void fso_gsm_isi_call_handler_real_releaseAll_data_free (gpointer _data);
static void fso_gsm_isi_call_handler_real_releaseAll (FsoGsmCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_isi_call_handler_real_releaseAll_co (fso_gsm_isi_call_handler_releaseAllData* _data_);
static void _vala_FreeSmartphoneGSMCallDetail_array_free (FreeSmartphoneGSMCallDetail* array, gint array_length);
static void fso_gsm_isi_call_handler_listCalls_data_free (gpointer _data);
void fso_gsm_isi_call_handler_listCalls (FsoGsmIsiCallHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
FreeSmartphoneGSMCallDetail* fso_gsm_isi_call_handler_listCalls_finish (FsoGsmIsiCallHandler* self, GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean fso_gsm_isi_call_handler_listCalls_co (fso_gsm_isi_call_handler_listCallsData* _data_);
static void _vala_array_add1 (FreeSmartphoneGSMCallDetail** array, int* length, int* size, const FreeSmartphoneGSMCallDetail* value);
static void fso_gsm_isi_call_handler_real_transfer_data_free (gpointer _data);
static void fso_gsm_isi_call_handler_real_transfer (FsoGsmCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_isi_call_handler_real_transfer_co (FsoGsmIsiCallHandlerTransferData* _data_);
static void fso_gsm_isi_call_handler_real_deflect_data_free (gpointer _data);
static void fso_gsm_isi_call_handler_real_deflect (FsoGsmCallHandler* base, const gchar* number, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_isi_call_handler_real_deflect_co (FsoGsmIsiCallHandlerDeflectData* _data_);
static void fso_gsm_isi_call_handler_real_conference_data_free (gpointer _data);
static void fso_gsm_isi_call_handler_real_conference (FsoGsmCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_isi_call_handler_real_conference_co (FsoGsmIsiCallHandlerConferenceData* _data_);
static void fso_gsm_isi_call_handler_real_join_data_free (gpointer _data);
static void fso_gsm_isi_call_handler_real_join (FsoGsmCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean fso_gsm_isi_call_handler_real_join_co (FsoGsmIsiCallHandlerJoinData* _data_);
static void fso_gsm_isi_call_handler_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FsoGsmIsiCallHandler* fso_gsm_isi_call_handler_construct (GType object_type, FsoGsmModem* modem) {
	FsoGsmIsiCallHandler * self = NULL;
	FsoGsmModem* _tmp0_;
	FsoGsmModem* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_val_if_fail (modem != NULL, NULL);
	self = (FsoGsmIsiCallHandler*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = modem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->modem);
	self->priv->modem = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, FSO_GSM_TYPE_CALL, (GBoxedCopyFunc) fso_gsm_call_ref, fso_gsm_call_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->calls);
	self->calls = _tmp2_;
	return self;
}


FsoGsmIsiCallHandler* fso_gsm_isi_call_handler_new (FsoGsmModem* modem) {
	return fso_gsm_isi_call_handler_construct (FSO_GSM_TYPE_ISI_CALL_HANDLER, modem);
}


static gchar* fso_gsm_isi_call_handler_real_repr (FsoFrameworkAbstractObject* base) {
	FsoGsmIsiCallHandler * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (FsoGsmIsiCallHandler*) base;
	_tmp0_ = g_strdup ("<>");
	result = _tmp0_;
	return result;
}


static void ___lambda2_ (FsoGsmIsiCallHandler* self, gint id, FreeSmartphoneGSMCallStatus status, GHashTable* properties) {
	FsoGsmModem* _tmp0_;
	gpointer _tmp1_ = NULL;
	FreeSmartphoneGSMCall* obj;
	gint _tmp2_;
	FreeSmartphoneGSMCallStatus _tmp3_;
	GHashTable* _tmp4_;
	g_return_if_fail (properties != NULL);
	_tmp0_ = self->priv->modem;
	_tmp1_ = fso_gsm_modem_theDevice (_tmp0_, FREE_SMARTPHONE_GSM_TYPE_CALL, (GBoxedCopyFunc) g_object_ref, g_object_unref);
	obj = (FreeSmartphoneGSMCall*) _tmp1_;
	_tmp2_ = id;
	_tmp3_ = status;
	_tmp4_ = properties;
	g_signal_emit_by_name (obj, "call-status", _tmp2_, _tmp3_, _tmp4_);
	_g_object_unref0 (obj);
}


static void ____lambda2__fso_gsm_call_status_changed (FsoGsmCall* _sender, gint id, FreeSmartphoneGSMCallStatus status, GHashTable* properties, gpointer self) {
	___lambda2_ (self, id, status, properties);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static GVariant* _variant_new1 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new2 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new3 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new4 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static const char* _CALL_status_to_string (guint8 value) {
	switch (value) {
		case CALL_STATUS_IDLE:
		return "CALL_STATUS_IDLE";
		case CALL_STATUS_CREATE:
		return "CALL_STATUS_CREATE";
		case CALL_STATUS_COMING:
		return "CALL_STATUS_COMING";
		case CALL_STATUS_PROCEEDING:
		return "CALL_STATUS_PROCEEDING";
		case CALL_STATUS_MO_ALERTING:
		return "CALL_STATUS_MO_ALERTING";
		case CALL_STATUS_MT_ALERTING:
		return "CALL_STATUS_MT_ALERTING";
		case CALL_STATUS_WAITING:
		return "CALL_STATUS_WAITING";
		case CALL_STATUS_ANSWERED:
		return "CALL_STATUS_ANSWERED";
		case CALL_STATUS_ACTIVE:
		return "CALL_STATUS_ACTIVE";
		case CALL_STATUS_MO_RELEASE:
		return "CALL_STATUS_MO_RELEASE";
		case CALL_STATUS_MT_RELEASE:
		return "CALL_STATUS_MT_RELEASE";
		case CALL_STATUS_HOLD_INITIATED:
		return "CALL_STATUS_HOLD_INITIATED";
		case CALL_STATUS_HOLD:
		return "CALL_STATUS_HOLD";
		case CALL_STATUS_RETRIEVE_INITIATED:
		return "CALL_STATUS_RETRIEVE_INITIATED";
		case CALL_STATUS_RECONNECT_PENDING:
		return "CALL_STATUS_RECONNECT_PENDING";
		case CALL_STATUS_TERMINATED:
		return "CALL_STATUS_TERMINATED";
		case CALL_STATUS_SWAP_INITIATED:
		return "CALL_STATUS_SWAP_INITIATED";
	}
	return NULL;
}


void fso_gsm_isi_call_handler_handleStatusUpdate (FsoGsmIsiCallHandler* self, GIsiCommCallISI_CallStatus* istatus) {
	FsoGsmCall* call = NULL;
	GeeHashMap* _tmp0_;
	GIsiCommCallISI_CallStatus _tmp1_;
	guint8 _tmp2_;
	gboolean _tmp3_ = FALSE;
	GIsiCommCallISI_CallStatus _tmp32_;
	guint8 _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (istatus != NULL);
	_tmp0_ = self->calls;
	_tmp1_ = *istatus;
	_tmp2_ = _tmp1_.id;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, GINT_TO_POINTER ((gint) _tmp2_));
	if (_tmp3_) {
		FsoFrameworkLogger* _tmp4_;
		GIsiCommCallISI_CallStatus _tmp5_;
		guint8 _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GeeHashMap* _tmp12_;
		GIsiCommCallISI_CallStatus _tmp13_;
		guint8 _tmp14_;
		gpointer _tmp15_ = NULL;
		_tmp4_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp5_ = *istatus;
		_tmp6_ = _tmp5_.id;
		_tmp7_ = g_strdup_printf ("%hhu", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat ("existing call with id ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = fso_framework_logger_debug (_tmp4_, _tmp10_);
		g_assert (_tmp11_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_tmp12_ = self->calls;
		_tmp13_ = *istatus;
		_tmp14_ = _tmp13_.id;
		_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, GINT_TO_POINTER ((gint) _tmp14_));
		_fso_gsm_call_unref0 (call);
		call = (FsoGsmCall*) _tmp15_;
	} else {
		FsoFrameworkLogger* _tmp16_;
		GIsiCommCallISI_CallStatus _tmp17_;
		guint8 _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gboolean _tmp23_ = FALSE;
		GIsiCommCallISI_CallStatus _tmp24_;
		guint8 _tmp25_;
		FsoGsmCall* _tmp26_;
		FsoGsmCall* _tmp27_;
		GeeHashMap* _tmp28_;
		GIsiCommCallISI_CallStatus _tmp29_;
		guint8 _tmp30_;
		FsoGsmCall* _tmp31_;
		_tmp16_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp17_ = *istatus;
		_tmp18_ = _tmp17_.id;
		_tmp19_ = g_strdup_printf ("%hhu", _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat ("new call with id ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = fso_framework_logger_debug (_tmp16_, _tmp22_);
		g_assert (_tmp23_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp24_ = *istatus;
		_tmp25_ = _tmp24_.id;
		_tmp26_ = fso_gsm_call_new_newFromId ((gint) _tmp25_);
		_fso_gsm_call_unref0 (call);
		call = _tmp26_;
		_tmp27_ = call;
		g_signal_connect_object (_tmp27_, "status-changed", (GCallback) ____lambda2__fso_gsm_call_status_changed, self, 0);
		_tmp28_ = self->calls;
		_tmp29_ = *istatus;
		_tmp30_ = _tmp29_.id;
		_tmp31_ = call;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, GINT_TO_POINTER ((gint) _tmp30_), _tmp31_);
	}
	_tmp32_ = *istatus;
	_tmp33_ = _tmp32_.status;
	switch (_tmp33_) {
		case CALL_STATUS_COMING:
		{
			FsoFrameworkLogger* _tmp34_;
			GIsiCommCallISI_CallStatus _tmp35_;
			guint8 _tmp36_;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_;
			GIsiCommCallISI_CallStatus _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			gboolean _tmp44_ = FALSE;
			FsoGsmCall* _tmp45_;
			FreeSmartphoneGSMCallDetail _tmp46_;
			GHashTable* _tmp47_;
			gchar* _tmp48_;
			GVariant* _tmp49_;
			FsoGsmCall* _tmp50_;
			FreeSmartphoneGSMCallDetail _tmp51_;
			GHashTable* _tmp52_;
			gchar* _tmp53_;
			GIsiCommCallISI_CallStatus _tmp54_;
			const gchar* _tmp55_;
			GIsiCommCallISI_CallStatus _tmp56_;
			guint8 _tmp57_;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_;
			GVariant* _tmp60_;
			FsoGsmCall* _tmp61_;
			_tmp34_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp35_ = *istatus;
			_tmp36_ = _tmp35_.id;
			_tmp37_ = g_strdup_printf ("%hhu", _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = *istatus;
			_tmp40_ = _tmp39_.number;
			_tmp41_ = string_to_string (_tmp40_);
			_tmp42_ = g_strconcat ("incoming call with id ", _tmp38_, " from ", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = fso_framework_logger_debug (_tmp34_, _tmp43_);
			g_assert (_tmp44_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp38_);
			_tmp45_ = call;
			_tmp46_ = _tmp45_->detail;
			_tmp47_ = _tmp46_.properties;
			_tmp48_ = g_strdup ("direction");
			_tmp49_ = _variant_new1 ("incoming");
			g_hash_table_insert (_tmp47_, _tmp48_, _tmp49_);
			_tmp50_ = call;
			_tmp51_ = _tmp50_->detail;
			_tmp52_ = _tmp51_.properties;
			_tmp53_ = g_strdup ("peer");
			_tmp54_ = *istatus;
			_tmp55_ = _tmp54_.number;
			_tmp56_ = *istatus;
			_tmp57_ = _tmp56_.ntype;
			_tmp58_ = fso_gsm_constants_phonenumberTupleToString (_tmp55_, (gint) _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = _variant_new2 (_tmp59_);
			g_hash_table_insert (_tmp52_, _tmp53_, _tmp60_);
			_g_free0 (_tmp59_);
			_tmp61_ = call;
			fso_gsm_call_update_status (_tmp61_, FREE_SMARTPHONE_GSM_CALL_STATUS_INCOMING);
			break;
		}
		case CALL_STATUS_CREATE:
		{
			FsoFrameworkLogger* _tmp62_;
			GIsiCommCallISI_CallStatus _tmp63_;
			guint8 _tmp64_;
			gchar* _tmp65_ = NULL;
			gchar* _tmp66_;
			GIsiCommCallISI_CallStatus _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_;
			gboolean _tmp72_ = FALSE;
			FsoGsmCall* _tmp73_;
			FreeSmartphoneGSMCallDetail _tmp74_;
			GHashTable* _tmp75_;
			gchar* _tmp76_;
			GVariant* _tmp77_;
			FsoGsmCall* _tmp78_;
			FreeSmartphoneGSMCallDetail _tmp79_;
			GHashTable* _tmp80_;
			gchar* _tmp81_;
			GIsiCommCallISI_CallStatus _tmp82_;
			const gchar* _tmp83_;
			GIsiCommCallISI_CallStatus _tmp84_;
			guint8 _tmp85_;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_;
			GVariant* _tmp88_;
			FsoGsmCall* _tmp89_;
			_tmp62_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp63_ = *istatus;
			_tmp64_ = _tmp63_.id;
			_tmp65_ = g_strdup_printf ("%hhu", _tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = *istatus;
			_tmp68_ = _tmp67_.number;
			_tmp69_ = string_to_string (_tmp68_);
			_tmp70_ = g_strconcat ("outgoing call with id ", _tmp66_, " to ", _tmp69_, NULL);
			_tmp71_ = _tmp70_;
			_tmp72_ = fso_framework_logger_debug (_tmp62_, _tmp71_);
			g_assert (_tmp72_);
			_g_free0 (_tmp71_);
			_g_free0 (_tmp66_);
			_tmp73_ = call;
			_tmp74_ = _tmp73_->detail;
			_tmp75_ = _tmp74_.properties;
			_tmp76_ = g_strdup ("direction");
			_tmp77_ = _variant_new3 ("outgoing");
			g_hash_table_insert (_tmp75_, _tmp76_, _tmp77_);
			_tmp78_ = call;
			_tmp79_ = _tmp78_->detail;
			_tmp80_ = _tmp79_.properties;
			_tmp81_ = g_strdup ("peer");
			_tmp82_ = *istatus;
			_tmp83_ = _tmp82_.number;
			_tmp84_ = *istatus;
			_tmp85_ = _tmp84_.ntype;
			_tmp86_ = fso_gsm_constants_phonenumberTupleToString (_tmp83_, (gint) _tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = _variant_new4 (_tmp87_);
			g_hash_table_insert (_tmp80_, _tmp81_, _tmp88_);
			_g_free0 (_tmp87_);
			_tmp89_ = call;
			fso_gsm_call_update_status (_tmp89_, FREE_SMARTPHONE_GSM_CALL_STATUS_OUTGOING);
			break;
		}
		case CALL_STATUS_ACTIVE:
		{
			FsoFrameworkLogger* _tmp90_;
			GIsiCommCallISI_CallStatus _tmp91_;
			guint8 _tmp92_;
			gchar* _tmp93_ = NULL;
			gchar* _tmp94_;
			gchar* _tmp95_ = NULL;
			gchar* _tmp96_;
			gboolean _tmp97_ = FALSE;
			FsoGsmCall* _tmp98_;
			_tmp90_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp91_ = *istatus;
			_tmp92_ = _tmp91_.id;
			_tmp93_ = g_strdup_printf ("%hhu", _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = g_strconcat ("call with id ", _tmp94_, " is active now", NULL);
			_tmp96_ = _tmp95_;
			_tmp97_ = fso_framework_logger_debug (_tmp90_, _tmp96_);
			g_assert (_tmp97_);
			_g_free0 (_tmp96_);
			_g_free0 (_tmp94_);
			_tmp98_ = call;
			fso_gsm_call_update_status (_tmp98_, FREE_SMARTPHONE_GSM_CALL_STATUS_ACTIVE);
			break;
		}
		case CALL_STATUS_HOLD:
		{
			FsoFrameworkLogger* _tmp99_;
			GIsiCommCallISI_CallStatus _tmp100_;
			guint8 _tmp101_;
			gchar* _tmp102_ = NULL;
			gchar* _tmp103_;
			gchar* _tmp104_ = NULL;
			gchar* _tmp105_;
			gboolean _tmp106_ = FALSE;
			FsoGsmCall* _tmp107_;
			_tmp99_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp100_ = *istatus;
			_tmp101_ = _tmp100_.id;
			_tmp102_ = g_strdup_printf ("%hhu", _tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = g_strconcat ("call with id ", _tmp103_, " is on hold now", NULL);
			_tmp105_ = _tmp104_;
			_tmp106_ = fso_framework_logger_debug (_tmp99_, _tmp105_);
			g_assert (_tmp106_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp103_);
			_tmp107_ = call;
			fso_gsm_call_update_status (_tmp107_, FREE_SMARTPHONE_GSM_CALL_STATUS_HELD);
			break;
		}
		case CALL_STATUS_IDLE:
		{
			FsoFrameworkLogger* _tmp108_;
			GIsiCommCallISI_CallStatus _tmp109_;
			guint8 _tmp110_;
			gchar* _tmp111_ = NULL;
			gchar* _tmp112_;
			gchar* _tmp113_ = NULL;
			gchar* _tmp114_;
			gboolean _tmp115_ = FALSE;
			FsoGsmCall* _tmp116_;
			_tmp108_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp109_ = *istatus;
			_tmp110_ = _tmp109_.id;
			_tmp111_ = g_strdup_printf ("%hhu", _tmp110_);
			_tmp112_ = _tmp111_;
			_tmp113_ = g_strconcat ("call with id ", _tmp112_, " is released", NULL);
			_tmp114_ = _tmp113_;
			_tmp115_ = fso_framework_logger_debug (_tmp108_, _tmp114_);
			g_assert (_tmp115_);
			_g_free0 (_tmp114_);
			_g_free0 (_tmp112_);
			_tmp116_ = call;
			fso_gsm_call_update_status (_tmp116_, FREE_SMARTPHONE_GSM_CALL_STATUS_RELEASE);
			break;
		}
		default:
		{
			FsoFrameworkLogger* _tmp117_;
			GIsiCommCallISI_CallStatus _tmp118_;
			guint8 _tmp119_;
			const gchar* _tmp120_ = NULL;
			GIsiCommCallISI_CallStatus _tmp121_;
			guint8 _tmp122_;
			gchar* _tmp123_ = NULL;
			gchar* _tmp124_;
			gchar* _tmp125_ = NULL;
			gchar* _tmp126_;
			gboolean _tmp127_ = FALSE;
			_tmp117_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp118_ = *istatus;
			_tmp119_ = _tmp118_.status;
			_tmp120_ = _CALL_status_to_string (_tmp119_);
			_tmp121_ = *istatus;
			_tmp122_ = _tmp121_.id;
			_tmp123_ = g_strdup_printf ("%hhu", _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = g_strconcat ("ignoring callstatus ", _tmp120_, " for call with id ", _tmp124_, NULL);
			_tmp126_ = _tmp125_;
			_tmp127_ = fso_framework_logger_debug (_tmp117_, _tmp126_);
			g_assert (_tmp127_);
			_g_free0 (_tmp126_);
			_g_free0 (_tmp124_);
			break;
		}
	}
	_fso_gsm_call_unref0 (call);
}


static void fso_gsm_isi_call_handler_real_handleIncomingCall (FsoGsmCallHandler* base, FsoGsmCallInfo* call_info) {
	FsoGsmIsiCallHandler * self;
	self = (FsoGsmIsiCallHandler*) base;
	g_return_if_fail (call_info != NULL);
}


static void fso_gsm_isi_call_handler_real_handleConnectingCall (FsoGsmCallHandler* base, FsoGsmCallInfo* call_info) {
	FsoGsmIsiCallHandler * self;
	self = (FsoGsmIsiCallHandler*) base;
	g_return_if_fail (call_info != NULL);
}


static void fso_gsm_isi_call_handler_real_handleEndingCall (FsoGsmCallHandler* base, FsoGsmCallInfo* call_info) {
	FsoGsmIsiCallHandler * self;
	self = (FsoGsmIsiCallHandler*) base;
	g_return_if_fail (call_info != NULL);
}


static void fso_gsm_isi_call_handler_real_addSupplementaryInformation (FsoGsmCallHandler* base, const gchar* direction, const gchar* info) {
	FsoGsmIsiCallHandler * self;
	self = (FsoGsmIsiCallHandler*) base;
	g_return_if_fail (direction != NULL);
	g_return_if_fail (info != NULL);
}


static void fso_gsm_isi_call_handler_real_activate_data_free (gpointer _data) {
	FsoGsmIsiCallHandlerActivateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoGsmIsiCallHandlerActivateData, _data_);
}


static void fso_gsm_isi_call_handler_real_activate (FsoGsmCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmIsiCallHandler * self;
	FsoGsmIsiCallHandlerActivateData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	gint _tmp1_;
	self = (FsoGsmIsiCallHandler*) base;
	_data_ = g_slice_new0 (FsoGsmIsiCallHandlerActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_real_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_data_->id = _tmp1_;
	fso_gsm_isi_call_handler_real_activate_co (_data_);
}


static void fso_gsm_isi_call_handler_real_activate_finish (FsoGsmCallHandler* base, GAsyncResult* _res_, GError** error) {
	FsoGsmIsiCallHandlerActivateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FsoGsmIsiCallHandler * self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda3_ (Block1Data* _data1_, GIsiCommErrorCode _error_) {
	FsoGsmIsiCallHandler * self;
	GIsiCommErrorCode _tmp0_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	_tmp0_ = _error_;
	if (_tmp0_ == GISI_COMM_ERROR_CODE_OK) {
		fso_gsm_isi_call_handler_real_activate_co (_data1_->_async_data_);
	} else {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_DEVICE_FAILED, "Unknown ISI Error");
		_inner_error_ = _tmp1_;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda3__gisi_comm_void_result_func (GIsiCommErrorCode _error_, gpointer self) {
	__lambda3_ (self, _error_);
}


static gboolean fso_gsm_isi_call_handler_real_activate_co (FsoGsmIsiCallHandlerActivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = nokia_isi_isimodem;
	_data_->_tmp1_ = _data_->_tmp0_->call;
	_data_->_tmp2_ = _data_->id;
	gisi_comm_call_answerVoiceCall (_data_->_tmp1_, (guint8) _data_->_tmp2_, ___lambda3__gisi_comm_void_result_func, _data_->_data1_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_gsm_isi_call_handler_real_initiate_data_free (gpointer _data) {
	FsoGsmIsiCallHandlerInitiateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->number);
	_g_free0 (_data_->ctype);
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoGsmIsiCallHandlerInitiateData, _data_);
}


static void fso_gsm_isi_call_handler_real_initiate (FsoGsmCallHandler* base, const gchar* number, const gchar* ctype, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmIsiCallHandler * self;
	FsoGsmIsiCallHandlerInitiateData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	self = (FsoGsmIsiCallHandler*) base;
	_data_ = g_slice_new0 (FsoGsmIsiCallHandlerInitiateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_real_initiate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_real_initiate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = number;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->number = _tmp2_;
	_tmp3_ = ctype;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->ctype = _tmp4_;
	fso_gsm_isi_call_handler_real_initiate_co (_data_);
}


static gint fso_gsm_isi_call_handler_real_initiate_finish (FsoGsmCallHandler* base, GAsyncResult* _res_, GError** error) {
	gint result;
	FsoGsmIsiCallHandlerInitiateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FsoGsmIsiCallHandler * self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda4_ (Block2Data* _data2_, GIsiCommErrorCode _error_, gint id) {
	FsoGsmIsiCallHandler * self;
	GIsiCommErrorCode _tmp0_;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	_tmp0_ = _error_;
	if (_tmp0_ == GISI_COMM_ERROR_CODE_OK) {
		fso_gsm_isi_call_handler_real_initiate_co (_data2_->_async_data_);
	} else {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_DEVICE_FAILED, "Unknown ISI Error");
		_inner_error_ = _tmp1_;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda4__gisi_comm_int_result_func (GIsiCommErrorCode _error_, gint _result_, gpointer self) {
	__lambda4_ (self, _error_, _result_);
}


static gboolean fso_gsm_isi_call_handler_real_initiate_co (FsoGsmIsiCallHandlerInitiateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->ctype;
	if (g_strcmp0 (_data_->_tmp0_, "voice") != 0) {
		_data_->_tmp1_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INVALID_PARAMETER, "This modem only supports voice calls");
		_data_->_inner_error_ = _data_->_tmp1_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp2_ = _data_->number;
	_data_->_tmp3_ = 0U;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = fso_gsm_constants_phonenumberStringToRealTuple (_data_->_tmp2_, &_data_->_tmp3_);
	_data_->ntype = _data_->_tmp3_;
	_data_->gsmnumber = _data_->_tmp4_;
	_data_->_tmp5_ = nokia_isi_isimodem;
	_data_->_tmp6_ = _data_->_tmp5_->call;
	gisi_comm_call_initiateVoiceCall (_data_->_tmp6_, _data_->gsmnumber, _data_->ntype, CALL_GSM_PRESENTATION_DEFAULT, ___lambda4__gisi_comm_int_result_func, _data_->_data2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->result = 0;
	_g_free0 (_data_->gsmnumber);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->gsmnumber);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_gsm_isi_call_handler_real_hold_data_free (gpointer _data) {
	FsoGsmIsiCallHandlerHoldData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoGsmIsiCallHandlerHoldData, _data_);
}


static void fso_gsm_isi_call_handler_real_hold (FsoGsmCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmIsiCallHandler * self;
	FsoGsmIsiCallHandlerHoldData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	self = (FsoGsmIsiCallHandler*) base;
	_data_ = g_slice_new0 (FsoGsmIsiCallHandlerHoldData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_real_hold);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_real_hold_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_gsm_isi_call_handler_real_hold_co (_data_);
}


static void fso_gsm_isi_call_handler_real_hold_finish (FsoGsmCallHandler* base, GAsyncResult* _res_, GError** error) {
	FsoGsmIsiCallHandlerHoldData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_gsm_isi_call_handler_real_hold_co (FsoGsmIsiCallHandlerHoldData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, "Not yet implemented");
	_data_->_inner_error_ = _data_->_tmp0_;
	if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_gsm_isi_call_handler_real_release_data_free (gpointer _data) {
	FsoGsmIsiCallHandlerReleaseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoGsmIsiCallHandlerReleaseData, _data_);
}


static void fso_gsm_isi_call_handler_real_release (FsoGsmCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmIsiCallHandler * self;
	FsoGsmIsiCallHandlerReleaseData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	gint _tmp1_;
	self = (FsoGsmIsiCallHandler*) base;
	_data_ = g_slice_new0 (FsoGsmIsiCallHandlerReleaseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_real_release);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_real_release_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_data_->id = _tmp1_;
	fso_gsm_isi_call_handler_real_release_co (_data_);
}


static void fso_gsm_isi_call_handler_real_release_finish (FsoGsmCallHandler* base, GAsyncResult* _res_, GError** error) {
	FsoGsmIsiCallHandlerReleaseData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		FsoGsmIsiCallHandler * self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda5_ (Block3Data* _data3_, GIsiCommErrorCode _error_) {
	FsoGsmIsiCallHandler * self;
	GIsiCommErrorCode _tmp0_;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	_tmp0_ = _error_;
	if (_tmp0_ == GISI_COMM_ERROR_CODE_OK) {
		fso_gsm_isi_call_handler_real_release_co (_data3_->_async_data_);
	} else {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_DEVICE_FAILED, "Unknown ISI Error");
		_inner_error_ = _tmp1_;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda5__gisi_comm_void_result_func (GIsiCommErrorCode _error_, gpointer self) {
	__lambda5_ (self, _error_);
}


static gboolean fso_gsm_isi_call_handler_real_release_co (FsoGsmIsiCallHandlerReleaseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->calls;
	_data_->_tmp1_ = _data_->id;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp0_, GINT_TO_POINTER (_data_->_tmp1_));
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_CALL_NOT_FOUND, "Call with specified id is not available");
		_data_->_inner_error_ = _data_->_tmp3_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp4_ = _data_->self->calls;
	_data_->_tmp5_ = _data_->id;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp4_, GINT_TO_POINTER (_data_->_tmp5_));
	_data_->_tmp7_ = (FsoGsmCall*) _data_->_tmp6_;
	_data_->_tmp8_ = _data_->_tmp7_->detail;
	_data_->_tmp9_ = _data_->_tmp8_.status;
	_data_->_tmp10_ = _data_->_tmp9_ == FREE_SMARTPHONE_GSM_CALL_STATUS_RELEASE;
	_fso_gsm_call_unref0 (_data_->_tmp7_);
	if (_data_->_tmp10_) {
		_data_->_tmp11_ = g_error_new_literal (FREE_SMARTPHONE_GSM_ERROR, FREE_SMARTPHONE_GSM_ERROR_CALL_NOT_FOUND, "No active call with that id found");
		_data_->_inner_error_ = _data_->_tmp11_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp12_ = nokia_isi_isimodem;
	_data_->_tmp13_ = _data_->_tmp12_->call;
	_data_->_tmp14_ = _data_->id;
	gisi_comm_call_releaseVoiceCall (_data_->_tmp13_, (guint8) _data_->_tmp14_, CALL_CAUSE_TYPE_CLIENT, CALL_CAUSE_RELEASE_BY_USER, ___lambda5__gisi_comm_void_result_func, _data_->_data3_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_gsm_isi_call_handler_real_releaseAll_data_free (gpointer _data) {
	fso_gsm_isi_call_handler_releaseAllData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (fso_gsm_isi_call_handler_releaseAllData, _data_);
}


static void fso_gsm_isi_call_handler_real_releaseAll (FsoGsmCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmIsiCallHandler * self;
	fso_gsm_isi_call_handler_releaseAllData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	self = (FsoGsmIsiCallHandler*) base;
	_data_ = g_slice_new0 (fso_gsm_isi_call_handler_releaseAllData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_real_releaseAll);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_real_releaseAll_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_gsm_isi_call_handler_real_releaseAll_co (_data_);
}


static void fso_gsm_isi_call_handler_real_releaseAll_finish (FsoGsmCallHandler* base, GAsyncResult* _res_, GError** error) {
	fso_gsm_isi_call_handler_releaseAllData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_gsm_isi_call_handler_real_releaseAll_co (fso_gsm_isi_call_handler_releaseAllData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->calls;
		_data_->_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp3_);
		_data_->_call_it = _data_->_tmp5_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_call_it;
			_data_->_tmp7_ = FALSE;
			_data_->_tmp7_ = gee_iterator_next (_data_->_tmp6_);
			if (!_data_->_tmp7_) {
				break;
			}
			_data_->_tmp8_ = _data_->_call_it;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
			_data_->call = (FsoGsmCall*) _data_->_tmp9_;
			_data_->_tmp10_ = _data_->call;
			_data_->_tmp11_ = _data_->_tmp10_->detail;
			_data_->_tmp12_ = _data_->_tmp11_.status;
			if (_data_->_tmp12_ != FREE_SMARTPHONE_GSM_CALL_STATUS_RELEASE) {
				{
					_data_->_tmp13_ = _data_->call;
					_data_->_tmp14_ = _data_->_tmp13_->detail;
					_data_->_tmp15_ = _data_->_tmp14_.id;
					fso_gsm_call_handler_release ((FsoGsmCallHandler*) _data_->self, _data_->_tmp15_, NULL, NULL);
				}
				goto __finally1;
				__catch1_g_error:
				{
					_data_->err = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_g_error_free0 (_data_->err);
				}
				__finally1:
				if (_data_->_inner_error_ != NULL) {
					if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_GSM_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_ERROR)) {
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
						g_error_free (_data_->_inner_error_);
						_fso_gsm_call_unref0 (_data_->call);
						_g_object_unref0 (_data_->_call_it);
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_fso_gsm_call_unref0 (_data_->call);
						_g_object_unref0 (_data_->_call_it);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
				}
			}
			_fso_gsm_call_unref0 (_data_->call);
		}
		_g_object_unref0 (_data_->_call_it);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_FreeSmartphoneGSMCallDetail_array_free (FreeSmartphoneGSMCallDetail* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			free_smartphone_gsm_call_detail_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void fso_gsm_isi_call_handler_listCalls_data_free (gpointer _data) {
	fso_gsm_isi_call_handler_listCallsData* _data_;
	_data_ = _data;
	_data_->result = (_vala_FreeSmartphoneGSMCallDetail_array_free (_data_->result, _data_->result_length1), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (fso_gsm_isi_call_handler_listCallsData, _data_);
}


void fso_gsm_isi_call_handler_listCalls (FsoGsmIsiCallHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	fso_gsm_isi_call_handler_listCallsData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	_data_ = g_slice_new0 (fso_gsm_isi_call_handler_listCallsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_listCalls);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_listCalls_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_gsm_isi_call_handler_listCalls_co (_data_);
}


FreeSmartphoneGSMCallDetail* fso_gsm_isi_call_handler_listCalls_finish (FsoGsmIsiCallHandler* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	FreeSmartphoneGSMCallDetail* result;
	fso_gsm_isi_call_handler_listCallsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void _vala_array_add1 (FreeSmartphoneGSMCallDetail** array, int* length, int* size, const FreeSmartphoneGSMCallDetail* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FreeSmartphoneGSMCallDetail, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gboolean fso_gsm_isi_call_handler_listCalls_co (fso_gsm_isi_call_handler_listCallsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_new0 (FreeSmartphoneGSMCallDetail, 0);
	_data_->ret = _data_->_tmp0_;
	_data_->ret_length1 = 0;
	_data_->_ret_size_ = _data_->ret_length1;
	{
		_data_->_tmp1_ = _data_->self->calls;
		_data_->_tmp2_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp4_);
		_data_->_call_it = _data_->_tmp6_;
		while (TRUE) {
			_data_->_tmp7_ = _data_->_call_it;
			_data_->_tmp8_ = FALSE;
			_data_->_tmp8_ = gee_iterator_next (_data_->_tmp7_);
			if (!_data_->_tmp8_) {
				break;
			}
			_data_->_tmp9_ = _data_->_call_it;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = gee_iterator_get (_data_->_tmp9_);
			_data_->call = (FsoGsmCall*) _data_->_tmp10_;
			_data_->_tmp11_ = _data_->call;
			_data_->_tmp12_ = _data_->_tmp11_->detail;
			_data_->_tmp13_ = _data_->_tmp12_.status;
			if (_data_->_tmp13_ != FREE_SMARTPHONE_GSM_CALL_STATUS_RELEASE) {
				_data_->_tmp14_ = _data_->ret;
				_data_->_tmp14__length1 = _data_->ret_length1;
				_data_->_tmp15_ = _data_->call;
				_data_->_tmp16_ = _data_->_tmp15_->detail;
				memset (&_data_->_tmp17_, 0, sizeof (FreeSmartphoneGSMCallDetail));
				free_smartphone_gsm_call_detail_copy (&_data_->_tmp16_, &_data_->_tmp17_);
				_vala_array_add1 (&_data_->ret, &_data_->ret_length1, &_data_->_ret_size_, &_data_->_tmp17_);
			}
			_fso_gsm_call_unref0 (_data_->call);
		}
		_g_object_unref0 (_data_->_call_it);
	}
	_data_->_tmp18_ = _data_->ret;
	_data_->_tmp18__length1 = _data_->ret_length1;
	_data_->result_length1 = _data_->_tmp18__length1;
	_data_->result = _data_->_tmp18_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->ret = (_vala_FreeSmartphoneGSMCallDetail_array_free (_data_->ret, _data_->ret_length1), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_gsm_isi_call_handler_real_transfer_data_free (gpointer _data) {
	FsoGsmIsiCallHandlerTransferData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoGsmIsiCallHandlerTransferData, _data_);
}


static void fso_gsm_isi_call_handler_real_transfer (FsoGsmCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmIsiCallHandler * self;
	FsoGsmIsiCallHandlerTransferData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	self = (FsoGsmIsiCallHandler*) base;
	_data_ = g_slice_new0 (FsoGsmIsiCallHandlerTransferData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_real_transfer);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_real_transfer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_gsm_isi_call_handler_real_transfer_co (_data_);
}


static void fso_gsm_isi_call_handler_real_transfer_finish (FsoGsmCallHandler* base, GAsyncResult* _res_, GError** error) {
	FsoGsmIsiCallHandlerTransferData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_gsm_isi_call_handler_real_transfer_co (FsoGsmIsiCallHandlerTransferData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_gsm_isi_call_handler_real_deflect_data_free (gpointer _data) {
	FsoGsmIsiCallHandlerDeflectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->number);
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoGsmIsiCallHandlerDeflectData, _data_);
}


static void fso_gsm_isi_call_handler_real_deflect (FsoGsmCallHandler* base, const gchar* number, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmIsiCallHandler * self;
	FsoGsmIsiCallHandlerDeflectData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (FsoGsmIsiCallHandler*) base;
	_data_ = g_slice_new0 (FsoGsmIsiCallHandlerDeflectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_real_deflect);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_real_deflect_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = number;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->number = _tmp2_;
	fso_gsm_isi_call_handler_real_deflect_co (_data_);
}


static void fso_gsm_isi_call_handler_real_deflect_finish (FsoGsmCallHandler* base, GAsyncResult* _res_, GError** error) {
	FsoGsmIsiCallHandlerDeflectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_gsm_isi_call_handler_real_deflect_co (FsoGsmIsiCallHandlerDeflectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_gsm_isi_call_handler_real_conference_data_free (gpointer _data) {
	FsoGsmIsiCallHandlerConferenceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoGsmIsiCallHandlerConferenceData, _data_);
}


static void fso_gsm_isi_call_handler_real_conference (FsoGsmCallHandler* base, gint id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmIsiCallHandler * self;
	FsoGsmIsiCallHandlerConferenceData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	gint _tmp1_;
	self = (FsoGsmIsiCallHandler*) base;
	_data_ = g_slice_new0 (FsoGsmIsiCallHandlerConferenceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_real_conference);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_real_conference_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_data_->id = _tmp1_;
	fso_gsm_isi_call_handler_real_conference_co (_data_);
}


static void fso_gsm_isi_call_handler_real_conference_finish (FsoGsmCallHandler* base, GAsyncResult* _res_, GError** error) {
	FsoGsmIsiCallHandlerConferenceData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_gsm_isi_call_handler_real_conference_co (FsoGsmIsiCallHandlerConferenceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_gsm_isi_call_handler_real_join_data_free (gpointer _data) {
	FsoGsmIsiCallHandlerJoinData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FsoGsmIsiCallHandlerJoinData, _data_);
}


static void fso_gsm_isi_call_handler_real_join (FsoGsmCallHandler* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FsoGsmIsiCallHandler * self;
	FsoGsmIsiCallHandlerJoinData* _data_;
	FsoGsmIsiCallHandler* _tmp0_;
	self = (FsoGsmIsiCallHandler*) base;
	_data_ = g_slice_new0 (FsoGsmIsiCallHandlerJoinData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, fso_gsm_isi_call_handler_real_join);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, fso_gsm_isi_call_handler_real_join_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	fso_gsm_isi_call_handler_real_join_co (_data_);
}


static void fso_gsm_isi_call_handler_real_join_finish (FsoGsmCallHandler* base, GAsyncResult* _res_, GError** error) {
	FsoGsmIsiCallHandlerJoinData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean fso_gsm_isi_call_handler_real_join_co (FsoGsmIsiCallHandlerJoinData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void fso_gsm_isi_call_handler_class_init (FsoGsmIsiCallHandlerClass * klass) {
	fso_gsm_isi_call_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoGsmIsiCallHandlerPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = fso_gsm_isi_call_handler_real_repr;
	G_OBJECT_CLASS (klass)->finalize = fso_gsm_isi_call_handler_finalize;
}


static void fso_gsm_isi_call_handler_fso_gsm_call_handler_interface_init (FsoGsmCallHandlerIface * iface) {
	fso_gsm_isi_call_handler_fso_gsm_call_handler_parent_iface = g_type_interface_peek_parent (iface);
	iface->handleIncomingCall = (void (*)(FsoGsmCallHandler*, FsoGsmCallInfo*)) fso_gsm_isi_call_handler_real_handleIncomingCall;
	iface->handleConnectingCall = (void (*)(FsoGsmCallHandler*, FsoGsmCallInfo*)) fso_gsm_isi_call_handler_real_handleConnectingCall;
	iface->handleEndingCall = (void (*)(FsoGsmCallHandler*, FsoGsmCallInfo*)) fso_gsm_isi_call_handler_real_handleEndingCall;
	iface->addSupplementaryInformation = (void (*)(FsoGsmCallHandler*, const gchar*, const gchar*)) fso_gsm_isi_call_handler_real_addSupplementaryInformation;
	iface->activate = (void (*)(FsoGsmCallHandler*, gint, GError**)) fso_gsm_isi_call_handler_real_activate;
	iface->activate_finish = fso_gsm_isi_call_handler_real_activate_finish;
	iface->initiate = (gint (*)(FsoGsmCallHandler*, const gchar*, const gchar*, GError**)) fso_gsm_isi_call_handler_real_initiate;
	iface->initiate_finish = fso_gsm_isi_call_handler_real_initiate_finish;
	iface->hold = (void (*)(FsoGsmCallHandler*, GError**)) fso_gsm_isi_call_handler_real_hold;
	iface->hold_finish = fso_gsm_isi_call_handler_real_hold_finish;
	iface->release = (void (*)(FsoGsmCallHandler*, gint, GError**)) fso_gsm_isi_call_handler_real_release;
	iface->release_finish = fso_gsm_isi_call_handler_real_release_finish;
	iface->releaseAll = (void (*)(FsoGsmCallHandler*, GError**)) fso_gsm_isi_call_handler_real_releaseAll;
	iface->releaseAll_finish = fso_gsm_isi_call_handler_real_releaseAll_finish;
	iface->transfer = (void (*)(FsoGsmCallHandler*, GError**)) fso_gsm_isi_call_handler_real_transfer;
	iface->transfer_finish = fso_gsm_isi_call_handler_real_transfer_finish;
	iface->deflect = (void (*)(FsoGsmCallHandler*, const gchar*, GError**)) fso_gsm_isi_call_handler_real_deflect;
	iface->deflect_finish = fso_gsm_isi_call_handler_real_deflect_finish;
	iface->conference = (void (*)(FsoGsmCallHandler*, gint, GError**)) fso_gsm_isi_call_handler_real_conference;
	iface->conference_finish = fso_gsm_isi_call_handler_real_conference_finish;
	iface->join = (void (*)(FsoGsmCallHandler*, GError**)) fso_gsm_isi_call_handler_real_join;
	iface->join_finish = fso_gsm_isi_call_handler_real_join_finish;
}


static void fso_gsm_isi_call_handler_instance_init (FsoGsmIsiCallHandler * self) {
	self->priv = FSO_GSM_ISI_CALL_HANDLER_GET_PRIVATE (self);
}


static void fso_gsm_isi_call_handler_finalize (GObject* obj) {
	FsoGsmIsiCallHandler * self;
	self = FSO_GSM_ISI_CALL_HANDLER (obj);
	_g_object_unref0 (self->calls);
	_g_object_unref0 (self->priv->modem);
	G_OBJECT_CLASS (fso_gsm_isi_call_handler_parent_class)->finalize (obj);
}


/**
 * @class IsiCallHandler
 **/
GType fso_gsm_isi_call_handler_get_type (void) {
	return fso_gsm_isi_call_handler_type_id;
}


GType fso_gsm_isi_call_handler_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (FsoGsmIsiCallHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_gsm_isi_call_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoGsmIsiCallHandler), 0, (GInstanceInitFunc) fso_gsm_isi_call_handler_instance_init, NULL };
	static const GInterfaceInfo fso_gsm_call_handler_info = { (GInterfaceInitFunc) fso_gsm_isi_call_handler_fso_gsm_call_handler_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	fso_gsm_isi_call_handler_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "FsoGsmIsiCallHandler", &g_define_type_info, 0);
	g_type_module_add_interface (module, fso_gsm_isi_call_handler_type_id, FSO_GSM_TYPE_CALL_HANDLER, &fso_gsm_call_handler_info);
	return fso_gsm_isi_call_handler_type_id;
}



