/***************************************************************************
 *  The FreeMedForms project is a set of free, open source medical         *
 *  applications.                                                          *
 *  (C) 2008-2014 by Eric MAEKER, MD (France) <eric.maeker@gmail.com>      *
 *  All rights reserved.                                                   *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program (COPYING.FREEMEDFORMS file).                   *
 *  If not, see <http://www.gnu.org/licenses/>.                            *
 ***************************************************************************/
/***************************************************************************
 *  Main developer: Eric MAEKER, <eric.maeker@gmail.com>                   *
 *  Contributors:                                                          *
 *       NAME <MAIL@ADDRESS.COM>                                           *
 ***************************************************************************/
#ifndef CONSTANTTRANSLATIONS_ACCOUNT_H
#define CONSTANTTRANSLATIONS_ACCOUNT_H

#include <qglobal.h>

namespace Trans {
namespace Constants {

// Account
const char* const ACCOUNTANCY           = QT_TRANSLATE_NOOP("tkConstants", "Accountancy");
const char* const BANK_DETAILS          = QT_TRANSLATE_NOOP("tkConstants", "Bank details");
const char* const AVAILABLE_MOVEMENTS   = QT_TRANSLATE_NOOP("tkConstants", "Available movements");
const char* const MEDICAL_PROCEDURES    = QT_TRANSLATE_NOOP("tkConstants", "Medical procedures");
const char*const  PAYMENT               = QT_TRANSLATE_NOOP("tkConstants", "Payment");
const char*const  PAYMENTS              = QT_TRANSLATE_NOOP("tkConstants", "Payments");
const char*const  FEE                   = QT_TRANSLATE_NOOP("tkConstants", "Fee");
const char*const  FEES                  = QT_TRANSLATE_NOOP("tkConstants", "Fees");
const char*const  SITES                 = QT_TRANSLATE_NOOP("tkConstants", "Sites");
const char*const  INSURANCE             = QT_TRANSLATE_NOOP("tkConstants", "Insurance");
const char*const  PERCENT               = QT_TRANSLATE_NOOP("tkConstants", "Percentages");
const char*const  DISTRULES             = QT_TRANSLATE_NOOP("tkConstants", "Distance rules");
const char*const  ASSETSRATES           = QT_TRANSLATE_NOOP("tkConstants", "Assets rates");

// Money (use QLocale::currency...) but we need to add 'cents'
const char*const  CENT                  = QT_TRANSLATE_NOOP("tkConstants", "cent");


} // end Constants
} // end TranslationUtils

#endif // CONSTANTTRANSLATIONS_ACCOUNT_H
