=======================
Installation de Freeciv
=======================

Ce document décrit comment compiler et installer Freeciv. La dernière
fois que nous nous sommes assuré que ce fichier soit à jour était le
16/07/2006.
Le dernière modification mineure date du 21/04/2015.

Il peut y avoir une version traduite de ce fichier sous le répertoire
./doc, nommé INSTALL.<locale> (par exemple : INSTALL.fr - que vous
êtes en train de lire !).

Ce document contient des sections et sous-sections comme suit :
     0. Prérequis
     1. Prérequis pour les clients
          1a. Prérequis pour le client Gtk2
          1b. Prérequis pour le client Gtk3
          1c. Prérequis pour le client SDL
          1d. Prérequis pour le client SDL2
          1e. Prérequis pour le client Xaw
          1f. Prérequis pour le client Qt
     2. Générer les Makefile
          2a. Générer les Makefile pour les version SVN
          2b. Générer les Makefile pour les versions publiées
     3. Compiler Freeciv
     4. Installation
     5. Localisation
     6. Support de Readline 
     7. Notes de Reinier pour l'installation sous Solaris
     8. Notes de Reinier pour l'installation de libXpm sous Solaris
     9. Notes pour Mac OS X et Darwin
    10. Notes pour Debian GNU/Linux
    11. Notes pour Windows


0. Prérequis
============

Freeciv a un certain nombre de prérequis. Cependant, à part le premier
prérequis, le processus de configuration est suffisamment intelligent
pour savoir si votre système convient. Dans le doute, essayez.

 - Unix (ou similaire)

   Le système d'exploitation Unix, un équivalent comme Linux ou
   FreeBSD ou un système qui propose un mode s'approchant beaucoup
   d'Unix, comme EMX sous OS/2 ou la boîte à outils Cygnus Cygwin sous
   Windows (voir http://www.cygwin.com/). Le support des sockets
   TCP/IP de style BSD est primordial, ainsi qu'un shell compatible
   Bourne comme GNU "bash" (la plupart des Unix remplissent le
   contrat...).

 - Un compilateur C ANSI

   Freeciv est écrit en C (presque) ANSI très portable. Les
   architectures 32 et 64 bits sont supportées. Vous ne pouvez pas
   utiliser un compilateur C "K&R" ou un compilateur C++.

   Le développement de Freeciv se fait avant tout avec "gcc",
   l'excellent compilateur C du projet GNU. Les distributions peuvent
   être compilées avec gcc ou la plupart des autres compilateurs (comme
   le compilateur C de Solaris). Notez que l'on rapporte que gcc avec
   l'option -O3 compilerait mal Freeciv.

 - Un programme "make"

   Les développeurs de Freeciv utilisent en général "gmake", le
   programme make de GNU.

   Les versions stables de Freeciv sont conçues pour avoir des Makefile
   qui fonctionnent avec la plupart des programmes make. 

   Vous pouvez vérifier que vous avez GNU make sur votre système en
   tapant :

    % make -v                   [si ça ne marche pas, essayez "gmake -v"]

   "GNU Make" devrait alors s'afficher quelque part.

 - libcurl version 7.12.1 ou mieux

   Libcurl s'occupe de la communication http avec le metaserveur, et
   des transferts de fichiers des installateurs de modpacks.
   
   http://curl.haxx.se/

La version SVN a des prérequis supplémentaires. Une version publiée
contient les fichiers générés.

 - Les programmes de GNU gettext version 0.14 ou mieux

   Particulièrement, le programme xgettext est nécessaire pour créer
   les fichiers *.gmo qui ne sont pas inclus dans l'arborescence SVN. 

 - GNU autoconf version 2.61 ou mieux

   Autoconf est requis pour créer configure à partir de configure.ac.

 - GNU automake version 1.10 ou mieux

   Automake est requis pour créer les divers Makefile.in à partir de
   Makefile.am.


1. Prérequis pour les clients
=============================

Le client Freeciv existe sous les formes suivantes :
* Bibliothèque de widgets Gtk+ 2.0 ("Gtk+ 2.0")
* Bibliothèque de widgets Gtk+ 3.0 ("Gtk+ 3.0")
* Bibliothèque X Athena Widgets ("Xaw")
* SDL
* Qt

Ces différentes formes ont des prérequis différents, comme expliqué
séparément ci-dessous.

Votre système devra satisfaire au moins un de ces ensembles de
prérequis.

Notez que la plupart des systèmes Linux ont des paquetages séparés
pour la bibliothèque d'exécution et pour le support du développement
(c'est-à-dire pour la compilation de programmes qui utilisent ces
bibliothèques). Pour compiler Freeciv sur de tels systèmes, vous
devrez avoir installé les paquetages appropriés de "développement".

1a. Prérequis pour le client Gtk+ 2.0
=====================================

 - "pkg-config"

   "pkg-config" est un système de gestion d'indicateurs de
   compilation/édition de liens qui fonctionne avec automake et
   autoconf. Vous pouvez l'obtenir sur :
   
   http://pkgconfig.freedesktop.org/releases/pkg-config-0.26.tar.gz

 - La bibliothèque utilitaire "Glib"

   La bibliothèque Glib fournit des fonctions non graphiques utilisées
   par les bibliothèques "Gdk" et "Gtk+", comme les tables de hachage,
   les listes simplement chaînées, etc.

   Freeciv nécessite une version de "Glib" supérieure ou égale à
   2.6.0.

   Si le processus de configuration de Freeciv vous indique que vous
   n'avez pas la bibliothèque Glib, vous pouvez l'obtenir ici :

   http://ftp.gnome.org/pub/gnome/sources/glib/2.30/glib-2.30.2.tar.xz

 - La bibliothèque d'accessibilité "Atk"

   La bibliothèque "Atk" fournit un ensemble d'interfaces pour
   l'accessibilité. Elle permet aux personnes avec handicap d'utiliser
   toutes les fonctionnalités fournies par les applications Gtk+. Vous
   pouvez l'obtenir sur :

   http://ftp.gnome.org/pub/gnome/sources/atk/2.2/atk-2.2.0.tar.xz

 - La bibliothèque de placement et de rendu textuel "Pango"

   "Pango" est une bibliothèque pour le placement et le rendu de
   texte, avec un accent mis sur l'internationalisation. Vous pouvez
   l'obtenir sur :

   http://ftp.acc.umu.se/pub/gnome/sources/pango/1.28/pango-1.28.4.tar.bz2

 - La bibliothèque de widgets "Gtk+"

   La bibliothèque "Gtk+" a été conçue pour le logiciel de graphisme
   GIMP. Depuis, elle a gagné en popularité comme boîte à outils libre
   et facile à programmer.

   La bibliothèque "Gtk+" est livrée accompagnée de deux autres
   bibliothèques :
   
     "Gdk"
       fournit une couche d'abstraction au-dessus de X-Window /
       LinuxFB / Win32 et implémente les fonctions de dessin de base,
       les fenêtres, le clipping, etc.

     "GdkPixbuf":
       fournit des services de chargement / sauvegarde d'images.

   Freeciv nécessite une version de "Gtk+" supérieure ou égale à
   2.12.0. Une version 2.16.0 au minimum est recommandée ; quelques
   fonctionnalités mineures d'interface utilisateur manqueront avec
   des versions plus anciennes.

   Si le processus de configuration de Freeciv vous indique que vous
   n'avez pas la bibliothèque Gtk+ installée, vous pouvez l'obtenir
   ici :

   http://ftp.acc.umu.se/pub/gnome/sources/gtk+/2.24/gtk+-2.24.9.tar.xz

   "Gtk+" dépend des bibliothèques "Glib", "Atk" et "Pango".

Si vous devez les construire vous-même, faites les compilations et les
installations dans l'ordre suivant : pkg-config, Glib, Atk, Pango et
Gtk+.

1b. Prérequis pour le client Gtk+ 3.0
=====================================

 - "pkg-config"

   "pkg-config" est un système de gestion d'indicateurs de
   compilation/édition de liens qui fonctionne avec automake et
   autoconf. Vous pouvez l'obtenir sur :
   
   http://pkgconfig.freedesktop.org/releases/pkg-config-0.28.tar.gz

 - La bibliothèque utilitaire "Glib"

   La bibliothèque Glib fournit des fonctions non graphiques utilisées
   par les bibliothèques "Gdk" et "Gtk+", comme les tables de hachage,
   les listes simplement chaînées, etc.

   Freeciv nécessite une version de "Glib" supérieure ou égale à
   la 2.36.

   Si le processus de configuration de Freeciv vous indique que vous
   n'avez pas la bibliothèque Glib, vous pouvez l'obtenir ici :

   http://ftp.gnome.org/pub/gnome/sources/glib/2.36/glib-2.36.1.tar.xz

 - La bibliothèque d'accessibilité "Atk"

   La bibliothèque "Atk" fournit un ensemble d'interfaces pour
   l'accessibilité. Elle permet aux personnes avec handicap d'utiliser
   toutes les fonctionnalités fournies par les applications Gtk+. Vous
   pouvez l'obtenir sur :

   http://ftp.gnome.org/pub/gnome/sources/atk/2.8/atk-2.8.0.tar.xz

 - La bibliothèque de placement et de rendu textuel "Pango"

   "Pango" est une bibliothèque pour le placement et le rendu de
   texte, avec un accent mis sur l'internationalisation. Vous pouvez
   l'obtenir sur :

   http://ftp.gnome.org/pub/gnome/sources/pango/1.34/pango-1.34.0.tar.xz

 - La bibliothèque de chargement/sauvegarde d'images "Gdk-Pixbuf"

   La bibliothèque "Gdk-Pixbuf" faisait partie de "Gtk+" lui-même,
   mais est maintenant un projet séparé. Elle peut être obtenue sur :

   http://ftp.gnome.org/pub/gnome/sources/gdk-pixbuf/2.28/gdk-pixbuf-2.28.1.tar.xz

 - La bibliothèque de widgets "Gtk+"

   La bibliothèque "Gtk+" a été conçue pour le logiciel de graphisme
   GIMP. Depuis, elle a gagné en popularité comme boîte à outils libre
   et facile à programmer.

   La bibliothèque "Gtk+" est livrée accompagnée d'une autre
   bibliothèque :
   
     "Gdk"
       fournit une couche d'abstraction au-dessus de X-Window /
       LinuxFB / Win32 et implémente les fonctions de dessin de base,
       les fenêtres, le clipping, etc.

   Freeciv nécessite une version de "Gtk+" supérieure ou égale à
   3.8.0.

   Si le processus de configuration de Freeciv vous indique que vous
   n'avez pas de bibliothèque Gtk+ installée, vous pouvez l'obtenir
   ici :

   http://ftp.gnome.org/pub/gnome/sources/gtk+/3.12/gtk+-3.12.2.tar.xz

   "Gtk+" dépend des bibliothèques "Glib", "Atk", "Gdk-Pixbuf" et
   "Pango".

Si vous devez les construire vous-même, faites les compilations et les
installations dans l'ordre suivant : pkg-config, Glib, Atk, Pango,
Gdk-Pixbuf et Gtk+.

1c. Prérequis pour le client SDL
================================

 - La bibliothèque SDL

   "Simple DirectMedia Layer est une bibliothèque multimédia
   portable, conçue pour fournir un accès bas niveau à l'audio, le
   clavier, la souris, le joystick, le matériel 3D par OpenGL, et le
   framebuffer vidéo 2D." (traduit de http://www.libsdl.org)

   Ces fonctionnalités en font un bon choix pour les jeux
   portables. Vous pouvez l'obtenir sur :

   http://www.libsdl.org/release/SDL-1.2.11.tar.gz

   Pour compiler le client en utilisant la bibliothèque SDL, ajoutez
   "--enable-client=sdl" au script de configuration de Freeciv. Voir
   la section ci-dessous pour plus d'information sur le script de
   configuration.

 - La bibliothèque SDL_image

   Cette bibliothèque charge les images PNG (avec l'aide de libpng) et
   les convertit en "surfaces SDL" qui peuvent être manipulées par la
   librairie SDL. Vous pouvez l'obtenir sur :
   
   http://www.libsdl.org/projects/SDL_image/release/SDL_image-1.2.12.tar.gz

 - La bibliothèque SDL_gfx

   http://www.ferzkopp.net/Software/SDL_gfx-2.0/SDL_gfx-2.0.25.tar.gz

 - La bibliothèque SDL_ttf

   http://www.libsdl.org/projects/SDL_ttf/release/SDL_ttf-2.0.11.tar.gz

 - La bibliothèque freetype

   Cette bibliothèque facilite le rendu du texte pour le client SDL,
   en utilisant une police TrueType externe. Vous pouvez l'obtenir à
   l'adresse :

   http://download.savannah.gnu.org/releases/freetype/freetype-2.3.2.tar.gz

1d. Prérequis pour le client SDL2
=================================

 - La bibliothèque SDL2

   "Simple DirectMedia Layer est une bibliothèque multimédia
   portable, conçue pour fournir un accès bas niveau à l'audio, le
   clavier, la souris, le joystick, le matériel 3D par OpenGL, et le
   framebuffer vidéo 2D." (traduit de http://www.libsdl.org)

   Ces fonctionnalités en font un bon choix pour les jeux
   portables. Vous pouvez l'obtenir sur :

   http://www.libsdl.org/release/SDL2-2.0.3.tar.gz

   Pour compiler le client en utilisant la bibliothèque SDL2, ajoutez
   "--enable-client=sdl2" au script de configuration de Freeciv. Voir
   la section ci-dessous pour plus d'information sur le script de
   configuration.

 - La bibliothèque SDL2_image

   Cette bibliothèque charge les images PNG (avec l'aide de libpng) et
   les convertit en "surfaces SDL" qui peuvent être manipulées par la
   librairie SDL. Vous pouvez l'obtenir sur :
   
   http://www.libsdl.org/projects/SDL_image/release/SDL2_image-2.0.0.tar.gz

 - La bibliothèque SDL2_gfx

   http://www.ferzkopp.net/Software/SDL_gfx-2.0/SDL_gfx-2.0.25.tar.gz

 - La bibliothèque SDL2_ttf

   http://www.ferzkopp.net/Software/SDL_gfx-2.0/SDL_gfx-2.0.25.tar.gz
   [NdT : étrange... voici un lien qui semble plus "logique" : ]
   https://www.libsdl.org/projects/SDL_ttf/release/SDL2_ttf-2.0.14.tar.gz

 - La bibliothèque freetype

   Cette bibliothèque facilite le rendu du texte pour le client SDL2,
   en utilisant une police TrueType externe. Vous pouvez l'obtenir à
   l'adresse :

   http://download.savannah.gnu.org/releases/freetype/freetype-2.5.4.tar.bz2

1e. Prérequis pour le client Xaw
================================

 - X-Window

   Le client Freeciv Xaw est un programme X-Window, ce qui fait que
   vous devrez avoir un moyen de lancer des programmes X11 (la plupart
   des Unix en sont capables).

   Si la configuration de Freeciv ne peut pas trouver X-Window sur votre
   système, vous aurez peut-être besoin des options --x-includes=RÉP et
   --x-libraries=RÉP.

 - La bibliothèque "Athena Widgets"

   Cette bibliothèque (aussi connue sous le nom de "Xaw") est en général
   fournie en standard avec le reste de X, mais certaines plateformes
   (HP-UX 10, par exemple) n'en proposent qu'une version limitée.

   Pour compiler le client en utilisant la bibliothèque "Xaw", utilisez
   l'option "--enable-client=xaw" du script configure. Consultez la
   section ci-dessous pour plus de renseignements à propos du script
   configure.

   Beaucoup d'Unix modernes (comme Linux) proposent une variante
   appelée "Xaw3d" qui a une apparence "3D" plus moderne. Si vous
   voulez compiler avec Xaw3d, utilisez l'option "--with-xaw-3d" de
   configure.

   Il y a aussi d'autres variantes de Xaw, comme Nextaw. Freeciv ne
   fonctionne pas avec celles-ci, bien qu'il devrait être possible de
   le modifier de la même façon que pour Xaw3D. Un autre outil, appelé
   "xaw_wrappers", peut être utile, mais son utilisation dépasse le
   cadre de ce document.

 - La bibliothèque "Xpm"

   Cette bibliothèque est essentielle pour la gestion des icônes et
   des bitmaps. Elle est largement utilisée et fournie en standard sur
   la plupart des machines Unix modernes, bien qu'elle puisse être
   absente sur des Unix traditionnels ou plus vieux (par exemple
   Solaris).

   Lorsque vous lancez le script configure de Freeciv, il peut être
   nécessaire que vous utilisiez l'option en ligne de commande
   "--with-xpm-prefix=RÉP" (RÉP désignant le nom du répertoire
   contenant les sous-répertoires "include" et "lib" où on peut
   trouver Xpm).

   Si le processus de configuration de Freeciv vous indique que vous
   n'avez pas la bibliothèque Xpm, vous pouvez l'obtenir ici :

     ftp://koala.inria.fr/pub/xpm/xpm-3.4k.tar.gz
     ftp://ftp.x.org/contrib/libraries/xpm-3.4k.tar.gz

   Installez la comme vous feriez pour n'importe quel autre
   paquetage. Si vous ne pouvez pas l'installer dans un répertoire
   système standard, utilisez l'option --with-xpm-prefix comme décrit
   plus haut.

   Si vous avez des problèmes pour installer libXpm sous Solaris, ou
   que vous ne voulez pas l'installer en tant que root, consultez la
   section "Notes de Reinier pour l'installation de libXpm sous
   Solaris" vers la fin de ce document.

 - Une police convenable

   Pour lancer le client Xaw, une police convenable est
   nécessaire. Les polices X devraient convenir. Si le client Xaw se
   plaint de ne pas pouvoir ouvrir une police sur votre installation
   X, vous ne l'avez probablement pas. Les polices X peuvent être
   obtenues sur :

   http://xorg.freedesktop.org/releases/individual/font/

   Si vous utilisez Debian, vous pouvez installer le paquetage appelé
   xfonts-base à la place. Après avoir installé une police convenable
   et avoir relancé X, le problème devrait disparaître.

1f. Prérequis pour le client Qt
===============================

 - Un compilateur C++

   Qt-client est écrit en C++, vous aurez donc besoin d'un compilateur
   approprié. Dans le développement de Freeciv, c'est g++ qui a été
   utilisé.

 - Les librairies et en-têtes de Qt5Core, Qt5Gui, et Qt5Widgets


2. Générer les Makefile :
=========================

Cette section contient deux parties, l'une pour générer les Makefile
des versions SVN, et l'autre pour générer les Makefile des versions
publiées.

2a. Générer le Makefile pour les versions SVN
=============================================

Cette étape n'est nécessaire que pour les versions SVN.

Pour créer le Makefile, tapez simplement :

 % ./autogen.sh

Cela créera le script configure et le lancera. Tous les paramètres
d'autogen.sh sont passés à configure. Lisez la section suivante pour
les paramètres qui peuvent être passés à configure.

2b. Générer le Makefile pour les versions publiées
==================================================

Avant de compiler Freeciv, vous devez générer un Makefile. Ce Makefile est
configuré pour correspondre aux fonctionnalités disponibles sur votre machine.

Cette configuration est faite en utilisant le script "configure" de GNU.

Pour utiliser "configure", rendez vous dans le répertoire racine de la
distribution de Freeciv et tapez :

 % ./configure

Ce script tentera ensuite de déterminer les fonctionnalités présentes
(et absentes) sur votre système. Il devrait imprimer une page ou deux de
diagnostics sur votre machine puis s'arrêter normalement.

Si vous désirez de l'aide sur les diverses options acceptées par le
script configure, utilisez l'option --help comme ceci :

 % ./configure --help

Par défaut, le script configure choisira le client Gtk+ s'il trouve
les bibliothèques requises. Si vous préférez passer outre ce défaut,
vous pouvez forcer le choix du client du client Xaw par exemple en
utilisant l'option "--enable-client=xaw".

Si vous voulez modifier les options du compilateur, positionnez la
variable d'environnement CFLAGS avec de lancer "configure". Par
exemple :

 % CFLAGS="-O -g -pipe" ./configure   [avec le Bourne shell ou bash]

ou

 % setenv CFLAGS "-O -g -pipe"
 % ./configure                        [avec le C shell or tcsh]

Si vous investiguez un "core dump", nous vous suggérons d'utiliser
l'option "-g" dans CFLAGS.

Lorsque vous installerez Freeciv (plus tard), les composants du jeu
seront copiés par défaut dans les sous-répertoires de /usr/local. Si
vous voulez utilisez un autre préfixe d'installation que /usr/local,
vous devez le préciser maintenant de la façon suivante :

 % ./configure --prefix=/opt/freeciv

Si, pour une raison quelconque, l'utilisation de "configure" vous pose
problème, suivez ces étapes :

  - Lisez la section des prérequis attentivement pour déterminer si
    votre système possède tout ce dont vous avez besoin.

  - Si vous voulez compiler la version Xaw du client : assurez-vous que
    vous avez les bibliothèques Xpm et Xaw sur votre système. Vérifiez
    ensuite que le script configure peut les trouver, soit en les
    installant aux endroits standards sur votre système, soit en
    utilisant les options en ligne de commande adéquates de configure
    (voir ./configure --help).

  - Si le problème provient de "gettext", veuillez lire la section
    Localisation plus bas, afin de connaître les contournements
    possibles.

  - Dites le nous, pour que nous puissions corriger le problème dans la
    prochaine version !

    Envoyez un e-mail à la liste de diffusion freeciv-dev, en expliquant
    ce que vous avez fait et quel résultat vous avez obtenu. Il peut
    être utile d'inclure ce que le script configure a affiché, ainsi que
    le contenu des fichiers "config.status", "config.cache" et
    "config.log", qui sont générés par le script configure.

    Vous pouvez en savoir plus à propos de la liste de diffusion
    freeciv-dev sur notre site web, à l'adresse http://www.freeciv.org/


3. Compiler Freeciv
===================

Si tout s'est bien déroulé jusqu'à présent, alors la compilation de
Freeciv devrait être aussi facile que de taper "make" (ou, de
préférence, "gmake").

Si vous avez des problèmes, lisez le fichier BUGS et suivez les
conseils scrupuleusement. Si le problème vient de "gettext", veuillez
lire la section Localisation ci-dessous afin de connaître les
contournements possibles.

Après la compilation, les choses suivantes sont importantes :

  - les binaires "client/freeciv-<IHM>" et "server/freeciv-server"
  - le répertoire "data" qui contient les graphismes et les scénarios
  - le répertoire "translations" qui contient les fichiers de localisation
  - les scripts "fcgui" et "fcser"

Il est parfaitement possible de jouer à Freeciv depuis ce répertoire,
sans l'installer. Si vous faites ceci, les scripts "fcgui" et "fcser"
seront utiles, bien qu'ils ne soient pas aussi nécessaires qu'ils
aient pu l'être.

Consultez le fichier README.fr pour plus de renseignements.

[ Cependant, vous ne pouvez pas utilisez la localisation en jouant à
Freeciv depuis le répertoire des sources ; vous devez installer Freeciv
pour cela. ]


4. Installation
===============

Pour installer Freeciv, il faut que les composants mentionnés dans la
section "Compiler Freeciv" soient installés. Ils doivent être copiés
dans un répertoire tel que /usr/local (par défaut), /usr/games/,
/usr/games/freeciv, /usr/local/freeciv ou n'importe quel répertoire
convenable.

Taper "make install" devrait tout installer correctement sur votre
machine. Vous pouvez utiliser l'option --prefix=RÉP de configure (voir
la section "Générer le Makefile") pour vous assurer que les fichiers
sont placés là où vous les voulez.

Lorsque le client et le server Freeciv sont lancés, ils ont besoin de
trouver certains fichiers dans le répertoire "data". Par défaut, Freeciv
cherche, dans l'ordre, dans les répertoires suivants pour trouver les
fichiers de données : le répertoire courant, le sous-répertoire "data"
du répertoire courant, le sous-répertoire ".freeciv" du répertoire
personnel de l'utilisateur et l'endroit où sont placés les fichiers en
lançant "make install". Vous pouvez forcer le chemin de recherche à
l'aide de la variable d'environnement FREECIV_PATH, qui doit être
positionnée sur un simple répertoire ou une liste de répertoires séparés
par des deux-points ":".

Par exemple :

  % setenv FREECIV_PATH "/usr/games/freeciv/data:./data"
  (pour les utilisateurs de csh, tcsh, etc.)

  % FREECIV_PATH="/usr/games/freeciv/data:./data"; export FREECIV_PATH
  (pour les utilisateurs de sh, bash, ksh, zsh, etc.)

Notez que vous devez généralement installer Freeciv si vous voulez
utiliser la localisation. Consultez le fichier README.fr pour plus de
renseignements.

Enfin, si vous avez choisi d'utiliser le client Xaw et que vous avez la
permission de vous connecter en tant qu'utilisateur 'root', vous pouvez
copier le fichier de ressource data/Freeciv dans le répertoire
app-defaults (qui se trouve en général dans /usr/lib/X11).


5. Localisation
===============

Freeciv utilise le système "gettext" pour la localisation.

Si vous rencontrez des problèmes avec gettext en configurant ou
compilant Freeciv, il y a un certain nombre de contournements que vous
pouvez tenter :

1. Si vous n'avez pas besoin de la localisation, désactivez la en
   utilisant l'option "--disable-nls" de ./configure :

      % ./configure --disable-nls
      % make

2. Vous pouvez essayer d'installer la dernière version de GNU
   gettext. Elle peut être obtenue ici :
    
   ftp://ftp.gnu.org/pub/gnu/gettext/gettext-0.19.2.tar.xz


6. Support de Readline
======================

En option, Freeciv peut utiliser la bibliothèque Readline.

Le support de Readline est ce qui permet à la ligne de commande du
serveur de se comporter raisonnablement, ce qui permet de :
 - Utiliser la touche Retour Arrière (Backspace)
 - Utiliser le curseur pur se déplacer en avant et en arrière dans la
   ligne que vous avez écrite.
 - Utiliser la complétion des commandes et des arguments de commande
   par la touche tabulation (Tab) - c'est-à-dire que, lorsque vous
   pressez la touche Tab, le serveur terminera votre mot pour vous
   s'il n'y a plus qu'un seul choix possible.
 - Utiliser les flèches en haut et en bas pour se déplacer dans
 l'historique des commandes entrées précédemment.
 - etc.

Le script configure vérifiera si bibliothèque Readline est
correctement installée. Si c'est le cas, il configurera les Makefile
de façon à ce que Readline soit intégrée dans le serveur. Sinon, il
configurera silencieusement sans support de Readline.
Vous pouvez obliger configure à inclure Readline ou à planter en
passant à configure l'option --with-readline :

 % ./configure --with-readline

Certaines distributions de Linux (et potentiellement, d'autres
systèmes d'exploitation) installent mal Readline 4, ce qui fait que
Readline n'est pas configuré pour déclarer ses dépendances
dynamiques. Dans ce cas, configure essayera de deviner à quelles
bibliothèques supplémentaires il doit lier l'exécutable, et les
ajoutera. Le script configure émettra un avertissement si il a dû
ajouter des bibliothèques supplémentaires pour faire fonctionner
Readline. Ceci devrait être sans conséquences, et est juste censé être
un rappel pour les gens qui distribuent Readline. :-)


7. Notes de Reinier pour l'installation sous Solaris
====================================================

Solaris (2.5 et suivants) a sa propre version de X dans /usr/openwin,
sa propre version de make dans /usr/ccs/bin/make et son propre
compilateur (qui doit être acheté séparément) qui, si vous l'avez, est
dans /opt/SUNWspro/bin. Solaris ne fournit pas la bibliothèque XPM,
qui est requise pour le client Xaw ; il ne fournit rien de ce qui est
requis pour imlib, gdk et gtk non plus, qui sont nécessaires pour le
client GTK+. Cependant, avec un peu de patience, tout peut être
compilé sans problème.

Pour plus de renseignements sur l'installation de XPM sous Solaris,
consultez la section suivante.

Un certain nombre d'installations de Solaris ont déjà MIT X (en général
dans /usr/X11), GNU make, le compilateur gcc et la bibliothèque XPM
installée quelque part. La commande standard "./configure && make" peut
ne pas trouver la bibliothèque XPM et a des chances de se tromper entre
les différentes versions.

Assurez-vous que vos variables d'environnement, en particulier $PATH et
$LD_LIBRARY_PATH et les options de ./configure ne pointent pas sur un
ensemble inconsistant de logiciels et la compilation se passera bien.

Une recette simple pour compiler avec Sun X, Sun make et Sun cc,
considérant que les bibliothèques xpm sont elles-mêmes à un endroit non
standard (/chemin/vers/xpm) :

  % setenv PATH /opt/SUNWspro/bin:/usr/ccs/bin:/bin
  % unsetenv LD_LIBRARY_PATH
  % ./configure --with-xpm-prefix=/chemin/vers/xpm
  % make

Vous pouvez régler votre $PATH et ./configure pour n'utiliser que des
outils GNU. Freeciv est connu pour compiler avec MIT X et avec
certaines combinaisons d'outils GNU et Sun. La recette exacte
dépendent de votre installation locale.


6. Notes de Reinier pour l'installation de libXpm sous Solaris
==============================================================

Lorsque j'étais root sur mon système Solaris, je ne voulais *quand même*
pas installer des logiciels supplémentaires en tant que root. C'est mal.

Malheureusement, la procédure d'installation de libXpm part du principe
que l'installation se fait dans /usr/openwin, qui appartient à
root. Mais ce n'est pas très dur à contourner.

Avertissements :

 - Assurez-vous que /usr/ucb/install est dans votre $PATH avant
   /usr/bin/install, sinon 'make install' ne fonctionnera pas, et
   renverra des messages d'erreur étranges.
   
 - L'endroit dans lequel vous voulez installer peut être spécifié avec
   $DESTDIR. Cependant, l'installation se fera en fait dans
   $DESTDIR/$OPENWINDIR, donc le sous-répertoire $OPENWINDIR
   supplémentaire devra être enlevé après (modifier la valeur de
   $OPENWINHOME ne fonctionne pas).

La procédure :

 - Récupérez les sources de quelque part, de-tarez les, rendez vous
   dans le répertoire des sources, et faites :
   
     % setenv MYXPMDEST /usr/local   # ou l'endroit où vous voulez installer
     % xmkmf; make Makefiles includes depend; make
     % setenv PATH /usr/local/bin:/usr/ucb:$PATH
     % make DESTDIR=$MYXPMDEST install
     % make DESTDIR=$MYXPMDEST install.man
     % cd $MYXPMDEST; mv ./$OPENWINHOME/* .; rm -rf ./$OPENWINHOME

   (Si vous utilisez sh, bash, ksh, zsh, etc, remplacez les "setenv"
     ci-dessus par :
     % MYXPMDEST=/usr/local; export MYXPMDEST
     % PATH=/usr/local/bin:/usr/ucb:$PATH
   )

 - Vous pouvez maintenant configurer Freeciv ainsi :
     % ./configure --with-xpm-prefix=$MYXPMDEST

   ce qui ajoutera les options -I/-L/-R qui conviennent aux commandes
   de compilations et d'édition de liens.

9. Notes pour Mac OS X et Darwin
================================

La version d'Apple de GCC utilise des entêtes précompilées qui ne
supportent pas les macros vararg (une extension GCC). Ceci fait
planter GCC quand il compile Freeciv, puisque le compilateur est par
ailleurs (quasiment) indifférentiable d'un GCC conventionnel. Donc, à
la place de l'habituel

  % ./configure <...>

Vous deviez utiliser soit :

 Shell Bourne :
   $ CC="gcc -no-cpp-precomp" ./configure <...>

ou

 C shell:
   % env CC="gcc -no-cpp-precomp" ./configure <...>

en fonction de la variante de votre shell, Bourne ou C (Si vous avez
un doute, essayez simplement les deux pour voir lequel fonctionne).

Remplacez <...> avec tout argument additionnel que vous souhaitez
passer à configure.


10. Notes pour Debian GNU/Linux
===============================

Pour compiler Freeciv sur un système Debian, vous aurez besoin des
paquetages suivants :

 Prérequis communs :
   gcc
   libc6-dev
   libreadline4-dev
   zlib1g-dev
   xlib6g-dev

 Pour le client Xaw
   xaw3dg-dev
   libxpm4-dev

Si vous voulez compiler le client Xaw, vous devriez passer à configure
l'argument --with-xaw3d, c'est-à-dire :

  % ./configure --with-xaw3d

Si vous devez lancer aclocal (si vous ne savez pas ce qu'est aclocal,
c'est que vous n'en avez pas besoin), il vous faut aussi installer
imlib-dev pour avoir la macro AM_PATH_GDK_IMLIB. C'est un bug de la
Debian que cette macro ne soit pas dans gdk-imlib-dev, et il sera,
espérons le, corrigé dans les futures versions de Debian.


11. Notes pour Windows
======================

La version Windows de Freeciv peut être fabriquée soit avec MinGW ou
avec Cygwin. Les binaires Windows officiels sont fabriqués avec MinGW,
et ce sont des paquetages autonomes. Pour utiliser la version Cygwin,
il vous faut un environnement Cygwin installé.

Les instructions de fabrication des version MinGW sont documentées au
début du fichier win32/installer/Makefile

Les notes d'installation spécifiques à Cygwin se trouvent dans
doc/INSTALL.Cygwin (en anglais) ou dans doc/fr/INSTALL.Cygwin.fr (en
français).



** FIN **
