%{
/* Lexer for the FreeCAD  Expression language   */
/* (c) 2010 Juergen Riegel  LGPL           */
/* (c) 2015 Eivind Kvedalen LGPL           */


/* This disables inclusion of unistd.h, which is not available under Visual C++
 * on Win32. The C++ scanner uses STL streams instead. */
#define YY_NO_UNISTD_H

#ifdef _MSC_VER
#define strdup _strdup
#endif

extern std::stack<FunctionExpression::Function> functions;                /**< Function identifier */
extern int last_column;
extern int column;

#define COUNTCHARS do { last_column = column; column += yyleng; } while (0)

%}

/*** Flex Declarations and Options ***/

/* change the name of the scanner class. */
%option prefix="ExpressionParser"

/* the manual says "somewhat more optimized" */
%option batch

%option never-interactive 

/* no support for include files is planned */
%option noyywrap nounput

/* UTF-8 unicode regular expressions. */

Cc	([\x00-\x1f\x7f]|\xc2[\x80-\x9f])
Cf	(\xc2\xad|\xd8[\x80-\x85\x9c]|\xdb\x9d|\xdc\x8f|\xe1(\xa0\x8e)|\xe2(\x80[\x8b-\x8f\xaa-\xae]|\x81[\xa0-\xa4\xa6-\xaf])|\xef(\xbb\xbf|\xbf[\xb9-\xbb])|\xf0(\x91(\x82\xbd))|\xf3(\xa0(\x80\x81)))
Cn11	(\xcd[\xb8-\xb9]|\xce[\x80-\x83\x8b\x8d\xa2]|\xd4\xb0|\xd5[\x97-\x98\xa0]|\xd6[\x88\x8b-\x8c\x90]|\xd7[\x88-\x8f\xab-\xaf\xb5-\xbf]|\xd8\x9d|\xdc\x8e|\xdd[\x8b-\x8c]|\xde[\xb2-\xbf]|\xdf[\xbb-\xbf]|\xe0(\xa0[\xae-\xaf\xbf]|\xa1[\x9c-\x9d\x9f-\xbf]|\xa2[\x80-\x9f\xb3-\xbf]|\xa3[\x80-\xa3]|\xa6[\x84\x8d-\x8e\x91-\x92\xa9\xb1\xb3-\xb5\xba-\xbb]|\xa7[\x85-\x86\x89-\x8a\x8f-\x96\x98-\x9b\x9e\xa4-\xa5\xbc-\xbf]|\xa8[\x80\x84\x8b-\x8e\x91-\x92\xa9\xb1\xb4\xb7\xba-\xbb\xbd]|\xa9[\x83-\x86\x89-\x8a\x8e-\x90\x92-\x98\x9d\x9f-\xa5\xb6-\xbf]|\xaa[\x80\x84\x8e\x92\xa9\xb1\xb4\xba-\xbb]|\xab[\x86\x8a\x8e-\x8f\x91-\x9f\xa4-\xa5\xb2-\xbf]|\xac[\x80\x84\x8d-\x8e\x91-\x92\xa9\xb1\xb4\xba-\xbb]|\xad[\x85-\x86\x89-\x8a\x8e-\x95\x98-\x9b\x9e\xa4-\xa5\xb8-\xbf]|\xae[\x80-\x81\x84\x8b-\x8d\x91\x96-\x98\x9b\x9d\xa0-\xa2\xa5-\xa7\xab-\xad\xba-\xbd]|\xaf[\x83-\x85\x89\x8e-\x8f\x91-\x96\x98-\xa5\xbb-\xbf]|\xb0[\x84\x8d\x91\xa9\xba-\xbc]|\xb1[\x85\x89\x8e-\x94\x97\x9a-\x9f\xa4-\xa5\xb0-\xb7]|\xb2[\x80\x84\x8d\x91\xa9\xb4\xba-\xbb]|\xb3[\x85\x89\x8e-\x94\x97-\x9d\x9f\xa4-\xa5\xb0\xb3-\xbf]|\xb4[\x80\x84\x8d\x91\xbb-\xbc]|\xb5[\x85\x89\x8f-\x96\x98-\x9f\xa4-\xa5\xb6-\xb8]|\xb6[\x80-\x81\x84\x97-\x99\xb2\xbc\xbe-\xbf]|\xb7[\x87-\x89\x8b-\x8d]))
Cn12	(\xe0(\xb7[\x8e\x95\x97\xa0-\xa5\xb0-\xb1\xb5-\xbf]|\xb8[\x80\xbb-\xbe]|\xb9[\x9c-\xbf]|\xba[\x80\x83\x85-\x86\x89\x8b-\x8c\x8e-\x93\x98\xa0\xa4\xa6\xa8-\xa9\xac\xba\xbe-\xbf]|\xbb[\x85\x87\x8e-\x8f\x9a-\x9b\xa0-\xbf]|\xbd[\x88\xad-\xb0]|\xbe[\x98\xbd]|\xbf[\x8d\x9b-\xbf])|\xe1(\x83[\x86\x88-\x8c\x8e-\x8f]|\x89[\x89\x8e-\x8f\x97\x99\x9e-\x9f]|\x8a[\x89\x8e-\x8f\xb1\xb6-\xb7\xbf]|\x8b[\x81\x86-\x87\x97]|\x8c[\x91\x96-\x97]|\x8d[\x9b-\x9c\xbd-\xbf]|\x8e[\x9a-\x9f]|\x8f[\xb5-\xbf]|\x9a[\x9d-\x9f]|\x9b[\xb9-\xbf]|\x9c[\x8d\x95-\x9f\xb7-\xbf]|\x9d[\x94-\x9f\xad\xb1\xb4-\xbf]|\x9f[\x9e-\x9f\xaa-\xaf\xba-\xbf]|\xa0[\x8f\x9a-\x9f]|\xa1[\xb8-\xbf]|\xa2[\xab-\xaf]|\xa3[\xb6-\xbf]|\xa4[\x9f\xac-\xaf\xbc-\xbf]|\xa5[\x81-\x83\xae-\xaf\xb5-\xbf]|\xa6[\xac-\xaf]|\xa7[\x8a-\x8f\x9b-\x9d]|\xa8[\x9c-\x9d]|\xa9[\x9f\xbd-\xbe]|\xaa[\x8a-\x8f\x9a-\x9f\xae-\xaf\xbf]|\xab[\x80-\xbf]|\xad[\x8c-\x8f\xbd-\xbf]|\xaf[\xb4-\xbb]|\xb0[\xb8-\xba]|\xb1[\x8a-\x8c]|\xb2[\x80-\xbc]))
Cn1	({Cn11}|{Cn12})
Cn21	(\xe1(\xb2[\xbd-\xbf]|\xb3[\x88-\x8f\xb7\xba-\xbf]|\xb7[\xb6-\xbb]|\xbc[\x96-\x97\x9e-\x9f]|\xbd[\x86-\x87\x8e-\x8f\x98\x9a\x9c\x9e\xbe-\xbf]|\xbe\xb5|\xbf[\x85\x94-\x95\x9c\xb0-\xb1\xb5\xbf])|\xe2(\x81[\xa5\xb2-\xb3]|\x82[\x8f\x9d-\x9f\xbe-\xbf]|\x83[\x80-\x8f\xb1-\xbf]|\x86[\x8a-\x8f]|\x8f[\xbb-\xbf]|\x90[\xa7-\xbf]|\x91[\x8b-\x9f]|\xad[\xb4-\xb5]|\xae[\x96-\x97\xba-\xbc]|\xaf[\x89\x92-\xbf]|\xb0\xaf|\xb1\x9f|\xb3[\xb4-\xb8]|\xb4[\xa6\xa8-\xac\xae-\xaf]|\xb5[\xa8-\xae\xb1-\xbe]|\xb6[\x97-\x9f\xa7\xaf\xb7\xbf]|\xb7[\x87\x8f\x97\x9f]|\xb9[\x83-\xbf]|\xba\x9a|\xbb[\xb4-\xbf]|\xbf[\x96-\xaf\xbc-\xbf])|\xe3(\x81\x80|\x82[\x97-\x98]|\x84[\x80-\x84\xae-\xb0]|\x86[\x8f\xbb-\xbf]|\x87[\xa4-\xaf]|\x88\x9f|\x8b\xbf)|\xe4(\xb6[\xb6-\xbf])|\xe9(\xbf[\x8d-\xbf])|\xea(\x92[\x8d-\x8f]|\x93[\x87-\x8f]|\x98[\xac-\xbf]|\x9a\x9e|\x9b[\xb8-\xbf]|\x9e[\x8f\xae-\xaf\xb2-\xbf]|\x9f[\x80-\x92]))
Cn22	(\xea(\x9f[\x93-\xb6]|\xa0[\xac-\xaf\xba-\xbf]|\xa1[\xb8-\xbf]|\xa3[\x85-\x8d\x9a-\x9f\xbc-\xbf]|\xa5[\x94-\x9e\xbd-\xbf]|\xa7[\x8e\x9a-\x9d\xbf]|\xa8[\xb7-\xbf]|\xa9[\x8e-\x8f\x9a-\x9b]|\xab[\x83-\x9a\xb7-\xbf]|\xac[\x80\x87-\x88\x8f-\x90\x97-\x9f\xa7\xaf]|\xad[\xa0-\xa3\xa6-\xbf]|\xae[\x80-\xbf]|\xaf[\xae-\xaf\xba-\xbf])|\xed(\x9e[\xa4-\xaf]|\x9f[\x87-\x8a\xbc-\xbf])|\xef(\xa9[\xae-\xaf]|\xab[\x9a-\xbf]|\xac[\x87-\x92\x98-\x9c\xb7\xbd\xbf]|\xad[\x82\x85]|\xaf[\x82-\x92]|\xb5[\x80-\x8f]|\xb6[\x90-\x91]|\xb7[\x88-\xaf\xbe-\xbf]|\xb8[\x9a-\x9f\xae-\xaf]|\xb9[\x93\xa7\xac-\xaf\xb5]|\xbb[\xbd-\xbe]|\xbc\x80|\xbe\xbf|\xbf[\x80-\x81\x88-\x89\x90-\x91\x98-\x99\x9d-\x9f\xa7\xaf-\xb8\xbe-\xbf])|\xf0(\x90(\x80[\x8c\xa7\xbb\xbe]|\x8e\x9e|\xa0[\x89\xb6]|\xa1\x96|\xa8[\x84\x94\x98])|\x91(\x84\xb5|\x88\x92|\x8c[\x84\xa9\xb1\xb4])|\x92(\x91\xaf)|\x96(\xa9\x9f|\xad[\x9a\xa2])|\x9d(\x91\x95|\x92[\x9d\xad\xba\xbc]|\x93\x84|\x94[\x86\x95\x9d\xba\xbf]|\x95[\x85\x91])|\x9e(\xb8[\x84\xa0\xa3\xa8\xb3\xb8\xba]|\xb9[\x88\x8a\x8c\x90\x93\x98\x9a\x9c\x9e\xa0\xa3\xab\xb3\xb8\xbd\xbf]|\xba[\x8a\xa4\xaa])|\x9f(\x83[\x80\x90]|\x84\xaf|\x93\xbf|\x95\xba|\x96\xa4)))
Cn2	({Cn21}|{Cn22})
Cn	({Cn1}|{Cn2})
Co	(\xee(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xef(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]))
Ll1	([a-z]|\xc2\xb5|\xc3[\x9f-\xb6\xb8-\xbf]|\xc4[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7-\xb8\xba\xbc\xbe]|\xc5[\x80\x82\x84\x86\x88-\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7\xba\xbc\xbe-\xbf]|\xc6[\x80\x83\x85\x88\x8c-\x8d\x92\x95\x99-\x9b\x9e\xa1\xa3\xa5\xa8\xaa-\xab\xad\xb0\xb4\xb6\xb9-\xba\xbd-\xbf]|\xc7[\x86\x89\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c-\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf-\xb0\xb3\xb5\xb9\xbb\xbd\xbf]|\xc8[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3-\xb9\xbc\xbf]|\xc9[\x80\x82\x87\x89\x8b\x8d\x8f-\xbf]|\xca[\x80-\x93\x95-\xaf]|\xcd[\xb1\xb3\xb7\xbb-\xbd]|\xce[\x90\xac-\xbf]|\xcf[\x80-\x8e\x90-\x91\x95-\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf-\xb3\xb5\xb8\xbb-\xbc]|\xd0[\xb0-\xbf]|\xd1[\x80-\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7\xb9\xbb\xbd\xbf]|\xd2[\x81\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7\xb9\xbb\xbd\xbf]|\xd3[\x82\x84\x86\x88\x8a\x8c\x8e-\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7\xb9\xbb\xbd\xbf]|\xd4[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf]|\xd5[\xa1-\xbf]|\xd6[\x80-\x87]|\xe1(\xb4[\x80-\xab]|\xb5[\xab-\xb7\xb9-\xbf]|\xb6[\x80-\x85]))
Ll2	(\xe1(\xb6[\x86-\x9a]|\xb8[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7\xb9\xbb\xbd\xbf]|\xb9[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7\xb9\xbb\xbd\xbf]|\xba[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95-\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7\xb9\xbb\xbd\xbf]|\xbb[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7\xb9\xbb\xbd\xbf]|\xbc[\x80-\x87\x90-\x95\xa0-\xa7\xb0-\xb7]|\xbd[\x80-\x85\x90-\x97\xa0-\xa7\xb0-\xbd]|\xbe[\x80-\x87\x90-\x97\xa0-\xa7\xb0-\xb4\xb6-\xb7\xbe]|\xbf[\x82-\x84\x86-\x87\x90-\x93\x96-\x97\xa0-\xa7\xb2-\xb4\xb6-\xb7])|\xe2(\x84[\x8a\x8e-\x8f\x93\xaf\xb4\xb9\xbc-\xbd]|\x85[\x86-\x89\x8e]|\x86\x84|\xb0[\xb0-\xbf]|\xb1[\x80-\x9e\xa1\xa5-\xa6\xa8\xaa\xac\xb1\xb3-\xb4\xb6-\xbb]|\xb2[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1\xb3\xb5\xb7\xb9\xbb\xbd\xbf]|\xb3[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3-\xa4\xac\xae\xb3]|\xb4[\x80-\xa5\xa7\xad])|\xea(\x99[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad]|\x9a[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b]|\x9c[\xa3\xa5\xa7\xa9\xab\xad\xaf-\xb1\xb3\xb5\xb7\xb9\xbb\xbd\xbf]|\x9d[\x81\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9\xab\xad\xaf\xb1-\xb8\xba\xbc\xbf]|\x9e[\x81\x83\x85\x87\x8c\x8e\x91\x93-\x95\x97\x99\x9b\x9d\x9f\xa1\xa3\xa5\xa7\xa9]|\x9f\xba|\xac[\xb0-\xbf]|\xad[\x80-\x9a\xa4-\xa5])|\xef(\xac[\x80-\x86\x93-\x97]|\xbd[\x81-\x9a])|\xf0(\x9d(\x92\xbb|\x9f\x8b)))
Ll	({Ll1}|{Ll2})
Lm	(\xca[\xb0-\xbf]|\xcb[\x80-\x81\x86-\x91\xa0-\xa4\xac\xae]|\xcd[\xb4\xba]|\xd5\x99|\xd9\x80|\xdb[\xa5-\xa6]|\xdf[\xb4-\xb5\xba]|\xe0(\xa0[\x9a\xa4\xa8]|\xa5\xb1|\xb9\x86|\xbb\x86)|\xe1(\x83\xbc|\x9f\x97|\xa1\x83|\xaa\xa7|\xb1[\xb8-\xbd]|\xb4[\xac-\xbf]|\xb5[\x80-\xaa\xb8]|\xb6[\x9b-\xbf])|\xe2(\x81[\xb1\xbf]|\x82[\x90-\x9c]|\xb1[\xbc-\xbd]|\xb5\xaf|\xb8\xaf)|\xe3(\x80[\x85\xb1-\xb5\xbb]|\x82[\x9d-\x9e]|\x83[\xbc-\xbe])|\xea(\x80\x95|\x93[\xb8-\xbd]|\x98\x8c|\x99\xbf|\x9a[\x9c-\x9d]|\x9c[\x97-\x9f]|\x9d\xb0|\x9e\x88|\x9f[\xb8-\xb9]|\xa7[\x8f\xa6]|\xa9\xb0|\xab[\x9d\xb3-\xb4]|\xad[\x9c-\x9f])|\xef(\xbd\xb0|\xbe[\x9e-\x9f]))
Lo11111	(\xc2[\xaa\xba]|\xc6\xbb|\xc7[\x80-\x83]|\xca\x94|\xd7[\x90-\xaa\xb0-\xb2]|\xd8[\xa0-\xbf]|\xd9[\x81-\x8a\xae-\xaf\xb1-\xbf]|\xda[\x80-\xbf]|\xdb[\x80-\x93\x95\xae-\xaf\xba-\xbc\xbf]|\xdc[\x90\x92-\xaf]|\xdd[\x8d-\xbf]|\xde[\x80-\xa5\xb1]|\xdf[\x8a-\xaa]|\xe0(\xa0[\x80-\x95]|\xa1[\x80-\x98]|\xa2[\xa0-\xb2]|\xa4[\x84-\xb9\xbd]|\xa5[\x90\x98-\xa1\xb2-\xbf]|\xa6[\x80\x85-\x8c\x8f-\x90\x93-\xa8\xaa-\xb0\xb2\xb6-\xb9\xbd]|\xa7[\x8e\x9c-\x9d\x9f-\xa1\xb0-\xb1]|\xa8[\x85-\x8a\x8f-\x90\x93-\xa8\xaa-\xb0\xb2-\xb3\xb5-\xb6\xb8-\xb9]|\xa9[\x99-\x9c\x9e\xb2-\xb4]|\xaa[\x85-\x8d\x8f-\x91\x93-\xa8\xaa-\xb0\xb2-\xb3\xb5-\xb9\xbd]|\xab[\x90\xa0-\xa1]|\xac[\x85-\x8c\x8f-\x90\x93-\xa8\xaa-\xb0\xb2-\xb3\xb5-\xb9\xbd]|\xad[\x9c-\x9d\x9f-\xa1\xb1]|\xae[\x83\x85-\x8a\x8e-\x90\x92-\x95\x99-\x9a\x9c\x9e-\x9f\xa3-\xa4\xa8-\xaa\xae-\xb9]|\xaf\x90|\xb0[\x85-\x8c\x8e-\x90\x92-\xa8\xaa-\xb9\xbd]|\xb1[\x98-\x99\xa0-\xa1]|\xb2[\x85-\x8c\x8e-\x90\x92-\xa8\xaa-\xb3\xb5-\xb9\xbd]|\xb3[\x9e\xa0-\xa1\xb1-\xb2]|\xb4[\x85-\x8c\x8e-\x90\x92-\xba\xbd]|\xb5[\x8e\xa0-\xa1\xba-\xbf]|\xb6[\x85-\x96\x9a-\xb1\xb3-\xbb\xbd]|\xb7[\x80-\x86]|\xb8[\x81-\xb0\xb2-\xb3]|\xb9[\x80-\x85]|\xba[\x81-\x82\x84\x87-\x88\x8a\x8d\x94-\x97\x99-\x9f\xa1-\xa3\xa5\xa7\xaa-\xab\xad-\xb0\xb2-\xb3\xbd]|\xbb[\x80-\x84\x9c-\x9f]|\xbc\x80|\xbd[\x80-\x87\x89-\xac]|\xbe[\x88-\x8c])|\xe1(\x80[\x80-\xaa\xbf]|\x81[\x90-\x95\x9a-\x9d\xa1\xa5-\xa6\xae-\xb0\xb5-\xbf]|\x82[\x80-\x81\x8e]|\x83[\x90-\xba\xbd-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\x8e]))
Lo11112	(\xe1(\x87[\x8f-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\x88\x8a-\x8d\x90-\x96\x98\x9a-\x9d\xa0-\xbf]|\x8a[\x80-\x88\x8a-\x8d\x90-\xb0\xb2-\xb5\xb8-\xbe]|\x8b[\x80\x82-\x85\x88-\x96\x98-\xbf]|\x8c[\x80-\x90\x92-\x95\x98-\xbf]|\x8d[\x80-\x9a]|\x8e[\x80-\x8f\xa0-\xbf]|\x8f[\x80-\xb4]|\x90[\x81-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xac\xaf-\xbf]|\x9a[\x81-\x9a\xa0-\xbf]|\x9b[\x80-\xaa\xb1-\xb8]|\x9c[\x80-\x8c\x8e-\x91\xa0-\xb1]|\x9d[\x80-\x91\xa0-\xac\xae-\xb0]|\x9e[\x80-\xb3]|\x9f\x9c|\xa0[\xa0-\xbf]|\xa1[\x80-\x82\x84-\xb7]|\xa2[\x80-\x89]))
Lo1111	({Lo11111}|{Lo11112})
Lo1112	(\xe1(\xa2[\x8a-\xa8\xaa\xb0-\xbf]|\xa3[\x80-\xb5]|\xa4[\x80-\x9e]|\xa5[\x90-\xad\xb0-\xb4]|\xa6[\x80-\xab]|\xa7[\x81-\x87]|\xa8[\x80-\x96\xa0-\xbf]|\xa9[\x80-\x94]|\xac[\x85-\xb3]|\xad[\x85-\x8b]|\xae[\x83-\xa0\xae-\xaf\xba-\xbf]|\xaf[\x80-\xa5]|\xb0[\x80-\xa3]|\xb1[\x8d-\x8f\x9a-\xb7]|\xb3[\xa9-\xac\xae-\xb1\xb5-\xb6])|\xe2(\x84[\xb5-\xb8]|\xb4[\xb0-\xbf]|\xb5[\x80-\xa7]|\xb6[\x80-\x96\xa0-\xa6\xa8-\xae\xb0-\xb6\xb8-\xbe]|\xb7[\x80-\x86\x88-\x8e\x90-\x96\x98-\x9e])|\xe3(\x80[\x86\xbc]|\x81[\x81-\xbf]|\x82[\x80-\x96\x9f\xa1-\xbf]|\x83[\x80-\xba\xbf]|\x84[\x85-\xad\xb1-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\x8e\xa0-\xba]|\x87[\xb0-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\x97]))
Lo111	({Lo1111}|{Lo1112})
Lo112	(\xe3(\xad[\x98-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe4(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xb5]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe5(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xa3]))
Lo11	({Lo111}|{Lo112})
Lo121	(\xe5(\x88[\xa4-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe6(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xa5]))
Lo122	(\xe6(\xa2[\xa6-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe7(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xa8]))
Lo12	({Lo121}|{Lo122})
Lo1	({Lo11}|{Lo12})
Lo211	(\xe7(\xbc[\xa9-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe8(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe9(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xaa]))
Lo212	(\xe9(\x96[\xab-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\x8c])|\xea(\x80[\x80-\x94\x96-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\x8c]|\x93[\x90-\xb7]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\x8b\x90-\x9f\xaa-\xab]|\x99\xae|\x9a[\xa0-\xbf]|\x9b[\x80-\xa5]|\x9f[\xb7\xbb-\xbf]|\xa0[\x80-\x81\x83-\x85\x87-\x8a\x8c-\xa2]|\xa1[\x80-\xb3]|\xa2[\x82-\xb3]|\xa3[\xb2-\xb7\xbb]|\xa4[\x8a-\xa5\xb0-\xbf]|\xa5[\x80-\x86\xa0-\xbc]|\xa6[\x84-\xb2]|\xa7[\xa0-\xa4\xa7-\xaf\xba-\xbe]|\xa8[\x80-\xa8]|\xa9[\x80-\x82\x84-\x8b\xa0-\xaf\xb1-\xb6\xba\xbe-\xbf]|\xaa[\x80-\xaf\xb1\xb5-\xb6\xb9-\xbd]|\xab[\x80\x82\x9b-\x9c\xa0-\xaa\xb2]|\xac[\x81-\x86\x89-\x8e\x91-\x96\xa0-\xa6\xa8-\xae]|\xaf[\x80-\xa2]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xeb(\x80[\x80-\xbf]|\x81[\x80-\x8a]))
Lo21	({Lo211}|{Lo212})
Lo221	(\xeb(\x81[\x8b-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xec(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\x8c]))
Lo222	(\xec(\x9b[\x8d-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xed(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xa3\xb0-\xbf]|\x9f[\x80-\x86\x8b-\xbb])|\xef(\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xad\xb0-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\x99]|\xac[\x9d\x9f-\xa8\xaa-\xb6\xb8-\xbc\xbe]|\xad[\x80-\x81\x83-\x84\x86-\xbf]|\xae[\x80-\xb1]|\xaf[\x93-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbd]|\xb5[\x90-\xbf]|\xb6[\x80-\x8f\x92-\xbf]|\xb7[\x80-\x87\xb0-\xbb]|\xb9[\xb0-\xb4\xb6-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbc]|\xbd[\xa6-\xaf\xb1-\xbf]|\xbe[\x80-\x9d\xa0-\xbe]|\xbf[\x82-\x87\x8a-\x8f\x92-\x97\x9a-\x9c])|\xf0(\x90(\xa0[\x88\xbc]|\xa8\x80)|\x91(\x85\xb6|\x87\x9a|\x8c\xbd|\x93\x87|\x99\x84|\xa3\xbf)|\x96(\xbd\x90)|\x9e(\xb8[\xa4\xa7\xb9\xbb]|\xb9[\x82\x87\x89\x8b\x94\x97\x99\x9b\x9d\x9f\xa4\xbe])))
Lo22	({Lo221}|{Lo222})
Lo2	({Lo21}|{Lo22})
Lo	({Lo1}|{Lo2})
Lt	(\xc7[\x85\x88\x8b\xb2]|\xe1(\xbe[\x88-\x8f\x98-\x9f\xa8-\xaf\xbc]|\xbf[\x8c\xbc]))
Lu1	([A-Z]|\xc3[\x80-\x96\x98-\x9e]|\xc4[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb9\xbb\xbd\xbf]|\xc5[\x81\x83\x85\x87\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb8-\xb9\xbb\xbd]|\xc6[\x81-\x82\x84\x86-\x87\x89-\x8b\x8e-\x91\x93-\x94\x96-\x98\x9c-\x9d\x9f-\xa0\xa2\xa4\xa6-\xa7\xa9\xac\xae-\xaf\xb1-\xb3\xb5\xb7-\xb8\xbc]|\xc7[\x84\x87\x8a\x8d\x8f\x91\x93\x95\x97\x99\x9b\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb1\xb4\xb6-\xb8\xba\xbc\xbe]|\xc8[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xba-\xbb\xbd-\xbe]|\xc9[\x81\x83-\x86\x88\x8a\x8c\x8e]|\xcd[\xb0\xb2\xb6\xbf]|\xce[\x86\x88-\x8a\x8c\x8e-\x8f\x91-\xa1\xa3-\xab]|\xcf[\x8f\x92-\x94\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb4\xb7\xb9-\xba\xbd-\xbf]|\xd0[\x80-\xaf]|\xd1[\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb8\xba\xbc\xbe]|\xd2[\x80\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb8\xba\xbc\xbe]|\xd3[\x80-\x81\x83\x85\x87\x89\x8b\x8d\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb8\xba\xbc\xbe]|\xd4[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb1-\xbf]|\xd5[\x80-\x96]|\xe1(\x82[\xa0-\xb4]))
Lu2	(\xe1(\x82[\xb5-\xbf]|\x83[\x80-\x85\x87\x8d]|\xb8[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb8\xba\xbc\xbe]|\xb9[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb8\xba\xbc\xbe]|\xba[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb8\xba\xbc\xbe]|\xbb[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb8\xba\xbc\xbe]|\xbc[\x88-\x8f\x98-\x9d\xa8-\xaf\xb8-\xbf]|\xbd[\x88-\x8d\x99\x9b\x9d\x9f\xa8-\xaf]|\xbe[\xb8-\xbb]|\xbf[\x88-\x8b\x98-\x9b\xa8-\xac\xb8-\xbb])|\xe2(\x84[\x82\x87\x8b-\x8d\x90-\x92\x95\x99-\x9d\xa4\xa6\xa8\xaa-\xad\xb0-\xb3\xbe-\xbf]|\x85\x85|\x86\x83|\xb0[\x80-\xae]|\xb1[\xa0\xa2-\xa4\xa7\xa9\xab\xad-\xb0\xb2\xb5\xbe-\xbf]|\xb2[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb0\xb2\xb4\xb6\xb8\xba\xbc\xbe]|\xb3[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xab\xad\xb2])|\xea(\x99[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac]|\x9a[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a]|\x9c[\xa2\xa4\xa6\xa8\xaa\xac\xae\xb2\xb4\xb6\xb8\xba\xbc\xbe]|\x9d[\x80\x82\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa\xac\xae\xb9\xbb\xbd-\xbe]|\x9e[\x80\x82\x84\x86\x8b\x8d\x90\x92\x96\x98\x9a\x9c\x9e\xa0\xa2\xa4\xa6\xa8\xaa-\xad\xb0-\xb1])|\xef(\xbc[\xa1-\xba])|\xf0(\x9d(\x92[\x9c\xa2]|\x95\x86|\x9f\x8a)))
Lu	({Lu1}|{Lu2})
Mc	(\xe0(\xa4[\x83\xbb\xbe-\xbf]|\xa5[\x80\x89-\x8c\x8e-\x8f]|\xa6[\x82-\x83\xbe-\xbf]|\xa7[\x80\x87-\x88\x8b-\x8c\x97]|\xa8[\x83\xbe-\xbf]|\xa9\x80|\xaa[\x83\xbe-\xbf]|\xab[\x80\x89\x8b-\x8c]|\xac[\x82-\x83\xbe]|\xad[\x80\x87-\x88\x8b-\x8c\x97]|\xae[\xbe-\xbf]|\xaf[\x81-\x82\x86-\x88\x8a-\x8c\x97]|\xb0[\x81-\x83]|\xb1[\x81-\x84]|\xb2[\x82-\x83\xbe]|\xb3[\x80-\x84\x87-\x88\x8a-\x8b\x95-\x96]|\xb4[\x82-\x83\xbe-\xbf]|\xb5[\x80\x86-\x88\x8a-\x8c\x97]|\xb6[\x82-\x83]|\xb7[\x8f-\x91\x98-\x9f\xb2-\xb3]|\xbc[\xbe-\xbf]|\xbd\xbf)|\xe1(\x80[\xab-\xac\xb1\xb8\xbb-\xbc]|\x81[\x96-\x97\xa2-\xa4\xa7-\xad]|\x82[\x83-\x84\x87-\x8c\x8f\x9a-\x9c]|\x9e[\xb6\xbe-\xbf]|\x9f[\x80-\x85\x87-\x88]|\xa4[\xa3-\xa6\xa9-\xab\xb0-\xb1\xb3-\xb8]|\xa6[\xb0-\xbf]|\xa7[\x80\x88-\x89]|\xa8[\x99-\x9a]|\xa9[\x95\x97\xa1\xa3-\xa4\xad-\xb2]|\xac[\x84\xb5\xbb\xbd-\xbf]|\xad[\x80-\x81\x83-\x84]|\xae[\x82\xa1\xa6-\xa7\xaa]|\xaf[\xa7\xaa-\xac\xae\xb2-\xb3]|\xb0[\xa4-\xab\xb4-\xb5]|\xb3[\xa1\xb2-\xb3])|\xe3(\x80[\xae-\xaf])|\xea(\xa0[\xa3-\xa4\xa7]|\xa2[\x80-\x81\xb4-\xbf]|\xa3[\x80-\x83]|\xa5[\x92-\x93]|\xa6[\x83\xb4-\xb5\xba-\xbb\xbd-\xbf]|\xa7\x80|\xa8[\xaf-\xb0\xb3-\xb4]|\xa9[\x8d\xbb\xbd]|\xab[\xab\xae-\xaf\xb5]|\xaf[\xa3-\xa4\xa6-\xa7\xa9-\xaa\xac])|\xf0(\x91(\x80[\x80\x82]|\x82\x82|\x84\xac|\x86\x82|\x88\xb5|\x8d\x97|\x92\xb9|\x93\x81|\x96\xbe|\x98\xbe|\x9a[\xac\xb6])))
Me	(\xd2[\x88-\x89]|\xe1(\xaa\xbe)|\xe2(\x83[\x9d-\xa0\xa2-\xa4])|\xea(\x99[\xb0-\xb2]))
Mn1	(\xcc[\x80-\xbf]|\xcd[\x80-\xaf]|\xd2[\x83-\x87]|\xd6[\x91-\xbd\xbf]|\xd7[\x81-\x82\x84-\x85\x87]|\xd8[\x90-\x9a]|\xd9[\x8b-\x9f\xb0]|\xdb[\x96-\x9c\x9f-\xa4\xa7-\xa8\xaa-\xad]|\xdc[\x91\xb0-\xbf]|\xdd[\x80-\x8a]|\xde[\xa6-\xb0]|\xdf[\xab-\xb3]|\xe0(\xa0[\x96-\x99\x9b-\xa3\xa5-\xa7\xa9-\xad]|\xa1[\x99-\x9b]|\xa3[\xa4-\xbf]|\xa4[\x80-\x82\xba\xbc]|\xa5[\x81-\x88\x8d\x91-\x97\xa2-\xa3]|\xa6[\x81\xbc]|\xa7[\x81-\x84\x8d\xa2-\xa3]|\xa8[\x81-\x82\xbc]|\xa9[\x81-\x82\x87-\x88\x8b-\x8d\x91\xb0-\xb1\xb5]|\xaa[\x81-\x82\xbc]|\xab[\x81-\x85\x87-\x88\x8d\xa2-\xa3]|\xac[\x81\xbc\xbf]|\xad[\x81-\x84\x8d\x96\xa2-\xa3]|\xae\x82|\xaf[\x80\x8d]|\xb0[\x80\xbe-\xbf]|\xb1[\x80\x86-\x88\x8a-\x8d\x95-\x96\xa2-\xa3]|\xb2[\x81\xbc\xbf]|\xb3[\x86\x8c-\x8d\xa2-\xa3]|\xb4\x81|\xb5[\x81-\x84\x8d\xa2-\xa3]|\xb7[\x8a\x92-\x94\x96]|\xb8[\xb1\xb4-\xba]|\xb9[\x87-\x8e]|\xba[\xb1\xb4-\xb9\xbb-\xbc]|\xbb[\x88-\x8d]|\xbc[\x98-\x99\xb5\xb7\xb9]|\xbd[\xb1-\xbe]|\xbe[\x80-\x84\x86-\x87\x8d-\x97\x99-\x9a]))
Mn2	(\xe0(\xbe[\x9b-\xbc]|\xbf\x86)|\xe1(\x80[\xad-\xb0\xb2-\xb7\xb9-\xba\xbd-\xbe]|\x81[\x98-\x99\x9e-\xa0\xb1-\xb4]|\x82[\x82\x85-\x86\x8d\x9d]|\x8d[\x9d-\x9f]|\x9c[\x92-\x94\xb2-\xb4]|\x9d[\x92-\x93\xb2-\xb3]|\x9e[\xb4-\xb5\xb7-\xbd]|\x9f[\x86\x89-\x93\x9d]|\xa0[\x8b-\x8d]|\xa2\xa9|\xa4[\xa0-\xa2\xa7-\xa8\xb2\xb9-\xbb]|\xa8[\x97-\x98\x9b]|\xa9[\x96\x98-\x9e\xa0\xa2\xa5-\xac\xb3-\xbc\xbf]|\xaa[\xb0-\xbd]|\xac[\x80-\x83\xb4\xb6-\xba\xbc]|\xad[\x82\xab-\xb3]|\xae[\x80-\x81\xa2-\xa5\xa8-\xa9\xab-\xad]|\xaf[\xa6\xa8-\xa9\xad\xaf-\xb1]|\xb0[\xac-\xb3\xb6-\xb7]|\xb3[\x90-\x92\x94-\xa0\xa2-\xa8\xad\xb4\xb8-\xb9]|\xb7[\x80-\xb5\xbc-\xbf])|\xe2(\x83[\x90-\x9c\xa1\xa5-\xb0]|\xb3[\xaf-\xb1]|\xb5\xbf|\xb7[\xa0-\xbf])|\xe3(\x80[\xaa-\xad]|\x82[\x99-\x9a])|\xea(\x99[\xaf\xb4-\xbd]|\x9a\x9f|\x9b[\xb0-\xb1]|\xa0[\x82\x86\x8b\xa5-\xa6]|\xa3[\x84\xa0-\xb1]|\xa4[\xa6-\xad]|\xa5[\x87-\x91]|\xa6[\x80-\x82\xb3\xb6-\xb9\xbc]|\xa7\xa5|\xa8[\xa9-\xae\xb1-\xb2\xb5-\xb6]|\xa9[\x83\x8c\xbc]|\xaa[\xb0\xb2-\xb4\xb7-\xb8\xbe-\xbf]|\xab[\x81\xac-\xad\xb6]|\xaf[\xa5\xa8\xad])|\xef(\xac\x9e|\xb8[\x80-\x8f\xa0-\xad])|\xf0(\x90(\x87\xbd|\x8b\xa0|\xa8\xbf)|\x91(\x80\x81|\x85\xb3|\x88\xb4|\x8b\x9f|\x8c[\x81\xbc]|\x8d\x80|\x92\xba|\x98\xbd|\x9a[\xab\xad\xb7])))
Mn	({Mn1}|{Mn2})
Nd	([0-9]|\xd9[\xa0-\xa9]|\xdb[\xb0-\xb9]|\xdf[\x80-\x89]|\xe0(\xa5[\xa6-\xaf]|\xa7[\xa6-\xaf]|\xa9[\xa6-\xaf]|\xab[\xa6-\xaf]|\xad[\xa6-\xaf]|\xaf[\xa6-\xaf]|\xb1[\xa6-\xaf]|\xb3[\xa6-\xaf]|\xb5[\xa6-\xaf]|\xb7[\xa6-\xaf]|\xb9[\x90-\x99]|\xbb[\x90-\x99]|\xbc[\xa0-\xa9])|\xe1(\x81[\x80-\x89]|\x82[\x90-\x99]|\x9f[\xa0-\xa9]|\xa0[\x90-\x99]|\xa5[\x86-\x8f]|\xa7[\x90-\x99]|\xaa[\x80-\x89\x90-\x99]|\xad[\x90-\x99]|\xae[\xb0-\xb9]|\xb1[\x80-\x89\x90-\x99])|\xea(\x98[\xa0-\xa9]|\xa3[\x90-\x99]|\xa4[\x80-\x89]|\xa7[\x90-\x99\xb0-\xb9]|\xa9[\x90-\x99]|\xaf[\xb0-\xb9])|\xef(\xbc[\x90-\x99]))
Nl	(\xe1(\x9b[\xae-\xb0])|\xe2(\x85[\xa0-\xbf]|\x86[\x80-\x82\x85-\x88])|\xe3(\x80[\x87\xa1-\xa9\xb8-\xba])|\xea(\x9b[\xa6-\xaf])|\xf0(\x90(\x8d[\x81\x8a])))
No	(\xc2[\xb2-\xb3\xb9\xbc-\xbe]|\xe0(\xa7[\xb4-\xb9]|\xad[\xb2-\xb7]|\xaf[\xb0-\xb2]|\xb1[\xb8-\xbe]|\xb5[\xb0-\xb5]|\xbc[\xaa-\xb3])|\xe1(\x8d[\xa9-\xbc]|\x9f[\xb0-\xb9]|\xa7\x9a)|\xe2(\x81[\xb0\xb4-\xb9]|\x82[\x80-\x89]|\x85[\x90-\x9f]|\x86\x89|\x91[\xa0-\xbf]|\x92[\x80-\x9b]|\x93[\xaa-\xbf]|\x9d[\xb6-\xbf]|\x9e[\x80-\x93]|\xb3\xbd)|\xe3(\x86[\x92-\x95]|\x88[\xa0-\xa9]|\x89[\x88-\x8f\x91-\x9f]|\x8a[\x80-\x89\xb1-\xbf])|\xea(\xa0[\xb0-\xb5]))
Pc	(_|\xe2(\x80\xbf|\x81[\x80\x94])|\xef(\xb8[\xb3-\xb4]|\xb9[\x8d-\x8f]|\xbc\xbf))
Pd	(-|\xd6[\x8a\xbe]|\xe1(\x90\x80|\xa0\x86)|\xe2(\x80[\x90-\x95]|\xb8[\x97\x9a\xba-\xbb]|\xb9\x80)|\xe3(\x80[\x9c\xb0]|\x82\xa0)|\xef(\xb8[\xb1-\xb2]|\xb9[\x98\xa3]|\xbc\x8d))
Pe	([\)\]\}]|\xe0(\xbc[\xbb\xbd])|\xe1(\x9a\x9c)|\xe2(\x81[\x86\xbe]|\x82\x8e|\x8c[\x89\x8b\xaa]|\x9d[\xa9\xab\xad\xaf\xb1\xb3\xb5]|\x9f[\x86\xa7\xa9\xab\xad\xaf]|\xa6[\x84\x86\x88\x8a\x8c\x8e\x90\x92\x94\x96\x98]|\xa7[\x99\x9b\xbd]|\xb8[\xa3\xa5\xa7\xa9])|\xe3(\x80[\x89\x8b\x8d\x8f\x91\x95\x97\x99\x9b\x9e-\x9f])|\xef(\xb4\xbe|\xb8[\x98\xb6\xb8\xba\xbc\xbe]|\xb9[\x80\x82\x84\x88\x9a\x9c\x9e]|\xbc[\x89\xbd]|\xbd[\x9d\xa0\xa3]))
Pf	(\xc2\xbb|\xe2(\x80[\x99\x9d\xba]|\xb8[\x83\x85\x8a\x8d\x9d\xa1]))
Pi	(\xc2\xab|\xe2(\x80[\x98\x9b-\x9c\x9f\xb9]|\xb8[\x82\x84\x89\x8c\x9c\xa0]))
Po	([!-\#%-\'\*,\.-\/\:-;\?-@\\]|\xc2[\xa1\xa7\xb6-\xb7\xbf]|\xcd\xbe|\xce\x87|\xd5[\x9a-\x9f]|\xd6\x89|\xd7[\x80\x83\x86\xb3-\xb4]|\xd8[\x89-\x8a\x8c-\x8d\x9b\x9e-\x9f]|\xd9[\xaa-\xad]|\xdb\x94|\xdc[\x80-\x8d]|\xdf[\xb7-\xb9]|\xe0(\xa0[\xb0-\xbe]|\xa1\x9e|\xa5[\xa4-\xa5\xb0]|\xab\xb0|\xb7\xb4|\xb9[\x8f\x9a-\x9b]|\xbc[\x84-\x92\x94]|\xbe\x85|\xbf[\x90-\x94\x99-\x9a])|\xe1(\x81[\x8a-\x8f]|\x83\xbb|\x8d[\xa0-\xa8]|\x99[\xad-\xae]|\x9b[\xab-\xad]|\x9c[\xb5-\xb6]|\x9f[\x94-\x96\x98-\x9a]|\xa0[\x80-\x85\x87-\x8a]|\xa5[\x84-\x85]|\xa8[\x9e-\x9f]|\xaa[\xa0-\xa6\xa8-\xad]|\xad[\x9a-\xa0]|\xaf[\xbc-\xbf]|\xb0[\xbb-\xbf]|\xb1[\xbe-\xbf]|\xb3[\x80-\x87\x93])|\xe2(\x80[\x96-\x97\xa0-\xa7\xb0-\xb8\xbb-\xbe]|\x81[\x81-\x83\x87-\x91\x93\x95-\x9e]|\xb3[\xb9-\xbc\xbe-\xbf]|\xb5\xb0|\xb8[\x80-\x81\x86-\x88\x8b\x8e-\x96\x98-\x99\x9b\x9e-\x9f\xaa-\xae\xb0-\xb9\xbc-\xbf]|\xb9\x81)|\xe3(\x80[\x81-\x83\xbd]|\x83\xbb)|\xea(\x93[\xbe-\xbf]|\x98[\x8d-\x8f]|\x99[\xb3\xbe]|\x9b[\xb2-\xb7]|\xa1[\xb4-\xb7]|\xa3[\x8e-\x8f\xb8-\xba]|\xa4[\xae-\xaf]|\xa5\x9f|\xa7[\x81-\x8d\x9e-\x9f]|\xa9[\x9c-\x9f]|\xab[\x9e-\x9f\xb0-\xb1]|\xaf\xab)|\xef(\xb8[\x90-\x96\x99\xb0]|\xb9[\x85-\x86\x89-\x8c\x90-\x92\x94-\x97\x9f-\xa1\xa8\xaa-\xab]|\xbc[\x81-\x83\x85-\x87\x8a\x8c\x8e-\x8f\x9a-\x9b\x9f-\xa0\xbc]|\xbd[\xa1\xa4-\xa5])|\xf0(\x90(\x8e\x9f|\x8f\x90|\x95\xaf|\xa1\x97|\xa4[\x9f\xbf]|\xa9\xbf)|\x91(\x87\x8d|\x93\x86)|\x96(\xab\xb5|\xad\x84)|\x9b(\xb2\x9f)))
Ps	([\(\[\{]|\xe0(\xbc[\xba\xbc])|\xe1(\x9a\x9b)|\xe2(\x80[\x9a\x9e]|\x81[\x85\xbd]|\x82\x8d|\x8c[\x88\x8a\xa9]|\x9d[\xa8\xaa\xac\xae\xb0\xb2\xb4]|\x9f[\x85\xa6\xa8\xaa\xac\xae]|\xa6[\x83\x85\x87\x89\x8b\x8d\x8f\x91\x93\x95\x97]|\xa7[\x98\x9a\xbc]|\xb8[\xa2\xa4\xa6\xa8]|\xb9\x82)|\xe3(\x80[\x88\x8a\x8c\x8e\x90\x94\x96\x98\x9a\x9d])|\xef(\xb4\xbf|\xb8[\x97\xb5\xb7\xb9\xbb\xbd\xbf]|\xb9[\x81\x83\x87\x99\x9b\x9d]|\xbc[\x88\xbb]|\xbd[\x9b\x9f\xa2]))
Sc	($|\xc2[\xa2-\xa5]|\xd6\x8f|\xd8\x8b|\xe0(\xa7[\xb2-\xb3\xbb]|\xab\xb1|\xaf\xb9|\xb8\xbf)|\xe1(\x9f\x9b)|\xe2(\x82[\xa0-\xbd])|\xea(\xa0\xb8)|\xef(\xb7\xbc|\xb9\xa9|\xbc\x84|\xbf[\xa0-\xa1\xa5-\xa6]))
Sk	([\^`]|\xc2[\xa8\xaf\xb4\xb8]|\xcb[\x82-\x85\x92-\x9f\xa5-\xab\xad\xaf-\xbf]|\xcd\xb5|\xce[\x84-\x85]|\xe1(\xbe[\xbd\xbf]|\xbf[\x80-\x81\x8d-\x8f\x9d-\x9f\xad-\xaf\xbd-\xbe])|\xe3(\x82[\x9b-\x9c])|\xea(\x9c[\x80-\x96\xa0-\xa1]|\x9e[\x89-\x8a]|\xad\x9b)|\xef(\xae[\xb2-\xbf]|\xaf[\x80-\x81]|\xbc\xbe|\xbd\x80|\xbf\xa3))
Sm	([\+<->\|~]|\xc2[\xac\xb1]|\xc3[\x97\xb7]|\xcf\xb6|\xd8[\x86-\x88]|\xe2(\x81[\x84\x92\xba-\xbc]|\x82[\x8a-\x8c]|\x84\x98|\x85[\x80-\x84\x8b]|\x86[\x90-\x94\x9a-\x9b\xa0\xa3\xa6\xae]|\x87[\x8e-\x8f\x92\x94\xb4-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\xa0-\xa1]|\x8d\xbc|\x8e[\x9b-\xb3]|\x8f[\x9c-\xa1]|\x96\xb7|\x97[\x81\xb8-\xbf]|\x99\xaf|\x9f[\x80-\x84\x87-\xa5\xb0-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\x82\x99-\xbf]|\xa7[\x80-\x97\x9c-\xbb\xbe-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\xb0-\xbf]|\xad[\x80-\x84\x87-\x8c])|\xef(\xac\xa9|\xb9[\xa2\xa4-\xa6]|\xbc[\x8b\x9c-\x9e]|\xbd[\x9c\x9e]|\xbf[\xa2\xa9-\xac])|\xf0(\x9d(\x9b[\x81\x9b\xbb]|\x9c[\x95\xb5]|\x9d[\x8f\xaf]|\x9e[\x89\xa9]|\x9f\x83)))
So	(\xc2[\xa6\xa9\xae\xb0]|\xd2\x82|\xd6[\x8d-\x8e]|\xd8[\x8e-\x8f]|\xdb[\x9e\xa9\xbd-\xbe]|\xdf\xb6|\xe0(\xa7\xba|\xad\xb0|\xaf[\xb3-\xb8\xba]|\xb1\xbf|\xb5\xb9|\xbc[\x81-\x83\x93\x95-\x97\x9a-\x9f\xb4\xb6\xb8]|\xbe[\xbe-\xbf]|\xbf[\x80-\x85\x87-\x8c\x8e-\x8f\x95-\x98])|\xe1(\x82[\x9e-\x9f]|\x8e[\x90-\x99]|\xa5\x80|\xa7[\x9e-\xbf]|\xad[\xa1-\xaa\xb4-\xbc])|\xe2(\x84[\x80-\x81\x83-\x86\x88-\x89\x94\x96-\x97\x9e-\xa3\xa5\xa7\xa9\xae\xba-\xbb]|\x85[\x8a\x8c-\x8d\x8f]|\x86[\x95-\x99\x9c-\x9f\xa1-\xa2\xa4-\xa5\xa7-\xad\xaf-\xbf]|\x87[\x80-\x8d\x90-\x91\x93\x95-\xb3]|\x8c[\x80-\x87\x8c-\x9f\xa2-\xa8\xab-\xbf]|\x8d[\x80-\xbb\xbd-\xbf]|\x8e[\x80-\x9a\xb4-\xbf]|\x8f[\x80-\x9b\xa2-\xba]|\x90[\x80-\xa6]|\x91[\x80-\x8a]|\x92[\x9c-\xbf]|\x93[\x80-\xa9]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xb6\xb8-\xbf]|\x97[\x80\x82-\xb7]|\x98[\x80-\xbf]|\x99[\x80-\xae\xb0-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xa7]|\x9e[\x94-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xac[\x80-\xaf]|\xad[\x85-\x86\x8d-\xb3\xb6-\xbf]|\xae[\x80-\x95\x98-\xb9\xbd-\xbf]|\xaf[\x80-\x88\x8a-\x91]|\xb3[\xa5-\xaa]|\xba[\x80-\x99\x9b-\xbf]|\xbb[\x80-\xb3]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\x95\xb0-\xbb])|\xe3(\x80[\x84\x92-\x93\xa0\xb6-\xb7\xbe-\xbf]|\x86[\x90-\x91\x96-\x9f]|\x87[\x80-\xa3]|\x88[\x80-\x9e\xaa-\xbf]|\x89[\x80-\x87\x90\xa0-\xbf]|\x8a[\x8a-\xb0]|\x8b[\x80-\xbe]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf])|\xe4(\xb7[\x80-\xbf])|\xea(\x92[\x90-\xbf]|\x93[\x80-\x86]|\xa0[\xa8-\xab\xb6-\xb7\xb9]|\xa9[\xb7-\xb9])|\xef(\xb7\xbd|\xbf[\xa4\xa8\xad-\xae\xbc-\xbd])|\xf0(\x90(\x86[\x8c\xa0]|\xab\x88)|\x96(\xad\x85)|\x9b(\xb2\x9c)|\x9d(\x89\x85)))
Zl	(\xe2(\x80\xa8))
Zp	(\xe2(\x80\xa9))
Zs	(\x20|\xc2\xa0|\xe1(\x9a\x80)|\xe2(\x80[\x80-\x8a\xaf]|\x81\x9f)|\xe3(\x80\x80))
L11111	([A-Za-z]|\xc2[\xaa\xb5\xba]|\xc3[\x80-\x96\x98-\xb6\xb8-\xbf]|\xc4[\x80-\xbf]|\xc5[\x80-\xbf]|\xc6[\x80-\xbf]|\xc7[\x80-\xbf]|\xc8[\x80-\xbf]|\xc9[\x80-\xbf]|\xca[\x80-\xbf]|\xcb[\x80-\x81\x86-\x91\xa0-\xa4\xac\xae]|\xcd[\xb0-\xb4\xb6-\xb7\xba-\xbd\xbf]|\xce[\x86\x88-\x8a\x8c\x8e-\xa1\xa3-\xbf]|\xcf[\x80-\xb5\xb7-\xbf]|\xd0[\x80-\xbf]|\xd1[\x80-\xbf]|\xd2[\x80-\x81\x8a-\xbf]|\xd3[\x80-\xbf]|\xd4[\x80-\xaf\xb1-\xbf]|\xd5[\x80-\x96\x99\xa1-\xbf]|\xd6[\x80-\x87]|\xd7[\x90-\xaa\xb0-\xb2]|\xd8[\xa0-\xbf]|\xd9[\x80-\x8a\xae-\xaf\xb1-\xbf]|\xda[\x80-\xbf]|\xdb[\x80-\x93\x95\xa5-\xa6\xae-\xaf\xba-\xbc\xbf]|\xdc[\x90\x92-\xaf]|\xdd[\x8d-\xbf]|\xde[\x80-\xa5\xb1]|\xdf[\x8a-\xaa\xb4-\xb5\xba]|\xe0(\xa0[\x80-\x95\x9a\xa4\xa8]|\xa1[\x80-\x98]|\xa2[\xa0-\xb2]|\xa4[\x84-\x98]))
L11112	(\xe0(\xa4[\x99-\xb9\xbd]|\xa5[\x90\x98-\xa1\xb1-\xbf]|\xa6[\x80\x85-\x8c\x8f-\x90\x93-\xa8\xaa-\xb0\xb2\xb6-\xb9\xbd]|\xa7[\x8e\x9c-\x9d\x9f-\xa1\xb0-\xb1]|\xa8[\x85-\x8a\x8f-\x90\x93-\xa8\xaa-\xb0\xb2-\xb3\xb5-\xb6\xb8-\xb9]|\xa9[\x99-\x9c\x9e\xb2-\xb4]|\xaa[\x85-\x8d\x8f-\x91\x93-\xa8\xaa-\xb0\xb2-\xb3\xb5-\xb9\xbd]|\xab[\x90\xa0-\xa1]|\xac[\x85-\x8c\x8f-\x90\x93-\xa8\xaa-\xb0\xb2-\xb3\xb5-\xb9\xbd]|\xad[\x9c-\x9d\x9f-\xa1\xb1]|\xae[\x83\x85-\x8a\x8e-\x90\x92-\x95\x99-\x9a\x9c\x9e-\x9f\xa3-\xa4\xa8-\xaa\xae-\xb9]|\xaf\x90|\xb0[\x85-\x8c\x8e-\x90\x92-\xa8\xaa-\xb9\xbd]|\xb1[\x98-\x99\xa0-\xa1]|\xb2[\x85-\x8c\x8e-\x90\x92-\xa8\xaa-\xb3\xb5-\xb9\xbd]|\xb3[\x9e\xa0-\xa1\xb1-\xb2]|\xb4[\x85-\x8c\x8e-\x90\x92-\xba\xbd]|\xb5[\x8e\xa0-\xa1\xba-\xbf]|\xb6[\x85-\x96\x9a-\xb1\xb3-\xbb\xbd]|\xb7[\x80-\x86]|\xb8[\x81-\xb0\xb2-\xb3]|\xb9[\x80-\x86]|\xba[\x81-\x82\x84\x87-\x88\x8a\x8d\x94-\x97\x99-\x9f\xa1-\xa3\xa5\xa7\xaa-\xab\xad-\xb0\xb2-\xb3\xbd]|\xbb[\x80-\x84\x86\x9c-\x9f]|\xbc\x80|\xbd[\x80-\x87\x89-\xac]|\xbe[\x88-\x8c])|\xe1(\x80[\x80-\xaa\xbf]|\x81[\x90-\x95\x9a-\x9d\xa1\xa5-\xa6\xae-\xb0\xb5-\xbf]|\x82[\x80-\x81\x8e\xa0-\xbf]|\x83[\x80-\x85\x87\x8d\x90-\xba\xbc-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\x88\x8a-\x8d\x90-\x96\x98\x9a-\x9d\xa0-\xbf]|\x8a[\x80-\x88\x8a-\x8d\x90-\xb0\xb2-\xb5\xb8-\xbe]|\x8b[\x80\x82-\x85\x88-\x96\x98-\xbf]|\x8c[\x80-\x90\x92-\x95\x98-\xbf]|\x8d[\x80-\x9a]|\x8e[\x80-\x8f\xa0-\xbf]|\x8f[\x80-\xa8]))
L1111	({L11111}|{L11112})
L1112	(\xe1(\x8f[\xa9-\xb4]|\x90[\x81-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xac\xaf-\xbf]|\x9a[\x81-\x9a\xa0-\xbf]|\x9b[\x80-\xaa\xb1-\xb8]|\x9c[\x80-\x8c\x8e-\x91\xa0-\xb1]|\x9d[\x80-\x91\xa0-\xac\xae-\xb0]|\x9e[\x80-\xb3]|\x9f[\x97\x9c]|\xa0[\xa0-\xbf]|\xa1[\x80-\xb7]|\xa2[\x80-\xa8\xaa\xb0-\xbf]|\xa3[\x80-\xb5]|\xa4[\x80-\x9e]|\xa5[\x90-\xad\xb0-\xb4]|\xa6[\x80-\xab]|\xa7[\x81-\x87]|\xa8[\x80-\x96\xa0-\xbf]|\xa9[\x80-\x94]|\xaa\xa7|\xac[\x85-\xb3]|\xad[\x85-\x8b]|\xae[\x83-\xa0\xae-\xaf\xba-\xbf]|\xaf[\x80-\xa5]|\xb0[\x80-\xa3]|\xb1[\x8d-\x8f\x9a-\xbd]|\xb3[\xa9-\xac\xae-\xb1\xb5-\xb6]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\x95\x98-\x9d\xa0-\xbf]|\xbd[\x80-\x85\x88-\x8d\x90-\x97\x99\x9b\x9d\x9f-\xbd]|\xbe[\x80-\xb4\xb6-\xbc\xbe]|\xbf[\x82-\x84\x86-\x8c\x90-\x93\x96-\x9b\xa0-\xac\xb2-\xb4\xb6-\xbc])|\xe2(\x81[\xb1\xbf]|\x82[\x90-\x9c]|\x84[\x82\x87\x8a-\x93\x95\x99-\x9d\xa4\xa6\xa8\xaa-\xad\xaf-\xb9\xbc-\xbf]|\x85[\x85-\x89\x8e]|\x86[\x83-\x84]|\xb0[\x80-\xae\xb0-\xbf]|\xb1[\x80-\x9e\xa0-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xa4\xab-\xae\xb2-\xb3]|\xb4[\x80-\xa5\xa7\xad\xb0-\xbf]|\xb5[\x80-\xa7\xaf]|\xb6[\x80-\x96\xa0-\xa6\xa8-\xae\xb0-\xb6\xb8-\xbe]|\xb7[\x80-\x86\x88-\x8e\x90-\x96\x98-\x9e]|\xb8\xaf)|\xe3(\x80[\x85-\x86\xb1-\xb5\xbb-\xbc]|\x81[\x81-\xbf]|\x82[\x80-\x96\x9d-\x9f\xa1-\xbf]|\x83[\x80-\xba\xbc-\xbf]|\x84[\x85-\xad\xb1-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\x8e\xa0-\xba]|\x87[\xb0-\xbf]|\x90[\x80-\xa7]))
L111	({L1111}|{L1112})
L112	(\xe3(\x90[\xa8-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe4(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xa4]))
L11	({L111}|{L112})
L121	(\xe4(\xaf[\xa5-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xb5]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe5(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe6(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xab]))
L122	(\xe6(\x8f[\xac-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe7(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xa9]))
L12	({L121}|{L122})
L1	({L11}|{L12})
L211	(\xe7(\xae[\xaa-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe8(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xe9(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xa6]))
L2121	(\xe9(\x8d[\xa7-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\x84]))
L2122	(\xe9(\xbd[\x85-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\x8c])|\xea(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\x8c]|\x93[\x90-\xbd]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\x8c\x90-\x9f\xaa-\xab]|\x99[\x80-\xae\xbf]|\x9a[\x80-\x9d\xa0-\xbf]|\x9b[\x80-\xa5]|\x9c[\x97-\x9f\xa2-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\x88\x8b-\x8e\x90-\xad\xb0-\xb1]|\x9f[\xb7-\xbf]|\xa0[\x80-\x81\x83-\x85\x87-\x8a\x8c-\xa2]|\xa1[\x80-\xb3]|\xa2[\x82-\xb3]|\xa3[\xb2-\xb7\xbb]|\xa4[\x8a-\xa5\xb0-\xbf]|\xa5[\x80-\x86\xa0-\xbc]|\xa6[\x84-\xb2]|\xa7[\x8f\xa0-\xa4\xa6-\xaf\xba-\xbe]|\xa8[\x80-\xa8]|\xa9[\x80-\x82\x84-\x8b\xa0-\xb6\xba\xbe-\xbf]|\xaa[\x80-\xaf\xb1\xb5-\xb6\xb9-\xbd]|\xab[\x80\x82\x9b-\x9d\xa0-\xaa\xb2-\xb4]|\xac[\x81-\x86\x89-\x8e\x91-\x96\xa0-\xa6\xa8-\xae\xb0-\xbf]|\xad[\x80-\x9a\x9c-\x9f\xa4-\xa5]|\xaf[\x80-\xa2]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\x9d]))
L212	({L2121}|{L2122})
L21	({L211}|{L212})
L221	(\xea(\xb8[\x9e-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xeb(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xec(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\x9a]))
L2221	(\xec(\x97[\x9b-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xed(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xb9]))
L2222	(\xed(\x86[\xba-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xa3\xb0-\xbf]|\x9f[\x80-\x86\x8b-\xbb])|\xef(\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xad\xb0-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\x99]|\xac[\x80-\x86\x93-\x97\x9d\x9f-\xa8\xaa-\xb6\xb8-\xbc\xbe]|\xad[\x80-\x81\x83-\x84\x86-\xbf]|\xae[\x80-\xb1]|\xaf[\x93-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbd]|\xb5[\x90-\xbf]|\xb6[\x80-\x8f\x92-\xbf]|\xb7[\x80-\x87\xb0-\xbb]|\xb9[\xb0-\xb4\xb6-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbc]|\xbc[\xa1-\xba]|\xbd[\x81-\x9a\xa6-\xbf]|\xbe[\x80-\xbe]|\xbf[\x82-\x87\x8a-\x8f\x92-\x97\x9a-\x9c])|\xf0(\x90(\xa0[\x88\xbc]|\xa8\x80)|\x91(\x85\xb6|\x87\x9a|\x8c\xbd|\x93\x87|\x99\x84|\xa3\xbf)|\x96(\xbd\x90)|\x9d(\x92[\x9c\xa2\xbb]|\x95\x86|\x9f[\x8a-\x8b])|\x9e(\xb8[\xa4\xa7\xb9\xbb]|\xb9[\x82\x87\x89\x8b\x94\x97\x99\x9b\x9d\x9f\xa4\xbe])))
L222	({L2221}|{L2222})
L22	({L221}|{L222})
L2	({L21}|{L22})
L	({L1}|{L2})
C1111	([\x00-\x1f\x7f]|\xc2[\x80-\x9f\xad]|\xcd[\xb8-\xb9]|\xce[\x80-\x83\x8b\x8d\xa2]|\xd4\xb0|\xd5[\x97-\x98\xa0]|\xd6[\x88\x8b-\x8c\x90]|\xd7[\x88-\x8f\xab-\xaf\xb5-\xbf]|\xd8[\x80-\x85\x9c-\x9d]|\xdb\x9d|\xdc[\x8e-\x8f]|\xdd[\x8b-\x8c]|\xde[\xb2-\xbf]|\xdf[\xbb-\xbf]|\xe0(\xa0[\xae-\xaf\xbf]|\xa1[\x9c-\x9d\x9f-\xbf]|\xa2[\x80-\x9f\xb3-\xbf]|\xa3[\x80-\xa3]|\xa6[\x84\x8d-\x8e\x91-\x92\xa9\xb1\xb3-\xb5\xba-\xbb]|\xa7[\x85-\x86\x89-\x8a\x8f-\x96\x98-\x9b\x9e\xa4-\xa5\xbc-\xbf]|\xa8[\x80\x84\x8b-\x8e\x91-\x92\xa9\xb1\xb4\xb7\xba-\xbb\xbd]|\xa9[\x83-\x86\x89-\x8a\x8e-\x90\x92-\x98\x9d\x9f-\xa5\xb6-\xbf]|\xaa[\x80\x84\x8e\x92\xa9\xb1\xb4\xba-\xbb]|\xab[\x86\x8a\x8e-\x8f\x91-\x9f\xa4-\xa5\xb2-\xbf]|\xac[\x80\x84\x8d-\x8e\x91-\x92\xa9\xb1\xb4\xba-\xbb]|\xad[\x85-\x86\x89-\x8a\x8e-\x95\x98-\x9b\x9e\xa4-\xa5\xb8-\xbf]|\xae[\x80-\x81\x84\x8b-\x8d\x91\x96-\x98\x9b\x9d\xa0-\xa2\xa5-\xa7\xab-\xad\xba-\xbd]|\xaf[\x83-\x85\x89\x8e-\x8f\x91-\x96\x98-\xa5\xbb-\xbf]|\xb0[\x84\x8d\x91\xa9\xba-\xbc]|\xb1[\x85\x89\x8e-\x94\x97\x9a-\x9f\xa4-\xa5\xb0-\xb7]|\xb2[\x80\x84\x8d\x91\xa9\xb4\xba-\xbb]|\xb3[\x85\x89\x8e-\x94\x97-\x9d]))
C1112	(\xe0(\xb3[\x9f\xa4-\xa5\xb0\xb3-\xbf]|\xb4[\x80\x84\x8d\x91\xbb-\xbc]|\xb5[\x85\x89\x8f-\x96\x98-\x9f\xa4-\xa5\xb6-\xb8]|\xb6[\x80-\x81\x84\x97-\x99\xb2\xbc\xbe-\xbf]|\xb7[\x87-\x89\x8b-\x8e\x95\x97\xa0-\xa5\xb0-\xb1\xb5-\xbf]|\xb8[\x80\xbb-\xbe]|\xb9[\x9c-\xbf]|\xba[\x80\x83\x85-\x86\x89\x8b-\x8c\x8e-\x93\x98\xa0\xa4\xa6\xa8-\xa9\xac\xba\xbe-\xbf]|\xbb[\x85\x87\x8e-\x8f\x9a-\x9b\xa0-\xbf]|\xbd[\x88\xad-\xb0]|\xbe[\x98\xbd]|\xbf[\x8d\x9b-\xbf])|\xe1(\x83[\x86\x88-\x8c\x8e-\x8f]|\x89[\x89\x8e-\x8f\x97\x99\x9e-\x9f]|\x8a[\x89\x8e-\x8f\xb1\xb6-\xb7\xbf]|\x8b[\x81\x86-\x87\x97]|\x8c[\x91\x96-\x97]|\x8d[\x9b-\x9c\xbd-\xbf]|\x8e[\x9a-\x9f]|\x8f[\xb5-\xbf]|\x9a[\x9d-\x9f]|\x9b[\xb9-\xbf]|\x9c[\x8d\x95-\x9f\xb7-\xbf]|\x9d[\x94-\x9f\xad\xb1\xb4-\xbf]|\x9f[\x9e-\x9f\xaa-\xaf\xba-\xbf]|\xa0[\x8e-\x8f\x9a-\x9f]|\xa1[\xb8-\xbf]|\xa2[\xab-\xaf]|\xa3[\xb6-\xbf]|\xa4[\x9f\xac-\xaf\xbc-\xbf]|\xa5[\x81-\x83\xae-\xaf\xb5-\xbf]|\xa6[\xac-\xaf]|\xa7[\x8a-\x8f\x9b-\x9d]|\xa8[\x9c-\x9d]|\xa9[\x9f\xbd-\xbe]|\xaa[\x8a-\x8f\x9a-\x9f\xae-\xaf\xbf]|\xab[\x80-\xbf]|\xad[\x8c-\x8f\xbd-\xbf]|\xaf[\xb4-\xbb]|\xb0[\xb8-\xba]|\xb1[\x8a-\x8c]|\xb2[\x80-\x8a]))
C111	({C1111}|{C1112})
C112	(\xe1(\xb2[\x8b-\xbf]|\xb3[\x88-\x8f\xb7\xba-\xbf]|\xb7[\xb6-\xbb]|\xbc[\x96-\x97\x9e-\x9f]|\xbd[\x86-\x87\x8e-\x8f\x98\x9a\x9c\x9e\xbe-\xbf]|\xbe\xb5|\xbf[\x85\x94-\x95\x9c\xb0-\xb1\xb5\xbf])|\xe2(\x80[\x8b-\x8f\xaa-\xae]|\x81[\xa0-\xaf\xb2-\xb3]|\x82[\x8f\x9d-\x9f\xbe-\xbf]|\x83[\x80-\x8f\xb1-\xbf]|\x86[\x8a-\x8f]|\x8f[\xbb-\xbf]|\x90[\xa7-\xbf]|\x91[\x8b-\x9f]|\xad[\xb4-\xb5]|\xae[\x96-\x97\xba-\xbc]|\xaf[\x89\x92-\xbf]|\xb0\xaf|\xb1\x9f|\xb3[\xb4-\xb8]|\xb4[\xa6\xa8-\xac\xae-\xaf]|\xb5[\xa8-\xae\xb1-\xbe]|\xb6[\x97-\x9f\xa7\xaf\xb7\xbf]|\xb7[\x87\x8f\x97\x9f]|\xb9[\x83-\xbf]|\xba\x9a|\xbb[\xb4-\xbf]|\xbf[\x96-\xaf\xbc-\xbf])|\xe3(\x81\x80|\x82[\x97-\x98]|\x84[\x80-\x84\xae-\xb0]|\x86[\x8f\xbb-\xbf]|\x87[\xa4-\xaf]|\x88\x9f|\x8b\xbf)|\xe4(\xb6[\xb6-\xbf])|\xe9(\xbf[\x8d-\xbf])|\xea(\x92[\x8d-\x8f]|\x93[\x87-\x8f]|\x98[\xac-\xbf]|\x9a\x9e|\x9b[\xb8-\xbf]|\x9e[\x8f\xae-\xaf\xb2-\xbf]|\x9f[\x80-\xb6]|\xa0[\xac-\xaf\xba-\xbf]|\xa1[\xb8-\xbf]|\xa3[\x85-\x8d\x9a-\x9f\xbc-\xbf]|\xa5[\x94-\x9e\xbd-\xbf]|\xa7[\x8e\x9a-\x9d\xbf]|\xa8[\xb7-\xbf]|\xa9[\x8e-\x8f\x9a-\x9b]|\xab[\x83-\x9a\xb7-\xbf]|\xac[\x80\x87-\x88\x8f-\x90\x97-\x9f\xa7\xaf]|\xad[\xa0-\xa3\xa6-\xbf]|\xae[\x80-\xbf]|\xaf[\xae-\xaf\xba-\xbf])|\xed(\x9e[\xa4-\xaf]|\x9f[\x87-\x8a\xbc-\xbf])|\xee(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\x87]))
C11	({C111}|{C112})
C12	(\xee(\x83[\x88-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xae]))
C1	({C11}|{C12})
C2	(\xee(\xa4[\xaf-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\xbf]|\xa7[\x80-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xbf]|\xae[\x80-\xbf]|\xaf[\x80-\xbf]|\xb0[\x80-\xbf]|\xb1[\x80-\xbf]|\xb2[\x80-\xbf]|\xb3[\x80-\xbf]|\xb4[\x80-\xbf]|\xb5[\x80-\xbf]|\xb6[\x80-\xbf]|\xb7[\x80-\xbf]|\xb8[\x80-\xbf]|\xb9[\x80-\xbf]|\xba[\x80-\xbf]|\xbb[\x80-\xbf]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\xbf])|\xef(\x80[\x80-\xbf]|\x81[\x80-\xbf]|\x82[\x80-\xbf]|\x83[\x80-\xbf]|\x84[\x80-\xbf]|\x85[\x80-\xbf]|\x86[\x80-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf]|\x90[\x80-\xbf]|\x91[\x80-\xbf]|\x92[\x80-\xbf]|\x93[\x80-\xbf]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xbf]|\x9e[\x80-\xbf]|\x9f[\x80-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\xbf]|\xa3[\x80-\xbf]|\xa9[\xae-\xaf]|\xab[\x9a-\xbf]|\xac[\x87-\x92\x98-\x9c\xb7\xbd\xbf]|\xad[\x82\x85]|\xaf[\x82-\x92]|\xb5[\x80-\x8f]|\xb6[\x90-\x91]|\xb7[\x88-\xaf\xbe-\xbf]|\xb8[\x9a-\x9f\xae-\xaf]|\xb9[\x93\xa7\xac-\xaf\xb5]|\xbb[\xbd-\xbf]|\xbc\x80|\xbe\xbf|\xbf[\x80-\x81\x88-\x89\x90-\x91\x98-\x99\x9d-\x9f\xa7\xaf-\xbb\xbe-\xbf])|\xf0(\x90(\x80[\x8c\xa7\xbb\xbe]|\x8e\x9e|\xa0[\x89\xb6]|\xa1\x96|\xa8[\x84\x94\x98])|\x91(\x82\xbd|\x84\xb5|\x88\x92|\x8c[\x84\xa9\xb1\xb4])|\x92(\x91\xaf)|\x96(\xa9\x9f|\xad[\x9a\xa2])|\x9d(\x91\x95|\x92[\x9d\xad\xba\xbc]|\x93\x84|\x94[\x86\x95\x9d\xba\xbf]|\x95[\x85\x91])|\x9e(\xb8[\x84\xa0\xa3\xa8\xb3\xb8\xba]|\xb9[\x88\x8a\x8c\x90\x93\x98\x9a\x9c\x9e\xa0\xa3\xab\xb3\xb8\xbd\xbf]|\xba[\x8a\xa4\xaa])|\x9f(\x83[\x80\x90]|\x84\xaf|\x93\xbf|\x95\xba|\x96\xa4))|\xf3(\xa0(\x80\x81)))
C	({C1}|{C2})
M1	(\xcc[\x80-\xbf]|\xcd[\x80-\xaf]|\xd2[\x83-\x89]|\xd6[\x91-\xbd\xbf]|\xd7[\x81-\x82\x84-\x85\x87]|\xd8[\x90-\x9a]|\xd9[\x8b-\x9f\xb0]|\xdb[\x96-\x9c\x9f-\xa4\xa7-\xa8\xaa-\xad]|\xdc[\x91\xb0-\xbf]|\xdd[\x80-\x8a]|\xde[\xa6-\xb0]|\xdf[\xab-\xb3]|\xe0(\xa0[\x96-\x99\x9b-\xa3\xa5-\xa7\xa9-\xad]|\xa1[\x99-\x9b]|\xa3[\xa4-\xbf]|\xa4[\x80-\x83\xba-\xbc\xbe-\xbf]|\xa5[\x80-\x8f\x91-\x97\xa2-\xa3]|\xa6[\x81-\x83\xbc\xbe-\xbf]|\xa7[\x80-\x84\x87-\x88\x8b-\x8d\x97\xa2-\xa3]|\xa8[\x81-\x83\xbc\xbe-\xbf]|\xa9[\x80-\x82\x87-\x88\x8b-\x8d\x91\xb0-\xb1\xb5]|\xaa[\x81-\x83\xbc\xbe-\xbf]|\xab[\x80-\x85\x87-\x89\x8b-\x8d\xa2-\xa3]|\xac[\x81-\x83\xbc\xbe-\xbf]|\xad[\x80-\x84\x87-\x88\x8b-\x8d\x96-\x97\xa2-\xa3]|\xae[\x82\xbe-\xbf]|\xaf[\x80-\x82\x86-\x88\x8a-\x8d\x97]|\xb0[\x80-\x83\xbe-\xbf]|\xb1[\x80-\x84\x86-\x88\x8a-\x8d\x95-\x96\xa2-\xa3]|\xb2[\x81-\x83\xbc\xbe-\xbf]|\xb3[\x80-\x84\x86-\x88\x8a-\x8d\x95-\x96\xa2-\xa3]|\xb4[\x81-\x83\xbe-\xbf]|\xb5[\x80-\x84\x86-\x88\x8a-\x8d\x97\xa2-\xa3]|\xb6[\x82-\x83]|\xb7[\x8a\x8f-\x94\x96\x98-\x9f\xb2-\xb3]|\xb8[\xb1\xb4-\xba]|\xb9[\x87-\x8e]|\xba[\xb1\xb4-\xb9\xbb-\xbc]|\xbb[\x88-\x8d]|\xbc[\x98-\x99\xb5\xb7\xb9\xbe-\xbf]|\xbd[\xb1-\xbf]|\xbe[\x80-\x84\x86-\x87\x8d-\x97\x99-\xbc]|\xbf\x86)|\xe1(\x80[\xab-\xb6]))
M2	(\xe1(\x80[\xb7-\xbe]|\x81[\x96-\x99\x9e-\xa0\xa2-\xa4\xa7-\xad\xb1-\xb4]|\x82[\x82-\x8d\x8f\x9a-\x9d]|\x8d[\x9d-\x9f]|\x9c[\x92-\x94\xb2-\xb4]|\x9d[\x92-\x93\xb2-\xb3]|\x9e[\xb4-\xbf]|\x9f[\x80-\x93\x9d]|\xa0[\x8b-\x8d]|\xa2\xa9|\xa4[\xa0-\xab\xb0-\xbb]|\xa6[\xb0-\xbf]|\xa7[\x80\x88-\x89]|\xa8[\x97-\x9b]|\xa9[\x95-\x9e\xa0-\xbc\xbf]|\xaa[\xb0-\xbe]|\xac[\x80-\x84\xb4-\xbf]|\xad[\x80-\x84\xab-\xb3]|\xae[\x80-\x82\xa1-\xad]|\xaf[\xa6-\xb3]|\xb0[\xa4-\xb7]|\xb3[\x90-\x92\x94-\xa8\xad\xb2-\xb4\xb8-\xb9]|\xb7[\x80-\xb5\xbc-\xbf])|\xe2(\x83[\x90-\xb0]|\xb3[\xaf-\xb1]|\xb5\xbf|\xb7[\xa0-\xbf])|\xe3(\x80[\xaa-\xaf]|\x82[\x99-\x9a])|\xea(\x99[\xaf-\xb2\xb4-\xbd]|\x9a\x9f|\x9b[\xb0-\xb1]|\xa0[\x82\x86\x8b\xa3-\xa7]|\xa2[\x80-\x81\xb4-\xbf]|\xa3[\x80-\x84\xa0-\xb1]|\xa4[\xa6-\xad]|\xa5[\x87-\x93]|\xa6[\x80-\x83\xb3-\xbf]|\xa7[\x80\xa5]|\xa8[\xa9-\xb6]|\xa9[\x83\x8c-\x8d\xbb-\xbd]|\xaa[\xb0\xb2-\xb4\xb7-\xb8\xbe-\xbf]|\xab[\x81\xab-\xaf\xb5-\xb6]|\xaf[\xa3-\xaa\xac-\xad])|\xef(\xac\x9e|\xb8[\x80-\x8f\xa0-\xad])|\xf0(\x90(\x87\xbd|\x8b\xa0|\xa8\xbf)|\x91(\x80[\x80-\x82]|\x82\x82|\x84\xac|\x85\xb3|\x86\x82|\x88[\xb4-\xb5]|\x8b\x9f|\x8c[\x81\xbc]|\x8d[\x80\x97]|\x92[\xb9-\xba]|\x93\x81|\x96\xbe|\x98[\xbd-\xbe]|\x9a[\xab-\xad\xb6-\xb7])))
M	({M1}|{M2})
N	([0-9]|\xc2[\xb2-\xb3\xb9\xbc-\xbe]|\xd9[\xa0-\xa9]|\xdb[\xb0-\xb9]|\xdf[\x80-\x89]|\xe0(\xa5[\xa6-\xaf]|\xa7[\xa6-\xaf\xb4-\xb9]|\xa9[\xa6-\xaf]|\xab[\xa6-\xaf]|\xad[\xa6-\xaf\xb2-\xb7]|\xaf[\xa6-\xb2]|\xb1[\xa6-\xaf\xb8-\xbe]|\xb3[\xa6-\xaf]|\xb5[\xa6-\xb5]|\xb7[\xa6-\xaf]|\xb9[\x90-\x99]|\xbb[\x90-\x99]|\xbc[\xa0-\xb3])|\xe1(\x81[\x80-\x89]|\x82[\x90-\x99]|\x8d[\xa9-\xbc]|\x9b[\xae-\xb0]|\x9f[\xa0-\xa9\xb0-\xb9]|\xa0[\x90-\x99]|\xa5[\x86-\x8f]|\xa7[\x90-\x9a]|\xaa[\x80-\x89\x90-\x99]|\xad[\x90-\x99]|\xae[\xb0-\xb9]|\xb1[\x80-\x89\x90-\x99])|\xe2(\x81[\xb0\xb4-\xb9]|\x82[\x80-\x89]|\x85[\x90-\xbf]|\x86[\x80-\x82\x85-\x89]|\x91[\xa0-\xbf]|\x92[\x80-\x9b]|\x93[\xaa-\xbf]|\x9d[\xb6-\xbf]|\x9e[\x80-\x93]|\xb3\xbd)|\xe3(\x80[\x87\xa1-\xa9\xb8-\xba]|\x86[\x92-\x95]|\x88[\xa0-\xa9]|\x89[\x88-\x8f\x91-\x9f]|\x8a[\x80-\x89\xb1-\xbf])|\xea(\x98[\xa0-\xa9]|\x9b[\xa6-\xaf]|\xa0[\xb0-\xb5]|\xa3[\x90-\x99]|\xa4[\x80-\x89]|\xa7[\x90-\x99\xb0-\xb9]|\xa9[\x90-\x99]|\xaf[\xb0-\xb9])|\xef(\xbc[\x90-\x99])|\xf0(\x90(\x8d[\x81\x8a])))
P	([!-\#%-\*,-\/\:-;\?-@\[-\]_\{\}]|\xc2[\xa1\xa7\xab\xb6-\xb7\xbb\xbf]|\xcd\xbe|\xce\x87|\xd5[\x9a-\x9f]|\xd6[\x89-\x8a\xbe]|\xd7[\x80\x83\x86\xb3-\xb4]|\xd8[\x89-\x8a\x8c-\x8d\x9b\x9e-\x9f]|\xd9[\xaa-\xad]|\xdb\x94|\xdc[\x80-\x8d]|\xdf[\xb7-\xb9]|\xe0(\xa0[\xb0-\xbe]|\xa1\x9e|\xa5[\xa4-\xa5\xb0]|\xab\xb0|\xb7\xb4|\xb9[\x8f\x9a-\x9b]|\xbc[\x84-\x92\x94\xba-\xbd]|\xbe\x85|\xbf[\x90-\x94\x99-\x9a])|\xe1(\x81[\x8a-\x8f]|\x83\xbb|\x8d[\xa0-\xa8]|\x90\x80|\x99[\xad-\xae]|\x9a[\x9b-\x9c]|\x9b[\xab-\xad]|\x9c[\xb5-\xb6]|\x9f[\x94-\x96\x98-\x9a]|\xa0[\x80-\x8a]|\xa5[\x84-\x85]|\xa8[\x9e-\x9f]|\xaa[\xa0-\xa6\xa8-\xad]|\xad[\x9a-\xa0]|\xaf[\xbc-\xbf]|\xb0[\xbb-\xbf]|\xb1[\xbe-\xbf]|\xb3[\x80-\x87\x93])|\xe2(\x80[\x90-\xa7\xb0-\xbf]|\x81[\x80-\x83\x85-\x91\x93-\x9e\xbd-\xbe]|\x82[\x8d-\x8e]|\x8c[\x88-\x8b\xa9-\xaa]|\x9d[\xa8-\xb5]|\x9f[\x85-\x86\xa6-\xaf]|\xa6[\x83-\x98]|\xa7[\x98-\x9b\xbc-\xbd]|\xb3[\xb9-\xbc\xbe-\xbf]|\xb5\xb0|\xb8[\x80-\xae\xb0-\xbf]|\xb9[\x80-\x82])|\xe3(\x80[\x81-\x83\x88-\x91\x94-\x9f\xb0\xbd]|\x82\xa0|\x83\xbb)|\xea(\x93[\xbe-\xbf]|\x98[\x8d-\x8f]|\x99[\xb3\xbe]|\x9b[\xb2-\xb7]|\xa1[\xb4-\xb7]|\xa3[\x8e-\x8f\xb8-\xba]|\xa4[\xae-\xaf]|\xa5\x9f|\xa7[\x81-\x8d\x9e-\x9f]|\xa9[\x9c-\x9f]|\xab[\x9e-\x9f\xb0-\xb1]|\xaf\xab)|\xef(\xb4[\xbe-\xbf]|\xb8[\x90-\x99\xb0-\xbf]|\xb9[\x80-\x92\x94-\xa1\xa3\xa8\xaa-\xab]|\xbc[\x81-\x83\x85-\x8a\x8c-\x8f\x9a-\x9b\x9f-\xa0\xbb-\xbd\xbf]|\xbd[\x9b\x9d\x9f-\xa5])|\xf0(\x90(\x8e\x9f|\x8f\x90|\x95\xaf|\xa1\x97|\xa4[\x9f\xbf]|\xa9\xbf)|\x91(\x87\x8d|\x93\x86)|\x96(\xab\xb5|\xad\x84)|\x9b(\xb2\x9f)))
S1	([\$\+<->\^`\|~]|\xc2[\xa2-\xa6\xa8-\xa9\xac\xae-\xb1\xb4\xb8]|\xc3[\x97\xb7]|\xcb[\x82-\x85\x92-\x9f\xa5-\xab\xad\xaf-\xbf]|\xcd\xb5|\xce[\x84-\x85]|\xcf\xb6|\xd2\x82|\xd6[\x8d-\x8f]|\xd8[\x86-\x88\x8b\x8e-\x8f]|\xdb[\x9e\xa9\xbd-\xbe]|\xdf\xb6|\xe0(\xa7[\xb2-\xb3\xba-\xbb]|\xab\xb1|\xad\xb0|\xaf[\xb3-\xba]|\xb1\xbf|\xb5\xb9|\xb8\xbf|\xbc[\x81-\x83\x93\x95-\x97\x9a-\x9f\xb4\xb6\xb8]|\xbe[\xbe-\xbf]|\xbf[\x80-\x85\x87-\x8c\x8e-\x8f\x95-\x98])|\xe1(\x82[\x9e-\x9f]|\x8e[\x90-\x99]|\x9f\x9b|\xa5\x80|\xa7[\x9e-\xbf]|\xad[\xa1-\xaa\xb4-\xbc]|\xbe[\xbd\xbf]|\xbf[\x80-\x81\x8d-\x8f\x9d-\x9f\xad-\xaf\xbd-\xbe])|\xe2(\x81[\x84\x92\xba-\xbc]|\x82[\x8a-\x8c\xa0-\xbd]|\x84[\x80-\x81\x83-\x86\x88-\x89\x94\x96-\x98\x9e-\xa3\xa5\xa7\xa9\xae\xba-\xbb]|\x85[\x80-\x84\x8a-\x8d\x8f]|\x86[\x90-\xbf]|\x87[\x80-\xbf]|\x88[\x80-\xbf]|\x89[\x80-\xbf]|\x8a[\x80-\xbf]|\x8b[\x80-\xbf]|\x8c[\x80-\x87\x8c-\xa8\xab-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xba]|\x90[\x80-\xa6]|\x91[\x80-\x8a]|\x92[\x9c-\xbf]|\x93[\x80-\xa9]|\x94[\x80-\xbf]|\x95[\x80-\xbf]|\x96[\x80-\xbf]|\x97[\x80-\xbf]|\x98[\x80-\xbf]|\x99[\x80-\xbf]|\x9a[\x80-\xbf]|\x9b[\x80-\xbf]|\x9c[\x80-\xbf]|\x9d[\x80-\xa7]|\x9e[\x94-\xbf]|\x9f[\x80-\x84\x87-\xa5\xb0-\xbf]|\xa0[\x80-\xbf]|\xa1[\x80-\xbf]|\xa2[\x80-\x88]))
S2	(\xe2(\xa2[\x89-\xbf]|\xa3[\x80-\xbf]|\xa4[\x80-\xbf]|\xa5[\x80-\xbf]|\xa6[\x80-\x82\x99-\xbf]|\xa7[\x80-\x97\x9c-\xbb\xbe-\xbf]|\xa8[\x80-\xbf]|\xa9[\x80-\xbf]|\xaa[\x80-\xbf]|\xab[\x80-\xbf]|\xac[\x80-\xbf]|\xad[\x80-\xb3\xb6-\xbf]|\xae[\x80-\x95\x98-\xb9\xbd-\xbf]|\xaf[\x80-\x88\x8a-\x91]|\xb3[\xa5-\xaa]|\xba[\x80-\x99\x9b-\xbf]|\xbb[\x80-\xb3]|\xbc[\x80-\xbf]|\xbd[\x80-\xbf]|\xbe[\x80-\xbf]|\xbf[\x80-\x95\xb0-\xbb])|\xe3(\x80[\x84\x92-\x93\xa0\xb6-\xb7\xbe-\xbf]|\x82[\x9b-\x9c]|\x86[\x90-\x91\x96-\x9f]|\x87[\x80-\xa3]|\x88[\x80-\x9e\xaa-\xbf]|\x89[\x80-\x87\x90\xa0-\xbf]|\x8a[\x8a-\xb0]|\x8b[\x80-\xbe]|\x8c[\x80-\xbf]|\x8d[\x80-\xbf]|\x8e[\x80-\xbf]|\x8f[\x80-\xbf])|\xe4(\xb7[\x80-\xbf])|\xea(\x92[\x90-\xbf]|\x93[\x80-\x86]|\x9c[\x80-\x96\xa0-\xa1]|\x9e[\x89-\x8a]|\xa0[\xa8-\xab\xb6-\xb9]|\xa9[\xb7-\xb9]|\xad\x9b)|\xef(\xac\xa9|\xae[\xb2-\xbf]|\xaf[\x80-\x81]|\xb7[\xbc-\xbd]|\xb9[\xa2\xa4-\xa6\xa9]|\xbc[\x84\x8b\x9c-\x9e\xbe]|\xbd[\x80\x9c\x9e]|\xbf[\xa0-\xa6\xa8-\xae\xbc-\xbd])|\xf0(\x90(\x86[\x8c\xa0]|\xab\x88)|\x96(\xad\x85)|\x9b(\xb2\x9c)|\x9d(\x89\x85|\x9b[\x81\x9b\xbb]|\x9c[\x95\xb5]|\x9d[\x8f\xaf]|\x9e[\x89\xa9]|\x9f\x83)))
S	({S1}|{S2})
Z	(\x20|\xc2\xa0|\xe1(\x9a\x80)|\xe2(\x80[\x80-\x8a\xa8-\xa9\xaf]|\x81\x9f)|\xe3(\x80\x80))

DIGIT   [0-9]
EXPO     [eE][-+]?[0-9]+

%% /*** Filter language Part ***/

[ \t]+     COUNTCHARS;
[\n]       column = 0;

\<\<(\\(.|\n)|[^\\>\n])*\>\> COUNTCHARS; yylval.string = unquote(yytext); return STRING;

[+()=/*^,\.\{\}\[\]:;@\?#]   COUNTCHARS; return *yytext;

"=="                         COUNTCHARS; return EQ;
"!="                         COUNTCHARS; return NEQ;
">"                          COUNTCHARS; return GT;
"<"                          COUNTCHARS; return LT;
">="                         COUNTCHARS; return GTE;
"<="                         COUNTCHARS; return LTE;

"-"                          COUNTCHARS; return MINUSSIGN;
"\xe2\x88\x92"               COUNTCHARS; return MINUSSIGN;

"nm"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::NanoMetre;           yylval.quantity.unitStr = yytext; return UNIT; // nano meter
"um"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MicroMetre;          yylval.quantity.unitStr = yytext; return UNIT; // micro meter
"\xC2\xB5m"                  COUNTCHARS; yylval.quantity.scaler  = Quantity::MicroMetre;          yylval.quantity.unitStr = yytext; return UNIT; // micro meter    (greek micro in UTF8)
"mm"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MilliMetre;          yylval.quantity.unitStr = yytext; return UNIT; // milli meter    (internal standard length)
"cm"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::CentiMetre;          yylval.quantity.unitStr = yytext; return UNIT; // centi meter
"dm"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::DeciMetre;           yylval.quantity.unitStr = yytext; return UNIT; // deci meter
"m"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Metre;               yylval.quantity.unitStr = yytext; return UNIT; // metre
"km"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::KiloMetre;           yylval.quantity.unitStr = yytext; return UNIT; // kilo meter

"l"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Liter;               yylval.quantity.unitStr = yytext; return UNIT; // Liter      dm^3

"ug"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MicroGram;           yylval.quantity.unitStr = yytext; return UNIT; // micro gram
"\xC2\xB5g"                  COUNTCHARS; yylval.quantity.scaler  = Quantity::MicroGram;           yylval.quantity.unitStr = yytext; return UNIT; // micro gram
"mg"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MilliGram;           yylval.quantity.unitStr = yytext; return UNIT; // milli gram
"g"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Gram;                yylval.quantity.unitStr = yytext; return UNIT; // gram
"kg"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::KiloGram;            yylval.quantity.unitStr = yytext; return UNIT; // kilo gram      (internal standard for mass)
"t"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Ton;                 yylval.quantity.unitStr = yytext; return UNIT; // Metric Tonne

"s"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Second;              yylval.quantity.unitStr = yytext; return UNIT; // second         (internal standard time)
"min"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::Minute;              yylval.quantity.unitStr = yytext; return UNIT; // minute
"h"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Hour;                yylval.quantity.unitStr = yytext; return UNIT; // hour

"A"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Ampere;              yylval.quantity.unitStr = yytext; return UNIT; // Ampere         (internal standard electric current)
"mA"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MilliAmpere;         yylval.quantity.unitStr = yytext; return UNIT; // milli Ampere
"kA"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::KiloAmpere;          yylval.quantity.unitStr = yytext; return UNIT; // kilo Ampere
"MA"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MegaAmpere;          yylval.quantity.unitStr = yytext; return UNIT; // Mega Ampere

"K"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Kelvin;              yylval.quantity.unitStr = yytext; return UNIT; // Kelvin         (internal standard thermodynamic temperature)
"mK"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MilliKelvin;         yylval.quantity.unitStr = yytext; return UNIT; // Kelvin
"\xC2\xB5K"                  COUNTCHARS; yylval.quantity.scaler  = Quantity::MicroKelvin;         yylval.quantity.unitStr = yytext; return UNIT; // Kelvin
"uK"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MicroKelvin;         yylval.quantity.unitStr = yytext; return UNIT; // Kelvin

"mol"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::Mole;                yylval.quantity.unitStr = yytext; return UNIT; // Mole           (internal standard amount of substance)

"cd"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Candela;             yylval.quantity.unitStr = yytext; return UNIT; // Candela        (internal standard luminous intensity)

"in"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Inch;                yylval.quantity.unitStr = yytext; return UNIT; // inch
"\""                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Inch;                yylval.quantity.unitStr = yytext; return UNIT; // inch
"ft"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Foot;                yylval.quantity.unitStr = yytext; return UNIT; // foot
"'"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Foot;                yylval.quantity.unitStr = yytext; return UNIT; // foot
"thou"                       COUNTCHARS; yylval.quantity.scaler  = Quantity::Thou;                yylval.quantity.unitStr = yytext; return UNIT; // thou (in/1000)
"mil"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::Thou;                yylval.quantity.unitStr = yytext; return UNIT; // mil  (the thou in US)
"yd"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Yard;                yylval.quantity.unitStr = yytext; return UNIT; // yard
"mi"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Mile;                yylval.quantity.unitStr = yytext; return UNIT; // mile



"lb"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Pound;               yylval.quantity.unitStr = yytext; return UNIT; // pound
"lbm"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::Pound;               yylval.quantity.unitStr = yytext; return UNIT; // pound
"oz"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Ounce;               yylval.quantity.unitStr = yytext; return UNIT; // ounce
"st"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Stone;               yylval.quantity.unitStr = yytext; return UNIT; // Stone
"cwt"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::Hundredweights;      yylval.quantity.unitStr = yytext; return UNIT; // hundredweights

"lbf"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::PoundForce;          yylval.quantity.unitStr = yytext; return UNIT; // pound

"N"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Newton;              yylval.quantity.unitStr = yytext; return UNIT; // Newton (kg*m/s^2)a-za-za-z
"kN"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::KiloNewton;          yylval.quantity.unitStr = yytext; return UNIT; // Newton
"MN"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MegaNewton;          yylval.quantity.unitStr = yytext; return UNIT; // Newton
"mN"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::MilliNewton;         yylval.quantity.unitStr = yytext; return UNIT; // Newton

"Pa"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::Pascal;              yylval.quantity.unitStr = yytext; return UNIT; // Pascal (kg/m*s^2 or N/m^2)
"kPa"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::KiloPascal;          yylval.quantity.unitStr = yytext; return UNIT; // Pascal
"MPa"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::MegaPascal;          yylval.quantity.unitStr = yytext; return UNIT; // Pascal
"GPa"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::GigaPascal;          yylval.quantity.unitStr = yytext; return UNIT; // Pascal

"Torr"                       COUNTCHARS; yylval.quantity.scaler  = Quantity::Torr;                yylval.quantity.unitStr = yytext; return UNIT; // portion of Pascal ( 101325/760 )
"mTorr"                      COUNTCHARS; yylval.quantity.scaler  = Quantity::mTorr;               yylval.quantity.unitStr = yytext; return UNIT; //
"uTorr"                      COUNTCHARS; yylval.quantity.scaler  = Quantity::yTorr;               yylval.quantity.unitStr = yytext; return UNIT; //
"\xC2\xB5Torr"               COUNTCHARS; yylval.quantity.scaler  = Quantity::yTorr;               yylval.quantity.unitStr = yytext; return UNIT; //

"psi"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::PSI;                 yylval.quantity.unitStr = yytext; return UNIT; // pounds/in^2
"ksi"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::KSI;                 yylval.quantity.unitStr = yytext; return UNIT; // 1000 x pounds/in^2

"W"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Watt;                yylval.quantity.unitStr = yytext; return UNIT; // Watt (kg*m^2/s^3)
"VA"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::VoltAmpere;          yylval.quantity.unitStr = yytext; return UNIT; // VoltAmpere (kg*m^2/s^3)

"J"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::Joule;               yylval.quantity.unitStr = yytext; return UNIT; // Joule (kg*m^2/s^2)
"Nm"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::NewtonMeter;         yylval.quantity.unitStr = yytext; return UNIT; // N*m = Joule
"VAs"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::VoltAmpereSecond;    yylval.quantity.unitStr = yytext; return UNIT; // V*A*s = Joule
"CV"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::WattSecond;          yylval.quantity.unitStr = yytext; return UNIT; //
"Ws"                         COUNTCHARS; yylval.quantity.scaler  = Quantity::WattSecond;          yylval.quantity.unitStr = yytext; return UNIT; // W*s = Joule

"\xC2\xB0"                   COUNTCHARS; yylval.quantity.scaler  = Quantity::Degree;              yylval.quantity.unitStr = yytext; return UNIT; // degree         (internal standard angle)
"deg"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::Degree;              yylval.quantity.unitStr = yytext; return UNIT; // degree         (internal standard angle)
"rad"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::Radian;              yylval.quantity.unitStr = yytext; return UNIT; // radian
"gon"                        COUNTCHARS; yylval.quantity.scaler  = Quantity::Gon;                 yylval.quantity.unitStr = yytext; return UNIT; // gon
"M"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::AngMinute;           yylval.quantity.unitStr = yytext; return UNIT; // angminute
"\xE2\x80\xB2"               COUNTCHARS; yylval.quantity.scaler  = Quantity::AngMinute;           yylval.quantity.unitStr = yytext; return UNIT; // angminute U+2032 	&prime; &#8242; ′
"S"                          COUNTCHARS; yylval.quantity.scaler  = Quantity::AngSecond;           yylval.quantity.unitStr = yytext; return UNIT; // angsecond
"\xE2\x80\xB3"               COUNTCHARS; yylval.quantity.scaler  = Quantity::AngSecond;           yylval.quantity.unitStr = yytext; return UNIT; // angsecond U+2033 	&Prime; &#8243; ″

{DIGIT}*"."{DIGIT}+{EXPO}?   COUNTCHARS; yylval.fvalue = num_change(yytext,'.',',');       return yylval.fvalue == 1 ? ONE : NUM;
{DIGIT}*","{DIGIT}+{EXPO}?   COUNTCHARS; yylval.fvalue = num_change(yytext,',','.');       return yylval.fvalue == 1 ? ONE : NUM;
{DIGIT}+{EXPO}               COUNTCHARS; yylval.fvalue = num_change(yytext,',','.');       return yylval.fvalue == 1 ? ONE : NUM;
{DIGIT}+                     { COUNTCHARS;
                               yylval.ivalue = strtoll( yytext, NULL, 0 );
                               if (yylval.ivalue == LLONG_MIN)
                                  throw Base::UnderflowError("Integer underflow");
                               else if (yylval.ivalue == LLONG_MAX)
                                  throw Base::OverflowError("Integer overflow");
                               if (yylval.ivalue == 1) { yylval.fvalue = 1; return ONE; } else return INTEGER;
                             }

"pi"                         COUNTCHARS; yylval.constant.fvalue = M_PI; yylval.constant.name = "pi"; return CONSTANT; // constant pi
"e"                          COUNTCHARS; yylval.constant.fvalue = M_E; yylval.constant.name = "e"; return CONSTANT; // constant e

$[A-Za-z]{1,2}+${DIGIT}+     COUNTCHARS; yylval.string = yytext; return CELLADDRESS;
[A-Za-z]{1,2}${DIGIT}+       COUNTCHARS; yylval.string = yytext; return CELLADDRESS;
$[A-Za-z]{1,2}{DIGIT}+       COUNTCHARS; yylval.string = yytext; return CELLADDRESS;

({L}{M}*)({L}{M}*|{N}|_)*[\20\t]*\( {
                            COUNTCHARS;
                            std::string s = yytext;
                            size_t i = s.size() - 2;
                            while (isspace(s[i]))
                              --i;
                            s.erase(i + 1);
                            std::map<std::string, FunctionExpression::Function>::const_iterator j = registered_functions.find(s);
                            if (j != registered_functions.end())
                              yylval.func = j->second;
                            else
                              yylval.func = FunctionExpression::NONE;
                            return FUNC;
                        }

({L}{M}*)({L}{M}*|{N}|_)*   COUNTCHARS; yylval.string = yytext; return IDENTIFIER;
