#!/usr/bin/env bash
#
# The names generated by the batch file win-to-dos-zips.bat
# are not correctly "shortened" by
# make shortnames
# This small script tries to simplify this task
# Requires a Cygwin/Msys installation
# Must to launched at fpcbuild directory level

ziplist=`(cd go32v2-zips; ls *.zip)`

cat go32v2-zips/install.dat | gawk '
BEGIN {
 do_print=0
}
/Source packages/ {do_print=1;}
/targetname=go32v2/ {do_print=1;}
/targetname=i386-win32/ {do_print=0;}
/targetname=i386-os2/ {do_print=0;}
/targetname=emx/ {do_print=0;}
/defaultcfg=/ {do_print=0;}
/.*/ { if (do_print == 1) print $0; } ' > go32v2-zips/install-go32v2.dat

function check ()
{
  file=$1
  origfile=$2
  echo Testing $file
  line=`grep $file go32v2-zips/install-go32v2.dat`
  if [ "X$line" != "X" ] ; then
    echo "Found line is \"$line\""
    shortname=`echo $line | sed -n "s:.*\[\(.*\)\].*:\1:p"`
    echo "ShortName is \"$shortname\""
    if [ "X$shortname" != "X" ] ; then
      if [ "X$shortname" != "X$origfile" ] ; then
        echo "Moving $origfile to $shortname"
        mv go32v2-zips/$origfile go32v2-zips/$shortname
      fi
    fi
  fi
}

for file in $ziplist ; do
  origfile=$file
  check $file $origfile
  file=${origfile/.source/src}
  check $file $origfile
  file=${origfile/u/units-}
  check $file $origfile
  file=${origfile/u/utils-}
  check $file $origfile
done

zipindat=`(cd go32v2-zips; sed -n "s:.*\[\(.*\)\].*:\1:p" install-go32v2.dat)`

for file in $zipindat ; do
  if [ ! -f go32v2-zips/$file ] ; then
    echo "file \"$file\" not found"
  fi
done
