/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.sunsecure;

import java.util.List;
import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.rules.sunsecure.AbstractSunSecureRule;

public class MethodReturnsInternalArray
extends AbstractSunSecureRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration method, Object data) {
        if (!method.getResultType().returnsArray()) {
            return data;
        }
        List<ASTReturnStatement> returns = method.findChildrenOfType(ASTReturnStatement.class);
        ASTTypeDeclaration td = method.getFirstParentOfType(ASTTypeDeclaration.class);
        for (ASTReturnStatement ret : returns) {
            ASTPrimarySuffix ps;
            String vn = this.getReturnedVariableName(ret);
            if (!this.isField(vn, td) || ret.findChildrenOfType(ASTPrimarySuffix.class).size() > 2 || !ret.findChildrenOfType(ASTAllocationExpression.class).isEmpty()) continue;
            if (!this.isLocalVariable(vn, method)) {
                this.addViolation(data, ret, vn);
                continue;
            }
            ASTPrimaryPrefix pp = ret.getFirstChildOfType(ASTPrimaryPrefix.class);
            if (pp == null || !pp.usesThisModifier() || !(ps = ret.getFirstChildOfType(ASTPrimarySuffix.class)).hasImageEqualTo(vn)) continue;
            this.addViolation(data, ret, vn);
        }
        return data;
    }
}

