/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.imports;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.rules.ImportWrapper;

public class DuplicateImportsRule
extends AbstractRule {
    private Set<ImportWrapper> singleTypeImports;
    private Set<ImportWrapper> importOnDemandImports;

    public Object visit(ASTCompilationUnit node, Object data) {
        this.singleTypeImports = new HashSet<ImportWrapper>();
        this.importOnDemandImports = new HashSet<ImportWrapper>();
        super.visit(node, data);
        for (ImportWrapper thisImportOnDemand : this.importOnDemandImports) {
            for (ImportWrapper thisSingleTypeImport : this.singleTypeImports) {
                String singleTypeFullName = thisSingleTypeImport.getName();
                int lastDot = singleTypeFullName.lastIndexOf(46);
                String singleTypePkg = singleTypeFullName.substring(0, lastDot);
                String singleTypeName = singleTypeFullName.substring(lastDot + 1);
                if (!thisImportOnDemand.getName().equals(singleTypePkg) || this.isDisambiguationImport(node, singleTypePkg, singleTypeName)) continue;
                this.addViolation(data, thisSingleTypeImport.getNode(), singleTypeFullName);
            }
        }
        this.singleTypeImports.clear();
        this.importOnDemandImports.clear();
        return data;
    }

    private boolean isDisambiguationImport(ASTCompilationUnit node, String singleTypePkg, String singleTypeName) {
        for (ImportWrapper thisImportOnDemand : this.importOnDemandImports) {
            if (thisImportOnDemand.getName().equals(singleTypePkg)) continue;
            String fullyQualifiedClassName = thisImportOnDemand.getName() + "." + singleTypeName;
            if (!node.getClassTypeResolver().classNameExists(fullyQualifiedClassName)) continue;
            return true;
        }
        String fullyQualifiedClassName = "java.lang." + singleTypeName;
        return node.getClassTypeResolver().classNameExists(fullyQualifiedClassName);
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        ImportWrapper wrapper = new ImportWrapper(node.getImportedName(), node.getImportedName(), node.getImportedNameNode());
        if (node.isImportOnDemand()) {
            if (this.importOnDemandImports.contains(wrapper)) {
                this.addViolation(data, node.getImportedNameNode(), node.getImportedNameNode().getImage());
            } else {
                this.importOnDemandImports.add(wrapper);
            }
        } else if (this.singleTypeImports.contains(wrapper)) {
            this.addViolation(data, node.getImportedNameNode(), node.getImportedNameNode().getImage());
        } else {
            this.singleTypeImports.add(wrapper);
        }
        return data;
    }
}

