/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.dfa.StackObject;

public class SequenceChecker {
    private static Status root = new Status(-1);
    private Status aktStatus = root;
    private List bracesList;
    private int firstIndex = -1;
    private int lastIndex = -1;

    public SequenceChecker(List bracesList) {
        this.bracesList = bracesList;
    }

    public boolean run() {
        this.aktStatus = root;
        this.firstIndex = 0;
        this.lastIndex = 0;
        boolean lookAhead = false;
        for (int i = 0; i < this.bracesList.size(); ++i) {
            StackObject so = (StackObject)this.bracesList.get(i);
            this.aktStatus = this.aktStatus.step(so.getType());
            if (this.aktStatus == null) {
                if (lookAhead) {
                    this.lastIndex = i - 1;
                    return false;
                }
                this.aktStatus = root;
                this.firstIndex = i--;
                continue;
            }
            if (this.aktStatus.isLastStep() && !this.aktStatus.hasMoreSteps()) {
                this.lastIndex = i;
                return false;
            }
            if (!this.aktStatus.isLastStep() || !this.aktStatus.hasMoreSteps()) continue;
            lookAhead = true;
            this.lastIndex = i;
        }
        return this.firstIndex == this.lastIndex;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    static {
        Status ifNode = new Status(1);
        Status ifSt = new Status(2);
        Status ifStWithoutElse = new Status(3, true);
        Status elseSt = new Status(4, true);
        Status whileNode = new Status(10);
        Status whileSt = new Status(11, true);
        Status switchNode = new Status(20);
        Status caseSt = new Status(21);
        Status switchDefault = new Status(22);
        Status switchEnd = new Status(23, true);
        Status forInit = new Status(30);
        Status forExpr = new Status(31);
        Status forUpdate = new Status(32);
        Status forSt = new Status(33);
        Status forEnd = new Status(34, true);
        Status doSt = new Status(40);
        Status doExpr = new Status(41, true);
        Status labelNode = new Status(60);
        Status labelEnd = new Status(61, true);
        root.addStep(ifNode);
        root.addStep(whileNode);
        root.addStep(switchNode);
        root.addStep(forInit);
        root.addStep(forExpr);
        root.addStep(forUpdate);
        root.addStep(forSt);
        root.addStep(doSt);
        root.addStep(labelNode);
        ifNode.addStep(ifSt);
        ifNode.addStep(ifStWithoutElse);
        ifSt.addStep(elseSt);
        ifStWithoutElse.addStep(root);
        elseSt.addStep(root);
        labelNode.addStep(labelEnd);
        labelEnd.addStep(root);
        whileNode.addStep(whileSt);
        whileSt.addStep(root);
        switchNode.addStep(caseSt);
        switchNode.addStep(switchDefault);
        switchNode.addStep(switchEnd);
        caseSt.addStep(caseSt);
        caseSt.addStep(switchDefault);
        caseSt.addStep(switchEnd);
        switchDefault.addStep(switchEnd);
        switchDefault.addStep(caseSt);
        switchEnd.addStep(root);
        forInit.addStep(forExpr);
        forInit.addStep(forUpdate);
        forInit.addStep(forSt);
        forExpr.addStep(forUpdate);
        forExpr.addStep(forSt);
        forUpdate.addStep(forSt);
        forSt.addStep(forEnd);
        forEnd.addStep(root);
        doSt.addStep(doExpr);
        doExpr.addStep(root);
    }

    private static class Status {
        public static final int ROOT = -1;
        private List<Status> nextSteps = new ArrayList<Status>();
        private int type;
        private boolean lastStep;

        public Status(int type) {
            this(type, false);
        }

        public Status(int type, boolean lastStep) {
            this.type = type;
            this.lastStep = lastStep;
        }

        public void addStep(Status type) {
            this.nextSteps.add(type);
        }

        public Status step(int type) {
            for (int i = 0; i < this.nextSteps.size(); ++i) {
                if (type != this.nextSteps.get((int)i).type) continue;
                return this.nextSteps.get(i);
            }
            return null;
        }

        public boolean isLastStep() {
            return this.lastStep;
        }

        public boolean hasMoreSteps() {
            return this.nextSteps.size() > 1;
        }
    }
}

