** Copyright (c) 1989, NVIDIA CORPORATION.  All rights reserved.
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.

* Vectorizer - stripmine, incorrect placement of temp stores of variant
*              expressions
*              iscbugs 911004a.f -- 911004f.f
*              same as kv02.f + use of pointers

	program p
	parameter (N=512)
	parameter (M=N/2)

	double precision x(N), y(N)
	double precision expect(N)

	pointer (px,idum)
	pointer (py,jdum)

	data x /N*1.0/
	data y /N*2.0/
	data (expect(i),i=1,N,2) / M*2.0 /
	data (expect(i),i=2,N,2) / M*1.0 /

	incx = 2
	incy = -2
	px = %loc(x)
	py = %loc(y)
	call dswap (N/2,px,incx,py,incy)
	call checkd(x, expect, N)
	end

      subroutine dswap (n,px,incx,py,incy)
      integer n, incx, incy
      double precision x, y
      pointer (px, x(n))
      pointer (py, y(n))
c
c     Swap vectors.
c     y <==> x
c
      integer i, ix, iy
      double precision t
c
   20 ix = 1
      iy = 1
      if (incx .lt. 0) ix = (-n+1)*incx + 1
      if (incy .lt. 0) iy = (-n+1)*incy + 1
c
c  need temps for computing the initial array addresses for x & y
c  these temps should be stored prior to the stripmine loop
c
      do 30 i = 1, n
         t = y(iy)
         y(iy) = x(ix)
         x(ix) = t
         ix = ix + incx
         iy = iy + incy
   30 continue
      return
      end
