  std::cout << "\" Vim indent file" << std::endl;
  std::cout << "\" Installation: Place this script in the $HOME/.vim/after/indent/ directory" << std::endl;
  std::cout << "\"               as fortran.vim   and use it with Vim > 7.1 and findent:" << std::endl;
  std::cout << "\"               findent.sourceforge.net" << std::endl;
  std::cout << "\"               Author: Willem Vermin wvermin@gmail.com" << std::endl;
  std::cout << "\"               Licence: fair" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" use findent for indenting,  unless use_findent == 0" << std::endl;
  std::cout << "if !exists(\"g:use_findent\")" << std::endl;
  std::cout << "   let b:use_findent = 1" << std::endl;
  std::cout << "else" << std::endl;
  std::cout << "   let b:use_findent = g:use_findent" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" use findent for indenting using indentexpr (see :help indentexpr)" << std::endl;
  std::cout << "\"     unless use_findent_indentexpr == 0" << std::endl;
  std::cout << "if !exists(\"g:use_findent_indentexpr\")" << std::endl;
  std::cout << "   let b:use_findent_indentexpr = 1" << std::endl;
  std::cout << "else" << std::endl;
  std::cout << "   let b:use_findent_indentexpr = g:use_findent_indentexpr" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" The location of findent:" << std::endl;
  std::cout << "if !exists(\"g:findent\")" << std::endl;
  std::cout << "   let g:findent = \"findent\"" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "if !exists(\"b:use_findent\")" << std::endl;
  std::cout << "   finish" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "if !b:use_findent" << std::endl;
  std::cout << "   finish" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" no interesting side-effects caused by settings in FINDENT_FLAGS:" << std::endl;
  std::cout << "let $FINDENT_FLAGS = \"\"" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "if !exists(\"b:use_findent_indentexpr\")" << std::endl;
  std::cout << "   let b:use_findent_indentexpr = 1" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "autocmd BufEnter * unlet! g:fortran_free_source g:fortran_fixed_source" << std::endl;
  std::cout << "autocmd BufEnter * unlet! b:fortran_free_source b:fortran_fixed_source" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" g:findent is probably set in .vimrc" << std::endl;
  std::cout << "\" if not: skip all" << std::endl;
  std::cout << "if !exists(\"g:findent\")" << std::endl;
  std::cout << "   finish" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" get fortran format from extension ext" << std::endl;
  std::cout << "\" return \"free\", \"fixed\" or \"unknown\"" << std::endl;
  std::cout << "function! Get_format_from_extension(ext)" << std::endl;
  std::cout << "   if a:ext =~? '^f$\\|^for$\\|^fpp$\\|^ftn$\\|^fortran$\\|^f77$'" << std::endl;
  std::cout << "      let format = \"fixed\"" << std::endl;
  std::cout << "   elseif a:ext =~? '^f90$\\|^f95$\\|^f03$\\|^f08$'" << std::endl;
  std::cout << "      let format = \"free\"" << std::endl;
  std::cout << "   else" << std::endl;
  std::cout << "      let format = \"unknown\"" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "   return format" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" return string that represents external command to determine" << std::endl;
  std::cout << "\" if input is free or fixed format." << std::endl;
  std::cout << "\" If no suitable command is found, return \"\"" << std::endl;
  std::cout << "\" The output of this external command must be \"free\" or \"fixed\"" << std::endl;
  std::cout << "function! Findent_get_freefixed()" << std::endl;
  std::cout << "   let indentparmsq = ' -q'" << std::endl;
  std::cout << "   let f = g:findent.indentparmsq" << std::endl;
  std::cout << "   if strpart(system(f,\" continue\"),0,4) != \"free\"" << std::endl;
  std::cout << "      let f = \"\"" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "   return f" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" Return external command to get the indent of the last line of the input" << std::endl;
  std::cout << "\" Return \"\" if no such command can be found" << std::endl;
  std::cout << "\" side effect: s:findent_getindent is the command tried" << std::endl;
  std::cout << "function! Findent_get_getindent()" << std::endl;
  std::cout << "   let getindent=g:findent.' -Ia -lastindent -i'.b:fortran_format.' '.b:findent_flags" << std::endl;
  std::cout << "   let s:findent_getindent = getindent" << std::endl;
  std::cout << "   if system(getindent,'      continue') == 6" << std::endl;
  std::cout << "      return getindent" << std::endl;
  std::cout << "   else" << std::endl;
  std::cout << "      return \"\"" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" Return external command that indents the input" << std::endl;
  std::cout << "\" Return \"\" if no such command can be found" << std::endl;
  std::cout << "\" side effect: s:fortran_indentprog is the command tried" << std::endl;
  std::cout << "function! Findent_get_indentprog()" << std::endl;
  std::cout << "   \" first a test:" << std::endl;
  std::cout << "   let indentparms = ' -Ia -i'.b:fortran_format.' '.b:findent_flags" << std::endl;
  std::cout << "   let indentprog = g:findent.indentparms" << std::endl;
  std::cout << "   let s:fortran_indentprog = indentprog" << std::endl;
  std::cout << "   if strpart(system(indentprog,\"continue\"),0,8) == \"continue\"" << std::endl;
  std::cout << "      return indentprog" << std::endl;
  std::cout << "   else" << std::endl;
  std::cout << "      return \"\"" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" Returns the indentation of the current line" << std::endl;
  std::cout << "function! Findent_getindent()" << std::endl;
  std::cout << "   if b:findent_use_whole_buffer" << std::endl;
  std::cout << "      \" use whole buffer up to current line to determine indent" << std::endl;
  std::cout << "      let startline = 1" << std::endl;
  std::cout << "   else" << std::endl;
  std::cout << "      let maxlines = 10*&lines" << std::endl;
  std::cout << "      \" use at most 'maxlines' previous lines to determine indent" << std::endl;
  std::cout << "      let s = max([v:lnum-maxlines,1])" << std::endl;
  std::cout << "      \"let startline = system(g:findent.\" -lastusable -i\".b:fortran_format,join(getline(1,v:lnum-1),\"\\n\"))" << std::endl;
  std::cout << "      let startline = s - 1 + system(g:findent.\" -lastusable -i\".b:fortran_format,join(getline(s,v:lnum-1),\"\\n\"))" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "   let startline = max([1,startline])" << std::endl;
  std::cout << "   let getindent = Findent_get_getindent()" << std::endl;
  std::cout << "   let lnum = prevnonblank(v:lnum)" << std::endl;
  std::cout << "   let ind  = system(getindent, join(getline(startline,lnum),\"\\n\"))" << std::endl;
  std::cout << "   return ind" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "function! Findent_set_flags()" << std::endl;
  std::cout << "   if !b:have_findent && !b:have_findent_getindent" << std::endl;
  std::cout << "      return" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "   let old = b:findent_flags" << std::endl;
  std::cout << "   let b:findent_flags = input(\"findent flags:\",b:findent_flags)" << std::endl;
  std::cout << "   if b:have_findent" << std::endl;
  std::cout << "      if Findent_get_indentprog() != \"\"" << std::endl;
  std::cout << "	 call Findent_set_indentprog()" << std::endl;
  std::cout << "      else" << std::endl;
  std::cout << "	 let x = input( \"Cannot use flags '\".b:findent_flags.\"' Will use '\".old.\"'\")" << std::endl;
  std::cout << "	 let b:findent_flags = old" << std::endl;
  std::cout << "	 return" << std::endl;
  std::cout << "      endif" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "   if b:have_findent_getindent" << std::endl;
  std::cout << "      if Findent_get_getindent() != \"\"" << std::endl;
  std::cout << "	 call Findent_set_getindent() " << std::endl;
  std::cout << "      else" << std::endl;
  std::cout << "	 let x = input( \"Cannot use flags '\".b:findent_flags.\"' Will use '\".old.\"'\")" << std::endl;
  std::cout << "	 let b:findent_flags = old" << std::endl;
  std::cout << "	 return" << std::endl;
  std::cout << "      endif" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "function! Findent_set_indentprog()" << std::endl;
  std::cout << "   let p = Findent_get_indentprog()" << std::endl;
  std::cout << "   if p == \"\"" << std::endl;
  std::cout << "      echomsg \"Warning '\".s:fortran_indentprog.\"' not usable as equalprg\"" << std::endl;
  std::cout << "      echomsg \"Using default for equalprg\"" << std::endl;
  std::cout << "      setlocal equalprg=" << std::endl;
  std::cout << "      let b:have_findent = 0" << std::endl;
  std::cout << "   else" << std::endl;
  std::cout << "      execute 'setlocal equalprg='.substitute(p,' ','\\\\ ','g')" << std::endl;
  std::cout << "      let b:have_findent = 1" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "function! Findent_set_getindent()" << std::endl;
  std::cout << "   if Findent_get_getindent() == \"\"" << std::endl;
  std::cout << "      echomsg \"Warning '\".s:findent_getindent.\"' not usable as indentexpr\"" << std::endl;
  std::cout << "      echomsg \"Using default for indentexpr\"" << std::endl;
  std::cout << "      setlocal indentexpr=" << std::endl;
  std::cout << "      let b:have_findent_getindent = 0" << std::endl;
  std::cout << "   else" << std::endl;
  std::cout << "      setlocal indentexpr=Findent_getindent()" << std::endl;
  std::cout << "      setlocal indentkeys=*<Return>,*<Up>,*<Down>,*<Esc>,!^F,o,O,0#" << std::endl;
  std::cout << "      \" fixed format: if first character is tab, indent the line" << std::endl;
  std::cout << "      if b:fortran_format == \"fixed\"" << std::endl;
  std::cout << "	 setlocal indentkeys+=!0<Tab>" << std::endl;
  std::cout << "      endif" << std::endl;
  std::cout << "      let b:have_findent_getindent = 1" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "function! Findent_use_wb_toggle()" << std::endl;
  std::cout << "   if b:use_findent_indentexpr" << std::endl;
  std::cout << "      let b:findent_use_whole_buffer = !b:findent_use_whole_buffer" << std::endl;
  std::cout << "      if b:findent_use_whole_buffer " << std::endl;
  std::cout << "	 let p = \"ON\"" << std::endl;
  std::cout << "      else" << std::endl;
  std::cout << "	 let p = \"OFF\"" << std::endl;
  std::cout << "      endif" << std::endl;
  std::cout << "      echomsg \"use whole buffer = \".p" << std::endl;
  std::cout << "   else" << std::endl;
  std::cout << "      echomsg \"not using findent for indentexpr\"" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "function! Get_free_or_fixed_default()" << std::endl;
  std::cout << "   if exists(\"b:fortran_fixed_source\")" << std::endl;
  std::cout << "      if b:fortran_fixed_source" << std::endl;
  std::cout << "	 return \"fixed\"" << std::endl;
  std::cout << "      endif" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "   if exists(\"b:fortran_free_source\")" << std::endl;
  std::cout << "      if b:fortran_free_source" << std::endl;
  std::cout << "	 return \"free\"" << std::endl;
  std::cout << "      endif" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "   return \"fixed\"" << std::endl;
  std::cout << "endfunction" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\"=========================================================================" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "if exists(\"g:findent_flags\")" << std::endl;
  std::cout << "   let b:findent_flags = g:findent_flags" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "if !exists(\"b:findent_flags\")" << std::endl;
  std::cout << "   let b:findent_flags = \"-i\".&shiftwidth" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "if !exists(\"b:findent_use_whole_buffer\")" << std::endl;
  std::cout << "   let b:findent_use_whole_buffer = 0" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "if !exists(\"g:findent\")" << std::endl;
  std::cout << "   let g:findent = \"/usr/bin/findent\"" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" determine fixed or free or unknown based on suffix" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "let b:fortran_format = Get_format_from_extension(expand('%:e'))" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "\" if format is unknown, try to get it from the source" << std::endl;
  std::cout << "if b:fortran_format == \"unknown\"" << std::endl;
  std::cout << "   \" determine command to determine free or fixed" << std::endl;
  std::cout << "   let b:findent_freefixed = Findent_get_freefixed()" << std::endl;
  std::cout << "   if b:findent_freefixed == \"\"" << std::endl;
  std::cout << "      let b:fortran_format = Get_free_or_fixed_default()" << std::endl;
  std::cout << "      echomsg \"Cannot determine format using findent, will use\" b:fortran_format" << std::endl;
  std::cout << "   else" << std::endl;
  std::cout << "      let r=system(b:findent_freefixed,join(getline(1,10000),\"\\n\"))" << std::endl;
  std::cout << "      if r =~ \"free\"" << std::endl;
  std::cout << "	 let b:fortran_format = \"free\"" << std::endl;
  std::cout << "      else" << std::endl;
  std::cout << "	 let b:fortran_format = \"fixed\"" << std::endl;
  std::cout << "      endif" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "if b:fortran_format == \"free\"" << std::endl;
  std::cout << "   let g:fortran_free_source = 1" << std::endl;
  std::cout << "   let b:fortran_free_source = 1" << std::endl;
  std::cout << "   let b:fortran_fixed_source = 0" << std::endl;
  std::cout << "   setlocal colorcolumn=133" << std::endl;
  std::cout << "   if exists(\"g:findent_setcolumns\")" << std::endl;
  std::cout << "      if(g:findent_setcolumns)" << std::endl;
  std::cout << "	 setlocal numberwidth=6" << std::endl;
  std::cout << "	 if &columns < 132+&numberwidth" << std::endl;
  std::cout << "	    let &columns=132+&numberwidth" << std::endl;
  std::cout << "	 endif" << std::endl;
  std::cout << "      endif" << std::endl;
  std::cout << "   endif" << std::endl;
  std::cout << "else" << std::endl;
  std::cout << "   let g:fortran_fixed_source = 1" << std::endl;
  std::cout << "   let b:fortran_fixed_source = 1" << std::endl;
  std::cout << "   let b:fortran_free_source = 0" << std::endl;
  std::cout << "   setlocal colorcolumn=6,73" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "call Findent_set_indentprog()" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "if b:use_findent_indentexpr" << std::endl;
  std::cout << "   call Findent_set_getindent()" << std::endl;
  std::cout << "endif" << std::endl;
  std::cout << "" << std::endl;
